/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.JAXBContextFactory;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.jpa.EntityMappings;
import org.apache.openejb.jee.jpa.JpaJaxbUtil;
import org.apache.openejb.jee.oejb2.GeronimoEjbJarType;
import org.apache.openejb.jee.oejb2.JaxbOpenejbJar2;
import org.apache.openejb.jee.oejb3.JaxbOpenejbJar3;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class OutputGeneratedDescriptors
implements DynamicDeployer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");
    public static final String OUTPUT_DESCRIPTORS = "openejb.descriptors.output";

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        boolean output = SystemInstance.get().getOptions().get(OUTPUT_DESCRIPTORS, false);
        if (output && appModule.getCmpMappings() != null) {
            this.writeGenratedCmpMappings(appModule);
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            ValidationContext context;
            boolean invalid;
            Options options = new Options(ejbModule.getOpenejbJar().getProperties(), SystemInstance.get().getOptions());
            output = options.get(OUTPUT_DESCRIPTORS, invalid = (context = ejbModule.getValidation()).hasErrors() || context.hasFailures());
            if (!output) continue;
            if (ejbModule.getEjbJar() != null) {
                this.writeEjbJar(ejbModule);
            }
            if (ejbModule.getOpenejbJar() != null) {
                this.writeOpenejbJar(ejbModule);
            }
            this.writeGeronimoOpenejb(ejbModule);
        }
        for (ConnectorModule connectorModule : appModule.getConnectorModules()) {
            this.writeRaXml(connectorModule);
        }
        return appModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRaXml(ConnectorModule connectorModule) {
        try {
            Connector connector = connectorModule.getConnector();
            File tempFile = File.createTempFile("ra-", connectorModule.getModuleId() + ".xml");
            FileOutputStream fout = new FileOutputStream(tempFile);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            try {
                JAXBContext ctx = JAXBContextFactory.newInstance((Class[])new Class[]{Connector.class});
                Marshaller marshaller = ctx.createMarshaller();
                marshaller.marshal((Object)connector, (OutputStream)out);
            }
            catch (JAXBException e) {
            }
            finally {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGenratedCmpMappings(AppModule appModule) {
        try {
            File tempFile = File.createTempFile("openejb-cmp-generated-orm-", ".xml");
            FileOutputStream fout = new FileOutputStream(tempFile);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            try {
                JpaJaxbUtil.marshal(EntityMappings.class, (Object)appModule.getCmpMappings(), (OutputStream)out);
            }
            catch (JAXBException e) {
            }
            finally {
                out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOpenejbJar(EjbModule ejbModule) {
        try {
            OpenejbJar openejbJar = ejbModule.getOpenejbJar();
            File tempFile = File.createTempFile("openejb-jar-", ejbModule.getModuleId() + ".xml");
            FileOutputStream fout = new FileOutputStream(tempFile);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            try {
                JaxbOpenejbJar3.marshal(OpenejbJar.class, (Object)openejbJar, (OutputStream)out);
                logger.info("Dumping Generated openejb-jar.xml to: " + tempFile.getAbsolutePath());
            }
            catch (JAXBException e) {
            }
            finally {
                out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGeronimoOpenejb(EjbModule ejbModule) {
        try {
            GeronimoEjbJarType geronimoEjbJarType = (GeronimoEjbJarType)ejbModule.getAltDDs().get("geronimo-openejb.xml");
            if (geronimoEjbJarType == null) {
                return;
            }
            File tempFile = File.createTempFile("geronimo-openejb-", ejbModule.getModuleId() + ".xml");
            FileOutputStream fout = new FileOutputStream(tempFile);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            try {
                JaxbOpenejbJar2.marshal(GeronimoEjbJarType.class, (Object)geronimoEjbJarType, (OutputStream)out);
                logger.info("Dumping Generated geronimo-openejb.xml to: " + tempFile.getAbsolutePath());
            }
            catch (JAXBException e) {
            }
            finally {
                out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEjbJar(EjbModule ejbModule) {
        try {
            EjbJar ejbJar = ejbModule.getEjbJar();
            File tempFile = File.createTempFile("ejb-jar-", ejbModule.getModuleId() + ".xml");
            FileOutputStream fout = new FileOutputStream(tempFile);
            BufferedOutputStream out = new BufferedOutputStream(fout);
            try {
                JaxbJavaee.marshal(EjbJar.class, (Object)ejbJar, (OutputStream)out);
                logger.info("Dumping Generated ejb-jar.xml to: " + tempFile.getAbsolutePath());
            }
            catch (JAXBException e) {
            }
            finally {
                out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

