/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.OutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.openejb.loader.Options;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.Pipe;

public class RemoteServer {
    private static final Options options = new Options(System.getProperties());
    private final boolean debug = options.get("openejb.server.debug", false);
    private final boolean profile = options.get("openejb.server.profile", false);
    private final boolean tomcat;
    private final String javaOpts = System.getProperty("java.opts");
    private boolean serverHasAlreadyBeenStarted = true;
    private Properties properties;
    private Process server;
    private final int tries;
    private final boolean verbose;
    private final int shutdownPort;

    public RemoteServer() {
        this(options.get("connect.tries", 10), options.get("verbose", false));
    }

    public RemoteServer(int tries, boolean verbose) {
        this.tries = tries;
        this.verbose = verbose;
        File home = RemoteServer.getHome();
        this.tomcat = home != null && new File(new File(home, "bin"), "catalina.sh").exists();
        this.shutdownPort = options.get("server.shutdown.port", this.tomcat ? 8005 : 4200);
    }

    public void init(Properties props) {
        this.properties = props;
        props.put("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
        props.put("java.naming.provider.url", options.get("java.naming.provider.url", "127.0.0.1:4201"));
        props.put("java.naming.security.principal", "testuser");
        props.put("java.naming.security.credentials", "testpassword");
    }

    public static void main(String[] args) {
        assert (args.length > 0) : "no arguments supplied: valid argumen -efts are 'start' or 'stop'";
        if (args[0].equalsIgnoreCase("start")) {
            new RemoteServer().start();
        } else if (args[0].equalsIgnoreCase("stop")) {
            RemoteServer remoteServer = new RemoteServer();
            remoteServer.serverHasAlreadyBeenStarted = false;
            remoteServer.stop();
        } else {
            throw new RuntimeException("valid arguments are 'start' or 'stop'");
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void destroy() {
        this.stop();
    }

    public void start() {
        if (!this.connect()) {
            try {
                Object[] args;
                System.out.println("[] START SERVER");
                File home = RemoteServer.getHome();
                System.out.println("OPENEJB_HOME = " + home.getAbsolutePath());
                String systemInfo = "Java " + System.getProperty("java.version") + "; " + System.getProperty("os.name") + "/" + System.getProperty("os.version");
                System.out.println("SYSTEM_INFO  = " + systemInfo);
                this.serverHasAlreadyBeenStarted = false;
                File openejbJar = null;
                File javaagentJar = null;
                File lib = !this.tomcat ? new File(home, "lib") : new File(new File(new File(home, "webapps"), "openejb"), "lib");
                for (File file : lib.listFiles()) {
                    if (file.getName().startsWith("openejb-core") && file.getName().endsWith("jar")) {
                        openejbJar = file;
                    }
                    if (!file.getName().startsWith("openejb-javaagent") || !file.getName().endsWith("jar")) continue;
                    javaagentJar = file;
                }
                if (openejbJar == null) {
                    throw new IllegalStateException("Cannot find the openejb-core jar in " + lib.getAbsolutePath());
                }
                if (javaagentJar == null) {
                    throw new IllegalStateException("Cannot find the openejb-javaagent jar in " + lib.getAbsolutePath());
                }
                int debugPort = options.get("server.debug.port", 5005);
                if (!this.tomcat) {
                    args = this.debug ? new String[]{"java", "-XX:+HeapDumpOnOutOfMemoryError", "-Xdebug", "-Xnoagent", "-Djava.compiler=NONE", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + debugPort, "-javaagent:" + javaagentJar.getAbsolutePath(), "-jar", openejbJar.getAbsolutePath(), "start"} : new String[]{"java", "-XX:+HeapDumpOnOutOfMemoryError", "-javaagent:" + javaagentJar.getAbsolutePath(), "-jar", openejbJar.getAbsolutePath(), "start"};
                } else {
                    File bin = new File(home, "bin");
                    File tlib = new File(home, "lib");
                    File bootstrapJar = new File(bin, "bootstrap.jar");
                    File juliJar = new File(bin, "tomcat-juli.jar");
                    File commonsLoggingJar = new File(bin, "commons-logging-api.jar");
                    File conf = new File(home, "conf");
                    File loggingProperties = new File(conf, "logging.properties");
                    File endorsed = new File(home, "endorsed");
                    File temp = new File(home, "temp");
                    ArrayList<String> argsList = new ArrayList<String>(){};
                    argsList.add("java");
                    argsList.add("-XX:+HeapDumpOnOutOfMemoryError");
                    if (this.debug) {
                        argsList.add("-Xdebug");
                        argsList.add("-Xnoagent");
                        argsList.add("-Djava.compiler=NONE");
                        argsList.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + debugPort);
                    }
                    if (this.profile) {
                        String yourkitHome = options.get("yourkit.home", "/Applications/YourKit_Java_Profiler_9.5.6.app/bin/mac/");
                        if (!yourkitHome.endsWith("/")) {
                            yourkitHome = yourkitHome + "/";
                        }
                        String yourkitOpts = options.get("yourkit.opts", "disablestacktelemetry,disableexceptiontelemetry,builtinprobes=none,delay=10000,sessionname=Tomcat");
                        argsList.add("-agentpath:" + yourkitHome + "libyjpagent.jnilib=" + yourkitOpts);
                    }
                    if (this.javaOpts != null) {
                        String[] strings;
                        for (String string : strings = this.javaOpts.split(" +")) {
                            argsList.add(string);
                        }
                    }
                    argsList.add("-javaagent:" + javaagentJar.getAbsolutePath());
                    argsList.add("-Dcom.sun.management.jmxremote");
                    argsList.add("-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager");
                    argsList.add("-Djava.util.logging.config.file=" + loggingProperties.getAbsolutePath());
                    argsList.add("-Djava.io.tmpdir=" + temp.getAbsolutePath());
                    argsList.add("-Djava.endorsed.dirs=" + endorsed.getAbsolutePath());
                    argsList.add("-Dcatalina.base=" + home.getAbsolutePath());
                    argsList.add("-Dcatalina.home=" + home.getAbsolutePath());
                    argsList.add("-Dcatalina.ext.dirs=" + tlib.getAbsolutePath());
                    argsList.add("-Dopenejb.servicemanager.enabled=" + Boolean.getBoolean("openejb.servicemanager.enabled"));
                    argsList.add("-Dorg.apache.catalina.STRICT_SERVLET_COMPLIANCE=true");
                    argsList.add("-Dorg.apache.tomcat.util.http.ServerCookie.ALLOW_HTTP_SEPARATORS_IN_V0=true");
                    this.addIfSet((List<String>)argsList, "javax.net.ssl.keyStore");
                    this.addIfSet((List<String>)argsList, "javax.net.ssl.keyStorePassword");
                    this.addIfSet((List<String>)argsList, "javax.net.ssl.trustStore");
                    this.addIfSet((List<String>)argsList, "java.protocol.handler.pkgs");
                    argsList.add("-ea");
                    argsList.add("-classpath");
                    String ps = File.pathSeparator;
                    if (commonsLoggingJar.exists()) {
                        argsList.add(bootstrapJar.getAbsolutePath() + ps + juliJar.getAbsolutePath() + ps + commonsLoggingJar.getAbsolutePath());
                    } else {
                        argsList.add(bootstrapJar.getAbsolutePath() + ps + juliJar.getAbsolutePath());
                    }
                    argsList.add("org.apache.catalina.startup.Bootstrap");
                    argsList.add("start");
                    args = argsList.toArray(new String[argsList.size()]);
                }
                if (this.verbose) {
                    System.out.println(Join.join("\n", args));
                }
                this.server = Runtime.getRuntime().exec((String[])args);
                Pipe.pipe(this.server);
            }
            catch (Exception e) {
                throw (RuntimeException)new RuntimeException("Cannot start the server.  Exception: " + e.getClass().getName() + ": " + e.getMessage()).initCause(e);
            }
            if (this.debug ? !this.connect(Integer.MAX_VALUE) : !this.connect(this.tries)) {
                throw new RuntimeException("Could not connect to server");
            }
        } else if (this.verbose) {
            System.out.println("[] FOUND STARTED SERVER");
        }
    }

    private void addIfSet(List<String> argsList, String key) {
        if (System.getProperties().containsKey(key)) {
            argsList.add("-D" + key + "=" + System.getProperty(key));
        }
    }

    private static File getHome() {
        String openejbHome = System.getProperty("openejb.home");
        if (openejbHome != null) {
            return new File(openejbHome);
        }
        return null;
    }

    public void stop() {
        if (!this.serverHasAlreadyBeenStarted) {
            try {
                System.out.println("[] STOP SERVER");
                String command = "SHUTDOWN";
                Socket socket = new Socket("localhost", this.shutdownPort);
                OutputStream out = socket.getOutputStream();
                out.write(command.getBytes());
                if (this.server != null) {
                    this.server.waitFor();
                    this.server = null;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean connect() {
        return this.connect(1);
    }

    private boolean connect(int tries) {
        if (this.verbose) {
            System.out.println("[] CONNECT ATTEMPT " + (this.tries - tries));
        }
        try {
            Socket socket = new Socket("localhost", this.shutdownPort);
            OutputStream out = socket.getOutputStream();
            out.close();
            if (this.verbose) {
                System.out.println("[] CONNECTED IN " + (this.tries - tries));
            }
        }
        catch (Exception e) {
            if (tries < 2) {
                if (this.verbose) {
                    System.out.println("[] CONNECT ATTEMPTS FAILED ( " + (this.tries - tries) + " tries)");
                }
                return false;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e2) {
                e.printStackTrace();
            }
            return this.connect(--tries);
        }
        return true;
    }
}

