/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.persistence;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.persistence.SharedCacheMode;
import javax.persistence.ValidationMode;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.apache.openejb.persistence.PersistenceClassLoaderHandler;

public class PersistenceUnitInfoImpl
implements PersistenceUnitInfo {
    private final PersistenceClassLoaderHandler persistenceClassLoaderHandler;
    private String id;
    private String persistenceUnitName;
    private String persistenceProviderClassName;
    private PersistenceUnitTransactionType transactionType = PersistenceUnitTransactionType.JTA;
    private DataSource jtaDataSource;
    private DataSource nonJtaDataSource;
    private final List<String> mappingFileNames = new ArrayList<String>();
    private final List<URL> jarFileUrls = new ArrayList<URL>();
    private URL persistenceUnitRootUrl;
    private final List<String> managedClassNames = new ArrayList<String>();
    private boolean excludeUnlistedClasses;
    private Properties properties;
    private ClassLoader classLoader;
    private String persistenceXMLSchemaVersion;
    private SharedCacheMode sharedCacheMode;
    private ValidationMode validationMode;

    public PersistenceUnitInfoImpl() {
        this.persistenceClassLoaderHandler = null;
    }

    public PersistenceUnitInfoImpl(PersistenceClassLoaderHandler persistenceClassLoaderHandler) {
        this.persistenceClassLoaderHandler = persistenceClassLoaderHandler;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public String getPersistenceProviderClassName() {
        return this.persistenceProviderClassName;
    }

    public void setPersistenceProviderClassName(String persistenceProviderClassName) {
        this.persistenceProviderClassName = persistenceProviderClassName;
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(PersistenceUnitTransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public DataSource getJtaDataSource() {
        return this.jtaDataSource;
    }

    public void setJtaDataSource(DataSource jtaDataSource) {
        this.jtaDataSource = jtaDataSource;
    }

    public DataSource getNonJtaDataSource() {
        return this.nonJtaDataSource;
    }

    public void setNonJtaDataSource(DataSource nonJtaDataSource) {
        this.nonJtaDataSource = nonJtaDataSource;
    }

    public List<String> getMappingFileNames() {
        return this.mappingFileNames;
    }

    public void setMappingFileNames(List<String> mappingFileNames) {
        if (mappingFileNames == null) {
            throw new NullPointerException("mappingFileNames is null");
        }
        this.mappingFileNames.clear();
        this.mappingFileNames.addAll(mappingFileNames);
    }

    public void addMappingFileName(String mappingFileName) {
        if (mappingFileName == null) {
            throw new NullPointerException("mappingFileName is null");
        }
        this.mappingFileNames.add(mappingFileName);
    }

    public List<URL> getJarFileUrls() {
        return this.jarFileUrls;
    }

    public URL getPersistenceUnitRootUrl() {
        return this.persistenceUnitRootUrl;
    }

    public void setRootUrlAndJarUrls(String persistenceUnitRootUrl, List<String> jarFiles) throws MalformedURLException {
        File root;
        try {
            URI rootUri = URI.create(persistenceUnitRootUrl);
            root = new File(rootUri);
        }
        catch (IllegalArgumentException e) {
            root = new File(persistenceUnitRootUrl);
        }
        this.persistenceUnitRootUrl = this.toUrl(root);
        try {
            for (String path : jarFiles) {
                File file = new File(root, path);
                file = file.getCanonicalFile();
                this.jarFileUrls.add(this.toUrl(file));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private URL toUrl(File root) throws MalformedURLException {
        return root.toURI().toURL();
    }

    public List<String> getManagedClassNames() {
        return this.managedClassNames;
    }

    public void setManagedClassNames(List<String> managedClassNames) {
        if (managedClassNames == null) {
            throw new NullPointerException("managedClassNames is null");
        }
        this.managedClassNames.clear();
        this.managedClassNames.addAll(managedClassNames);
    }

    public void addManagedClassName(String className) {
        this.managedClassNames.add(className);
    }

    public boolean excludeUnlistedClasses() {
        return this.excludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void addTransformer(ClassTransformer classTransformer) {
        if (this.persistenceClassLoaderHandler != null) {
            PersistenceClassFileTransformer classFileTransformer = new PersistenceClassFileTransformer(classTransformer);
            this.persistenceClassLoaderHandler.addTransformer(this.id, this.classLoader, classFileTransformer);
        }
    }

    public ClassLoader getNewTempClassLoader() {
        if (this.persistenceClassLoaderHandler != null) {
            return this.persistenceClassLoaderHandler.getNewTempClassLoader(this.classLoader);
        }
        return null;
    }

    public String getPersistenceXMLSchemaVersion() {
        return this.persistenceXMLSchemaVersion;
    }

    public void setPersistenceXMLSchemaVersion(String persistenceXMLSchemaVersion) {
        this.persistenceXMLSchemaVersion = persistenceXMLSchemaVersion;
    }

    public SharedCacheMode getSharedCacheMode() {
        return this.sharedCacheMode;
    }

    public void setSharedCacheMode(SharedCacheMode sharedCacheMode) {
        this.sharedCacheMode = sharedCacheMode;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public static class PersistenceClassFileTransformer
    implements ClassFileTransformer {
        private final ClassTransformer classTransformer;

        public PersistenceClassFileTransformer(ClassTransformer classTransformer) {
            this.classTransformer = classTransformer;
        }

        @Override
        public byte[] transform(ClassLoader classLoader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
            byte[] bytes = this.classTransformer.transform(classLoader, className.replace('/', '.'), classBeingRedefined, protectionDomain, classfileBuffer);
            return bytes;
        }
    }
}

