/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DataSourceConnectionFactory;
import org.apache.commons.dbcp.managed.DataSourceXAConnectionFactory;
import org.apache.commons.dbcp.managed.LocalXAConnectionFactory;
import org.apache.commons.dbcp.managed.TransactionRegistry;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.XAResourceWrapper;
import org.apache.openejb.resource.jdbc.BasicDataSource;
import org.apache.openejb.resource.jdbc.BasicManagedDataSource;
import org.apache.openejb.resource.jdbc.ManagedDataSourceWithRecovery;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.hsqldb.jdbc.jdbcDataSource;

public class DataSourceFactory {
    public static DataSource create(boolean managed, Class impl, String definition) throws IllegalAccessException, InstantiationException, IOException {
        Object ds;
        if (DataSource.class.isAssignableFrom(impl)) {
            ObjectRecipe recipe = new ObjectRecipe(impl);
            recipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
            recipe.allow(Option.IGNORE_MISSING_PROPERTIES);
            recipe.allow(Option.NAMED_PARAMETERS);
            recipe.setAllProperties(DataSourceFactory.asProperties(definition));
            DataSource dataSource = (DataSource)recipe.create();
            ds = managed ? new DbcpManagedDataSource(dataSource) : new DbcpDataSource(dataSource);
        } else {
            ds = (org.apache.commons.dbcp.BasicDataSource)DataSourceFactory.create(managed);
        }
        ds.setDriverClassName(impl.getName());
        return ds;
    }

    private static Map<?, ?> asProperties(String definition) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(definition.getBytes());
        Properties properties = new Properties();
        properties.load(in);
        DataSourceFactory.trimNotSupportedDataSourceProperties(properties);
        return properties;
    }

    public static void trimNotSupportedDataSourceProperties(Properties properties) {
        properties.remove("LoginTimeout");
    }

    public static DataSource create(boolean managed) {
        XAResourceWrapper xaResourceWrapper;
        Object ds = managed ? ((xaResourceWrapper = (XAResourceWrapper)SystemInstance.get().getComponent(XAResourceWrapper.class)) != null ? new ManagedDataSourceWithRecovery(xaResourceWrapper) : new BasicManagedDataSource()) : new BasicDataSource();
        return ds;
    }

    public static class DbcpManagedDataSource
    extends BasicManagedDataSource {
        private final DataSource dataSource;

        public DbcpManagedDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        @Override
        public void setJdbcUrl(String string) {
            if (this.dataSource instanceof jdbcDataSource) {
                ((jdbcDataSource)this.dataSource).setDatabase(string);
            }
        }

        protected ConnectionFactory createConnectionFactory() throws SQLException {
            if (this.dataSource instanceof XADataSource) {
                XADataSource xaDataSourceInstance = (XADataSource)((Object)this.dataSource);
                DataSourceXAConnectionFactory xaConnectionFactory = new DataSourceXAConnectionFactory(this.getTransactionManager(), xaDataSourceInstance, this.username, this.password);
                this.setTransactionRegistry(xaConnectionFactory.getTransactionRegistry());
                return xaConnectionFactory;
            }
            DataSourceConnectionFactory connectionFactory = new DataSourceConnectionFactory(this.dataSource, this.username, this.password);
            LocalXAConnectionFactory xaConnectionFactory = new LocalXAConnectionFactory(this.getTransactionManager(), (ConnectionFactory)connectionFactory);
            this.setTransactionRegistry(xaConnectionFactory.getTransactionRegistry());
            return xaConnectionFactory;
        }

        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            try {
                return (Logger)DataSource.class.getDeclaredMethod("getParentLogger", new Class[0]).invoke((Object)this.dataSource, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }

        public void setTransactionRegistry(TransactionRegistry registry) {
            try {
                Field field = org.apache.commons.dbcp.managed.BasicManagedDataSource.class.getDeclaredField("transactionRegistry");
                field.setAccessible(true);
                field.set((Object)this, registry);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static class DbcpDataSource
    extends BasicDataSource {
        private final DataSource dataSource;

        public DbcpDataSource(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        protected ConnectionFactory createConnectionFactory() throws SQLException {
            return new DataSourceConnectionFactory(this.dataSource, this.username, this.password);
        }

        @Override
        public void setJdbcUrl(String string) {
            try {
                Class<?> hsql = ((Object)((Object)this)).getClass().getClassLoader().loadClass("org.hsqldb.jdbc.jdbcDataSource");
                Method setDatabase = hsql.getMethod("setDatabase", String.class);
                setDatabase.setAccessible(true);
                setDatabase.invoke((Object)this.dataSource, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            try {
                return (Logger)DataSource.class.getDeclaredMethod("getParentLogger", new Class[0]).invoke((Object)this.dataSource, new Object[0]);
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

