/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.openejb.util.Computable;
import org.apache.openejb.util.JuliLogStreamFactory;
import org.apache.openejb.util.Log4jLogStreamFactory;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.LogStream;
import org.apache.openejb.util.LogStreamFactory;
import org.apache.openejb.util.Memoizer;

public class Logger {
    private static final String SUFFIX = ".Messages";
    private static final String OPENEJB = "org.apache.openejb";
    private static LogStreamFactory logStreamFactory;
    private static final Computable<String, String> heirarchyResolver;
    private static final Computable<String, ResourceBundle> bundleResolver;
    private static final Computable<Object[], Logger> loggerResolver;
    private static final Computable<String, MessageFormat> messageFormatResolver;
    private static final Computable<String, String> heirarchyCache;
    private static final Computable<String, ResourceBundle> bundleCache;
    private static final Computable<Object[], Logger> loggerCache;
    private static final Computable<String, MessageFormat> messageFormatCache;
    private final LogCategory category;
    private final LogStream logStream;
    private final String baseName;

    public static void configure() {
        String factoryName = System.getProperty("openejb.log.factory");
        Class<?> factoryClass = null;
        if (factoryName != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                try {
                    factoryClass = classLoader.loadClass(factoryName);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (factoryClass == null) {
                try {
                    factoryClass = Class.forName(factoryName);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
        }
        LogStreamFactory factory = null;
        if (factoryClass != null) {
            try {
                factory = (LogStreamFactory)factoryClass.newInstance();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (factory == null) {
            try {
                factory = new Log4jLogStreamFactory();
            }
            catch (NoClassDefFoundError e) {
                factory = new JuliLogStreamFactory();
            }
        }
        logStreamFactory = factory;
    }

    public static Logger getInstance(LogCategory category, String baseName) {
        try {
            Logger logger = loggerCache.compute(new Object[]{category, baseName});
            return logger;
        }
        catch (InterruptedException e) {
            LogStream logStream = logStreamFactory.createLogStream(category);
            Logger logger = new Logger(category, logStream, baseName);
            return logger;
        }
    }

    public Logger(LogCategory category, LogStream logStream, String baseName) {
        this.category = category;
        this.logStream = logStream;
        this.baseName = baseName;
    }

    public static Logger getInstance(LogCategory category, Class clazz) {
        return Logger.getInstance(category, Logger.packageName(clazz));
    }

    private static String packageName(Class clazz) {
        String name = clazz.getName();
        return name.substring(0, name.lastIndexOf("."));
    }

    public Logger getChildLogger(String child) {
        return Logger.getInstance(this.category.createChild(child), this.baseName);
    }

    private String formatMessage(String message, Object ... args) {
        if (args.length == 0) {
            return message;
        }
        try {
            MessageFormat mf = messageFormatCache.compute(message);
            String msg = mf.format(args);
            return msg;
        }
        catch (Exception e) {
            return "Error in formatting message " + message;
        }
    }

    public boolean isDebugEnabled() {
        return this.logStream.isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logStream.isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        return this.logStream.isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logStream.isInfoEnabled();
    }

    public boolean isWarningEnabled() {
        return this.logStream.isWarnEnabled();
    }

    public String debug(String message) {
        if (this.isDebugEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.debug(msg);
            return msg;
        }
        return message;
    }

    public String debug(String message, Object ... args) {
        if (this.isDebugEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.debug(msg);
            return msg;
        }
        return message;
    }

    public String debug(String message, Throwable t) {
        if (this.isDebugEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.debug(msg, t);
            return msg;
        }
        return message;
    }

    public String debug(String message, Throwable t, Object ... args) {
        if (this.isDebugEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.debug(msg, t);
            return msg;
        }
        return message;
    }

    public String error(String message) {
        if (this.isErrorEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.error(msg);
            return msg;
        }
        return message;
    }

    public String error(String message, Object ... args) {
        if (this.isErrorEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.error(msg);
            return msg;
        }
        return message;
    }

    public String error(String message, Throwable t) {
        if (this.isErrorEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.error(msg, t);
            return msg;
        }
        return message;
    }

    public String error(String message, Throwable t, Object ... args) {
        if (this.isErrorEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.error(msg, t);
            return msg;
        }
        return message;
    }

    public String fatal(String message) {
        if (this.isFatalEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.fatal(msg);
            return msg;
        }
        return message;
    }

    public String fatal(String message, Object ... args) {
        if (this.isFatalEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.fatal(msg);
            return msg;
        }
        return message;
    }

    public String fatal(String message, Throwable t) {
        if (this.isFatalEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.fatal(msg, t);
            return msg;
        }
        return message;
    }

    public String fatal(String message, Throwable t, Object ... args) {
        if (this.isFatalEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.fatal(msg, t);
            return msg;
        }
        return message;
    }

    public String info(String message) {
        if (this.isInfoEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.info(msg);
            return msg;
        }
        return message;
    }

    public String info(String message, Object ... args) {
        if (this.isInfoEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.info(msg);
            return msg;
        }
        return message;
    }

    public String info(String message, Throwable t) {
        if (this.isInfoEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.info(msg, t);
            return msg;
        }
        return message;
    }

    public String info(String message, Throwable t, Object ... args) {
        if (this.isInfoEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.info(msg, t);
            return msg;
        }
        return message;
    }

    public String warning(String message) {
        if (this.isWarningEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.warn(msg);
            return msg;
        }
        return message;
    }

    public String warning(String message, Object ... args) {
        if (this.isWarningEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.warn(msg);
            return msg;
        }
        return message;
    }

    public String warning(String message, Throwable t) {
        if (this.isWarningEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            this.logStream.warn(msg, t);
            return msg;
        }
        return message;
    }

    public String warning(String message, Throwable t, Object ... args) {
        if (this.isWarningEnabled()) {
            String msg = this.getMessage(message, this.baseName);
            msg = this.formatMessage(msg, args);
            this.logStream.warn(msg, t);
            return msg;
        }
        return message;
    }

    private String getMessage(String key, String baseName) {
        try {
            ResourceBundle bundle = bundleCache.compute(baseName);
            if (bundle != null) {
                String message = null;
                try {
                    message = bundle.getString(key);
                    return message;
                }
                catch (MissingResourceException e) {
                    String parentName = heirarchyCache.compute(baseName);
                    if (parentName == null) {
                        return key;
                    }
                    return this.getMessage(key, parentName);
                }
            }
            String parentName = heirarchyCache.compute(baseName);
            if (parentName == null) {
                return key;
            }
            return this.getMessage(key, parentName);
        }
        catch (InterruptedException interruptedException) {
            return key;
        }
    }

    static {
        Logger.configure();
        heirarchyResolver = new Computable<String, String>(){

            @Override
            public String compute(String key) throws InterruptedException {
                int index = key.lastIndexOf(".");
                String parent = key.substring(0, index);
                if (parent.contains(Logger.OPENEJB)) {
                    return parent;
                }
                return null;
            }
        };
        bundleResolver = new Computable<String, ResourceBundle>(){

            @Override
            public ResourceBundle compute(String baseName) throws InterruptedException {
                try {
                    return ResourceBundle.getBundle(baseName + Logger.SUFFIX);
                }
                catch (MissingResourceException e) {
                    return null;
                }
            }
        };
        loggerResolver = new Computable<Object[], Logger>(){

            @Override
            public Logger compute(Object[] args) throws InterruptedException {
                LogCategory category = (LogCategory)args[0];
                LogStream logStream = logStreamFactory.createLogStream(category);
                String baseName = (String)args[1];
                Logger logger = new Logger(category, logStream, baseName);
                return logger;
            }
        };
        messageFormatResolver = new Computable<String, MessageFormat>(){

            @Override
            public MessageFormat compute(String message) throws InterruptedException {
                return new MessageFormat(message);
            }
        };
        heirarchyCache = new Memoizer<String, String>(heirarchyResolver);
        bundleCache = new Memoizer<String, ResourceBundle>(bundleResolver);
        loggerCache = new Memoizer<Object[], Logger>(loggerResolver);
        messageFormatCache = new Memoizer<String, MessageFormat>(messageFormatResolver);
    }
}

