/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Future;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityBean;
import javax.ejb.Handle;
import javax.ejb.LockType;
import javax.ejb.MessageDrivenBean;
import javax.ejb.SessionBean;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.naming.Context;
import javax.persistence.EntityManagerFactory;
import org.apache.openejb.BeanType;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentContext;
import org.apache.openejb.Injection;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.MethodContext;
import org.apache.openejb.ModuleContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.SystemException;
import org.apache.openejb.assembler.classic.ProxyInterfaceResolver;
import org.apache.openejb.cdi.CdiEjbBean;
import org.apache.openejb.cdi.ConstructorInjectionBean;
import org.apache.openejb.cdi.CurrentCreationalContext;
import org.apache.openejb.core.ExceptionType;
import org.apache.openejb.core.InstanceContext;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.cmp.KeyGenerator;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.core.interceptor.InterceptorInstance;
import org.apache.openejb.core.interceptor.InterceptorStack;
import org.apache.openejb.core.ivm.EjbHomeProxyHandler;
import org.apache.openejb.core.timer.EjbTimerService;
import org.apache.openejb.core.transaction.EjbTransactionUtil;
import org.apache.openejb.core.transaction.TransactionPolicy;
import org.apache.openejb.core.transaction.TransactionPolicyFactory;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.Index;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.proxy.DynamicProxyImplFactory;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.AbstractInjectable;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.xbean.recipe.ConstructionException;

public class BeanContext
extends DeploymentContext {
    private Logger logger = Logger.getInstance(LogCategory.OPENEJB, BeanContext.class);
    public static final String USER_INTERCEPTOR_KEY = "org.apache.openejb.default.system.interceptors";
    public static final String USER_INTERCEPTOR_SEPARATOR = ",| |;";
    private final ModuleContext moduleContext;
    private final Context jndiContext;
    private Object containerData;
    private boolean destroyed;
    private Class homeInterface;
    private Class remoteInterface;
    private Class localHomeInterface;
    private Class localInterface;
    private Class beanClass;
    private Class pkClass;
    private final List<Class> businessLocals = new ArrayList<Class>();
    private final List<Class> businessRemotes = new ArrayList<Class>();
    private Class mdbInterface;
    private Class serviceEndpointInterface;
    private final List<Method> removeMethods = new ArrayList<Method>();
    private final Set<String> dependsOn = new LinkedHashSet<String>();
    private Method ejbTimeout;
    private EjbTimerService ejbTimerService;
    private boolean isBeanManagedTransaction;
    private boolean isBeanManagedConcurrency;
    private boolean isReentrant;
    private Container container;
    private EJBHome ejbHomeRef;
    private EJBLocalHome ejbLocalHomeRef;
    private String destinationId;
    private String ejbName;
    private String runAs;
    private Method createMethod = null;
    private final BeanType componentType;
    private boolean hidden = false;
    private final Map<Method, Method> postCreateMethodMap = new HashMap<Method, Method>();
    private final Map<Method, TransactionType> methodTransactionType = new HashMap<Method, TransactionType>();
    private final Map<Method, Method> methodMap = new HashMap<Method, Method>();
    private final Map<Method, MethodContext> methodContextMap = new HashMap<Method, MethodContext>();
    private final Map<String, ViewContext> viewContextMap = new HashMap<String, ViewContext>();
    private Index<EntityManagerFactory, Map> extendedEntityManagerFactories;
    private TransactionPolicyFactory transactionPolicyFactory;
    private final List<InterceptorData> callbackInterceptors = new ArrayList<InterceptorData>();
    private final Set<InterceptorData> instanceScopedInterceptors = new HashSet<InterceptorData>();
    private final List<InterceptorInstance> systemInterceptors = new ArrayList<InterceptorInstance>();
    private final List<InterceptorInstance> userInterceptors = new ArrayList<InterceptorInstance>();
    private final Map<String, String> activationProperties = new HashMap<String, String>();
    private final List<Injection> injections = new ArrayList<Injection>();
    private final Map<Class, InterfaceType> interfaces = new HashMap<Class, InterfaceType>();
    private final Map<Class, ExceptionType> exceptions = new HashMap<Class, ExceptionType>();
    private boolean loadOnStartup;
    private final boolean localbean;
    private Duration accessTimeout;
    private Duration statefulTimeout;
    private Set<Class<?>> asynchronousClasses = new HashSet();
    private Set<String> asynchronousMethodSignatures = new HashSet<String>();
    private Class<?> proxyClass;
    private final Map<Method, Boolean> removeExceptionPolicy = new HashMap<Method, Boolean>();
    private final Set<InterceptorData> cdiInterceptors = new LinkedHashSet<InterceptorData>();
    private boolean cmp2;
    private KeyGenerator keyGenerator;
    private String primaryKeyField;
    private Class cmpImplClass;
    private String abstractSchemaName;
    private Set<String> remoteQueryResults = new TreeSet<String>();

    public boolean isDynamicallyImplemented() {
        return this.proxyClass != null;
    }

    public Class getInterface(InterfaceType interfaceType) {
        switch (interfaceType) {
            case EJB_HOME: {
                return this.getHomeInterface();
            }
            case EJB_OBJECT: {
                return this.getRemoteInterface();
            }
            case EJB_LOCAL_HOME: {
                return this.getLocalHomeInterface();
            }
            case EJB_LOCAL: {
                return this.getLocalInterface();
            }
            case BUSINESS_LOCAL: {
                return this.getBusinessLocalInterface();
            }
            case BUSINESS_REMOTE: {
                return this.getBusinessRemoteInterface();
            }
            case TIMEOUT: {
                return Timeout.class;
            }
            case BUSINESS_REMOTE_HOME: {
                return BusinessRemoteHome.class;
            }
            case BUSINESS_LOCAL_HOME: {
                return BusinessLocalHome.class;
            }
            case SERVICE_ENDPOINT: {
                return this.getServiceEndpointInterface();
            }
            case LOCALBEAN: {
                return this.getBeanClass();
            }
            case BUSINESS_LOCALBEAN_HOME: {
                return BusinessLocalBeanHome.class;
            }
        }
        throw new IllegalStateException("Unexpected enum constant: " + (Object)((Object)interfaceType));
    }

    public List<Class> getInterfaces(InterfaceType interfaceType) {
        switch (interfaceType) {
            case BUSINESS_REMOTE: {
                return this.getBusinessRemoteInterfaces();
            }
            case BUSINESS_LOCAL: {
                return this.getBusinessLocalInterfaces();
            }
        }
        ArrayList<Class> interfaces = new ArrayList<Class>();
        interfaces.add(this.getInterface(interfaceType));
        return interfaces;
    }

    public InterfaceType getInterfaceType(Class clazz) {
        InterfaceType type = this.interfaces.get(clazz);
        if (type != null) {
            return type;
        }
        if (EJBLocalHome.class.isAssignableFrom(clazz)) {
            return InterfaceType.EJB_LOCAL_HOME;
        }
        if (EJBLocalObject.class.isAssignableFrom(clazz)) {
            return InterfaceType.EJB_LOCAL;
        }
        if (EJBHome.class.isAssignableFrom(clazz)) {
            return InterfaceType.EJB_HOME;
        }
        if (EJBObject.class.isAssignableFrom(clazz)) {
            return InterfaceType.EJB_OBJECT;
        }
        return null;
    }

    private BeanContext(String id, Context jndiContext, ModuleContext moduleContext, BeanType componentType, boolean localBean) {
        super(id, moduleContext.getOptions());
        this.moduleContext = moduleContext;
        this.jndiContext = jndiContext;
        this.localbean = localBean;
        this.componentType = componentType;
        String interceptors = SystemInstance.get().getProperties().getProperty(USER_INTERCEPTOR_KEY);
        if (interceptors != null) {
            String[] interceptorArray = interceptors.split(USER_INTERCEPTOR_SEPARATOR);
            ClassLoader classLoader = moduleContext.getClassLoader();
            for (String interceptor : interceptorArray) {
                Object interceptorObject;
                if (interceptor == null || interceptor.isEmpty()) continue;
                try {
                    Class<?> clazz = classLoader.loadClass(interceptor);
                    interceptorObject = clazz.newInstance();
                }
                catch (Exception e) {
                    this.logger.warning("interceptor " + interceptor + " not found, are you sure the container can load it?");
                    continue;
                }
                this.addUserInterceptor(interceptorObject);
            }
        }
    }

    public BeanContext(String id, Context jndiContext, ModuleContext moduleContext, Class beanClass, Class homeInterface, Class remoteInterface, Class localHomeInterface, Class localInterface, Class proxy, Class serviceEndpointInterface, List<Class> businessLocals, List<Class> businessRemotes, Class pkClass, BeanType componentType, boolean localBean) throws SystemException {
        this(id, jndiContext, moduleContext, componentType, localBean);
        if (beanClass == null) {
            throw new NullPointerException("beanClass input parameter is null");
        }
        this.pkClass = pkClass;
        this.proxyClass = proxy;
        this.homeInterface = homeInterface;
        this.remoteInterface = remoteInterface;
        this.localInterface = localInterface;
        this.localHomeInterface = localHomeInterface;
        if (businessLocals != null) {
            this.businessLocals.addAll(businessLocals);
        }
        if (businessRemotes != null) {
            this.businessRemotes.addAll(businessRemotes);
        }
        this.remoteInterface = remoteInterface;
        this.beanClass = beanClass;
        this.pkClass = pkClass;
        this.serviceEndpointInterface = serviceEndpointInterface;
        if (TimedObject.class.isAssignableFrom(beanClass)) {
            try {
                this.ejbTimeout = beanClass.getMethod("ejbTimeout", Timer.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
        this.addInterface(this.getServiceEndpointInterface(), InterfaceType.SERVICE_ENDPOINT);
        this.addInterface(EJBHome.class, InterfaceType.EJB_HOME);
        this.addInterface(EJBObject.class, InterfaceType.EJB_OBJECT);
        this.addInterface(EJBLocalHome.class, InterfaceType.EJB_LOCAL_HOME);
        this.addInterface(EJBLocalObject.class, InterfaceType.EJB_LOCAL);
        this.addInterface(this.getHomeInterface(), InterfaceType.EJB_HOME);
        this.addInterface(this.getRemoteInterface(), InterfaceType.EJB_OBJECT);
        this.addInterface(this.getLocalHomeInterface(), InterfaceType.EJB_LOCAL_HOME);
        this.addInterface(this.getLocalInterface(), InterfaceType.EJB_LOCAL);
        this.addInterface(BusinessRemoteHome.class, InterfaceType.BUSINESS_REMOTE_HOME);
        for (Class businessRemote : this.businessRemotes) {
            this.addInterface(businessRemote, InterfaceType.BUSINESS_REMOTE);
        }
        this.addInterface(BusinessLocalHome.class, InterfaceType.BUSINESS_LOCAL_HOME);
        for (Class businessLocal : this.businessLocals) {
            this.addInterface(businessLocal, InterfaceType.BUSINESS_LOCAL);
        }
        if (localBean) {
            this.addInterface(beanClass, InterfaceType.LOCALBEAN);
        }
    }

    private void addInterface(Class interfce, InterfaceType type) {
        if (interfce == null) {
            return;
        }
        this.interfaces.put(interfce, type);
        for (Class<?> clazz : interfce.getInterfaces()) {
            this.addInterface(clazz, type);
        }
    }

    public void addApplicationException(Class exception, boolean rollback, boolean inherited) {
        if (inherited) {
            if (rollback) {
                this.exceptions.put(exception, ExceptionType.APPLICATION_ROLLBACK);
            } else {
                this.exceptions.put(exception, ExceptionType.APPLICATION);
            }
        } else if (rollback) {
            this.exceptions.put(exception, ExceptionType.APPLICATION_ROLLBACK_NOT_INHERITED);
        } else {
            this.exceptions.put(exception, ExceptionType.APPLICATION_NOT_INHERITED);
        }
    }

    public ExceptionType getExceptionType(Throwable e) {
        if (!(e instanceof Exception)) {
            return ExceptionType.SYSTEM;
        }
        boolean inherited = false;
        for (Class<?> exceptionClass = e.getClass(); exceptionClass != Object.class; exceptionClass = exceptionClass.getSuperclass()) {
            ExceptionType type = this.exceptions.get(exceptionClass);
            if (type == ExceptionType.APPLICATION || type == ExceptionType.APPLICATION_ROLLBACK) {
                return type;
            }
            if (type != null) {
                if (inherited) {
                    return ExceptionType.SYSTEM;
                }
                if (type == ExceptionType.APPLICATION_NOT_INHERITED) {
                    return ExceptionType.APPLICATION;
                }
                return ExceptionType.APPLICATION_ROLLBACK;
            }
            inherited = true;
        }
        if (e instanceof RuntimeException) {
            return ExceptionType.SYSTEM;
        }
        return ExceptionType.APPLICATION;
    }

    public BeanContext(String id, Context jndiContext, ModuleContext moduleContext, Class beanClass, Class mdbInterface, Map<String, String> activationProperties) throws SystemException {
        this(id, jndiContext, moduleContext, BeanType.MESSAGE_DRIVEN, false);
        this.beanClass = beanClass;
        this.mdbInterface = mdbInterface;
        this.activationProperties.putAll(activationProperties);
        if (TimedObject.class.isAssignableFrom(beanClass)) {
            try {
                this.ejbTimeout = beanClass.getMethod("ejbTimeout", Timer.class);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
        this.createMethodMap();
    }

    public Object getContainerData() {
        return this.containerData;
    }

    public void setContainerData(Object containerData) {
        this.containerData = containerData;
    }

    public ClassLoader getClassLoader() {
        return this.moduleContext.getClassLoader();
    }

    public Context getJndiContext() {
        return this.jndiContext;
    }

    public ModuleContext getModuleContext() {
        return this.moduleContext;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean destroyed) {
        this.destroyed = destroyed;
    }

    public List<Injection> getInjections() {
        return this.injections;
    }

    public Index<EntityManagerFactory, Map> getExtendedEntityManagerFactories() {
        return this.extendedEntityManagerFactories;
    }

    public void setExtendedEntityManagerFactories(Index<EntityManagerFactory, Map> extendedEntityManagerFactories) {
        this.extendedEntityManagerFactories = extendedEntityManagerFactories;
    }

    public void setContainer(Container container) {
        this.container = container;
    }

    public BeanType getComponentType() {
        return this.componentType;
    }

    public LockType getConcurrencyAttribute(Method beanMethod) {
        return this.getMethodContext(beanMethod).getLockType();
    }

    public LockType getLockType() {
        return LockType.WRITE;
    }

    public TransactionType getTransactionType(Method method) {
        return this.getTransactionType(method, null);
    }

    public TransactionType getTransactionType(Method method, InterfaceType interfaceType) {
        MethodContext methodContext = null;
        if (interfaceType != null) {
            methodContext = this.getViewMethodContext(method, interfaceType.getSpecName());
        }
        if (methodContext == null) {
            methodContext = this.methodContextMap.get(method);
        }
        if (methodContext == null) {
            Method beanMethod = this.getMatchingBeanMethod(method);
            methodContext = this.getMethodContext(beanMethod);
        }
        return methodContext.getTransactionType();
    }

    public TransactionType getTransactionType() {
        return this.isBeanManagedTransaction ? TransactionType.BeanManaged : TransactionType.Required;
    }

    public TransactionPolicyFactory getTransactionPolicyFactory() {
        return this.transactionPolicyFactory;
    }

    public void setTransactionPolicyFactory(TransactionPolicyFactory transactionPolicyFactory) {
        this.transactionPolicyFactory = transactionPolicyFactory;
    }

    public Container getContainer() {
        return this.container;
    }

    public Object getDeploymentID() {
        return this.getId();
    }

    public boolean isBeanManagedTransaction() {
        return this.isBeanManagedTransaction;
    }

    public boolean isBeanManagedConcurrency() {
        return this.isBeanManagedConcurrency;
    }

    public Class getHomeInterface() {
        return this.homeInterface;
    }

    public Class getRemoteInterface() {
        return this.remoteInterface;
    }

    public Class getLocalHomeInterface() {
        return this.localHomeInterface;
    }

    public Class getLocalInterface() {
        return this.localInterface;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public Class getBusinessLocalInterface() {
        return this.businessLocals.size() > 0 ? this.businessLocals.get(0) : null;
    }

    public Class getBusinessRemoteInterface() {
        return this.businessRemotes.size() > 0 ? this.businessRemotes.get(0) : null;
    }

    public List<Class> getBusinessLocalInterfaces() {
        return this.businessLocals;
    }

    public List<Class> getBusinessRemoteInterfaces() {
        return this.businessRemotes;
    }

    public Class getMdbInterface() {
        return this.mdbInterface;
    }

    public Class getServiceEndpointInterface() {
        return this.serviceEndpointInterface;
    }

    public Map<String, String> getActivationProperties() {
        return this.activationProperties;
    }

    public Class getPrimaryKeyClass() {
        return this.pkClass;
    }

    public EJBHome getEJBHome() {
        if (this.getHomeInterface() == null) {
            throw new IllegalStateException("This component has no home interface: " + this.getDeploymentID());
        }
        if (this.ejbHomeRef == null) {
            this.ejbHomeRef = (EJBHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.EJB_HOME);
        }
        return this.ejbHomeRef;
    }

    public EJBLocalHome getEJBLocalHome() {
        if (this.getLocalHomeInterface() == null) {
            throw new IllegalStateException("This component has no local home interface: " + this.getDeploymentID());
        }
        if (this.ejbLocalHomeRef == null) {
            this.ejbLocalHomeRef = (EJBLocalHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.EJB_LOCAL_HOME);
        }
        return this.ejbLocalHomeRef;
    }

    public BusinessLocalHome getBusinessLocalHome() {
        return this.getBusinessLocalHome(this.getBusinessLocalInterfaces(), null);
    }

    public BusinessLocalBeanHome getBusinessLocalBeanHome() {
        ArrayList<Class> interfaces = new ArrayList<Class>();
        interfaces.add(this.beanClass);
        return (BusinessLocalBeanHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.BUSINESS_LOCALBEAN_HOME, interfaces, this.beanClass);
    }

    public BusinessLocalHome getBusinessLocalHome(Class mainInterface) {
        List<Class> localInterfaces = this.getBusinessLocalInterfaces();
        List<Class> interfaces = ProxyInterfaceResolver.getInterfaces(this.getBeanClass(), mainInterface, localInterfaces);
        return this.getBusinessLocalHome(interfaces, mainInterface);
    }

    public BusinessLocalHome getBusinessLocalHome(List<Class> interfaces, Class mainInterface) {
        if (this.getBusinessLocalInterfaces().size() == 0) {
            throw new IllegalStateException("This component has no business local interfaces: " + this.getDeploymentID());
        }
        if (interfaces.size() == 0) {
            throw new IllegalArgumentException("No interface classes were specified");
        }
        for (Class clazz : interfaces) {
            if (this.getBusinessLocalInterfaces().contains(clazz)) continue;
            throw new IllegalArgumentException("Not a business interface of this bean:" + clazz.getName());
        }
        return (BusinessLocalHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.BUSINESS_LOCAL_HOME, interfaces, mainInterface);
    }

    public BusinessRemoteHome getBusinessRemoteHome() {
        return this.getBusinessRemoteHome(this.getBusinessRemoteInterfaces(), null);
    }

    public BusinessRemoteHome getBusinessRemoteHome(Class mainInterface) {
        List<Class> remoteInterfaces = this.getBusinessRemoteInterfaces();
        List<Class> interfaces = ProxyInterfaceResolver.getInterfaces(this.getBeanClass(), mainInterface, remoteInterfaces);
        return this.getBusinessRemoteHome(interfaces, mainInterface);
    }

    public BusinessRemoteHome getBusinessRemoteHome(List<Class> interfaces, Class mainInterface) {
        if (this.getBusinessRemoteInterfaces().size() == 0) {
            throw new IllegalStateException("This component has no business remote interfaces: " + this.getDeploymentID());
        }
        if (interfaces.size() == 0) {
            throw new IllegalArgumentException("No interface classes were specified");
        }
        for (Class clazz : interfaces) {
            if (this.getBusinessRemoteInterfaces().contains(clazz)) continue;
            throw new IllegalArgumentException("Not a business interface of this bean:" + clazz.getName());
        }
        return (BusinessRemoteHome)EjbHomeProxyHandler.createHomeProxy(this, InterfaceType.BUSINESS_REMOTE_HOME, interfaces, mainInterface);
    }

    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public void setBeanManagedTransaction(boolean value) {
        this.isBeanManagedTransaction = value;
    }

    public void setBeanManagedConcurrency(boolean beanManagedConcurrency) {
        this.isBeanManagedConcurrency = beanManagedConcurrency;
    }

    public Context getJndiEnc() {
        return this.jndiContext;
    }

    public boolean isReentrant() {
        return this.isReentrant;
    }

    public void setIsReentrant(boolean reentrant) {
        this.isReentrant = reentrant;
    }

    public Method getMatchingBeanMethod(Method interfaceMethod) {
        Method method = this.methodMap.get(interfaceMethod);
        return method == null ? interfaceMethod : method;
    }

    public MethodContext getMethodContext(Method method) {
        MethodContext methodContext = this.methodContextMap.get(method);
        if (methodContext == null) {
            methodContext = new MethodContext(this, method);
            this.methodContextMap.put(method, methodContext);
        }
        return methodContext;
    }

    public Iterator<Map.Entry<Method, MethodContext>> iteratorMethodContext() {
        return this.methodContextMap.entrySet().iterator();
    }

    public void setMethodConcurrencyAttribute(Method method, LockType concurrencyAttribute) {
        this.getMethodContext(method).setLockType(concurrencyAttribute);
    }

    public void setMethodTransactionAttribute(Method method, TransactionType transactionType) throws OpenEJBException {
        this.setMethodTransactionAttribute(method, transactionType, null);
    }

    public void setMethodTransactionAttribute(Method method, TransactionType transactionType, String view) throws OpenEJBException {
        if (view == null) {
            this.getMethodContext(method).setTransactionType(transactionType);
        } else {
            this.initViewMethodContext(method, view).setTransactionType(transactionType);
        }
    }

    public List<Method> getRemoveMethods() {
        return this.removeMethods;
    }

    public void setRetainIfExeption(Method removeMethod, boolean retain) {
        if (this.getRemoveMethods().contains(removeMethod)) {
            this.removeExceptionPolicy.put(removeMethod, retain);
        }
    }

    public boolean retainIfExeption(Method removeMethod) {
        Boolean retain = this.removeExceptionPolicy.get(removeMethod);
        return retain != null && retain != false;
    }

    public Set<InterceptorData> getInstanceScopedInterceptors() {
        return this.instanceScopedInterceptors;
    }

    public void addSystemInterceptor(Object interceptor) {
        this.systemInterceptors.add(new InterceptorInstance(interceptor));
    }

    public void addUserInterceptor(Object interceptor) {
        this.userInterceptors.add(new InterceptorInstance(interceptor));
    }

    public List<InterceptorInstance> getUserAndSystemInterceptors() {
        ArrayList<InterceptorInstance> interceptors = new ArrayList<InterceptorInstance>(this.systemInterceptors);
        interceptors.addAll(this.userInterceptors);
        return interceptors;
    }

    public List<InterceptorData> getCallbackInterceptors() {
        List<InterceptorData> datas = this.getInterceptorData();
        datas.addAll(this.callbackInterceptors);
        datas.addAll(this.cdiInterceptors);
        return datas;
    }

    public void setCallbackInterceptors(List<InterceptorData> callbackInterceptors) {
        this.callbackInterceptors.clear();
        this.callbackInterceptors.addAll(callbackInterceptors);
        this.instanceScopedInterceptors.addAll(callbackInterceptors);
    }

    public List<InterceptorData> getCdiInterceptors() {
        return new ArrayList<InterceptorData>(this.cdiInterceptors);
    }

    public void setCdiInterceptors(List<InterceptorData> cdiInterceptors) {
        this.cdiInterceptors.clear();
        this.cdiInterceptors.addAll(cdiInterceptors);
        this.instanceScopedInterceptors.addAll(cdiInterceptors);
    }

    public List<InterceptorData> getMethodInterceptors(Method method) {
        return this.getMethodContext(method).getInterceptors();
    }

    public List<InterceptorData> getInterceptorData() {
        ArrayList<InterceptorData> datas = new ArrayList<InterceptorData>();
        for (InterceptorInstance instance : this.getUserAndSystemInterceptors()) {
            datas.add(instance.getData());
        }
        return datas;
    }

    public void addCdiMethodInterceptor(Method method, InterceptorData interceptor) {
        this.getMethodContext(method).addCdiInterceptor(interceptor);
        this.instanceScopedInterceptors.add(interceptor);
    }

    public void setMethodInterceptors(Method method, List<InterceptorData> interceptors) {
        this.getMethodContext(method).setInterceptors(interceptors);
        this.instanceScopedInterceptors.addAll(interceptors);
    }

    public void createMethodMap() throws SystemException {
        if (this.remoteInterface != null) {
            this.mapObjectInterface(this.remoteInterface);
            this.mapHomeInterface(this.homeInterface);
        }
        if (this.localInterface != null) {
            this.mapObjectInterface(this.localInterface);
        }
        if (this.localHomeInterface != null) {
            this.mapHomeInterface(this.localHomeInterface);
        }
        if (this.serviceEndpointInterface != null) {
            this.mapObjectInterface(this.serviceEndpointInterface);
        }
        for (Class businessLocal : this.businessLocals) {
            this.mapObjectInterface(businessLocal);
        }
        for (Class businessRemote : this.businessRemotes) {
            this.mapObjectInterface(businessRemote);
        }
        if (this.componentType == BeanType.MESSAGE_DRIVEN && MessageDrivenBean.class.isAssignableFrom(this.beanClass)) {
            try {
                this.createMethod = this.beanClass.getMethod("ejbCreate", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        try {
            Method clientMethod;
            Method beanMethod;
            if (this.componentType == BeanType.STATEFUL || this.componentType == BeanType.MANAGED) {
                beanMethod = null;
                if (SessionBean.class.isAssignableFrom(this.beanClass)) {
                    beanMethod = SessionBean.class.getDeclaredMethod("ejbRemove", new Class[0]);
                } else {
                    for (Method method : this.getRemoveMethods()) {
                        if (method.getParameterTypes().length != 0) continue;
                        beanMethod = method;
                        break;
                    }
                    if (beanMethod == null && (this.homeInterface != null || this.localHomeInterface != null)) {
                        throw new IllegalStateException("Bean class has no @Remove methods to match EJBObject.remove() or EJBLocalObject.remove().  A no-arg remove method must be added: beanClass=" + this.beanClass.getName());
                    }
                }
                clientMethod = EJBHome.class.getDeclaredMethod("remove", Handle.class);
                this.mapMethods(clientMethod, beanMethod);
                clientMethod = EJBHome.class.getDeclaredMethod("remove", Object.class);
                this.mapMethods(clientMethod, beanMethod);
                clientMethod = EJBObject.class.getDeclaredMethod("remove", new Class[0]);
                this.mapMethods(clientMethod, beanMethod);
                clientMethod = EJBLocalObject.class.getDeclaredMethod("remove", new Class[0]);
                this.mapMethods(clientMethod, beanMethod);
            } else if (this.componentType == BeanType.BMP_ENTITY || this.componentType == BeanType.CMP_ENTITY) {
                beanMethod = EntityBean.class.getDeclaredMethod("ejbRemove", new Class[0]);
                clientMethod = EJBHome.class.getDeclaredMethod("remove", Handle.class);
                this.mapMethods(clientMethod, beanMethod);
                clientMethod = EJBHome.class.getDeclaredMethod("remove", Object.class);
                this.mapMethods(clientMethod, beanMethod);
                clientMethod = EJBObject.class.getDeclaredMethod("remove", new Class[0]);
                this.mapMethods(clientMethod, beanMethod);
                clientMethod = EJBLocalObject.class.getDeclaredMethod("remove", new Class[0]);
                this.mapMethods(clientMethod, beanMethod);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new SystemException(nsme);
        }
        if (this.mdbInterface != null) {
            this.mapObjectInterface(this.mdbInterface);
        }
    }

    private void mapHomeInterface(Class intrface) {
        Method[] homeMethods;
        for (Method method : homeMethods = intrface.getMethods()) {
            Class<?> owner = method.getDeclaringClass();
            if (owner == EJBHome.class || owner == EJBLocalHome.class) continue;
            try {
                String beanMethodName;
                Method beanMethod = null;
                if (method.getName().startsWith("create")) {
                    StringBuilder ejbCreateName = new StringBuilder(method.getName());
                    ejbCreateName.replace(0, 1, "ejbC");
                    this.createMethod = beanMethod = this.beanClass.getMethod(ejbCreateName.toString(), method.getParameterTypes());
                    if (this.componentType == BeanType.BMP_ENTITY || this.componentType == BeanType.CMP_ENTITY) {
                        ejbCreateName.insert(3, "Post");
                        Class clazz = this.beanClass;
                        if (this.cmpImplClass != null) {
                            clazz = this.cmpImplClass;
                        }
                        Method postCreateMethod = clazz.getMethod(ejbCreateName.toString(), method.getParameterTypes());
                        this.postCreateMethodMap.put(this.createMethod, postCreateMethod);
                    }
                } else if (method.getName().startsWith("find")) {
                    if (this.componentType == BeanType.BMP_ENTITY) {
                        beanMethodName = "ejbF" + method.getName().substring(1);
                        beanMethod = this.beanClass.getMethod(beanMethodName, method.getParameterTypes());
                    }
                } else {
                    beanMethodName = "ejbHome" + method.getName().substring(0, 1).toUpperCase() + method.getName().substring(1);
                    beanMethod = this.beanClass.getMethod(beanMethodName, method.getParameterTypes());
                }
                if (beanMethod == null) continue;
                this.mapMethods(method, beanMethod);
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
        }
    }

    public void mapMethods(Method interfaceMethod, Method beanMethod) {
        this.methodMap.put(interfaceMethod, beanMethod);
    }

    private void mapObjectInterface(Class intrface) {
        Method[] interfaceMethods;
        if (intrface == BusinessLocalHome.class || intrface == BusinessRemoteHome.class || intrface == ServiceEndpoint.class) {
            return;
        }
        for (Method method : interfaceMethods = intrface.getMethods()) {
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass == EJBObject.class || declaringClass == EJBLocalObject.class) continue;
            try {
                Method beanMethod = this.beanClass.getMethod(method.getName(), method.getParameterTypes());
                this.mapMethods(method, beanMethod);
            }
            catch (NoSuchMethodException nsme) {
                throw new OpenEJBRuntimeException("Invalid method [" + method + "]. Not declared by " + this.beanClass.getName() + " class");
            }
        }
    }

    public List<Class> getObjectInterface(Class homeInterface) {
        if (BusinessLocalHome.class.isAssignableFrom(homeInterface)) {
            return this.getBusinessLocalInterfaces();
        }
        if (BusinessRemoteHome.class.isAssignableFrom(homeInterface)) {
            return this.getBusinessRemoteInterfaces();
        }
        if (EJBLocalHome.class.isAssignableFrom(homeInterface)) {
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.add(this.getLocalInterface());
            return classes;
        }
        if (EJBHome.class.isAssignableFrom(homeInterface)) {
            ArrayList<Class> classes = new ArrayList<Class>();
            classes.add(this.getRemoteInterface());
            return classes;
        }
        throw new IllegalArgumentException("Cannot determine object interface for " + homeInterface);
    }

    public Method getCreateMethod() {
        return this.createMethod;
    }

    public Method getMatchingPostCreateMethod(Method createMethod) {
        return this.postCreateMethodMap.get(createMethod);
    }

    public boolean isAsynchronous(Method method) {
        Method matchingBeanMethod = this.getMatchingBeanMethod(method);
        Class<?> returnType = matchingBeanMethod.getReturnType();
        if (returnType != Void.TYPE && returnType != Future.class) {
            return false;
        }
        if (this.asynchronousClasses.contains(matchingBeanMethod.getDeclaringClass())) {
            return true;
        }
        MethodContext methodContext = this.methodContextMap.get(matchingBeanMethod);
        return methodContext == null ? false : methodContext.isAsynchronous();
    }

    public boolean isCmp2() {
        return this.cmp2;
    }

    public void setCmp2(boolean cmp2) {
        this.cmp2 = cmp2;
    }

    public String getPrimaryKeyField() {
        return this.primaryKeyField;
    }

    public void setPrimaryKeyField(String primaryKeyField) {
        this.primaryKeyField = primaryKeyField;
    }

    public KeyGenerator getKeyGenerator() {
        return this.keyGenerator;
    }

    public void setKeyGenerator(KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
    }

    public void setRemoteQueryResults(String methodSignature) {
        this.remoteQueryResults.add(methodSignature);
    }

    public boolean isRemoteQueryResults(String methodSignature) {
        return this.remoteQueryResults.contains(methodSignature);
    }

    public Class getCmpImplClass() {
        return this.cmpImplClass;
    }

    public void setCmpImplClass(Class cmpImplClass) {
        this.cmpImplClass = cmpImplClass;
    }

    public String getAbstractSchemaName() {
        return this.abstractSchemaName;
    }

    public void setAbstractSchemaName(String abstractSchemaName) {
        this.abstractSchemaName = abstractSchemaName;
    }

    public Method getEjbTimeout() {
        return this.ejbTimeout;
    }

    public void setEjbTimeout(Method ejbTimeout) {
        this.ejbTimeout = ejbTimeout;
    }

    public EjbTimerService getEjbTimerService() {
        return this.ejbTimerService;
    }

    public void setEjbTimerService(EjbTimerService ejbTimerService) {
        this.ejbTimerService = ejbTimerService;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public String getModuleID() {
        return this.getModuleContext().getModuleURI().toString();
    }

    public String getModuleName() {
        return this.getModuleContext().getId();
    }

    public String getRunAs() {
        return this.runAs;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public void setRunAs(String runAs) {
        this.runAs = runAs;
    }

    public String toString() {
        return "BeanContext(id=" + this.getDeploymentID() + ")";
    }

    public boolean isLoadOnStartup() {
        return this.loadOnStartup;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public Set<String> getDependsOn() {
        return this.dependsOn;
    }

    public boolean isSessionSynchronized() {
        return !this.isBeanManagedTransaction();
    }

    public boolean isLocalbean() {
        return this.localbean;
    }

    public Class getBusinessLocalBeanInterface() {
        if (this.isLocalbean()) {
            return this.beanClass;
        }
        return null;
    }

    public Duration getAccessTimeout(Method beanMethod) {
        return this.getMethodContext(beanMethod).getAccessTimeout();
    }

    public Duration getAccessTimeout() {
        return this.accessTimeout;
    }

    public void setAccessTimeout(Duration accessTimeout) {
        this.accessTimeout = accessTimeout;
    }

    public Duration getStatefulTimeout() {
        return this.statefulTimeout;
    }

    public void setStatefulTimeout(Duration statefulTimeout) {
        this.statefulTimeout = statefulTimeout;
    }

    public Class<Object> getManagedClass() {
        if (this.isDynamicallyImplemented()) {
            return this.getProxyClass();
        }
        return this.beanClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceContext newInstance() throws Exception {
        ThreadContext callContext = new ThreadContext(this, null, Operation.INJECTION);
        ThreadContext oldContext = ThreadContext.enter(callContext);
        WebBeansContext webBeansContext = null;
        ConstructorInjectionBean<Object> beanDefinition = null;
        webBeansContext = this.getModuleContext().getAppContext().getWebBeansContext();
        beanDefinition = (ConstructorInjectionBean<Object>)((Object)this.get(CdiEjbBean.class));
        if (this.isDynamicallyImplemented() && !InvocationHandler.class.isAssignableFrom(this.getProxyClass())) {
            throw new OpenEJBException("proxy class can only be InvocationHandler");
        }
        ConstructorInjectionBean<Object> beanConstructor = new ConstructorInjectionBean<Object>(webBeansContext, this.getManagedClass());
        if (beanDefinition == null) {
            beanDefinition = beanConstructor;
        }
        try {
            TransactionType transactionType;
            Class clazz;
            Object beanInstance;
            InjectionProcessor<Object> injectionProcessor;
            CreationalContext creationalContext;
            Context ctx = this.getJndiEnc();
            Class beanClass = this.getBeanClass();
            CurrentCreationalContext currentCreationalContext = this.get(CurrentCreationalContext.class);
            CreationalContext creationalContext2 = creationalContext = currentCreationalContext != null ? currentCreationalContext.get() : null;
            if (creationalContext == null) {
                creationalContext = webBeansContext.getBeanManagerImpl().createCreationalContext(beanDefinition);
            }
            if (!this.isDynamicallyImplemented()) {
                injectionProcessor = new InjectionProcessor<Object>(beanConstructor.create(creationalContext), this.getInjections(), InjectionProcessor.unwrap(ctx));
                beanInstance = injectionProcessor.createInstance();
                this.inject(beanInstance, creationalContext);
            } else {
                ArrayList<Injection> newInjections = new ArrayList<Injection>();
                for (Injection injection : this.getInjections()) {
                    if (beanClass.equals(injection.getTarget())) {
                        Injection updated = new Injection(injection.getJndiName(), injection.getName(), beanDefinition.getBeanClass());
                        newInjections.add(updated);
                        continue;
                    }
                    newInjections.add(injection);
                }
                this.injections.clear();
                this.injections.addAll(newInjections);
                injectionProcessor = new InjectionProcessor<Object>(beanConstructor.create(creationalContext), this.injections, InjectionProcessor.unwrap(ctx));
                InvocationHandler handler = (InvocationHandler)injectionProcessor.createInstance();
                beanInstance = DynamicProxyImplFactory.newProxy(this, handler);
                this.inject(handler, creationalContext);
            }
            HashMap<String, Object> interceptorInstances = new HashMap<String, Object>();
            for (InterceptorInstance interceptorInstance : this.getUserAndSystemInterceptors()) {
                clazz = interceptorInstance.getData().getInterceptorClass();
                interceptorInstances.put(clazz.getName(), interceptorInstance.getInterceptor());
            }
            for (InterceptorData interceptorData : this.getInstanceScopedInterceptors()) {
                if (interceptorData.getInterceptorClass().equals(beanClass)) continue;
                clazz = interceptorData.getInterceptorClass();
                ConstructorInjectionBean interceptorConstructor = new ConstructorInjectionBean(webBeansContext, clazz);
                InjectionProcessor<Object> interceptorInjector = new InjectionProcessor<Object>(interceptorConstructor.create(creationalContext), this.getInjections(), InjectionProcessor.unwrap(ctx));
                try {
                    Object interceptorInstance = interceptorInjector.createInstance();
                    try {
                        OWBInjector interceptorCdiInjector = new OWBInjector(webBeansContext);
                        interceptorCdiInjector.inject(interceptorInstance, creationalContext);
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    interceptorInstances.put(clazz.getName(), interceptorInstance);
                }
                catch (ConstructionException e) {
                    throw new Exception("Failed to create interceptor: " + clazz.getName(), e);
                }
            }
            interceptorInstances.put(beanClass.getName(), beanInstance);
            callContext.setCurrentOperation(Operation.POST_CONSTRUCT);
            List<InterceptorData> callbackInterceptors = this.getCallbackInterceptors();
            InterceptorStack postConstruct = new InterceptorStack(beanInstance, null, Operation.POST_CONSTRUCT, callbackInterceptors, interceptorInstances);
            if (this.getComponentType() == BeanType.SINGLETON) {
                Set<Method> callbacks = callbackInterceptors.get(callbackInterceptors.size() - 1).getPostConstruct();
                if (callbacks.isEmpty()) {
                    transactionType = TransactionType.RequiresNew;
                } else {
                    transactionType = this.getTransactionType(callbacks.iterator().next());
                    if (transactionType == TransactionType.Required) {
                        transactionType = TransactionType.RequiresNew;
                    }
                }
            } else {
                transactionType = this.isBeanManagedTransaction() ? TransactionType.BeanManaged : TransactionType.NotSupported;
            }
            TransactionPolicy transactionPolicy = EjbTransactionUtil.createTransactionPolicy(transactionType, callContext);
            try {
                postConstruct.invoke(new Object[0]);
            }
            catch (Throwable e) {
                EjbTransactionUtil.handleSystemException(transactionPolicy, e, callContext);
            }
            finally {
                EjbTransactionUtil.afterInvoke(transactionPolicy, callContext);
            }
            InstanceContext instanceContext = new InstanceContext(this, beanInstance, interceptorInstances, creationalContext);
            return instanceContext;
        }
        finally {
            ThreadContext.exit(oldContext);
        }
    }

    protected <X> X getBean(Class<X> clazz, Bean<?> bean) {
        return clazz.cast(bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void inject(T instance, CreationalContext<T> ctx) {
        WebBeansContext webBeansContext = this.getModuleContext().getAppContext().getWebBeansContext();
        ConstructorInjectionBean<Object> beanDefinition = (ConstructorInjectionBean<Object>)((Object)this.get(CdiEjbBean.class));
        ConstructorInjectionBean<Object> beanConstructor = new ConstructorInjectionBean<Object>(webBeansContext, this.getManagedClass());
        if (beanDefinition == null) {
            beanDefinition = beanConstructor;
        }
        if (!(ctx instanceof CreationalContextImpl)) {
            ctx = webBeansContext.getCreationalContextFactory().wrappedCreationalContext(ctx, beanDefinition);
        }
        Object oldInstanceUnderInjection = AbstractInjectable.instanceUnderInjection.get();
        boolean isInjectionToAnotherBean = false;
        try {
            Contextual contextual = null;
            if (ctx instanceof CreationalContextImpl) {
                contextual = ((CreationalContextImpl)ctx).getBean();
                boolean bl = isInjectionToAnotherBean = contextual != this.getBean((Class)InjectionTargetBean.class, (Bean<?>)beanDefinition);
            }
            if (!isInjectionToAnotherBean) {
                AbstractInjectable.instanceUnderInjection.set(instance);
            }
            InjectionTargetBean bean = this.getBean((Class)InjectionTargetBean.class, (Bean<?>)beanDefinition);
            bean.injectResources(instance, ctx);
            bean.injectSuperFields(instance, ctx);
            bean.injectSuperMethods(instance, ctx);
            bean.injectFields(instance, ctx);
            bean.injectMethods(instance, ctx);
        }
        finally {
            if (oldInstanceUnderInjection != null) {
                AbstractInjectable.instanceUnderInjection.set(oldInstanceUnderInjection);
            } else {
                AbstractInjectable.instanceUnderInjection.set(null);
                AbstractInjectable.instanceUnderInjection.remove();
            }
        }
    }

    public Set<Class<?>> getAsynchronousClasses() {
        return this.asynchronousClasses;
    }

    public Set<String> getAsynchronousMethodSignatures() {
        return this.asynchronousMethodSignatures;
    }

    public void createAsynchronousMethodSet() {
        for (Map.Entry<Method, MethodContext> entry : this.methodContextMap.entrySet()) {
            if (!entry.getValue().isAsynchronous()) continue;
            this.asynchronousMethodSignatures.add(this.generateMethodSignature(entry.getKey()));
        }
        for (Class clazz : this.asynchronousClasses) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!Modifier.isPublic(method.getModifiers())) continue;
                this.asynchronousMethodSignatures.add(this.generateMethodSignature(method));
            }
        }
    }

    private String generateMethodSignature(Method method) {
        StringBuilder buffer = new StringBuilder(method.getName());
        for (Class<?> parameterType : method.getParameterTypes()) {
            buffer.append(parameterType.getName());
        }
        return buffer.toString();
    }

    private MethodContext getViewMethodContext(Method method, String view) {
        ViewContext viewContext = this.viewContextMap.get(view);
        return viewContext == null ? null : viewContext.getMethodContext(method);
    }

    private MethodContext initViewMethodContext(Method method, String view) {
        ViewContext viewContext = this.viewContextMap.get(view);
        if (viewContext == null) {
            viewContext = new ViewContext();
            this.viewContextMap.put(view, viewContext);
        }
        return viewContext.initMethodContext(method);
    }

    public Class<?> getProxyClass() {
        return this.proxyClass;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public class ViewContext {
        private final Map<Method, MethodContext> methodContextMap = new HashMap<Method, MethodContext>();

        public MethodContext getMethodContext(Method method) {
            return this.methodContextMap.get(method);
        }

        public MethodContext initMethodContext(Method method) {
            MethodContext methodContext = this.methodContextMap.get(method);
            if (methodContext != null) {
                return methodContext;
            }
            methodContext = new MethodContext(BeanContext.this, method);
            this.methodContextMap.put(method, methodContext);
            return methodContext;
        }
    }

    public static class Comp {
        public static String openejbCompName(String module) {
            return module + "." + Comp.class.getSimpleName();
        }
    }

    public static interface Timeout {
    }

    public static interface ServiceEndpoint {
    }

    public static interface Removable {
        public void $$remove();
    }

    public static interface BusinessRemoteHome
    extends EJBHome {
        public Object create();
    }

    public static interface BusinessLocalBeanHome
    extends EJBLocalHome {
        public Object create();
    }

    public static interface BusinessLocalHome
    extends EJBLocalHome {
        public Object create();
    }
}

