/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import java.util.concurrent.Semaphore;
import org.apache.openejb.OpenEjbContainer;

public class Core {
    public static void warmup() {
    }

    static {
        String[] classes = new String[]{"org.apache.openejb.util.JuliLogStreamFactory", "org.slf4j.LoggerFactory", "org.slf4j.impl.StaticLoggerBinder", "org.apache.openejb.config.sys.JaxbJavaee", "org.apache.bval.jsr303.ApacheValidatorFactory", "org.apache.bval.jsr303.ConstraintAnnotationAttributes", "org.apache.bval.jsr303.ConstraintDefaults", "org.apache.bval.jsr303.groups.GroupsComputer", "org.apache.bval.jsr303.xml.ValidationMappingParser", "org.apache.bval.util.PrivilegedActions", "org.apache.geronimo.transaction.manager.TransactionManagerImpl", "org.apache.openejb.InterfaceType", "org.apache.openejb.assembler.classic.Assembler", "org.apache.openejb.assembler.classic.AssemblerTool", "org.apache.openejb.cdi.CdiBuilder", "org.apache.openejb.cdi.ThreadSingletonServiceImpl", "org.apache.openejb.config.AppValidator", "org.apache.openejb.config.AnnotationDeployer", "org.apache.openejb.config.AutoConfig", "org.apache.openejb.config.ConfigurationFactory", "org.apache.openejb.config.MBeanDeployer", "org.apache.openejb.config.PersistenceContextAnnFactory", "org.apache.openejb.core.ServerFederation", "org.apache.openejb.core.ivm.EjbHomeProxyHandler$1", "org.apache.openejb.core.ivm.EjbHomeProxyHandler$MethodType", "org.apache.openejb.core.managed.ManagedContainer$MethodType", "org.apache.openejb.loader.FileUtils", "org.apache.openejb.loader.IO", "org.apache.openejb.loader.SystemInstance", "org.apache.openejb.monitoring.StatsInterceptor", "org.apache.openejb.persistence.JtaEntityManagerRegistry", "org.apache.openejb.util.Duration", "org.apache.openejb.util.Join", "org.apache.openejb.util.JuliLogStreamFactory", "org.apache.openejb.util.LogCategory", "org.apache.openejb.util.Logger", "org.apache.openejb.util.Messages", "org.apache.openejb.util.SafeToolkit", "org.apache.openejb.util.StringTemplate", "org.apache.openejb.util.proxy.ProxyManager", "org.apache.openjpa.enhance.PCRegistry", "org.apache.openjpa.lib.util.Localizer", "org.apache.xbean.naming.reference.SimpleReference", "org.apache.xbean.propertyeditor.PropertyEditors", "org.apache.xbean.propertyeditor.ReferenceIdentityMap", "org.apache.xbean.recipe.ReflectionUtil"};
        int permits = 2;
        final Semaphore semaphore = new Semaphore(2);
        final ClassLoader loader = OpenEjbContainer.class.getClassLoader();
        for (final String className : classes) {
            try {
                semaphore.acquire();
                Thread thread = new Thread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Class.forName(className, true, loader);
                        }
                        catch (Throwable throwable) {
                        }
                        finally {
                            semaphore.release();
                        }
                    }
                });
                thread.setDaemon(true);
                thread.start();
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
        try {
            semaphore.acquire(2);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }

    public static class Parallel {
        public static void exec(Runnable ... runnables) {
            int permits = 2;
            Semaphore semaphore = new Semaphore(2);
            for (Runnable runnable : runnables) {
                try {
                    semaphore.acquire();
                    Thread thread = new Thread();
                    thread.setDaemon(true);
                    thread.start();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
            try {
                semaphore.acquire(2);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
        }
    }
}

