/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler;

import java.util.Collection;
import java.util.Properties;
import javax.management.Description;
import javax.management.MBean;
import javax.management.ManagedAttribute;
import javax.management.ManagedOperation;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.DeployerEjb;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.core.LocalInitialContextFactory;

@MBean
@Description(value="OpenEJB Deployer")
public class JMXDeployer {
    @ManagedOperation
    @Description(value="Deploy the specified application")
    public String deploy(String location) {
        try {
            JMXDeployer.deployer().deploy(location);
            return "OK";
        }
        catch (Exception e) {
            return "ERR:" + e.getMessage();
        }
    }

    @ManagedOperation
    @Description(value="Undeploy the specified application")
    public String undeploy(String moduleId) {
        try {
            JMXDeployer.deployer().undeploy(moduleId);
            return "OK";
        }
        catch (Exception e) {
            return "ERR:" + e.getMessage();
        }
    }

    @ManagedAttribute
    @Description(value="List available applications")
    public String[] getDeployedApplications() {
        try {
            Collection<AppInfo> apps = JMXDeployer.deployer().getDeployedApps();
            String[] appsNames = new String[apps.size()];
            int i = 0;
            for (AppInfo info : apps) {
                appsNames[i++] = info.path;
            }
            return appsNames;
        }
        catch (Exception e) {
            return new String[]{"ERR:" + e.getMessage()};
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Deployer deployer() throws NamingException {
        Properties p = new Properties();
        p.setProperty("java.naming.factory.initial", LocalInitialContextFactory.class.getName());
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(DeployerEjb.class.getClassLoader());
        try {
            Deployer deployer = (Deployer)new InitialContext(p).lookup("openejb/DeployerBusinessRemote");
            return deployer;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

