/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.CmrFieldInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.EntityBeanInfo;
import org.apache.openejb.core.cmp.CmpUtil;
import org.apache.openejb.core.cmp.cmp2.Cmp1Generator;
import org.apache.openejb.core.cmp.cmp2.Cmp2Generator;
import org.apache.openejb.core.cmp.cmp2.CmrField;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.UrlCache;

public class CmpJarBuilder {
    private final ClassLoader tempClassLoader;
    private File jarFile;
    private final Set<String> entries = new TreeSet<String>();
    private final AppInfo appInfo;

    public CmpJarBuilder(AppInfo appInfo, ClassLoader classLoader) {
        this.appInfo = appInfo;
        this.tempClassLoader = ClassLoaderUtil.createTempClassLoader(classLoader);
    }

    public File getJarFile() throws IOException {
        if (this.jarFile == null) {
            this.generate();
        }
        return this.jarFile;
    }

    private void generate() throws IOException {
        if (!this.hasCmpBeans()) {
            return;
        }
        boolean threwException = false;
        JarOutputStream jarOutputStream = this.openJarFile();
        try {
            for (EjbJarInfo ejbJar : this.appInfo.ejbJars) {
                for (EnterpriseBeanInfo beanInfo : ejbJar.enterpriseBeans) {
                    if (!(beanInfo instanceof EntityBeanInfo)) continue;
                    EntityBeanInfo entityBeanInfo = (EntityBeanInfo)beanInfo;
                    if (!"CONTAINER".equalsIgnoreCase(entityBeanInfo.persistenceType)) continue;
                    this.generateClass(jarOutputStream, entityBeanInfo);
                }
            }
            if (this.appInfo.cmpMappingsXml != null) {
                this.addJarEntry(jarOutputStream, "META-INF/openejb-cmp-generated-orm.xml", this.appInfo.cmpMappingsXml.getBytes());
            }
        }
        catch (IOException e) {
            threwException = true;
            throw e;
        }
        finally {
            this.close(jarOutputStream);
            if (threwException) {
                this.jarFile.delete();
                this.jarFile = null;
            }
        }
    }

    private boolean hasCmpBeans() {
        for (EjbJarInfo ejbJar : this.appInfo.ejbJars) {
            for (EnterpriseBeanInfo beanInfo : ejbJar.enterpriseBeans) {
                if (!(beanInfo instanceof EntityBeanInfo)) continue;
                EntityBeanInfo entityBeanInfo = (EntityBeanInfo)beanInfo;
                if (!"CONTAINER".equalsIgnoreCase(entityBeanInfo.persistenceType)) continue;
                return true;
            }
        }
        return false;
    }

    private void generateClass(JarOutputStream jarOutputStream, EntityBeanInfo entityBeanInfo) throws IOException {
        byte[] bytes;
        String cmpImplClass = CmpUtil.getCmpImplClassName(entityBeanInfo.abstractSchemaName, entityBeanInfo.ejbClass);
        String entryName = cmpImplClass.replace(".", "/") + ".class";
        if (this.entries.contains(entryName) || this.tempClassLoader.getResource(entryName) != null) {
            return;
        }
        Class<?> beanClass = null;
        try {
            beanClass = this.tempClassLoader.loadClass(entityBeanInfo.ejbClass);
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException("Could not find entity bean class " + beanClass).initCause(e);
        }
        Class<?> primKeyClass = null;
        if (entityBeanInfo.primKeyClass != null) {
            try {
                primKeyClass = this.tempClassLoader.loadClass(entityBeanInfo.primKeyClass);
            }
            catch (ClassNotFoundException e) {
                throw (IOException)new IOException("Could not find entity primary key class " + entityBeanInfo.primKeyClass).initCause(e);
            }
        }
        if (entityBeanInfo.cmpVersion != 2) {
            Cmp1Generator cmp1Generator = new Cmp1Generator(cmpImplClass, beanClass);
            if ("java.lang.Object".equals(entityBeanInfo.primKeyClass)) {
                cmp1Generator.setUnknownPk(true);
            }
            bytes = cmp1Generator.generate();
        } else {
            Cmp2Generator cmp2Generator = new Cmp2Generator(cmpImplClass, beanClass, entityBeanInfo.primKeyField, primKeyClass, entityBeanInfo.cmpFieldNames.toArray(new String[entityBeanInfo.cmpFieldNames.size()]));
            for (CmrFieldInfo cmrFieldInfo : entityBeanInfo.cmrFields) {
                EntityBeanInfo roleSource = cmrFieldInfo.mappedBy.roleSource;
                CmrField cmrField = new CmrField(cmrFieldInfo.fieldName, cmrFieldInfo.fieldType, CmpUtil.getCmpImplClassName(roleSource.abstractSchemaName, roleSource.ejbClass), roleSource.local, cmrFieldInfo.mappedBy.fieldName, cmrFieldInfo.synthetic);
                cmp2Generator.addCmrField(cmrField);
            }
            bytes = cmp2Generator.generate();
        }
        this.addJarEntry(jarOutputStream, entryName, bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJarEntry(JarOutputStream jarOutputStream, String fileName, byte[] bytes) throws IOException {
        String path = "";
        StringTokenizer tokenizer = new StringTokenizer(fileName, "/");
        while (tokenizer.hasMoreTokens()) {
            String part = tokenizer.nextToken();
            if (!tokenizer.hasMoreTokens() || this.entries.contains(path = path + part + "/")) continue;
            jarOutputStream.putNextEntry(new JarEntry(path));
            jarOutputStream.closeEntry();
            this.entries.add(path);
        }
        jarOutputStream.putNextEntry(new JarEntry(fileName));
        try {
            jarOutputStream.write(bytes);
        }
        finally {
            jarOutputStream.closeEntry();
            this.entries.add(fileName);
        }
    }

    private JarOutputStream openJarFile() throws IOException {
        if (this.jarFile != null) {
            throw new IllegalStateException("Jar file is closed");
        }
        this.jarFile = UrlCache.cacheDir != null ? File.createTempFile("OpenEJB_Generated_", ".jar", UrlCache.cacheDir) : File.createTempFile("OpenEJB_Generated_", ".jar");
        this.jarFile.deleteOnExit();
        JarOutputStream jarOutputStream = new JarOutputStream(IO.write((File)this.jarFile));
        return jarOutputStream;
    }

    private void close(JarOutputStream jarOutputStream) {
        if (jarOutputStream != null) {
            try {
                jarOutputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

