/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.util.HashMap;
import java.util.concurrent.Callable;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.openejb.assembler.classic.ImportSql;
import org.apache.openejb.assembler.classic.ValidatorFactoryWrapper;
import org.apache.openejb.persistence.PersistenceUnitInfoImpl;

public class EntityManagerFactoryCallable
implements Callable<EntityManagerFactory> {
    private final String persistenceProviderClassName;
    private final PersistenceUnitInfoImpl unitInfo;

    public EntityManagerFactoryCallable(String persistenceProviderClassName, PersistenceUnitInfoImpl unitInfo) {
        this.persistenceProviderClassName = persistenceProviderClassName;
        this.unitInfo = unitInfo;
    }

    @Override
    public EntityManagerFactory call() throws Exception {
        ImportSql importer;
        ClassLoader appClassLoader = Thread.currentThread().getContextClassLoader();
        Class<?> clazz = appClassLoader.loadClass(this.persistenceProviderClassName);
        PersistenceProvider persistenceProvider = (PersistenceProvider)clazz.newInstance();
        HashMap<String, ValidatorFactoryWrapper> properties = new HashMap<String, ValidatorFactoryWrapper>();
        properties.put("javax.persistence.validator.ValidatorFactory", new ValidatorFactoryWrapper());
        EntityManagerFactory emf = persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.unitInfo, properties);
        if (this.unitInfo.getNonJtaDataSource() != null && (importer = new ImportSql(appClassLoader, this.unitInfo.getPersistenceUnitName(), this.unitInfo.getNonJtaDataSource())).hasSomethingToImport()) {
            emf.createEntityManager().close();
            importer.doImport();
        }
        return emf;
    }

    public PersistenceUnitInfoImpl getUnitInfo() {
        return this.unitInfo;
    }
}

