/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.util.ArrayList;
import java.util.List;
import org.apache.openejb.Injection;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.EjbLocalReferenceInfo;
import org.apache.openejb.assembler.classic.EjbReferenceInfo;
import org.apache.openejb.assembler.classic.EnvEntryInfo;
import org.apache.openejb.assembler.classic.InjectionInfo;
import org.apache.openejb.assembler.classic.JndiEncInfo;
import org.apache.openejb.assembler.classic.PersistenceContextReferenceInfo;
import org.apache.openejb.assembler.classic.PersistenceUnitReferenceInfo;
import org.apache.openejb.assembler.classic.ResourceEnvReferenceInfo;
import org.apache.openejb.assembler.classic.ResourceReferenceInfo;
import org.apache.openejb.assembler.classic.ServiceReferenceInfo;

public class InjectionBuilder {
    private final ClassLoader classLoader;

    public InjectionBuilder(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public List<Injection> buildInjections(JndiEncInfo jndiEnc) throws OpenEJBException {
        Injection injection;
        Class targetClass;
        ArrayList<Injection> injections = new ArrayList<Injection>();
        for (EnvEntryInfo envEntryInfo : jndiEnc.envEntries) {
            for (InjectionInfo target : envEntryInfo.targets) {
                try {
                    targetClass = this.loadClass(target.className);
                }
                catch (OpenEJBException ex) {
                    continue;
                }
                injection = new Injection(envEntryInfo.referenceName, target.propertyName, targetClass);
                injections.add(injection);
            }
        }
        for (EjbReferenceInfo ejbReferenceInfo : jndiEnc.ejbReferences) {
            for (InjectionInfo target : ejbReferenceInfo.targets) {
                try {
                    targetClass = this.loadClass(target.className);
                }
                catch (OpenEJBException ex) {
                    continue;
                }
                injection = new Injection(ejbReferenceInfo.referenceName, target.propertyName, targetClass);
                injections.add(injection);
            }
        }
        for (EjbLocalReferenceInfo ejbLocalReferenceInfo : jndiEnc.ejbLocalReferences) {
            for (InjectionInfo target : ejbLocalReferenceInfo.targets) {
                try {
                    targetClass = this.loadClass(target.className);
                }
                catch (OpenEJBException ex) {
                    continue;
                }
                injection = new Injection(ejbLocalReferenceInfo.referenceName, target.propertyName, targetClass);
                injections.add(injection);
            }
        }
        for (PersistenceUnitReferenceInfo persistenceUnitReferenceInfo : jndiEnc.persistenceUnitRefs) {
            for (InjectionInfo target : persistenceUnitReferenceInfo.targets) {
                try {
                    targetClass = this.loadClass(target.className);
                }
                catch (OpenEJBException ex) {
                    continue;
                }
                injection = new Injection(persistenceUnitReferenceInfo.referenceName, target.propertyName, targetClass);
                injections.add(injection);
            }
        }
        for (PersistenceContextReferenceInfo persistenceContextReferenceInfo : jndiEnc.persistenceContextRefs) {
            for (InjectionInfo target : persistenceContextReferenceInfo.targets) {
                try {
                    targetClass = this.loadClass(target.className);
                }
                catch (OpenEJBException ex) {
                    continue;
                }
                injection = new Injection(persistenceContextReferenceInfo.referenceName, target.propertyName, targetClass);
                injections.add(injection);
            }
        }
        for (ResourceReferenceInfo resourceReferenceInfo : jndiEnc.resourceRefs) {
            for (InjectionInfo target : resourceReferenceInfo.targets) {
                try {
                    targetClass = this.loadClass(target.className);
                }
                catch (OpenEJBException ex) {
                    continue;
                }
                injection = new Injection(resourceReferenceInfo.referenceName, target.propertyName, targetClass);
                injections.add(injection);
            }
        }
        for (ResourceEnvReferenceInfo resourceEnvReferenceInfo : jndiEnc.resourceEnvRefs) {
            for (InjectionInfo target : resourceEnvReferenceInfo.targets) {
                try {
                    targetClass = this.loadClass(target.className);
                }
                catch (OpenEJBException ex) {
                    continue;
                }
                injection = new Injection(resourceEnvReferenceInfo.referenceName, target.propertyName, targetClass);
                injections.add(injection);
            }
        }
        for (ServiceReferenceInfo serviceReferenceInfo : jndiEnc.serviceRefs) {
            for (InjectionInfo target : serviceReferenceInfo.targets) {
                try {
                    targetClass = this.loadClass(target.className);
                }
                catch (OpenEJBException ex) {
                    continue;
                }
                injection = new Injection(serviceReferenceInfo.referenceName, target.propertyName, targetClass);
                injections.add(injection);
            }
        }
        return injections;
    }

    private Class loadClass(String className) throws OpenEJBException {
        try {
            Class<?> clazz = Class.forName(className, true, this.classLoader);
            return clazz;
        }
        catch (Throwable e) {
            throw new OpenEJBException("Unable to load class " + className);
        }
    }
}

