/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.ClassListInfo;
import org.apache.openejb.assembler.classic.ClientInfo;
import org.apache.openejb.assembler.classic.ConnectorInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.HandlerChainInfo;
import org.apache.openejb.assembler.classic.JndiEncInfo;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.MessageDrivenBeanInfo;
import org.apache.openejb.assembler.classic.PersistenceUnitInfo;
import org.apache.openejb.assembler.classic.PortInfo;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.ServletInfo;
import org.apache.openejb.assembler.classic.ValidatorBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConfigUtils;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.EjbJarInfoBuilder;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.JPAPropertyConverter;
import org.apache.openejb.config.JndiEncInfoBuilder;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.ReportValidationResults;
import org.apache.openejb.config.ServiceUtils;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.Container;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.ServiceProvider;
import org.apache.openejb.jee.AdminObject;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.ConfigProperty;
import org.apache.openejb.jee.ConnectionDefinition;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.InboundResourceadapter;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.MessageListener;
import org.apache.openejb.jee.OutboundResourceAdapter;
import org.apache.openejb.jee.PortComponent;
import org.apache.openejb.jee.ResourceAdapter;
import org.apache.openejb.jee.ServiceImplBean;
import org.apache.openejb.jee.Servlet;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebserviceDescription;
import org.apache.openejb.jee.Webservices;
import org.apache.openejb.jee.jpa.EntityMappings;
import org.apache.openejb.jee.jpa.JpaJaxbUtil;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.CircularReferencesException;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.References;
import org.apache.openejb.util.URLs;

class AppInfoBuilder {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");
    private static final Messages messages = new Messages("org.apache.openejb.util.resources");
    private final ConfigurationFactory configFactory;
    private EjbJarInfoBuilder ejbJarInfoBuilder = new EjbJarInfoBuilder();

    public AppInfoBuilder(ConfigurationFactory configFactory) {
        this.configFactory = configFactory;
    }

    public AppInfo build(AppModule appModule) throws OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.appId = appModule.getModuleId();
        appInfo.path = appModule.getJarLocation();
        appInfo.standaloneModule = appModule.isStandaloneModule();
        appInfo.watchedResources.addAll(appModule.getWatchedResources());
        appInfo.mbeans.addAll(appModule.getAdditionalLibMbeans());
        if (appInfo.appId == null) {
            throw new IllegalArgumentException("AppInfo.appId cannot be null");
        }
        if (appInfo.path == null) {
            appInfo.path = appInfo.appId;
        }
        this.buildAppResources(appModule, appInfo);
        this.buildConnectorModules(appModule, appInfo);
        this.buildPersistenceModules(appModule, appInfo);
        List<String> containerIds = this.configFactory.getContainerIds();
        for (ConnectorInfo connectorInfo : appInfo.connectors) {
            for (MdbContainerInfo containerInfo : connectorInfo.inbound) {
                containerIds.add(containerInfo.id);
            }
        }
        HashMap<EjbModule, EjbJarInfo> ejbJarInfos = new HashMap<EjbModule, EjbJarInfo>();
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            try {
                EjbJarInfo ejbJarInfo = this.ejbJarInfoBuilder.buildInfo(ejbModule);
                ejbJarInfo.mbeans = ejbModule.getMbeans();
                Map deploymentsByEjbName = ejbModule.getOpenejbJar().getDeploymentsByEjbName();
                for (EnterpriseBeanInfo bean : ejbJarInfo.enterpriseBeans) {
                    EjbDeployment d = (EjbDeployment)deploymentsByEjbName.get(bean.ejbName);
                    if (bean instanceof MessageDrivenBeanInfo && !containerIds.contains(d.getContainerId()) && !AppInfoBuilder.skipMdb(bean)) {
                        MessageDrivenBeanInfo mdb = (MessageDrivenBeanInfo)bean;
                        String newContainerId = d.getContainerId() + "-" + mdb.mdbInterface;
                        if (containerIds.contains(newContainerId)) {
                            d.setContainerId(newContainerId);
                        }
                    }
                    if (!containerIds.contains(d.getContainerId()) && !AppInfoBuilder.skipMdb(bean)) {
                        String msg = messages.format("config.noContainerFound", d.getContainerId(), d.getEjbName());
                        logger.fatal(msg);
                        throw new OpenEJBException(msg);
                    }
                    bean.containerId = d.getContainerId();
                }
                ejbJarInfo.validationInfo = ValidatorBuilder.getInfo(ejbModule.getValidationConfig());
                ejbJarInfo.portInfos.addAll(this.configureWebservices(ejbModule.getWebservices()));
                ejbJarInfo.uniqueId = ejbModule.getUniqueId();
                ejbJarInfo.repositories = ejbModule.getRepositories();
                this.configureWebserviceSecurity(ejbJarInfo, ejbModule);
                ejbJarInfos.put(ejbModule, ejbJarInfo);
                appInfo.ejbJars.add(ejbJarInfo);
            }
            catch (OpenEJBException e) {
                ConfigUtils.logger.warning("conf.0004", ejbModule.getJarLocation(), e.getMessage());
                throw e;
            }
        }
        JndiEncInfoBuilder jndiEncInfoBuilder = new JndiEncInfoBuilder(appInfo);
        if (appModule.getApplication() != null) {
            jndiEncInfoBuilder.build((JndiConsumer)appModule.getApplication(), appInfo.appId, null, appModule.getModuleUri(), new JndiEncInfo(), new JndiEncInfo());
        }
        ArrayList<EnterpriseBeanInfo> beans = new ArrayList<EnterpriseBeanInfo>();
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            EjbJarInfo ejbJar = (EjbJarInfo)ejbJarInfos.get(ejbModule);
            Map beanData = ejbModule.getEjbJar().getEnterpriseBeansByEjbName();
            for (EnterpriseBeanInfo beanInfo : ejbJar.enterpriseBeans) {
                beans.add(beanInfo);
                EnterpriseBean enterpriseBean = (EnterpriseBean)beanData.get(beanInfo.ejbName);
                jndiEncInfoBuilder.build((JndiConsumer)enterpriseBean, beanInfo.ejbName, ejbJar.moduleName, ejbModule.getModuleUri(), ejbJar.moduleJndiEnc, beanInfo.jndiEnc);
                jndiEncInfoBuilder.buildDependsOnRefs(ejbModule, enterpriseBean, beanInfo, ejbJar.moduleName);
            }
        }
        try {
            References.sort(beans, new References.Visitor<EnterpriseBeanInfo>(){

                @Override
                public String getName(EnterpriseBeanInfo bean) {
                    return bean.ejbDeploymentId;
                }

                @Override
                public Set<String> getReferences(EnterpriseBeanInfo bean) {
                    return new LinkedHashSet<String>(bean.dependsOn);
                }
            });
        }
        catch (CircularReferencesException e) {
            // empty catch block
        }
        this.buildClientModules(appModule, appInfo, jndiEncInfoBuilder);
        this.buildWebModules(appModule, jndiEncInfoBuilder, appInfo);
        List<URL> additionalLibraries = appModule.getAdditionalLibraries();
        for (URL url : additionalLibraries) {
            File file = URLs.toFile(url);
            try {
                appInfo.libs.add(file.getCanonicalPath());
            }
            catch (IOException e) {
                throw new OpenEJBException("Invalid application lib path " + file.getAbsolutePath());
            }
        }
        if (appModule.getCmpMappings() != null) {
            try {
                appInfo.cmpMappingsXml = JpaJaxbUtil.marshal(EntityMappings.class, (Object)appModule.getCmpMappings());
            }
            catch (JAXBException e) {
                throw new OpenEJBException("Unable to marshal cmp entity mappings", e);
            }
        }
        ReportValidationResults reportValidationResults = new ReportValidationResults();
        reportValidationResults.deploy(appModule);
        logger.info("config.appLoaded", appInfo.path);
        return appInfo;
    }

    private void buildAppResources(AppModule module, AppInfo info) {
        for (Resource def : module.getResources()) {
            ResourceInfo resourceInfo = new ResourceInfo();
            resourceInfo.id = module.getModuleId() + "/" + def.getJndi().replace("java:", "");
            resourceInfo.service = "Resource";
            resourceInfo.types.add(def.getType());
            resourceInfo.properties = def.getProperties();
            info.resourceInfos.add(resourceInfo);
        }
    }

    private void buildClientModules(AppModule appModule, AppInfo appInfo, JndiEncInfoBuilder jndiEncInfoBuilder) throws OpenEJBException {
        for (ClientModule clientModule : appModule.getClientModules()) {
            ApplicationClient applicationClient = clientModule.getApplicationClient();
            ClientInfo clientInfo = new ClientInfo();
            clientInfo.description = applicationClient.getDescription();
            clientInfo.displayName = applicationClient.getDisplayName();
            clientInfo.path = clientModule.getJarLocation();
            clientInfo.mainClass = clientModule.getMainClass();
            clientInfo.localClients.addAll(clientModule.getLocalClients());
            clientInfo.remoteClients.addAll(clientModule.getRemoteClients());
            clientInfo.callbackHandler = applicationClient.getCallbackHandler();
            clientInfo.moduleId = AppInfoBuilder.getClientModuleId(clientModule);
            clientInfo.watchedResources.addAll(clientModule.getWatchedResources());
            clientInfo.validationInfo = ValidatorBuilder.getInfo(clientModule.getValidationConfig());
            clientInfo.uniqueId = clientModule.getUniqueId();
            jndiEncInfoBuilder.build((JndiConsumer)applicationClient, clientModule.getJarLocation(), clientInfo.moduleId, clientModule.getModuleUri(), clientInfo.jndiEnc, clientInfo.jndiEnc);
            appInfo.clients.add(clientInfo);
        }
    }

    private void buildWebModules(AppModule appModule, JndiEncInfoBuilder jndiEncInfoBuilder, AppInfo appInfo) throws OpenEJBException {
        for (WebModule webModule : appModule.getWebModules()) {
            WebApp webApp = webModule.getWebApp();
            WebAppInfo webAppInfo = new WebAppInfo();
            webAppInfo.description = webApp.getDescription();
            webAppInfo.displayName = webApp.getDisplayName();
            webAppInfo.path = webModule.getJarLocation();
            webAppInfo.moduleId = webModule.getModuleId();
            webAppInfo.watchedResources.addAll(webModule.getWatchedResources());
            webAppInfo.validationInfo = ValidatorBuilder.getInfo(webModule.getValidationConfig());
            webAppInfo.uniqueId = webModule.getUniqueId();
            webAppInfo.restApplications.addAll(webModule.getRestApplications());
            webAppInfo.restClass.addAll(webModule.getRestClasses());
            webAppInfo.ejbWebServices.addAll(webModule.getEjbWebServices());
            webAppInfo.ejbRestServices.addAll(webModule.getEjbRestServices());
            webAppInfo.webAnnotatedClasses.addAll(webModule.getWebAnnotatedClasses());
            for (Map.Entry<String, Set<String>> entry : webModule.getJsfAnnotatedClasses().entrySet()) {
                ClassListInfo info = new ClassListInfo();
                info.name = entry.getKey();
                info.list.addAll((Collection<String>)entry.getValue());
                webAppInfo.jsfAnnotatedClasses.add(info);
            }
            webAppInfo.host = webModule.getHost();
            webAppInfo.contextRoot = webModule.getContextRoot();
            jndiEncInfoBuilder.build((JndiConsumer)webApp, webModule.getJarLocation(), webAppInfo.moduleId, webModule.getModuleUri(), webAppInfo.jndiEnc, webAppInfo.jndiEnc);
            webAppInfo.portInfos.addAll(this.configureWebservices(webModule.getWebservices()));
            for (Servlet servlet : webModule.getWebApp().getServlet()) {
                ServletInfo servletInfo = new ServletInfo();
                servletInfo.servletName = servlet.getServletName();
                servletInfo.servletClass = servlet.getServletClass();
                webAppInfo.servlets.add(servletInfo);
            }
            appInfo.webApps.add(webAppInfo);
        }
    }

    private void buildConnectorModules(AppModule appModule, AppInfo appInfo) throws OpenEJBException {
        String appId = appModule.getModuleId();
        for (ConnectorModule connectorModule : appModule.getConnectorModules()) {
            InboundResourceadapter inbound;
            ResourceInfo resourceInfo;
            String value;
            String name;
            Properties properties;
            Resource resource;
            ServiceProvider provider;
            String type;
            String className;
            String id;
            OutboundResourceAdapter outbound;
            Connector connector = connectorModule.getConnector();
            ConnectorInfo connectorInfo = new ConnectorInfo();
            connectorInfo.description = connector.getDescription();
            connectorInfo.displayName = connector.getDisplayName();
            connectorInfo.path = connectorModule.getJarLocation();
            connectorInfo.moduleId = connectorModule.getModuleId();
            connectorInfo.watchedResources.addAll(connectorModule.getWatchedResources());
            connectorInfo.validationInfo = ValidatorBuilder.getInfo(connectorModule.getValidationConfig());
            connectorInfo.uniqueId = connectorModule.getUniqueId();
            connectorInfo.mbeans = connectorModule.getMbeans();
            List<URL> libraries = connectorModule.getLibraries();
            for (URL url : libraries) {
                File file = URLs.toFile(url);
                try {
                    connectorInfo.libs.add(file.getCanonicalPath());
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Invalid application lib path " + file.getAbsolutePath());
                }
            }
            ResourceAdapter resourceAdapter = connector.getResourceAdapter();
            if (resourceAdapter.getResourceAdapterClass() != null) {
                String id2 = this.getId(connectorModule);
                String className2 = resourceAdapter.getResourceAdapterClass();
                ServiceProvider provider2 = new ServiceProvider(className2, id2, "Resource");
                provider2.getTypes().add(className2);
                ServiceUtils.registerServiceProvider(appId, provider2);
                Resource resource2 = new Resource(id2, className2, appId + "#" + id2);
                for (ConfigProperty property : resourceAdapter.getConfigProperty()) {
                    String name2 = property.getConfigPropertyName();
                    String value2 = property.getConfigPropertyValue();
                    if (value2 == null) continue;
                    resource2.getProperties().setProperty(name2, value2);
                }
                connectorInfo.resourceAdapter = this.configFactory.configureService(resource2, ResourceInfo.class);
            }
            if ((outbound = resourceAdapter.getOutboundResourceAdapter()) != null) {
                String transactionSupport = "none";
                switch (outbound.getTransactionSupport()) {
                    case LOCAL_TRANSACTION: {
                        transactionSupport = "local";
                        break;
                    }
                    case NO_TRANSACTION: {
                        transactionSupport = "none";
                        break;
                    }
                    case XA_TRANSACTION: {
                        transactionSupport = "xa";
                    }
                }
                for (ConnectionDefinition connection : outbound.getConnectionDefinition()) {
                    id = this.getId(connection, outbound, connectorModule);
                    className = connection.getManagedConnectionFactoryClass();
                    type = connection.getConnectionFactoryInterface();
                    provider = new ServiceProvider(className, id, "Resource");
                    provider.getTypes().add(type);
                    ServiceUtils.registerServiceProvider(appId, provider);
                    resource = new Resource(id, type, appId + "#" + id);
                    properties = resource.getProperties();
                    for (ConfigProperty property : connection.getConfigProperty()) {
                        name = property.getConfigPropertyName();
                        value = property.getConfigPropertyValue();
                        if (value == null) continue;
                        properties.setProperty(name, value);
                    }
                    properties.setProperty("TransactionSupport", transactionSupport);
                    if (connectorInfo.resourceAdapter != null) {
                        properties.setProperty("ResourceAdapter", connectorInfo.resourceAdapter.id);
                    }
                    resourceInfo = this.configFactory.configureService(resource, ResourceInfo.class);
                    connectorInfo.outbound.add(resourceInfo);
                }
            }
            if ((inbound = resourceAdapter.getInboundResourceAdapter()) != null) {
                for (MessageListener messageListener : inbound.getMessageAdapter().getMessageListener()) {
                    id = this.getId(messageListener, inbound, connectorModule);
                    Container container = new Container(id, "MESSAGE", null);
                    Properties properties2 = container.getProperties();
                    properties2.setProperty("ResourceAdapter", connectorInfo.resourceAdapter.id);
                    properties2.setProperty("MessageListenerInterface", messageListener.getMessageListenerType());
                    properties2.setProperty("ActivationSpecClass", messageListener.getActivationSpec().getActivationSpecClass());
                    MdbContainerInfo mdbContainerInfo = this.configFactory.configureService(container, MdbContainerInfo.class);
                    connectorInfo.inbound.add(mdbContainerInfo);
                }
            }
            for (AdminObject adminObject : resourceAdapter.getAdminObject()) {
                id = this.getId(adminObject, resourceAdapter, connectorModule);
                className = adminObject.getAdminObjectClass();
                type = adminObject.getAdminObjectInterface();
                provider = new ServiceProvider(className, id, "Resource");
                provider.getTypes().add(type);
                ServiceUtils.registerServiceProvider(appId, provider);
                resource = new Resource(id, type, appId + "#" + id);
                properties = resource.getProperties();
                for (ConfigProperty property : adminObject.getConfigProperty()) {
                    name = property.getConfigPropertyName();
                    value = property.getConfigPropertyValue();
                    if (value == null) continue;
                    properties.setProperty(name, value);
                }
                resourceInfo = this.configFactory.configureService(resource, ResourceInfo.class);
                connectorInfo.adminObject.add(resourceInfo);
            }
            appInfo.connectors.add(connectorInfo);
        }
    }

    private String getId(AdminObject adminObject, ResourceAdapter resourceAdapter, ConnectorModule connectorModule) {
        String id = adminObject.getId() != null ? adminObject.getId() : (resourceAdapter.getAdminObject().size() == 1 ? connectorModule.getModuleId() : connectorModule.getModuleId() + "-" + adminObject.getAdminObjectInterface());
        return id;
    }

    private String getId(MessageListener messageListener, InboundResourceadapter inbound, ConnectorModule connectorModule) {
        String id = messageListener.getId() != null ? messageListener.getId() : (inbound.getMessageAdapter().getMessageListener().size() == 1 ? connectorModule.getModuleId() : connectorModule.getModuleId() + "-" + messageListener.getMessageListenerType());
        return id;
    }

    private String getId(ConnectionDefinition connection, OutboundResourceAdapter outbound, ConnectorModule connectorModule) {
        String id = connection.getId() != null ? connection.getId() : (outbound.getConnectionDefinition().size() == 1 ? connectorModule.getModuleId() : connectorModule.getModuleId() + "-" + connection.getConnectionFactoryInterface());
        return id;
    }

    private String getId(ConnectorModule connectorModule) {
        String id = connectorModule.getConnector().getResourceAdapter().getId();
        if (id == null) {
            id = connectorModule.getModuleId() + "RA";
        }
        return id;
    }

    private void buildPersistenceModules(AppModule appModule, AppInfo appInfo) {
        for (PersistenceModule persistenceModule : appModule.getPersistenceModules()) {
            String rootUrl = persistenceModule.getRootUrl();
            Persistence persistence = persistenceModule.getPersistence();
            for (PersistenceUnit persistenceUnit : persistence.getPersistenceUnit()) {
                PersistenceUnitInfo info = new PersistenceUnitInfo();
                info.id = persistenceUnit.getName() + " " + rootUrl.hashCode();
                info.name = persistenceUnit.getName();
                info.watchedResources.addAll(persistenceModule.getWatchedResources());
                info.persistenceUnitRootUrl = rootUrl;
                info.provider = persistenceUnit.getProvider();
                info.transactionType = persistenceUnit.getTransactionType().toString();
                Boolean excludeUnlistedClasses = persistenceUnit.isExcludeUnlistedClasses();
                info.excludeUnlistedClasses = excludeUnlistedClasses != null && excludeUnlistedClasses != false;
                info.jtaDataSource = persistenceUnit.getJtaDataSource();
                info.nonJtaDataSource = persistenceUnit.getNonJtaDataSource();
                info.jarFiles.addAll(persistenceUnit.getJarFile());
                info.classes.addAll(persistenceUnit.getClazz());
                info.mappingFiles.addAll(persistenceUnit.getMappingFile());
                info.persistenceXMLSchemaVersion = persistence.getVersion();
                info.sharedCacheMode = persistenceUnit.getSharedCacheMode().toString();
                info.validationMode = persistenceUnit.getValidationMode().toString();
                info.properties.putAll((Map<?, ?>)persistenceUnit.getProperties());
                PersistenceProviderProperties.apply(info);
                appInfo.persistenceUnits.add(info);
            }
        }
    }

    private static String getClientModuleId(ClientModule clientModule) {
        String jarLocation = clientModule.getJarLocation();
        File file = new File(jarLocation);
        String name = file.getName();
        if (name.endsWith(".jar") || name.endsWith(".zip")) {
            name = name.replaceFirst("....$", "");
        }
        return name;
    }

    private List<PortInfo> configureWebservices(Webservices webservices) {
        ArrayList<PortInfo> portMap = new ArrayList<PortInfo>();
        if (webservices == null) {
            return portMap;
        }
        for (WebserviceDescription desc : webservices.getWebserviceDescription()) {
            String wsdlFile = desc.getWsdlFile();
            String serviceName = desc.getWebserviceDescriptionName();
            for (PortComponent port : desc.getPortComponent()) {
                PortInfo portInfo = new PortInfo();
                ServiceImplBean serviceImplBean = port.getServiceImplBean();
                portInfo.serviceId = desc.getId();
                portInfo.portId = port.getId();
                portInfo.serviceLink = serviceImplBean.getEjbLink();
                if (portInfo.serviceLink == null) {
                    portInfo.serviceLink = serviceImplBean.getServletLink();
                }
                portInfo.seiInterfaceName = port.getServiceEndpointInterface();
                portInfo.portName = port.getPortComponentName();
                portInfo.binding = port.getProtocolBinding();
                portInfo.serviceName = serviceName;
                portInfo.wsdlFile = wsdlFile;
                portInfo.mtomEnabled = port.isEnableMtom();
                portInfo.wsdlPort = port.getWsdlPort();
                portInfo.wsdlService = port.getWsdlService();
                portInfo.location = port.getLocation();
                List<HandlerChainInfo> handlerChains = ConfigurationFactory.toHandlerChainInfo(port.getHandlerChains());
                portInfo.handlerChains.addAll(handlerChains);
                portMap.add(portInfo);
            }
        }
        return portMap;
    }

    void configureWebserviceSecurity(EjbJarInfo ejbJarInfo, EjbModule ejbModule) {
        OpenejbJar altDD = ejbModule.getOpenejbJar();
        List<PortInfo> infoList = ejbJarInfo.portInfos;
        this.configureWebserviceScurity(infoList, altDD);
    }

    private void configureWebserviceScurity(List<PortInfo> infoList, Object altDD) {
        if (altDD == null || !(altDD instanceof OpenejbJar)) {
            return;
        }
        OpenejbJar openejbJar = (OpenejbJar)altDD;
        Map deploymentsByEjbName = openejbJar.getDeploymentsByEjbName();
        for (PortInfo portInfo : infoList) {
            EjbDeployment deployment = (EjbDeployment)deploymentsByEjbName.get(portInfo.serviceLink);
            if (deployment == null) continue;
            portInfo.realmName = deployment.getProperties().getProperty("webservice.security.realm");
            portInfo.securityRealmName = deployment.getProperties().getProperty("webservice.security.securityRealm");
            portInfo.transportGuarantee = deployment.getProperties().getProperty("webservice.security.transportGarantee") != null ? deployment.getProperties().getProperty("webservice.security.transportGarantee") : "NONE";
            portInfo.authMethod = deployment.getProperties().getProperty("webservice.security.authMethod") != null ? deployment.getProperties().getProperty("webservice.security.authMethod") : "NONE";
            portInfo.properties = deployment.getProperties();
        }
    }

    private static boolean skipMdb(EnterpriseBeanInfo bean) {
        return bean instanceof MessageDrivenBeanInfo && SystemInstance.get().hasProperty("openejb.geronimo");
    }

    public static class PersistenceProviderProperties {
        public static final String OPENJPA_RUNTIME_UNENHANCED_CLASSES = "openjpa.RuntimeUnenhancedClasses";
        public static final String DEFAULT_RUNTIME_UNENHANCED_CLASSES = "supported";
        public static final String REMOVE_DEFAULT_RUNTIME_UNENHANCED_CLASSES = "disable";
        public static final String OPENJPA_MANAGED_RUNTIME = "openjpa.ManagedRuntime";
        public static final String DEFAULT_MANAGED_RUNTIME = "invocation(TransactionManagerMethod=org.apache.openejb.OpenEJB.getTransactionManager)";
        public static final String PROVIDER_PROP = "javax.persistence.provider";
        public static final String TRANSACTIONTYPE_PROP = "javax.persistence.transactionType";
        public static final String JTADATASOURCE_PROP = "javax.persistence.jtaDataSource";
        public static final String NON_JTADATASOURCE_PROP = "javax.persistence.nonJtaDataSource";
        private static final String DEFAULT_PERSISTENCE_PROVIDER = "org.apache.openjpa.persistence.PersistenceProviderImpl";
        public static final String HIBERNATE_TRANSACTION_MANAGER_LOOKUP_CLASS = "hibernate.transaction.manager_lookup_class";
        public static final String HIBERNATE_JTA_PLATFORM = "hibernate.transaction.jta.platform";
        private static String providerEnv = SystemInstance.get().getOptions().get("javax.persistence.provider", (String)null);
        private static String transactionTypeEnv = SystemInstance.get().getOptions().get("javax.persistence.transactionType", (String)null);
        private static String jtaDataSourceEnv = SystemInstance.get().getOptions().get("javax.persistence.jtaDataSource", (String)null);
        private static String nonJtaDataSourceEnv = SystemInstance.get().getOptions().get("javax.persistence.nonJtaDataSource", (String)null);

        private static void apply(PersistenceUnitInfo info) {
            PersistenceProviderProperties.overrideFromSystemProp(info);
            if ("org.hibernate.ejb.HibernatePersistence".equals(info.provider)) {
                PersistenceProviderProperties.override(info, "hibernate");
                String className = info.properties.getProperty(HIBERNATE_JTA_PLATFORM);
                if (className == null) {
                    className = info.properties.getProperty(HIBERNATE_TRANSACTION_MANAGER_LOOKUP_CLASS);
                }
                if (className == null || className.startsWith("org.hibernate.transaction") || className.startsWith("org.hibernate.service.jta.platform")) {
                    String key = HIBERNATE_JTA_PLATFORM;
                    String value = "org.apache.openejb.hibernate.OpenEJBJtaPlatform";
                    try {
                        AppInfoBuilder.class.getClassLoader().loadClass("org.hibernate.service.jta.platform.spi.JtaPlatform");
                    }
                    catch (Exception e) {
                        key = HIBERNATE_TRANSACTION_MANAGER_LOOKUP_CLASS;
                        value = "org.apache.openejb.hibernate.TransactionManagerLookup";
                    }
                    info.properties.setProperty(key, value);
                    logger.debug("Adjusting PersistenceUnit(name=" + info.name + ") property to " + key + "=" + value);
                }
            } else if ("oracle.toplink.essentials.PersistenceProvider".equals(info.provider) || "oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider".equals(info.provider)) {
                PersistenceProviderProperties.override(info, "toplink");
                String lookupProperty = "toplink.target-server";
                String openejbLookupClass = "org.apache.openejb.toplink.JTATransactionController";
                String className = info.properties.getProperty(lookupProperty);
                if (className == null || className.startsWith("oracle.toplink.transaction")) {
                    info.properties.setProperty(lookupProperty, openejbLookupClass);
                    logger.debug("Adjusting PersistenceUnit(name=" + info.name + ") property to " + lookupProperty + "=" + openejbLookupClass);
                }
            } else if ("org.eclipse.persistence.jpa.PersistenceProvider".equals(info.provider) || "org.eclipse.persistence.jpa.osgi.PersistenceProvider".equals(info.provider)) {
                PersistenceProviderProperties.override(info, "eclipselink");
                String lookupProperty = "eclipselink.target-server";
                String openejbLookupClass = "org.apache.openejb.eclipselink.JTATransactionController";
                String className = info.properties.getProperty(lookupProperty);
                if (className == null || className.startsWith("org.eclipse.persistence.transaction")) {
                    info.properties.setProperty(lookupProperty, openejbLookupClass);
                    logger.debug("Adjusting PersistenceUnit(name=" + info.name + ") property to " + lookupProperty + "=" + openejbLookupClass);
                }
            } else if (info.provider == null || DEFAULT_PERSISTENCE_PROVIDER.equals(info.provider)) {
                PersistenceProviderProperties.override(info, "openjpa");
                String existing = info.properties.getProperty(OPENJPA_RUNTIME_UNENHANCED_CLASSES);
                if (existing == null) {
                    info.properties.setProperty(OPENJPA_RUNTIME_UNENHANCED_CLASSES, DEFAULT_RUNTIME_UNENHANCED_CLASSES);
                    logger.debug("Adjusting PersistenceUnit(name=" + info.name + ") property to " + OPENJPA_RUNTIME_UNENHANCED_CLASSES + "=" + DEFAULT_RUNTIME_UNENHANCED_CLASSES);
                } else if (REMOVE_DEFAULT_RUNTIME_UNENHANCED_CLASSES.equals(existing.trim())) {
                    info.properties.remove(OPENJPA_RUNTIME_UNENHANCED_CLASSES);
                    logger.info("Adjusting PersistenceUnit(name=" + info.name + ") removing property " + OPENJPA_RUNTIME_UNENHANCED_CLASSES);
                }
                HashSet<String> keys = new HashSet<String>(info.properties.stringPropertyNames());
                for (String key : keys) {
                    if (key.matches("openjpa.Connection(DriverName|URL|UserName|Password)")) {
                        Object o = info.properties.remove(key);
                        logger.warning("Removing PersistenceUnit(name=" + info.name + ") property " + key + "=" + o + "  [not valid in a container environment]");
                        continue;
                    }
                    JPAPropertyConverter.Pair pair = JPAPropertyConverter.toOpenJPAValue(key, info.properties.getProperty(key), info.properties);
                    if (pair == null || info.properties.containsKey(pair.getKey())) continue;
                    logger.info("Converting PersistenceUnit(name=" + info.name + ") property " + key + "=" + info.properties.getProperty(key) + " to " + pair.toString());
                    info.properties.remove(key);
                    info.properties.setProperty(pair.getKey(), pair.getValue());
                }
            }
            PersistenceProviderProperties.override(info);
        }

        private static void overrideFromSystemProp(PersistenceUnitInfo info) {
            if (providerEnv != null) {
                info.provider = providerEnv;
            }
            if (info.provider == null) {
                info.provider = DEFAULT_PERSISTENCE_PROVIDER;
            }
            if (jtaDataSourceEnv != null) {
                info.jtaDataSource = jtaDataSourceEnv;
            }
            if (transactionTypeEnv != null) {
                info.transactionType = transactionTypeEnv.toUpperCase();
            }
            if (nonJtaDataSourceEnv != null) {
                info.nonJtaDataSource = nonJtaDataSourceEnv;
            }
        }

        private static void override(PersistenceUnitInfo info) {
            PersistenceProviderProperties.override(info, info.name);
        }

        private static void override(PersistenceUnitInfo info, String prefix) {
            Properties overrides = ConfigurationFactory.getSystemProperties(prefix, "PersistenceUnit");
            for (Map.Entry<Object, Object> entry : overrides.entrySet()) {
                String property = (String)(prefix.equalsIgnoreCase(info.name) ? entry.getKey() : prefix + "." + entry.getKey());
                String value = (String)entry.getValue();
                if (info.properties.containsKey(property)) {
                    logger.debug("Overriding persistence-unit " + info.name + " property " + property + "=" + value);
                } else {
                    logger.debug("Adding persistence-unit " + info.name + " property " + property + "=" + value);
                }
                info.properties.put(property, value);
                if (!property.endsWith("openjpa.Specification")) continue;
                info.persistenceXMLSchemaVersion = value.replace("JPA ", "");
            }
        }
    }
}

