/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.ManagedBean;
import javax.ejb.TimerService;
import javax.enterprise.inject.spi.BeanManager;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import org.apache.openejb.JndiConstants;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.ServiceUtils;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.jee.ActivationConfig;
import org.apache.openejb.jee.ActivationConfigProperty;
import org.apache.openejb.jee.AdminObject;
import org.apache.openejb.jee.AssemblyDescriptor;
import org.apache.openejb.jee.ConnectionDefinition;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.EntityBean;
import org.apache.openejb.jee.InboundResourceadapter;
import org.apache.openejb.jee.InjectionTarget;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.JndiReference;
import org.apache.openejb.jee.MessageDestination;
import org.apache.openejb.jee.MessageDestinationRef;
import org.apache.openejb.jee.MessageDrivenBean;
import org.apache.openejb.jee.MessageListener;
import org.apache.openejb.jee.OutboundResourceAdapter;
import org.apache.openejb.jee.PersistenceContextRef;
import org.apache.openejb.jee.PersistenceRef;
import org.apache.openejb.jee.PersistenceType;
import org.apache.openejb.jee.PersistenceUnitRef;
import org.apache.openejb.jee.ResourceAdapter;
import org.apache.openejb.jee.ResourceRef;
import org.apache.openejb.jee.SessionBean;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.jee.oejb3.ResourceLink;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.DataSourceFactory;
import org.apache.openejb.util.IntrospectionSupport;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LinkResolver;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.SuperProperties;
import org.apache.openejb.util.URISupport;
import org.apache.openejb.util.UniqueDefaultLinkResolver;

public class AutoConfig
implements DynamicDeployer,
JndiConstants {
    public static final String ORIGIN_ANNOTATION = "Annotation";
    public static final String ORIGIN_FLAG = "Origin";
    public static Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, AutoConfig.class);
    private static Set<String> ignoredReferenceTypes = new TreeSet<String>();
    public static final String AUTOCREATE_JTA_DATASOURCE_FROM_NON_JTA_ONE_KEY = "openejb.autocreate.jta-datasource-from-non-jta-one";
    private final ConfigurationFactory configFactory;
    private boolean autoCreateContainers = true;
    private boolean autoCreateResources = true;

    public AutoConfig(ConfigurationFactory configFactory) {
        this.configFactory = configFactory;
    }

    public synchronized boolean autoCreateResources() {
        return this.autoCreateResources;
    }

    public synchronized void autoCreateResources(boolean autoCreateResources) {
        this.autoCreateResources = autoCreateResources;
    }

    public synchronized boolean autoCreateContainers() {
        return this.autoCreateContainers;
    }

    public synchronized void autoCreateContainers(boolean autoCreateContainers) {
        this.autoCreateContainers = autoCreateContainers;
    }

    public void init() throws OpenEJBException {
    }

    @Override
    public synchronized AppModule deploy(AppModule appModule) throws OpenEJBException {
        AppResources appResources = new AppResources(appModule);
        this.processDataSourceDefinitions(appModule);
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            this.processActivationConfig(ejbModule);
        }
        this.resolveDestinationLinks(appModule);
        this.resolvePersistenceRefs(appModule);
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            this.deploy(ejbModule, appResources);
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            this.deploy(clientModule, appResources);
        }
        for (ConnectorModule connectorModule : appModule.getConnectorModules()) {
            this.deploy(connectorModule);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            this.deploy(webModule, appResources);
        }
        for (PersistenceModule persistenceModule : appModule.getPersistenceModules()) {
            this.deploy(appModule, persistenceModule);
        }
        return appModule;
    }

    private void resolvePersistenceRefs(AppModule appModule) {
        URI moduleURI;
        UniqueDefaultLinkResolver<PersistenceUnit> persistenceUnits = new UniqueDefaultLinkResolver<PersistenceUnit>();
        for (PersistenceModule module : appModule.getPersistenceModules()) {
            String rootUrl = module.getRootUrl();
            for (PersistenceUnit unit : module.getPersistence().getPersistenceUnit()) {
                unit.setId(unit.getName() + " " + rootUrl.hashCode());
                persistenceUnits.add(rootUrl, unit.getName(), unit);
            }
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            moduleURI = ejbModule.getModuleUri();
            for (EnterpriseBean component : ejbModule.getEjbJar().getEnterpriseBeans()) {
                this.processPersistenceRefs((JndiConsumer)component, ejbModule, persistenceUnits, moduleURI);
            }
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            moduleURI = URI.create(clientModule.getModuleId());
            this.processPersistenceRefs((JndiConsumer)clientModule.getApplicationClient(), clientModule, persistenceUnits, moduleURI);
        }
        for (WebModule webModule : appModule.getWebModules()) {
            moduleURI = URI.create(webModule.getModuleId());
            this.processPersistenceRefs((JndiConsumer)webModule.getWebApp(), webModule, persistenceUnits, moduleURI);
        }
    }

    private void processPersistenceRefs(JndiConsumer component, DeploymentModule module, LinkResolver<PersistenceUnit> persistenceUnits, URI moduleURI) {
        String componentName = component.getJndiConsumerName();
        ValidationContext validation = module.getValidation();
        for (PersistenceUnitRef ref : component.getPersistenceUnitRef()) {
            this.processPersistenceRef(persistenceUnits, (PersistenceRef)ref, moduleURI, componentName, validation);
        }
        for (PersistenceUnitRef ref : component.getPersistenceContextRef()) {
            this.processPersistenceRef(persistenceUnits, (PersistenceRef)ref, moduleURI, componentName, validation);
        }
    }

    private PersistenceUnit processPersistenceRef(LinkResolver<PersistenceUnit> persistenceUnits, PersistenceRef ref, URI moduleURI, String componentName, ValidationContext validation) {
        if (ref.getMappedName() != null && ref.getMappedName().startsWith("jndi:")) {
            return null;
        }
        PersistenceUnit unit = persistenceUnits.resolveLink(ref.getPersistenceUnitName(), moduleURI);
        Collection<PersistenceUnit> cmpUnits = persistenceUnits.values("cmp");
        if (unit == null && cmpUnits.size() > 0 && persistenceUnits.values().size() - cmpUnits.size() == 1) {
            for (PersistenceUnit persistenceUnit : persistenceUnits.values()) {
                if (persistenceUnit.getName().equals("cmp")) continue;
                unit = persistenceUnit;
                break;
            }
        }
        if (unit == null) {
            unit = persistenceUnits.resolveLink(ref.getName(), moduleURI);
        }
        if (unit == null) {
            String shortName = ref.getName().replaceFirst(".*/", "");
            unit = persistenceUnits.resolveLink(shortName, moduleURI);
        }
        if (unit != null) {
            ref.setPersistenceUnitName(unit.getName());
            ref.setMappedName(unit.getId());
        } else {
            String refType = "persistence";
            refType = ref instanceof PersistenceContextRef ? refType + "ContextRef" : refType + "UnitRef";
            String refShortName = ref.getName();
            if (refShortName.matches(".*\\..*/.*")) {
                refShortName = refShortName.replaceFirst(".*/", "");
            }
            ArrayList<String> availableUnits = new ArrayList<String>();
            for (PersistenceUnit persistenceUnit : persistenceUnits.values()) {
                availableUnits.add(persistenceUnit.getName());
            }
            Collections.sort(availableUnits);
            String unitName = ref.getPersistenceUnitName();
            if (availableUnits.size() == 0) {
                if (unitName == null) {
                    unitName = refShortName;
                }
                validation.fail(componentName, refType + ".noPersistenceUnits", refShortName, unitName);
            } else if ((ref.getPersistenceUnitName() == null || ref.getPersistenceUnitName().length() == 0) && availableUnits.size() > 1) {
                String sampleUnitName = (String)availableUnits.get(0);
                validation.fail(componentName, refType + ".noUnitName", refShortName, Join.join(", ", availableUnits), sampleUnitName);
            } else {
                Collection<PersistenceUnit> vagueMatches = persistenceUnits.values(ref.getPersistenceUnitName());
                if (vagueMatches.size() != 0) {
                    ArrayList<String> possibleUnits = new ArrayList<String>();
                    for (PersistenceUnit persistenceUnit : persistenceUnits.values()) {
                        try {
                            URI unitURI = URI.create(persistenceUnit.getId());
                            unitURI = URISupport.relativize(moduleURI, unitURI);
                            possibleUnits.add(unitURI.toString());
                        }
                        catch (Exception e) {
                            possibleUnits.add(persistenceUnit.getId());
                        }
                    }
                    Collections.sort(possibleUnits);
                    validation.fail(componentName, refType + ".vagueMatches", refShortName, unitName, possibleUnits.size(), Join.join("\n", possibleUnits));
                } else {
                    validation.fail(componentName, refType + ".noMatches", refShortName, unitName, Join.join(", ", availableUnits));
                }
            }
        }
        return unit;
    }

    private void processActivationConfig(EjbModule ejbModule) throws OpenEJBException {
        OpenejbJar openejbJar;
        if (ejbModule.getOpenejbJar() != null) {
            openejbJar = ejbModule.getOpenejbJar();
        } else {
            openejbJar = new OpenejbJar();
            ejbModule.setOpenejbJar(openejbJar);
        }
        Map deployments = openejbJar.getDeploymentsByEjbName();
        for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
            String destinationType;
            ResourceLink link;
            if (!(bean instanceof MessageDrivenBean)) continue;
            MessageDrivenBean mdb = (MessageDrivenBean)bean;
            if (mdb.getActivationConfig() == null) {
                mdb.setActivationConfig(new ActivationConfig());
            }
            if (!this.isJms(mdb)) continue;
            EjbDeployment ejbDeployment = (EjbDeployment)deployments.get(bean.getEjbName());
            if (ejbDeployment == null) {
                throw new OpenEJBException("No ejb deployment found for ejb " + bean.getEjbName());
            }
            Properties properties = mdb.getActivationConfig().toProperties();
            String destination = properties.getProperty("destinationName");
            if (destination != null) {
                mdb.getActivationConfig().addProperty("destination", destination);
                List list = mdb.getActivationConfig().getActivationConfigProperty();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    ActivationConfigProperty configProperty = (ActivationConfigProperty)iterator.next();
                    if (!configProperty.getActivationConfigPropertyName().equals("destinationName")) continue;
                    iterator.remove();
                    break;
                }
            } else {
                destination = properties.getProperty("destination");
            }
            if (destination == null) {
                destination = ejbDeployment.getDeploymentId();
                mdb.getActivationConfig().addProperty("destination", destination);
            }
            if ((link = ejbDeployment.getResourceLink("openejb/destination")) == null && mdb.getMessageDestinationLink() == null) {
                link = new ResourceLink();
                link.setResId(destination);
                link.setResRefName("openejb/destination");
                ejbDeployment.addResourceLink(link);
            }
            if ((destinationType = properties.getProperty("destinationType")) == null && mdb.getMessageDestinationType() != null) {
                destinationType = mdb.getMessageDestinationType();
                mdb.getActivationConfig().addProperty("destinationType", destinationType);
            }
            if (mdb.getMessageDestinationType() == null) {
                mdb.setMessageDestinationType(destinationType);
            }
            if (!"javax.jms.Topic".equals(destinationType)) continue;
            if (!properties.containsKey("clientId")) {
                mdb.getActivationConfig().addProperty("clientId", ejbDeployment.getDeploymentId());
            }
            if (properties.containsKey("subscriptionName")) continue;
            mdb.getActivationConfig().addProperty("subscriptionName", ejbDeployment.getDeploymentId() + "_subscription");
        }
    }

    private boolean isJms(MessageDrivenBean mdb) {
        String messagingType = mdb.getMessagingType();
        return messagingType != null && messagingType.startsWith("javax.jms");
    }

    private void resolveDestinationLinks(AppModule appModule) throws OpenEJBException {
        String destinationId;
        URI moduleUri;
        EjbDeployment ejbDeployment;
        MessageDrivenBean mdb;
        OpenejbJar openejbJar;
        URI moduleUri2;
        AssemblyDescriptor assembly;
        LinkResolver<MessageDestination> destinationResolver = new LinkResolver<MessageDestination>();
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            AssemblyDescriptor assembly2 = ejbModule.getEjbJar().getAssemblyDescriptor();
            if (assembly2 == null) continue;
            for (MessageDestination destination : assembly2.getMessageDestination()) {
                destinationResolver.add(ejbModule.getModuleUri(), destination.getMessageDestinationName(), destination);
            }
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            for (MessageDestination destination : clientModule.getApplicationClient().getMessageDestination()) {
                destinationResolver.add(appModule.getModuleUri(), destination.getMessageDestinationName(), destination);
            }
        }
        for (WebModule webModule : appModule.getWebModules()) {
            for (MessageDestination destination : webModule.getWebApp().getMessageDestination()) {
                destinationResolver.add(appModule.getModuleUri(), destination.getMessageDestinationName(), destination);
            }
        }
        HashMap<MessageDestination, String> destinationTypes = new HashMap<MessageDestination, String>();
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            assembly = ejbModule.getEjbJar().getAssemblyDescriptor();
            if (assembly == null) continue;
            moduleUri2 = ejbModule.getModuleUri();
            openejbJar = ejbModule.getOpenejbJar();
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                ResourceLink resourceLink;
                if (!(bean instanceof MessageDrivenBean)) continue;
                mdb = (MessageDrivenBean)bean;
                ejbDeployment = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(bean.getEjbName());
                if (ejbDeployment == null) {
                    throw new OpenEJBException("No ejb deployment found for ejb " + bean.getEjbName());
                }
                String link = mdb.getMessageDestinationLink();
                if (link == null || link.length() == 0) continue;
                MessageDestination destination = destinationResolver.resolveLink(link, moduleUri2);
                if (destination == null) {
                    throw new OpenEJBException("Message destination " + link + " for message driven bean " + mdb.getEjbName() + " not found");
                }
                String destinationId2 = destination.getMappedName();
                if (destinationId2 == null) {
                    Properties properties = mdb.getActivationConfig().toProperties();
                    destinationId2 = properties.getProperty("destination");
                    destination.setMappedName(destinationId2);
                }
                if (mdb.getMessageDestinationType() != null && !destinationTypes.containsKey(destination)) {
                    destinationTypes.put(destination, mdb.getMessageDestinationType());
                }
                if ((resourceLink = ejbDeployment.getResourceLink("openejb/destination")) == null) {
                    resourceLink = new ResourceLink();
                    resourceLink.setResRefName("openejb/destination");
                    ejbDeployment.addResourceLink(resourceLink);
                }
                resourceLink.setResId(destinationId2);
            }
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            assembly = ejbModule.getEjbJar().getAssemblyDescriptor();
            if (assembly == null) continue;
            moduleUri2 = ejbModule.getModuleUri();
            openejbJar = ejbModule.getOpenejbJar();
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                EjbDeployment ejbDeployment2 = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(bean.getEjbName());
                if (ejbDeployment2 == null) {
                    throw new OpenEJBException("No ejb deployment found for ejb " + bean.getEjbName());
                }
                for (MessageDestinationRef ref : bean.getMessageDestinationRef()) {
                    String destinationId3;
                    if (ref.getMappedName() != null || ejbDeployment2.getResourceLink(ref.getName()) != null || (destinationId3 = this.resolveDestinationId(ref, moduleUri2, destinationResolver, destinationTypes)) == null) continue;
                    ResourceLink resourceLink = new ResourceLink();
                    resourceLink.setResId(destinationId3);
                    resourceLink.setResRefName(ref.getName());
                    ejbDeployment2.addResourceLink(resourceLink);
                }
            }
        }
        for (ClientModule clientModule : appModule.getClientModules()) {
            moduleUri = clientModule.getModuleUri();
            for (MessageDestinationRef ref : clientModule.getApplicationClient().getMessageDestinationRef()) {
                destinationId = this.resolveDestinationId(ref, moduleUri, destinationResolver, destinationTypes);
                if (destinationId == null) continue;
                ref.setMappedName(destinationId);
            }
        }
        for (WebModule webModule : appModule.getWebModules()) {
            moduleUri = URI.create(webModule.getModuleId());
            for (MessageDestinationRef ref : webModule.getWebApp().getMessageDestinationRef()) {
                destinationId = this.resolveDestinationId(ref, moduleUri, destinationResolver, destinationTypes);
                if (destinationId == null) continue;
                ref.setMappedName(destinationId);
            }
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            assembly = ejbModule.getEjbJar().getAssemblyDescriptor();
            if (assembly == null) continue;
            moduleUri2 = URI.create(ejbModule.getModuleId());
            openejbJar = ejbModule.getOpenejbJar();
            for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
                Properties properties;
                if (!(bean instanceof MessageDrivenBean) || !this.isJms(mdb = (MessageDrivenBean)bean)) continue;
                ejbDeployment = (EjbDeployment)openejbJar.getDeploymentsByEjbName().get(bean.getEjbName());
                if (ejbDeployment == null) {
                    throw new OpenEJBException("No ejb deployment found for ejb " + bean.getEjbName());
                }
                String destinationType = mdb.getMessageDestinationType();
                if (destinationType != null) continue;
                String link = mdb.getMessageDestinationLink();
                if (link != null && link.length() != 0) {
                    MessageDestination destination = destinationResolver.resolveLink(link, moduleUri2);
                    if (destination == null) {
                        throw new OpenEJBException("Message destination " + link + " for message driven bean " + mdb.getEjbName() + " not found");
                    }
                    destinationType = (String)destinationTypes.get(destination);
                }
                if (destinationType == null) {
                    properties = mdb.getActivationConfig().toProperties();
                    String destination = properties.getProperty("destination").toLowerCase();
                    destinationType = destination.indexOf("queue") >= 0 ? Queue.class.getName() : (destination.indexOf("topic") >= 0 ? Topic.class.getName() : Queue.class.getName());
                    logger.info("Auto-configuring a message driven bean " + ejbDeployment.getDeploymentId() + " destination " + properties.getProperty("destination") + " to be destinationType " + destinationType);
                }
                if (destinationType == null) continue;
                mdb.getActivationConfig().addProperty("destinationType", destinationType);
                mdb.setMessageDestinationType(destinationType);
                if (!"javax.jms.Topic".equals(destinationType)) continue;
                properties = mdb.getActivationConfig().toProperties();
                if (!properties.containsKey("clientId")) {
                    mdb.getActivationConfig().addProperty("clientId", ejbDeployment.getDeploymentId());
                }
                if (properties.containsKey("subscriptionName")) continue;
                mdb.getActivationConfig().addProperty("subscriptionName", ejbDeployment.getDeploymentId() + "_subscription");
            }
        }
    }

    private String resolveDestinationId(MessageDestinationRef ref, URI moduleUri, LinkResolver<MessageDestination> destinationResolver, Map<MessageDestination, String> destinationTypes) throws OpenEJBException {
        String destinationId;
        String link = ref.getMessageDestinationLink();
        if (link == null || link.length() == 0) {
            return null;
        }
        MessageDestination destination = destinationResolver.resolveLink(link, moduleUri);
        if (destination == null) {
            throw new OpenEJBException("Message destination " + link + " for message-destination-ref " + ref.getMessageDestinationRefName() + " not found");
        }
        if (ref.getMessageDestinationType() != null && !destinationTypes.containsKey(destination)) {
            destinationTypes.put(destination, ref.getMessageDestinationType());
        }
        if ((destinationId = destination.getMappedName()) == null) {
            destination.getMessageDestinationName();
        }
        return destinationId;
    }

    private void deploy(ClientModule clientModule, AppResources appResources) throws OpenEJBException {
        this.processJndiRefs(clientModule.getModuleId(), (JndiConsumer)clientModule.getApplicationClient(), appResources, clientModule.getClassLoader());
    }

    private void deploy(ConnectorModule connectorModule) throws OpenEJBException {
    }

    private void deploy(WebModule webModule, AppResources appResources) throws OpenEJBException {
        this.processJndiRefs(webModule.getModuleId(), (JndiConsumer)webModule.getWebApp(), appResources, webModule.getClassLoader());
    }

    private void processJndiRefs(String moduleId, JndiConsumer jndiConsumer, AppResources appResources, ClassLoader classLoader) throws OpenEJBException {
        String destinationId;
        String refType;
        String mappedName;
        for (ResourceRef ref : jndiConsumer.getResourceRef()) {
            if (ref.getLookupName() != null || (mappedName = ref.getMappedName() == null ? "" : ref.getMappedName()).startsWith("jndi:") || this.isIgnoredReferenceType(refType = this.getType((JndiReference)ref, classLoader), classLoader)) continue;
            destinationId = mappedName.length() == 0 ? ref.getName() : mappedName;
            destinationId = this.getResourceId(moduleId, destinationId, refType, appResources);
            ref.setMappedName(destinationId);
        }
        for (ResourceRef ref : jndiConsumer.getResourceEnvRef()) {
            if (ref.getLookupName() != null || (mappedName = ref.getMappedName() == null ? "" : ref.getMappedName()).startsWith("jndi:") || this.isIgnoredReferenceType(refType = this.getType((JndiReference)ref, classLoader), classLoader)) continue;
            destinationId = mappedName.length() == 0 ? ref.getName() : mappedName;
            destinationId = this.getResourceEnvId(moduleId, destinationId, refType, appResources);
            ref.setMappedName(destinationId);
        }
        for (ResourceRef ref : jndiConsumer.getMessageDestinationRef()) {
            if (ref.getLookupName() != null || (mappedName = ref.getMappedName() == null ? "" : ref.getMappedName()).startsWith("jndi:")) continue;
            String destinationId2 = mappedName.length() == 0 ? ref.getName() : mappedName;
            destinationId2 = this.getResourceEnvId(moduleId, destinationId2, ref.getType(), appResources);
            ref.setMappedName(destinationId2);
        }
    }

    private boolean isIgnoredReferenceType(String typeName, ClassLoader loader) {
        if (ignoredReferenceTypes.contains(typeName)) {
            return true;
        }
        if (loader != null) {
            try {
                Class<?> type = loader.loadClass(typeName);
                return type.isAnnotationPresent(ManagedBean.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return false;
    }

    private void deploy(EjbModule ejbModule, AppResources appResources) throws OpenEJBException {
        OpenejbJar openejbJar;
        if (ejbModule.getOpenejbJar() != null) {
            openejbJar = ejbModule.getOpenejbJar();
        } else {
            openejbJar = new OpenejbJar();
            ejbModule.setOpenejbJar(openejbJar);
        }
        Map deployments = openejbJar.getDeploymentsByEjbName();
        for (EnterpriseBean bean : ejbModule.getEjbJar().getEnterpriseBeans()) {
            EjbDeployment ejbDeployment = (EjbDeployment)deployments.get(bean.getEjbName());
            if (ejbDeployment == null) {
                throw new OpenEJBException("No ejb deployment found for ejb " + bean.getEjbName());
            }
            Class<? extends ContainerInfo> containerInfoType = ConfigurationFactory.getContainerInfoType(AutoConfig.getType(bean));
            if (ejbDeployment.getContainerId() == null && !AutoConfig.skipMdb(bean)) {
                String containerId = this.getUsableContainer(containerInfoType, bean, appResources);
                if (containerId == null) {
                    containerId = this.createContainer(containerInfoType, ejbDeployment, bean);
                }
                ejbDeployment.setContainerId(containerId);
            }
            List<String> containerIds = this.configFactory.getContainerIds();
            containerIds.addAll(appResources.getContainerIds());
            if (!containerIds.contains(ejbDeployment.getContainerId()) && !AutoConfig.skipMdb(bean)) {
                this.createContainer(containerInfoType, ejbDeployment, bean);
            }
            for (ResourceRef ref : bean.getResourceRef()) {
                this.processResourceRef(ref, ejbDeployment, appResources, ejbModule.getClassLoader());
            }
            for (ResourceRef ref : bean.getResourceEnvRef()) {
                this.processResourceEnvRef((JndiReference)ref, ejbDeployment, appResources, ejbModule.getClassLoader());
            }
            for (ResourceRef ref : bean.getMessageDestinationRef()) {
                this.processResourceEnvRef((JndiReference)ref, ejbDeployment, appResources, ejbModule.getClassLoader());
            }
            if (!this.autoCreateResources || !(bean instanceof MessageDrivenBean)) continue;
            MessageDrivenBean mdb = (MessageDrivenBean)bean;
            ResourceLink resourceLink = ejbDeployment.getResourceLink("openejb/destination");
            if (resourceLink == null) continue;
            try {
                String destinationId = this.getResourceEnvId(bean.getEjbName(), resourceLink.getResId(), mdb.getMessageDestinationType(), appResources);
                resourceLink.setResId(destinationId);
            }
            catch (OpenEJBException e) {
                ejbDeployment.removeResourceLink("openejb/destination");
            }
        }
    }

    private void processDataSourceDefinitions(AppModule module) throws OpenEJBException {
        Collection<Resource> resources = module.getResources();
        if (resources.size() == 0) {
            return;
        }
        ArrayList<WebApp> jndiConsumers = new ArrayList<WebApp>();
        for (WebModule webModule : module.getWebModules()) {
            WebApp consumer = webModule.getWebApp();
            jndiConsumers.add(consumer);
        }
        for (EjbModule ejbModule : module.getEjbModules()) {
            Collections.addAll(jndiConsumers, ejbModule.getEjbJar().getEnterpriseBeans());
        }
        ArrayList<ResourceInfo> resourceInfos = new ArrayList<ResourceInfo>();
        for (Resource resource : resources) {
            Properties properties = resource.getProperties();
            if (DataSource.class.getName().equals(resource.getType()) || DataSource.class.getSimpleName().equals(resource.getType())) {
                DataSourceFactory.trimNotSupportedDataSourceProperties(properties);
            }
            ResourceInfo resourceInfo = this.configFactory.configureService(resource, ResourceInfo.class);
            ResourceRef resourceRef = new ResourceRef();
            resourceRef.setResType(resource.getType());
            if (DataSource.class.getName().equals(resource.getType()) && resource.getProperties().containsKey(ORIGIN_FLAG) && resource.getProperties().getProperty(ORIGIN_FLAG).equals(ORIGIN_ANNOTATION)) {
                String url;
                properties.remove(ORIGIN_FLAG);
                resourceInfo.id = module.getModuleId() + "/" + resourceInfo.id;
                if (properties.get("JdbcUrl") == null && (url = AutoConfig.getVendorUrl(properties)) != null) {
                    properties.put("JdbcUrl", url);
                }
                resourceRef.setResRefName(this.dataSourceLookupName(resource));
            } else {
                resourceRef.setResRefName("openejb/Resource/" + resourceInfo.id);
            }
            resourceRef.setMappedName(resourceInfo.id);
            for (JndiConsumer jndiConsumer : jndiConsumers) {
                ResourceRef existing = (ResourceRef)jndiConsumer.getResourceRefMap().get(resourceRef.getKey());
                if (existing != null) {
                    existing.setMappedName(resourceRef.getMappedName());
                    continue;
                }
                jndiConsumer.getResourceRef().add(resourceRef);
            }
            resourceInfos.add(resourceInfo);
        }
        Collections.sort(resourceInfos, new ConfigurationFactory.ResourceInfoComparator(resourceInfos));
        for (ResourceInfo resourceInfo : resourceInfos) {
            this.installResource(module.getModuleId(), resourceInfo);
        }
        resourceInfos.clear();
        resources.clear();
    }

    private String dataSourceLookupName(Resource datasource) {
        String jndi = datasource.getJndi();
        if (jndi.startsWith("java:")) {
            return jndi;
        }
        if (jndi.startsWith("comp/env/")) {
            return "java:" + jndi;
        }
        if (jndi.startsWith("module/")) {
            return "java:" + jndi;
        }
        if (jndi.startsWith("global/")) {
            return "java:" + jndi;
        }
        if (jndi.startsWith("app/")) {
            return "java:" + jndi;
        }
        return "java:comp/env/" + jndi;
    }

    private static String getVendorUrl(Properties properties) {
        String driver = properties.getProperty("JdbcDriver");
        String serverName = properties.getProperty("ServerName");
        int port = AutoConfig.getInt(properties.get("PortNumber"));
        boolean remote = port != -1;
        String databaseName = properties.getProperty("DatabaseName");
        if (driver == null || driver.equals("org.hsqldb.jdbcDriver")) {
            if (remote) {
                return String.format("jdbc:hsqldb:hsql://%s:%s/%s", serverName, port, databaseName);
            }
            return String.format("jdbc:hsqldb:mem:%s", databaseName);
        }
        if (driver.equals("org.apache.derby.jdbc.EmbeddedDriver")) {
            return String.format("jdbc:derby:%s;create=true", databaseName);
        }
        if (driver.equals("org.apache.derby.jdbc.ClientDriver")) {
            return String.format("jdbc:derby://%s:%s/%s;create=true", serverName, port, databaseName);
        }
        if (driver.equals("com.mysql.jdbc.Driver")) {
            return String.format("jdbc:mysql://%s:%s/%s", serverName, port, databaseName);
        }
        if (driver.equals("com.postgresql.jdbc.Driver")) {
            return String.format("jdbc:postgresql://%s:%s/%s", serverName, port, databaseName);
        }
        if (driver.equals("oracle.jdbc.OracleDriver")) {
            return String.format("jdbc:oracle:thin:@//%s:%s/%s", serverName, port, databaseName);
        }
        return null;
    }

    private static int getInt(Object number) {
        try {
            return (Integer)number;
        }
        catch (Exception e) {
            try {
                return Integer.parseInt(number + "");
            }
            catch (NumberFormatException e1) {
                return -1;
            }
        }
    }

    private void set(Properties properties, String key, String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        properties.put(key, value);
    }

    private void set(Properties properties, String key, int value) {
        this.set(properties, key, value, 0);
    }

    private void set(Properties properties, String key, int value, int min) {
        if (value < min) {
            return;
        }
        properties.put(key, (Object)value);
    }

    private String createContainer(Class<? extends ContainerInfo> containerInfoType, EjbDeployment ejbDeployment, EnterpriseBean bean) throws OpenEJBException {
        String newResourceId;
        if (!this.autoCreateContainers) {
            throw new OpenEJBException("A container of type " + AutoConfig.getType(bean) + " must be declared in the configuration file for bean: " + bean.getEjbName());
        }
        ContainerInfo containerInfo = this.configFactory.configureService(containerInfoType);
        logger.info("Auto-creating a container for bean " + ejbDeployment.getDeploymentId() + ": Container(type=" + AutoConfig.getType(bean) + ", id=" + containerInfo.id + ")");
        String resourceAdapterId = containerInfo.properties.getProperty("ResourceAdapter");
        if (resourceAdapterId != null && resourceAdapterId != (newResourceId = this.getResourceId(ejbDeployment.getDeploymentId(), resourceAdapterId, null, null))) {
            containerInfo.properties.setProperty("ResourceAdapter", newResourceId);
        }
        this.configFactory.install(containerInfo);
        return containerInfo.id;
    }

    private void processResourceRef(ResourceRef ref, EjbDeployment ejbDeployment, AppResources appResources, ClassLoader classLoader) throws OpenEJBException {
        String mappedName;
        if (ref.getLookupName() != null) {
            return;
        }
        String string = mappedName = ref.getMappedName() == null ? "" : ref.getMappedName();
        if (mappedName.startsWith("jndi:")) {
            return;
        }
        String refName = ref.getName();
        String refType = this.getType((JndiReference)ref, classLoader);
        if (ignoredReferenceTypes.contains(refType)) {
            return;
        }
        try {
            Class<?> clazz = classLoader.loadClass(refType);
            if (clazz.isAnnotationPresent(ManagedBean.class)) {
                return;
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        ResourceLink link = ejbDeployment.getResourceLink(refName);
        if (link == null) {
            String id = mappedName.length() == 0 ? ref.getName() : mappedName;
            id = this.getResourceId(ejbDeployment.getDeploymentId(), id, refType, appResources);
            logger.info("Auto-linking resource-ref '" + refName + "' in bean " + ejbDeployment.getDeploymentId() + " to Resource(id=" + id + ")");
            link = new ResourceLink();
            link.setResId(id);
            link.setResRefName(refName);
            ejbDeployment.addResourceLink(link);
        } else {
            String id = this.getResourceId(ejbDeployment.getDeploymentId(), link.getResId(), refType, appResources);
            link.setResId(id);
            link.setResRefName(refName);
        }
    }

    private void processResourceEnvRef(JndiReference ref, EjbDeployment ejbDeployment, AppResources appResources, ClassLoader classLoader) throws OpenEJBException {
        String mappedName;
        if (ref.getLookupName() != null) {
            return;
        }
        String string = mappedName = ref.getMappedName() == null ? "" : ref.getMappedName();
        if (mappedName.startsWith("jndi:")) {
            return;
        }
        String refName = ref.getName();
        String refType = this.getType(ref, classLoader);
        if (this.isIgnoredReferenceType(refType, classLoader)) {
            return;
        }
        ResourceLink link = ejbDeployment.getResourceLink(refName);
        if (link == null) {
            String id = mappedName.length() == 0 ? refName : mappedName;
            id = this.getResourceEnvId(ejbDeployment.getDeploymentId(), id, refType, appResources);
            if (id == null) {
                return;
            }
            logger.info("Auto-linking resource-env-ref '" + refName + "' in bean " + ejbDeployment.getDeploymentId() + " to Resource(id=" + id + ")");
            link = new ResourceLink();
            link.setResId(id);
            link.setResRefName(refName);
            ejbDeployment.addResourceLink(link);
        } else {
            String id = this.getResourceEnvId(ejbDeployment.getDeploymentId(), link.getResId(), refType, appResources);
            link.setResId(id);
            link.setResRefName(refName);
        }
    }

    private String getType(JndiReference ref, ClassLoader classLoader) throws OpenEJBException {
        if (ref.getType() != null) {
            return ref.getType();
        }
        if (classLoader != null) {
            Set injections = ref.getInjectionTarget();
            for (InjectionTarget injection : injections) {
                try {
                    Class<?> target = classLoader.loadClass(injection.getInjectionTargetClass().trim());
                    Class type = IntrospectionSupport.getPropertyType(target, injection.getInjectionTargetName().trim());
                    return type.getName();
                }
                catch (ClassNotFoundException e) {
                }
                catch (NoSuchFieldException e) {
                }
            }
        }
        throw new OpenEJBException("Unable to infer type for " + (String)ref.getKey());
    }

    private static boolean skipMdb(Object bean) {
        return bean instanceof MessageDrivenBean && SystemInstance.get().hasProperty("openejb.geronimo");
    }

    private static String getType(EnterpriseBean enterpriseBean) throws OpenEJBException {
        if (enterpriseBean instanceof EntityBean) {
            if (((EntityBean)enterpriseBean).getPersistenceType() == PersistenceType.CONTAINER) {
                return "CMP_ENTITY";
            }
            return "BMP_ENTITY";
        }
        if (enterpriseBean instanceof SessionBean) {
            if (((SessionBean)enterpriseBean).getSessionType() == SessionType.STATEFUL) {
                return "STATEFUL";
            }
            if (((SessionBean)enterpriseBean).getSessionType() == SessionType.SINGLETON) {
                return "SINGLETON";
            }
            if (((SessionBean)enterpriseBean).getSessionType() == SessionType.MANAGED) {
                return "MANAGED";
            }
            return "STATELESS";
        }
        if (enterpriseBean instanceof MessageDrivenBean) {
            return "MESSAGE";
        }
        throw new OpenEJBException("Unknown enterprise bean type " + enterpriseBean.getClass().getName());
    }

    private void deploy(AppModule app, PersistenceModule persistenceModule) throws OpenEJBException {
        if (!this.autoCreateResources) {
            return;
        }
        Persistence persistence = persistenceModule.getPersistence();
        for (PersistenceUnit unit : persistence.getPersistenceUnit()) {
            if (unit.getProvider() != null) {
                logger.info("Configuring PersistenceUnit(name=" + unit.getName() + ", provider=" + unit.getProvider() + ")");
            } else {
                logger.info("Configuring PersistenceUnit(name=" + unit.getName() + ")");
            }
            Properties required = new Properties();
            logger.debug("raw <jta-data-source>" + unit.getJtaDataSource() + "</jta-datasource>");
            logger.debug("raw <non-jta-data-source>" + unit.getNonJtaDataSource() + "</non-jta-datasource>");
            unit.setJtaDataSource(this.normalizeResourceId(unit.getJtaDataSource()));
            unit.setNonJtaDataSource(this.normalizeResourceId(unit.getNonJtaDataSource()));
            logger.debug("normalized <jta-data-source>" + unit.getJtaDataSource() + "</jta-datasource>");
            logger.debug("normalized <non-jta-data-source>" + unit.getNonJtaDataSource() + "</non-jta-datasource>");
            if (logger.isDebugEnabled()) {
                required.put("JtaManaged", "true");
                List<String> managed = this.configFactory.getResourceIds("DataSource", required);
                required.put("JtaManaged", "false");
                List<String> unmanaged = this.configFactory.getResourceIds("DataSource", required);
                required.clear();
                List<String> unknown = this.configFactory.getResourceIds("DataSource", required);
                logger.debug("Available DataSources");
                for (String name : managed) {
                    logger.debug("DataSource(name=" + name + ", JtaManaged=true)");
                }
                for (String name : unmanaged) {
                    logger.debug("DataSource(name=" + name + ", JtaManaged=false)");
                }
                for (String name : unknown) {
                    if (managed.contains(name) || unmanaged.contains(name)) continue;
                    logger.debug("DataSource(name=" + name + ", JtaManaged=<unknown>)");
                }
            }
            required.put("JtaManaged", "true");
            String jtaDataSourceId = this.findResourceId(unit.getJtaDataSource(), "DataSource", required, null);
            required.put("JtaManaged", "false");
            String nonJtaDataSourceId = this.findResourceId(unit.getNonJtaDataSource(), "DataSource", required, null);
            if (jtaDataSourceId != null && nonJtaDataSourceId != null) {
                this.setJtaDataSource(unit, jtaDataSourceId);
                this.setNonJtaDataSource(unit, nonJtaDataSourceId);
                continue;
            }
            if (jtaDataSourceId == null && nonJtaDataSourceId == null) {
                required.put("JtaManaged", ServiceUtils.NONE);
                jtaDataSourceId = this.findResourceId(unit.getJtaDataSource(), "DataSource", required, null);
                nonJtaDataSourceId = this.findResourceId(unit.getNonJtaDataSource(), "DataSource", required, null);
                if (jtaDataSourceId != null || nonJtaDataSourceId != null) {
                    if (jtaDataSourceId != null) {
                        this.setJtaDataSource(unit, jtaDataSourceId);
                    }
                    if (nonJtaDataSourceId == null) continue;
                    this.setNonJtaDataSource(unit, nonJtaDataSourceId);
                    continue;
                }
            }
            required.put("JtaManaged", ServiceUtils.ANY);
            String possibleJta = this.findResourceId(unit.getJtaDataSource(), "DataSource", required, null);
            String possibleNonJta = this.findResourceId(unit.getNonJtaDataSource(), "DataSource", required, null);
            if (possibleJta != null && possibleJta == possibleNonJta) {
                ResourceInfo dataSource = this.configFactory.getResourceInfo(possibleJta);
                String jtaManaged = (String)dataSource.properties.get("JtaManaged");
                logger.warning("PeristenceUnit(name=" + unit.getName() + ") invalidly refers to Resource(id=" + dataSource.id + ") as both its <jta-data-source> and <non-jta-data-source>.");
                if ("true".equalsIgnoreCase(jtaManaged)) {
                    nonJtaDataSourceId = null;
                    unit.setNonJtaDataSource(null);
                } else if ("false".equalsIgnoreCase(jtaManaged)) {
                    jtaDataSourceId = null;
                    unit.setJtaDataSource(null);
                }
            }
            this.checkUnitDataSourceRefs(unit);
            if (jtaDataSourceId == null && nonJtaDataSourceId == null) {
                jtaDataSourceId = this.findResourceProviderId(unit.getJtaDataSource());
                nonJtaDataSourceId = this.findResourceProviderId(unit.getNonJtaDataSource());
                if (jtaDataSourceId != null || nonJtaDataSourceId != null) {
                    Resource jtaResource = new Resource(jtaDataSourceId, "DataSource", jtaDataSourceId);
                    jtaResource.getProperties().setProperty("JtaManaged", "true");
                    Resource nonJtaResource = new Resource(nonJtaDataSourceId, "DataSource", nonJtaDataSourceId);
                    nonJtaResource.getProperties().setProperty("JtaManaged", "false");
                    if (jtaDataSourceId == null) {
                        jtaResource.setId(nonJtaDataSourceId + "Jta");
                        jtaResource.setProvider(nonJtaDataSourceId);
                    } else if (nonJtaDataSourceId == null) {
                        nonJtaResource.setId(jtaDataSourceId + "NonJta");
                        nonJtaResource.setProvider(jtaDataSourceId);
                    }
                    ResourceInfo jtaResourceInfo = this.configFactory.configureService(jtaResource, ResourceInfo.class);
                    ResourceInfo nonJtaResourceInfo = this.configFactory.configureService(nonJtaResource, ResourceInfo.class);
                    this.logAutoCreateResource(jtaResourceInfo, "DataSource", unit.getName());
                    jtaDataSourceId = this.installResource(unit.getName(), jtaResourceInfo);
                    this.logAutoCreateResource(nonJtaResourceInfo, "DataSource", unit.getName());
                    nonJtaDataSourceId = this.installResource(unit.getName(), nonJtaResourceInfo);
                    this.setJtaDataSource(unit, jtaDataSourceId);
                    this.setNonJtaDataSource(unit, nonJtaDataSourceId);
                    continue;
                }
            }
            if (jtaDataSourceId == null && nonJtaDataSourceId == null) {
                ArrayList<String> ids = new ArrayList<String>();
                ids.add(unit.getName());
                for (WebModule webModule : app.getWebModules()) {
                    ids.add(webModule.getModuleId());
                    ids.add(webModule.getContextRoot());
                }
                ids.add(app.getModuleId());
                for (String id : ids) {
                    required.put("JtaManaged", "true");
                    jtaDataSourceId = this.findResourceId(id, "DataSource", required, null);
                    if (jtaDataSourceId == null) {
                        required.clear();
                        required.put("JtaManaged", "false");
                        nonJtaDataSourceId = this.findResourceId(id, "DataSource", required, null);
                    }
                    if (jtaDataSourceId == null && nonJtaDataSourceId == null) {
                        required.clear();
                        required.put("JtaManaged", ServiceUtils.NONE);
                        jtaDataSourceId = this.findResourceId(id, "DataSource", required, null);
                    }
                    if (jtaDataSourceId == null && nonJtaDataSourceId == null) continue;
                    break;
                }
            }
            if (jtaDataSourceId == null && nonJtaDataSourceId == null) {
                required.clear();
                required.put("JtaManaged", "true");
                jtaDataSourceId = this.firstMatching("DataSource", required, null);
                if (jtaDataSourceId == null) {
                    required.clear();
                    required.put("JtaManaged", "false");
                    nonJtaDataSourceId = this.firstMatching("DataSource", required, null);
                }
            }
            if (jtaDataSourceId != null && nonJtaDataSourceId == null) {
                ResourceInfo jtaResourceInfo = this.configFactory.getResourceInfo(jtaDataSourceId);
                Properties jtaProperties = jtaResourceInfo.properties;
                if (jtaProperties.containsKey("JtaManaged")) {
                    required.clear();
                    required.put("JtaManaged", "false");
                    for (String key : Arrays.asList("JdbcDriver", "JdbcUrl")) {
                        if (!jtaProperties.containsKey(key)) continue;
                        required.put(key, jtaProperties.get(key));
                    }
                    nonJtaDataSourceId = this.firstMatching("DataSource", required, null);
                    if (nonJtaDataSourceId == null) {
                        ResourceInfo nonJtaResourceInfo = this.copy(jtaResourceInfo);
                        nonJtaResourceInfo.id = jtaResourceInfo.id + "NonJta";
                        Properties overrides = ConfigurationFactory.getSystemProperties(nonJtaResourceInfo.id, nonJtaResourceInfo.service);
                        nonJtaResourceInfo.properties.putAll((Map<?, ?>)overrides);
                        nonJtaResourceInfo.properties.setProperty("JtaManaged", "false");
                        this.logAutoCreateResource(nonJtaResourceInfo, "DataSource", unit.getName());
                        logger.info("configureService.configuring", nonJtaResourceInfo.id, nonJtaResourceInfo.service, jtaResourceInfo.id);
                        nonJtaDataSourceId = this.installResource(unit.getName(), nonJtaResourceInfo);
                    }
                }
            }
            String deduceJtaFromNonJta = SystemInstance.get().getOptions().get(AUTOCREATE_JTA_DATASOURCE_FROM_NON_JTA_ONE_KEY, (String)null);
            if (nonJtaDataSourceId != null && jtaDataSourceId == null && (deduceJtaFromNonJta == null || deduceJtaFromNonJta != null && Boolean.parseBoolean(deduceJtaFromNonJta))) {
                ResourceInfo nonJtaResourceInfo = this.configFactory.getResourceInfo(nonJtaDataSourceId);
                Properties nonJtaProperties = nonJtaResourceInfo.properties;
                if (nonJtaProperties.containsKey("JtaManaged")) {
                    required.clear();
                    required.put("JtaManaged", "true");
                    for (String key : Arrays.asList("JdbcDriver", "JdbcUrl")) {
                        if (!nonJtaProperties.containsKey(key)) continue;
                        required.put(key, nonJtaProperties.get(key));
                    }
                    jtaDataSourceId = this.firstMatching("DataSource", required, null);
                    if (jtaDataSourceId == null) {
                        ResourceInfo jtaResourceInfo = this.copy(nonJtaResourceInfo);
                        jtaResourceInfo.id = nonJtaResourceInfo.id + "Jta";
                        Properties overrides = ConfigurationFactory.getSystemProperties(jtaResourceInfo.id, jtaResourceInfo.service);
                        jtaResourceInfo.properties.putAll((Map<?, ?>)overrides);
                        jtaResourceInfo.properties.setProperty("JtaManaged", "true");
                        this.logAutoCreateResource(jtaResourceInfo, "DataSource", unit.getName());
                        logger.info("configureService.configuring", jtaResourceInfo.id, jtaResourceInfo.service, nonJtaResourceInfo.id);
                        jtaDataSourceId = this.installResource(unit.getName(), jtaResourceInfo);
                    }
                }
            }
            if (jtaDataSourceId == null && nonJtaDataSourceId == null) {
                required.put("JtaManaged", "true");
                jtaDataSourceId = this.autoCreateResource("DataSource", required, unit.getName());
                required.put("JtaManaged", "false");
                nonJtaDataSourceId = this.autoCreateResource("DataSource", required, unit.getName());
            }
            if (jtaDataSourceId != null) {
                this.setJtaDataSource(unit, jtaDataSourceId);
            }
            if (nonJtaDataSourceId == null) continue;
            this.setNonJtaDataSource(unit, nonJtaDataSourceId);
        }
    }

    private void setNonJtaDataSource(PersistenceUnit unit, String current) {
        String previous = unit.getNonJtaDataSource();
        if (!current.equals(previous)) {
            logger.info("Adjusting PersistenceUnit " + unit.getName() + " <non-jta-data-source> to Resource ID '" + current + "' from '" + previous + "'");
        }
        unit.setNonJtaDataSource(current);
    }

    private void setJtaDataSource(PersistenceUnit unit, String current) {
        String previous = unit.getJtaDataSource();
        if (!current.equals(previous)) {
            logger.info("Adjusting PersistenceUnit " + unit.getName() + " <jta-data-source> to Resource ID '" + current + "' from '" + previous + "'");
        }
        unit.setJtaDataSource(current);
    }

    private ResourceInfo copy(ResourceInfo a) {
        ResourceInfo b = new ResourceInfo();
        b.id = a.id;
        b.service = a.service;
        b.className = a.className;
        b.codebase = a.codebase;
        b.displayName = a.displayName;
        b.description = a.description;
        b.factoryMethod = a.factoryMethod;
        b.constructorArgs.addAll(a.constructorArgs);
        b.types.addAll(a.types);
        b.properties = new SuperProperties();
        b.properties.putAll((Map<?, ?>)a.properties);
        return b;
    }

    private void checkUnitDataSourceRefs(PersistenceUnit unit) throws OpenEJBException {
        Properties required = new Properties();
        required.put("JtaManaged", "true");
        String invalidNonJta = this.findResourceId(unit.getNonJtaDataSource(), "DataSource", required, null);
        if (invalidNonJta != null) {
            throw new OpenEJBException("PeristenceUnit " + unit.getName() + " <non-jta-data-source> points to a jta managed Resource.  Update Resource \"" + invalidNonJta + "\" to \"JtaManaged=false\", use a different Resource, or delete the <non-jta-data-source> element and a default will be supplied if possible.");
        }
        required.put("JtaManaged", "false");
        String invalidJta = this.findResourceId(unit.getJtaDataSource(), "DataSource", required, null);
        if (invalidJta != null) {
            throw new OpenEJBException("PeristenceUnit " + unit.getName() + " <jta-data-source> points to a non jta managed Resource.  Update Resource \"" + invalidJta + "\" to \"JtaManaged=true\", use a different Resource, or delete the <jta-data-source> element and a default will be supplied if possible.");
        }
    }

    private String findResourceProviderId(String resourceId) throws OpenEJBException {
        if (resourceId == null) {
            return null;
        }
        if (ServiceUtils.hasServiceProvider(resourceId)) {
            return resourceId;
        }
        if (ServiceUtils.hasServiceProvider(resourceId = this.toShortName(resourceId))) {
            return resourceId;
        }
        return null;
    }

    private String getResourceId(String beanName, String resourceId, String type, AppResources appResources) throws OpenEJBException {
        return this.getResourceId(beanName, resourceId, type, null, appResources);
    }

    private String getResourceId(String beanName, String resourceId, String type, Properties required, AppResources appResources) throws OpenEJBException {
        if ((resourceId = this.normalizeResourceId(resourceId)) == null) {
            return null;
        }
        if (appResources == null) {
            appResources = new AppResources();
        }
        if (type != null && ignoredReferenceTypes.contains(type)) {
            return null;
        }
        String id = this.findResourceId(resourceId, type, required, appResources);
        if (id != null) {
            return id;
        }
        id = this.findResourceId(resourceId, null, required, appResources);
        if (id != null) {
            return id;
        }
        String shortName = this.toShortName(resourceId);
        String message = "No existing resource found while attempting to Auto-link unmapped resource-ref '" + resourceId + "' of type '" + type + "' for '" + beanName + "'.  Looked for Resource(id=" + resourceId + ") and Resource(id=" + shortName + ")";
        if (!this.autoCreateResources) {
            throw new OpenEJBException(message);
        }
        logger.debug(message);
        if (ServiceUtils.hasServiceProvider(resourceId)) {
            ResourceInfo resourceInfo = this.configFactory.configureService(resourceId, ResourceInfo.class);
            return this.installResource(beanName, resourceInfo);
        }
        if (ServiceUtils.hasServiceProvider(shortName)) {
            ResourceInfo resourceInfo = this.configFactory.configureService(shortName, ResourceInfo.class);
            return this.installResource(beanName, resourceInfo);
        }
        id = this.firstMatching(type, required, appResources);
        if (id != null) {
            return id;
        }
        return this.autoCreateResource(type, required, beanName);
    }

    private String autoCreateResource(String type, Properties required, String beanName) throws OpenEJBException {
        String resourceId = ServiceUtils.getServiceProviderId(type, required);
        if (resourceId == null) {
            throw new OpenEJBException("No provider available for resource-ref '" + resourceId + "' of type '" + type + "' for '" + beanName + "'.");
        }
        ResourceInfo resourceInfo = this.configFactory.configureService(resourceId, ResourceInfo.class);
        this.logAutoCreateResource(resourceInfo, type, beanName);
        return this.installResource(beanName, resourceInfo);
    }

    private void logAutoCreateResource(ResourceInfo resourceInfo, String type, String beanName) {
        logger.info("Auto-creating a Resource with id '" + resourceInfo.id + "' of type '" + type + " for '" + beanName + "'.");
    }

    private String firstMatching(String type, Properties required, AppResources appResources) {
        List<String> resourceIds = this.getResourceIds(appResources, type, required);
        String idd = null;
        if (resourceIds.size() > 0) {
            idd = resourceIds.get(0);
        }
        return idd;
    }

    private String findResourceId(String resourceId, String type, Properties required, AppResources appResources) {
        if (resourceId == null) {
            return null;
        }
        resourceId = this.normalizeResourceId(resourceId);
        List<String> resourceIds = this.getResourceIds(appResources, type, required);
        for (String id : resourceIds) {
            if (!id.equalsIgnoreCase(resourceId)) continue;
            return id;
        }
        String shortName = this.toShortName(resourceId);
        for (String id : resourceIds) {
            if (!id.equalsIgnoreCase(shortName)) continue;
            return id;
        }
        if (resourceId.startsWith("osgi:")) {
            return resourceId;
        }
        return null;
    }

    private List<String> getResourceIds(AppResources appResources, String type, Properties required) {
        ArrayList<String> resourceIds = new ArrayList<String>();
        if (appResources != null) {
            resourceIds.addAll(appResources.getResourceIds(type));
        }
        resourceIds.addAll(this.configFactory.getResourceIds(type, required));
        return resourceIds;
    }

    private String toShortName(String resourceId) {
        String shortName = resourceId.replaceFirst(".*/", "");
        return shortName;
    }

    private String normalizeResourceId(String resourceId) {
        if (resourceId == null) {
            return null;
        }
        if (resourceId.startsWith("java:comp/env/")) {
            resourceId = resourceId.substring("java:comp/env/".length());
        }
        if (resourceId.startsWith("java:openejb/Resource/")) {
            resourceId = resourceId.substring("java:openejb/Resource/".length());
        }
        if (resourceId.startsWith("java:openejb/Connector/")) {
            resourceId = resourceId.substring("java:openejb/Connector/".length());
        }
        return resourceId;
    }

    private String installResource(String beanName, ResourceInfo resourceInfo) throws OpenEJBException {
        String newResourceId;
        String dataSourceId;
        String newResourceId2;
        String resourceAdapterId = resourceInfo.properties.getProperty("ResourceAdapter");
        if (resourceAdapterId != null && resourceAdapterId != (newResourceId2 = this.getResourceId(beanName, resourceAdapterId, null, null))) {
            resourceInfo.properties.setProperty("ResourceAdapter", newResourceId2);
        }
        if ((dataSourceId = resourceInfo.properties.getProperty("DataSource")) != null && dataSourceId.length() > 0 && dataSourceId != (newResourceId = this.getResourceId(beanName, dataSourceId, null, null))) {
            resourceInfo.properties.setProperty("DataSource", newResourceId);
        }
        this.configFactory.install(resourceInfo);
        return resourceInfo.id;
    }

    private String getResourceEnvId(String beanName, String resourceId, String type, AppResources appResources) throws OpenEJBException {
        if (resourceId == null) {
            return null;
        }
        if (appResources == null) {
            appResources = new AppResources();
        }
        if (ignoredReferenceTypes.contains(type)) {
            return null;
        }
        resourceId = this.normalizeResourceId(resourceId);
        List<String> resourceEnvIds = this.getResourceIds(appResources, type, null);
        for (String id : resourceEnvIds) {
            if (!id.equalsIgnoreCase(resourceId)) continue;
            return id;
        }
        String message = "No existing resource found while attempting to Auto-link unmapped resource-env-ref '" + resourceId + "' of type '" + type + "' for '" + beanName + "'.  Looked for Resource(id=" + resourceId + ")";
        if (!this.autoCreateResources) {
            throw new OpenEJBException(message);
        }
        logger.debug(message);
        String providerId = ServiceUtils.getServiceProviderId(type);
        if (providerId == null) {
            if (resourceEnvIds.size() > 0) {
                return resourceEnvIds.get(0);
            }
            throw new OpenEJBException("No provider available for resource-env-ref '" + resourceId + "' of type '" + type + "' for '" + beanName + "'.");
        }
        Resource resource = new Resource(resourceId, null, providerId);
        resource.getProperties().setProperty("destination", resourceId);
        ResourceInfo resourceInfo = this.configFactory.configureService(resource, ResourceInfo.class);
        this.logAutoCreateResource(resourceInfo, type, beanName);
        return this.installResource(beanName, resourceInfo);
    }

    private String getUsableContainer(Class<? extends ContainerInfo> containerInfoType, Object bean, AppResources appResources) {
        if (bean instanceof MessageDrivenBean) {
            MessageDrivenBean messageDrivenBean = (MessageDrivenBean)bean;
            String messagingType = messageDrivenBean.getMessagingType();
            List containerIds = (List)appResources.containerIdsByType.get(messagingType);
            if (containerIds != null && !containerIds.isEmpty()) {
                return (String)containerIds.get(0);
            }
        }
        for (ContainerInfo containerInfo : this.configFactory.getContainerInfos()) {
            if (!containerInfo.getClass().equals(containerInfoType)) continue;
            if (bean instanceof MessageDrivenBean) {
                MessageDrivenBean messageDrivenBean = (MessageDrivenBean)bean;
                String messagingType = messageDrivenBean.getMessagingType();
                if (!containerInfo.properties.get("MessageListenerInterface").equals(messagingType)) continue;
                return containerInfo.id;
            }
            return containerInfo.id;
        }
        return null;
    }

    static {
        ignoredReferenceTypes.add("javax.ejb.SessionContext");
        ignoredReferenceTypes.add("javax.ejb.EntityContext");
        ignoredReferenceTypes.add("javax.ejb.MessageDrivenContext");
        ignoredReferenceTypes.add("javax.ejb.EJBContext");
        ignoredReferenceTypes.add("javax.xml.ws.WebServiceContext");
        ignoredReferenceTypes.add("java.net.URL");
        ignoredReferenceTypes.add(UserTransaction.class.getName());
        ignoredReferenceTypes.add(TransactionManager.class.getName());
        ignoredReferenceTypes.add(TransactionSynchronizationRegistry.class.getName());
        ignoredReferenceTypes.add(TimerService.class.getName());
        ignoredReferenceTypes.add(Validator.class.getName());
        ignoredReferenceTypes.add(ValidatorFactory.class.getName());
        ignoredReferenceTypes.add(BeanManager.class.getName());
        ignoredReferenceTypes.add(Request.class.getName());
        ignoredReferenceTypes.add(UriInfo.class.getName());
        ignoredReferenceTypes.add(HttpHeaders.class.getName());
        ignoredReferenceTypes.add(SecurityContext.class.getName());
        ignoredReferenceTypes.add(ContextResolver.class.getName());
        ignoredReferenceTypes.add(Application.class.getName());
    }

    private static class AppResources {
        private final Set<String> resourceAdapterIds = new TreeSet<String>();
        private final Map<String, List<String>> resourceIdsByType = new TreeMap<String, List<String>>();
        private final Map<String, List<String>> resourceEnvIdsByType = new TreeMap<String, List<String>>();
        private final Map<String, List<String>> containerIdsByType = new TreeMap<String, List<String>>();

        public AppResources() {
        }

        public AppResources(AppModule appModule) {
            for (ConnectorModule connectorModule : appModule.getConnectorModules()) {
                String type;
                InboundResourceadapter inbound;
                OutboundResourceAdapter outbound;
                Connector connector = connectorModule.getConnector();
                ResourceAdapter resourceAdapter = connector.getResourceAdapter();
                if (resourceAdapter.getResourceAdapterClass() != null) {
                    String resourceAdapterId = resourceAdapter.getId() != null ? resourceAdapter.getId() : connectorModule.getModuleId() + "RA";
                    this.resourceAdapterIds.add(resourceAdapterId);
                }
                if ((outbound = resourceAdapter.getOutboundResourceAdapter()) != null) {
                    for (ConnectionDefinition connection : outbound.getConnectionDefinition()) {
                        String type2 = connection.getConnectionFactoryInterface();
                        String resourceId = connection.getId() != null ? connection.getId() : (outbound.getConnectionDefinition().size() == 1 ? connectorModule.getModuleId() : connectorModule.getModuleId() + "-" + type2);
                        List<String> resourceIds = this.resourceIdsByType.get(type2);
                        if (resourceIds == null) {
                            resourceIds = new ArrayList<String>();
                            this.resourceIdsByType.put(type2, resourceIds);
                        }
                        resourceIds.add(resourceId);
                    }
                }
                if ((inbound = resourceAdapter.getInboundResourceAdapter()) != null) {
                    for (MessageListener messageListener : inbound.getMessageAdapter().getMessageListener()) {
                        type = messageListener.getMessageListenerType();
                        String containerId = messageListener.getId() != null ? messageListener.getId() : (inbound.getMessageAdapter().getMessageListener().size() == 1 ? connectorModule.getModuleId() : connectorModule.getModuleId() + "-" + type);
                        List<String> containerIds = this.containerIdsByType.get(type);
                        if (containerIds == null) {
                            containerIds = new ArrayList<String>();
                            this.containerIdsByType.put(type, containerIds);
                        }
                        containerIds.add(containerId);
                    }
                }
                for (AdminObject adminObject : resourceAdapter.getAdminObject()) {
                    type = adminObject.getAdminObjectInterface();
                    String resourceEnvId = adminObject.getId() != null ? adminObject.getId() : (resourceAdapter.getAdminObject().size() == 1 ? connectorModule.getModuleId() : connectorModule.getModuleId() + "-" + type);
                    List<String> resourceEnvIds = this.resourceEnvIdsByType.get(type);
                    if (resourceEnvIds == null) {
                        resourceEnvIds = new ArrayList<String>();
                        this.resourceEnvIdsByType.put(type, resourceEnvIds);
                    }
                    resourceEnvIds.add(resourceEnvId);
                }
            }
        }

        public List<String> getResourceIds(String type) {
            if (type == null) {
                ArrayList<String> allResourceIds = new ArrayList<String>();
                for (List<String> resourceIds : this.resourceIdsByType.values()) {
                    allResourceIds.addAll(resourceIds);
                }
                return allResourceIds;
            }
            List<String> resourceIds = this.resourceIdsByType.get(type);
            if (resourceIds != null) {
                return resourceIds;
            }
            return Collections.emptyList();
        }

        public List<String> getResourceEnvIds(String type) {
            List<String> resourceIds;
            if (type != null && (resourceIds = this.resourceEnvIdsByType.get(type)) != null) {
                return resourceIds;
            }
            return Collections.emptyList();
        }

        public List<String> getContainerIds() {
            ArrayList<String> ids = new ArrayList<String>();
            for (List<String> list : this.containerIdsByType.values()) {
                ids.addAll(list);
            }
            return ids;
        }
    }
}

