/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.openejb.config.ConfigurableClasspathArchive;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.WebappAggregatedArchive;
import org.apache.openejb.loader.SystemInstance;
import org.apache.xbean.finder.Annotated;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.ClasspathArchive;

public class FinderFactory {
    private static final FinderFactory factory = new FinderFactory();

    private static FinderFactory get() {
        FinderFactory factory = (FinderFactory)SystemInstance.get().getComponent(FinderFactory.class);
        return factory != null ? factory : FinderFactory.factory;
    }

    public static IAnnotationFinder createFinder(DeploymentModule module) throws Exception {
        return FinderFactory.get().create(module);
    }

    public static AnnotationFinder getFinder(ClassLoader classLoader, URL url) {
        return new AnnotationFinder(ClasspathArchive.archive((ClassLoader)classLoader, (URL)url));
    }

    public IAnnotationFinder create(DeploymentModule module) throws Exception {
        AnnotationFinder finder;
        if (module instanceof WebModule) {
            WebModule webModule = (WebModule)module;
            AnnotationFinder annotationFinder = new AnnotationFinder((Archive)new WebappAggregatedArchive(webModule, webModule.getScannableUrls()));
            if (annotationFinder.hasMetaAnnotations()) {
                annotationFinder.enableMetaAnnotations();
            }
            if (this.enableFindSubclasses()) {
                annotationFinder.enableFindSubclasses();
            }
            finder = annotationFinder;
        } else if (module instanceof ConnectorModule) {
            ConnectorModule connectorModule = (ConnectorModule)module;
            finder = new AnnotationFinder((Archive)new ConfigurableClasspathArchive((Module)connectorModule, connectorModule.getLibraries())).link();
        } else if (module.getJarLocation() != null) {
            URL url;
            String location = module.getJarLocation();
            File file = new File(location);
            if (file.exists()) {
                url = file.toURI().toURL();
                File webInfClassesFolder = new File(file, "WEB-INF/classes");
                if (webInfClassesFolder.exists() && webInfClassesFolder.isDirectory()) {
                    url = webInfClassesFolder.toURI().toURL();
                }
            } else {
                url = new URL(location);
            }
            finder = module instanceof Module ? new AnnotationFinder((Archive)new ConfigurableClasspathArchive((Module)((Object)module), url)).link() : new AnnotationFinder((Archive)new ConfigurableClasspathArchive(module.getClassLoader(), url)).link();
        } else {
            finder = new AnnotationFinder((Archive)new ClassesArchive(new Class[0])).link();
        }
        return new ModuleLimitedFinder((IAnnotationFinder)finder);
    }

    private boolean enableFindSubclasses() {
        return this.isJaxRsInstalled() && SystemInstance.get().getOptions().get("tomee.jaxrs.deploy.undeclared", false);
    }

    public boolean isJaxRsInstalled() {
        try {
            this.getClass().getClassLoader().loadClass("org.apache.openejb.server.rest.RsRegistry");
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static class ModuleLimitedFinder
    implements IAnnotationFinder {
        private final IAnnotationFinder delegate;

        public ModuleLimitedFinder(IAnnotationFinder delegate) {
            this.delegate = delegate;
        }

        public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
            return this.delegate.isAnnotationPresent(annotation);
        }

        public List<String> getClassesNotLoaded() {
            return this.delegate.getClassesNotLoaded();
        }

        public List<Package> findAnnotatedPackages(Class<? extends Annotation> annotation) {
            return this.delegate.findAnnotatedPackages(annotation);
        }

        public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findAnnotatedClasses(annotation), new ClassPredicate(this.getAnnotatedClassNames()));
        }

        public List<Class<?>> findInheritedAnnotatedClasses(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findInheritedAnnotatedClasses(annotation), new ClassPredicate(this.getAnnotatedClassNames()));
        }

        public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findAnnotatedMethods(annotation), new MethodPredicate(this.getAnnotatedClassNames()));
        }

        public List<Constructor> findAnnotatedConstructors(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findAnnotatedConstructors(annotation), new ConstructorPredicate(this.getAnnotatedClassNames()));
        }

        public List<Field> findAnnotatedFields(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findAnnotatedFields(annotation), new FieldPredicate(this.getAnnotatedClassNames()));
        }

        public List<Class<?>> findClassesInPackage(String packageName, boolean recursive) {
            return ModuleLimitedFinder.filter(this.delegate.findClassesInPackage(packageName, recursive), new ClassPredicate(this.getAnnotatedClassNames()));
        }

        public <T> List<Class<? extends T>> findSubclasses(Class<T> clazz) {
            return ModuleLimitedFinder.filter(this.delegate.findSubclasses(clazz), new ClassPredicate(this.getAnnotatedClassNames()));
        }

        public <T> List<Class<? extends T>> findImplementations(Class<T> clazz) {
            return ModuleLimitedFinder.filter(this.delegate.findImplementations(clazz), new ClassPredicate(this.getAnnotatedClassNames()));
        }

        public List<Annotated<Method>> findMetaAnnotatedMethods(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findMetaAnnotatedMethods(annotation), new AnnotatedMethodPredicate(this.getAnnotatedClassNames()));
        }

        public List<Annotated<Field>> findMetaAnnotatedFields(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findMetaAnnotatedFields(annotation), new AnnotatedFieldPredicate(this.getAnnotatedClassNames()));
        }

        public List<Annotated<Class<?>>> findMetaAnnotatedClasses(Class<? extends Annotation> annotation) {
            return ModuleLimitedFinder.filter(this.delegate.findMetaAnnotatedClasses(annotation), new AnnotatedClassPredicate(this.getAnnotatedClassNames()));
        }

        public List<String> getAnnotatedClassNames() {
            return this.delegate.getAnnotatedClassNames();
        }

        private static <T> List<T> filter(List<T> list, Predicate<T> predicate) {
            ArrayList<T> ts = new ArrayList<T>();
            for (T t : list) {
                if (!predicate.accept(t)) continue;
                ts.add(t);
            }
            return ts;
        }

        public IAnnotationFinder getDelegate() {
            return this.delegate;
        }

        private static class AnnotatedFieldPredicate
        extends Predicate<Annotated<Field>> {
            public AnnotatedFieldPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Annotated<Field> field) {
                return ((Field)field.get()).getDeclaringClass().getName();
            }
        }

        private static class AnnotatedMethodPredicate
        extends Predicate<Annotated<Method>> {
            public AnnotatedMethodPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Annotated<Method> method) {
                return ((Method)method.get()).getDeclaringClass().getName();
            }
        }

        private static class AnnotatedClassPredicate
        extends Predicate<Annotated<Class<?>>> {
            public AnnotatedClassPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Annotated<Class<?>> aClass) {
                return ((Class)aClass.get()).getName();
            }
        }

        private static class ConstructorPredicate
        extends Predicate<Constructor> {
            public ConstructorPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Constructor constructor) {
                return constructor.getDeclaringClass().getName();
            }
        }

        private static class FieldPredicate
        extends Predicate<Field> {
            public FieldPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Field field) {
                return field.getDeclaringClass().getName();
            }
        }

        private static class MethodPredicate
        extends Predicate<Method> {
            public MethodPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Method method) {
                return method.getDeclaringClass().getName();
            }
        }

        private static class ClassPredicate<T>
        extends Predicate<Class<? extends T>> {
            public ClassPredicate(List<String> list) {
                super(list);
            }

            @Override
            protected String name(Class<? extends T> aClass) {
                return aClass.getName();
            }
        }

        private static abstract class Predicate<T> {
            protected final List<String> accepted;

            public Predicate(List<String> list) {
                this.accepted = list;
            }

            protected boolean accept(T t) {
                return this.accepted.contains(this.name(t));
            }

            protected abstract String name(T var1);
        }
    }
}

