/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DynamicDeployer;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.JAXBContextFactory;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.jpa.EntityMappings;
import org.apache.openejb.jee.jpa.JpaJaxbUtil;
import org.apache.openejb.jee.oejb2.GeronimoEjbJarType;
import org.apache.openejb.jee.oejb2.JaxbOpenejbJar2;
import org.apache.openejb.jee.oejb3.JaxbOpenejbJar3;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class OutputGeneratedDescriptors
implements DynamicDeployer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");
    public static final String OUTPUT_DESCRIPTORS = "openejb.descriptors.output";
    public static final String OUTPUT_DESCRIPTORS_FOLDER = "openejb.descriptors.output.folder";

    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        boolean output = SystemInstance.get().getOptions().get(OUTPUT_DESCRIPTORS, false);
        if (output && appModule.getCmpMappings() != null) {
            this.writeGenratedCmpMappings(appModule);
        }
        for (EjbModule ejbModule : appModule.getEjbModules()) {
            ValidationContext context;
            boolean invalid;
            Options options = new Options(ejbModule.getOpenejbJar().getProperties(), SystemInstance.get().getOptions());
            output = options.get(OUTPUT_DESCRIPTORS, invalid = (context = ejbModule.getValidation()).hasErrors() || context.hasFailures());
            if (!output) continue;
            if (ejbModule.getEjbJar() != null) {
                this.writeEjbJar(ejbModule);
            }
            if (ejbModule.getOpenejbJar() != null) {
                this.writeOpenejbJar(ejbModule);
            }
            this.writeGeronimoOpenejb(ejbModule);
        }
        for (ConnectorModule connectorModule : appModule.getConnectorModules()) {
            this.writeRaXml(connectorModule);
        }
        return appModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRaXml(ConnectorModule connectorModule) {
        try {
            Connector connector = connectorModule.getConnector();
            File tempFile = this.tempFile("ra-", connectorModule.getModuleId() + ".xml");
            OutputStream out = IO.write((File)tempFile);
            try {
                JAXBContext ctx = JAXBContextFactory.newInstance((Class[])new Class[]{Connector.class});
                Marshaller marshaller = ctx.createMarshaller();
                marshaller.marshal((Object)connector, out);
            }
            catch (JAXBException e) {
            }
            finally {
                IO.close((Closeable)out);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File tempFile(String start, String end) throws IOException {
        if (SystemInstance.get().getOptions().get(OUTPUT_DESCRIPTORS_FOLDER, (String)null) != null) {
            File tmp = new File(SystemInstance.get().getOptions().get(OUTPUT_DESCRIPTORS_FOLDER, ""));
            if (!tmp.exists() && !tmp.mkdirs()) {
                throw new IOException("can't create " + tmp.getAbsolutePath());
            }
            return new File(tmp, start + Long.toString(new Random().nextInt()) + end);
        }
        return File.createTempFile(start, end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGenratedCmpMappings(AppModule appModule) {
        try {
            File tempFile = this.tempFile("openejb-cmp-generated-orm-", ".xml");
            OutputStream out = IO.write((File)tempFile);
            try {
                JpaJaxbUtil.marshal(EntityMappings.class, (Object)appModule.getCmpMappings(), (OutputStream)out);
            }
            catch (JAXBException e) {
            }
            finally {
                IO.close((Closeable)out);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOpenejbJar(EjbModule ejbModule) {
        try {
            OpenejbJar openejbJar = ejbModule.getOpenejbJar();
            File tempFile = this.tempFile("openejb-jar-", ejbModule.getModuleId() + ".xml");
            OutputStream out = IO.write((File)tempFile);
            try {
                JaxbOpenejbJar3.marshal(OpenejbJar.class, (Object)openejbJar, (OutputStream)out);
                logger.info("Dumping Generated openejb-jar.xml to: " + tempFile.getAbsolutePath());
            }
            catch (JAXBException e) {
            }
            finally {
                IO.close((Closeable)out);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGeronimoOpenejb(EjbModule ejbModule) {
        try {
            GeronimoEjbJarType geronimoEjbJarType = (GeronimoEjbJarType)ejbModule.getAltDDs().get("geronimo-openejb.xml");
            if (geronimoEjbJarType == null) {
                return;
            }
            File tempFile = this.tempFile("geronimo-openejb-", ejbModule.getModuleId() + ".xml");
            OutputStream out = IO.write((File)tempFile);
            try {
                JaxbOpenejbJar2.marshal(GeronimoEjbJarType.class, (Object)geronimoEjbJarType, (OutputStream)out);
                logger.info("Dumping Generated geronimo-openejb.xml to: " + tempFile.getAbsolutePath());
            }
            catch (JAXBException e) {
            }
            finally {
                IO.close((Closeable)out);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEjbJar(EjbModule ejbModule) {
        try {
            EjbJar ejbJar = ejbModule.getEjbJar();
            File tempFile = this.tempFile("ejb-jar-", ejbModule.getModuleId() + ".xml");
            OutputStream out = IO.write((File)tempFile);
            try {
                JaxbJavaee.marshal(EjbJar.class, (Object)ejbJar, (OutputStream)out);
                logger.info("Dumping Generated ejb-jar.xml to: " + tempFile.getAbsolutePath());
            }
            catch (JAXBException e) {
            }
            finally {
                IO.close((Closeable)out);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

