/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.RESTModule;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.config.WsModule;
import org.apache.openejb.jee.FacesConfig;
import org.apache.openejb.jee.NamedModule;
import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.Webservices;
import org.apache.xbean.finder.IAnnotationFinder;

public class WebModule
extends Module
implements WsModule,
RESTModule {
    private final ValidationContext validation;
    private WebApp webApp;
    private Webservices webservices;
    private String host;
    private String contextRoot;
    private final List<TldTaglib> taglibs = new ArrayList<TldTaglib>();
    private final Set<String> watchedResources = new TreeSet<String>();
    private final List<FacesConfig> facesConfigs = new ArrayList<FacesConfig>();
    private IAnnotationFinder finder;
    private final Set<String> restClasses = new TreeSet<String>();
    private final Set<String> ejbWebServices = new TreeSet<String>();
    private final Set<String> ejbRestServices = new TreeSet<String>();
    private final Set<String> restApplications = new TreeSet<String>();
    private final Map<String, Set<String>> jsfAnnotatedClasses = new HashMap<String, Set<String>>();
    private final Set<String> webAnnotatedClasses = new TreeSet<String>();
    private DeploymentModule.ID id;
    private List<URL> urls;
    private List<URL> scannableUrls;

    public WebModule(WebApp webApp, String contextRoot, ClassLoader classLoader, String jarLocation, String moduleId) {
        this.webApp = webApp;
        File file = jarLocation == null ? null : new File(jarLocation);
        this.id = new DeploymentModule.ID(null, (NamedModule)webApp, moduleId, file, null, this);
        this.validation = new ValidationContext(this);
        if (contextRoot == null) {
            contextRoot = jarLocation.substring(jarLocation.lastIndexOf(System.getProperty("file.separator")));
            if (contextRoot.endsWith(".unpacked")) {
                contextRoot = contextRoot.substring(0, contextRoot.length() - ".unpacked".length());
            }
            if (contextRoot.endsWith(".war")) {
                contextRoot = contextRoot.substring(0, contextRoot.length() - ".war".length());
            }
        }
        if (contextRoot.startsWith("/")) {
            contextRoot = contextRoot.substring(1);
        }
        this.contextRoot = contextRoot;
        this.setClassLoader(classLoader);
        if (webApp != null) {
            webApp.setContextRoot(contextRoot);
        }
    }

    @Override
    public String getJarLocation() {
        return this.id.getLocation() != null ? this.id.getLocation().getAbsolutePath() : null;
    }

    @Override
    public String getModuleId() {
        return this.id.getName();
    }

    @Override
    public File getFile() {
        return this.id.getLocation();
    }

    @Override
    public URI getModuleUri() {
        return this.id.getUri();
    }

    public List<URL> getUrls() {
        return this.urls;
    }

    public void setUrls(List<URL> urls) {
        this.urls = urls;
    }

    public IAnnotationFinder getFinder() {
        return this.finder;
    }

    public void setFinder(IAnnotationFinder finder) {
        this.finder = finder;
    }

    @Override
    public ValidationContext getValidation() {
        return this.validation;
    }

    public WebApp getWebApp() {
        return this.webApp;
    }

    public void setWebApp(WebApp webApp) {
        this.webApp = webApp;
        if (webApp != null) {
            webApp.setContextRoot(this.contextRoot);
        }
    }

    @Override
    public Webservices getWebservices() {
        return this.webservices;
    }

    @Override
    public void setWebservices(Webservices webservices) {
        this.webservices = webservices;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }

    public void setContextRoot(String contextRoot) {
        if (this.webApp != null) {
            this.webApp.setContextRoot(contextRoot);
        }
        this.contextRoot = contextRoot;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public List<TldTaglib> getTaglibs() {
        return this.taglibs;
    }

    @Override
    public Set<String> getWatchedResources() {
        return this.watchedResources;
    }

    public List<FacesConfig> getFacesConfigs() {
        return this.facesConfigs;
    }

    public String toString() {
        return "WebModule{moduleId='" + this.id.getName() + '\'' + ", contextRoot='" + this.contextRoot + '\'' + '}';
    }

    @Override
    public Set<String> getRestClasses() {
        return this.restClasses;
    }

    public Set<String> getRestApplications() {
        return this.restApplications;
    }

    public Set<String> getEjbWebServices() {
        return this.ejbWebServices;
    }

    public Set<String> getEjbRestServices() {
        return this.ejbRestServices;
    }

    public List<URL> getScannableUrls() {
        return this.scannableUrls;
    }

    public void setScannableUrls(List<URL> scannableUrls) {
        this.scannableUrls = scannableUrls;
    }

    public Map<String, Set<String>> getJsfAnnotatedClasses() {
        return this.jsfAnnotatedClasses;
    }

    public Set<String> getWebAnnotatedClasses() {
        return this.webAnnotatedClasses;
    }
}

