/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.sys;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.openejb.config.Service;
import org.apache.openejb.config.sys.ConnectionManager;
import org.apache.openejb.config.sys.Container;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.config.sys.JndiProvider;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.config.sys.PropertiesAdapter;
import org.apache.openejb.config.sys.ProxyFactory;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.SecurityService;
import org.apache.openejb.config.sys.TransactionManager;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SaxOpenejb
extends DefaultHandler {
    private final Openejb openejb = new Openejb();
    private final List<DefaultHandler> handlers = new LinkedList<DefaultHandler>();

    SaxOpenejb() {
    }

    public static Openejb parse(InputSource source) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        SAXParser parser = factory.newSAXParser();
        SaxOpenejb sax = new SaxOpenejb();
        parser.parse(source, (DefaultHandler)sax);
        return sax.openejb;
    }

    private DefaultHandler get() {
        return this.handlers.get(0);
    }

    private DefaultHandler pop() {
        return this.handlers.remove(0);
    }

    private void push(DefaultHandler handler) {
        this.handlers.add(0, handler);
    }

    @Override
    public void startDocument() throws SAXException {
        this.push(new Document());
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.get().startElement(uri, localName, qName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.get().endElement(uri, localName, qName);
        this.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.get().characters(ch, start, length);
    }

    public class ResourceElement
    extends ServiceElement<Resource> {
        public ResourceElement() {
            super(SaxOpenejb.this, (Service)new Resource());
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            super.startElement(uri, localName, qName, attributes);
            ((Resource)this.service).setJndi(attributes.getValue("jndi"));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.getResource().add((Resource)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    public class JndiProviderElement
    extends ServiceElement<JndiProvider> {
        public JndiProviderElement() {
            super(SaxOpenejb.this, (Service)new JndiProvider());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.getJndiProvider().add((JndiProvider)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    public class TransactionManagerElement
    extends ServiceElement<TransactionManager> {
        public TransactionManagerElement() {
            super(SaxOpenejb.this, (Service)new TransactionManager());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.setTransactionManager((TransactionManager)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    public class ProxyFactoryElement
    extends ServiceElement<ProxyFactory> {
        public ProxyFactoryElement() {
            super(SaxOpenejb.this, (Service)new ProxyFactory());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.setProxyFactory((ProxyFactory)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    public class ConnectionManagerElement
    extends ServiceElement<ConnectionManager> {
        public ConnectionManagerElement() {
            super(SaxOpenejb.this, (Service)new ConnectionManager());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.setConnectionManager((ConnectionManager)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    public class SecurityServiceElement
    extends ServiceElement<SecurityService> {
        public SecurityServiceElement() {
            super(SaxOpenejb.this, (Service)new SecurityService());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.setSecurityService((SecurityService)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    public class ContainerElement
    extends ServiceElement<Container> {
        public ContainerElement() {
            super(SaxOpenejb.this, (Service)new Container());
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            super.startElement(uri, localName, qName, attributes);
            String ctype = attributes.getValue("ctype");
            if (ctype != null) {
                ((Container)this.service).setType(ctype);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.getContainer().add((Container)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    private static abstract class ServiceElement<S extends Service>
    extends Content {
        final S service;
        final /* synthetic */ SaxOpenejb this$0;

        protected ServiceElement(S service) {
            this.this$0 = var1_1;
            this.service = service;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.service.setType(attributes.getValue("type"));
            this.service.setJar(attributes.getValue("jar"));
            this.service.setProvider(attributes.getValue("provider"));
            this.service.setId(attributes.getValue("id"));
        }

        @Override
        public void setValue(String text) {
            try {
                this.service.getProperties().putAll((Map<?, ?>)new PropertiesAdapter().unmarshal(text));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class DeploymentsElement
    extends DefaultHandler {
        private final Deployments deployments = new Deployments();

        private DeploymentsElement() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.deployments.setDir(attributes.getValue("dir"));
            this.deployments.setJar(attributes.getValue("jar"));
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            SaxOpenejb.this.openejb.getDeployments().add(this.deployments);
        }
    }

    private class Document
    extends DefaultHandler {
        private Document() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("openejb")) {
                SaxOpenejb.this.push(new Root());
            } else if (localName.equals("tomee")) {
                SaxOpenejb.this.push(new Root());
            } else {
                throw new IllegalStateException("Unsupported Element: " + localName);
            }
        }
    }

    private class Root
    extends DefaultHandler {
        private Root() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("Container")) {
                SaxOpenejb.this.push(new ContainerElement());
            } else if (localName.equals("JndiProvider")) {
                SaxOpenejb.this.push(new JndiProviderElement());
            } else if (localName.equals("SecurityService")) {
                SaxOpenejb.this.push(new SecurityServiceElement());
            } else if (localName.equals("TransactionManager")) {
                SaxOpenejb.this.push(new TransactionManagerElement());
            } else if (localName.equals("ConnectionManager")) {
                SaxOpenejb.this.push(new ConnectionManagerElement());
            } else if (localName.equals("ProxyFactory")) {
                SaxOpenejb.this.push(new ProxyFactoryElement());
            } else if (localName.equals("Resource")) {
                SaxOpenejb.this.push(new ResourceElement());
            } else if (localName.equals("Deployments")) {
                SaxOpenejb.this.push(new DeploymentsElement());
            } else {
                throw new IllegalStateException("Unsupported Element: " + localName);
            }
            SaxOpenejb.this.get().startElement(uri, localName, qName, attributes);
        }
    }

    public class Content
    extends DefaultHandler {
        private StringBuilder characters = new StringBuilder();

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.characters = new StringBuilder();
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.characters.append(new String(ch, start, length));
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            this.setValue(this.characters.toString());
        }

        public void setValue(String text) {
        }
    }
}

