/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm;

import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.NoSuchEJBException;
import org.apache.openejb.AppContext;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.InvalidateReferenceException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.BaseEjbProxyHandler;
import org.apache.openejb.core.ivm.EjbHomeProxyHandler;
import org.apache.openejb.core.ivm.IntraVmArtifact;
import org.apache.openejb.core.ivm.IntraVmCopyMonitor;
import org.apache.openejb.core.ivm.IntraVmHandle;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public abstract class EjbObjectProxyHandler
extends BaseEjbProxyHandler {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    static final Map<String, Integer> dispatchTable = new HashMap<String, Integer>();

    public EjbObjectProxyHandler(BeanContext beanContext, Object pk, InterfaceType interfaceType, List<Class> interfaces, Class mainInterface) {
        super(beanContext, pk, interfaceType, interfaces, mainInterface);
    }

    public abstract Object getRegistryId();

    @Override
    public Object _invoke(Object p, Class interfce, Method m, Object[] a) throws Throwable {
        Object retValue = null;
        Throwable exc = null;
        try {
            Integer operation;
            if (logger.isDebugEnabled()) {
                logger.debug("invoking method " + m.getName() + " on " + this.deploymentID + " with identity " + this.primaryKey);
            }
            if ((operation = dispatchTable.get(m.getName())) != null) {
                if (operation == 3) {
                    if (m.getParameterTypes()[0] != EJBObject.class && m.getParameterTypes()[0] != EJBLocalObject.class) {
                        operation = null;
                    }
                } else {
                    Integer n = operation = m.getParameterTypes().length == 0 ? operation : null;
                }
            }
            if (operation == null || !this.interfaceType.isComponent()) {
                retValue = this.businessMethod(interfce, m, a, p);
            } else {
                switch (operation) {
                    case 1: {
                        retValue = this.getHandle(m, a, p);
                        break;
                    }
                    case 2: {
                        retValue = this.getPrimaryKey(m, a, p);
                        break;
                    }
                    case 3: {
                        retValue = this.isIdentical(m, a, p);
                        break;
                    }
                    case 4: {
                        retValue = this.remove(interfce, m, a, p);
                        break;
                    }
                    case 5: {
                        retValue = this.getEJBHome(m, a, p);
                        break;
                    }
                    case 6: {
                        retValue = this.getEJBLocalHome(m, a, p);
                        break;
                    }
                    default: {
                        throw new OpenEJBRuntimeException("Inconsistent internal state");
                    }
                }
            }
            Object object = retValue;
            return object;
        }
        catch (InvalidateReferenceException ire) {
            this.invalidateAllHandlers(this.getRegistryId());
            exc = ire.getRootCause() != null ? ire.getRootCause() : ire;
            throw exc;
        }
        catch (ApplicationException ae) {
            Throwable throwable = exc = ae.getRootCause() != null ? ae.getRootCause() : ae;
            if (exc instanceof EJBAccessException) {
                if (this.interfaceType.isBusiness()) {
                    throw exc;
                }
                if (this.interfaceType.isLocal()) {
                    throw new AccessLocalException(exc.getMessage()).initCause(exc.getCause());
                }
                throw new AccessException(exc.getMessage());
            }
            throw exc;
        }
        catch (SystemException se) {
            this.invalidateReference();
            exc = se.getRootCause() != null ? se.getRootCause() : se;
            logger.debug("The container received an unexpected exception: ", exc);
            throw new RemoteException("Container has suffered a SystemException", exc);
        }
        catch (OpenEJBException oe) {
            exc = oe.getRootCause() != null ? oe.getRootCause() : oe;
            logger.debug("The container received an unexpected exception: ", exc);
            throw new RemoteException("Unknown Container Exception", oe.getRootCause());
        }
        finally {
            if (logger.isDebugEnabled()) {
                if (exc == null) {
                    String ret;
                    try {
                        ret = retValue.toString();
                    }
                    catch (Exception e) {
                        ret = "can't get toString() value (" + e.getMessage() + ")";
                    }
                    logger.debug("finished invoking method " + m.getName() + ". Return value:" + ret);
                } else {
                    logger.debug("finished invoking method " + m.getName() + " with exception " + exc);
                }
            }
        }
    }

    protected Object getEJBHome(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        return this.getBeanContext().getEJBHome();
    }

    protected Object getEJBLocalHome(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        return this.getBeanContext().getEJBLocalHome();
    }

    protected Object getHandle(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        return new IntraVmHandle(proxy);
    }

    @Override
    public ProxyInfo getProxyInfo() {
        return new ProxyInfo(this.getBeanContext(), this.primaryKey, this.getInterfaces(), this.interfaceType, this.getMainInterface());
    }

    @Override
    protected Object _writeReplace(Object proxy) throws ObjectStreamException {
        if (IntraVmCopyMonitor.isIntraVmCopyOperation()) {
            return new IntraVmArtifact(proxy);
        }
        if (IntraVmCopyMonitor.isStatefulPassivationOperation()) {
            return proxy;
        }
        if (IntraVmCopyMonitor.isCrossClassLoaderOperation()) {
            return proxy;
        }
        ApplicationServer applicationServer = ServerFederation.getApplicationServer();
        if (this.interfaceType.isBusiness()) {
            return applicationServer.getBusinessObject(this.getProxyInfo());
        }
        return applicationServer.getEJBObject(this.getProxyInfo());
    }

    protected abstract Object getPrimaryKey(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object isIdentical(Method var1, Object[] var2, Object var3) throws Throwable;

    protected abstract Object remove(Class var1, Method var2, Object[] var3, Object var4) throws Throwable;

    protected Object businessMethod(Class<?> interfce, Method method, Object[] args, Object proxy) throws Throwable {
        BeanContext beanContext = this.getBeanContext();
        if (beanContext.isAsynchronous(method)) {
            return this.asynchronizedBusinessMethod(interfce, method, args, proxy);
        }
        return this.synchronizedBusinessMethod(interfce, method, args, proxy);
    }

    protected Object asynchronizedBusinessMethod(Class<?> interfce, Method method, Object[] args, Object proxy) throws Throwable {
        BeanContext beanContext = this.getBeanContext();
        AtomicBoolean asynchronousCancelled = new AtomicBoolean(false);
        AsynchronousCall asynchronousCall = new AsynchronousCall(interfce, method, args, asynchronousCancelled);
        try {
            Future<Object> retValue = beanContext.getModuleContext().getAppContext().submitTask(asynchronousCall);
            if (method.getReturnType() == Void.TYPE) {
                return null;
            }
            return new FutureAdapter<Object>(retValue, asynchronousCancelled, beanContext.getModuleContext().getAppContext());
        }
        catch (RejectedExecutionException e) {
            throw new EJBException("fail to allocate internal resource to execute the target task", (Exception)e);
        }
    }

    protected Object synchronizedBusinessMethod(Class<?> interfce, Method method, Object[] args, Object proxy) throws Throwable {
        return this.container.invoke(this.deploymentID, this.interfaceType, interfce, method, args, this.primaryKey);
    }

    public static Object createProxy(BeanContext beanContext, Object primaryKey, InterfaceType interfaceType, Class mainInterface) {
        return EjbObjectProxyHandler.createProxy(beanContext, primaryKey, interfaceType, null, mainInterface);
    }

    public static Object createProxy(BeanContext beanContext, Object primaryKey, InterfaceType interfaceType, List<Class> interfaces, Class mainInterface) {
        if (!interfaceType.isHome()) {
            interfaceType = interfaceType.getCounterpart();
        }
        EjbHomeProxyHandler homeHandler = EjbHomeProxyHandler.createHomeHandler(beanContext, interfaceType, interfaces, mainInterface);
        return homeHandler.createProxy(primaryKey, mainInterface);
    }

    static {
        dispatchTable.put("getHandle", 1);
        dispatchTable.put("getPrimaryKey", 2);
        dispatchTable.put("isIdentical", 3);
        dispatchTable.put("remove", 4);
        dispatchTable.put("getEJBHome", 5);
        dispatchTable.put("getEJBLocalHome", 6);
    }

    private class FutureAdapter<T>
    implements Future<T> {
        private Future<T> target;
        private AtomicBoolean asynchronousCancelled;
        private AppContext appContext;
        private volatile boolean canceled;

        public FutureAdapter(Future<T> target, AtomicBoolean asynchronousCancelled, AppContext appContext) {
            this.target = target;
            this.asynchronousCancelled = asynchronousCancelled;
            this.appContext = appContext;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.canceled) {
                return true;
            }
            if (this.appContext.removeTask((Runnable)((Object)this.target))) {
                this.canceled = true;
                return true;
            }
            if (!this.target.isDone()) {
                this.asynchronousCancelled.set(mayInterruptIfRunning);
            }
            return false;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (this.canceled) {
                throw new CancellationException();
            }
            T object = null;
            try {
                object = this.target.get();
            }
            catch (Throwable e) {
                this.handleException(e);
            }
            return object;
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (this.canceled) {
                throw new CancellationException();
            }
            T object = null;
            try {
                object = this.target.get(timeout, unit);
            }
            catch (Throwable e) {
                this.handleException(e);
            }
            return object;
        }

        private void handleException(Throwable e) throws ExecutionException {
            boolean isExceptionUnchecked;
            while (e.getCause() != null) {
                e = e.getCause();
            }
            if (e instanceof NoSuchObjectException) {
                e = new NoSuchEJBException(e.getMessage(), (Exception)e);
            }
            boolean bl = isExceptionUnchecked = e instanceof Error || e instanceof RuntimeException;
            if (!isExceptionUnchecked || e instanceof EJBException) {
                throw new ExecutionException(e);
            }
            throw e instanceof Exception ? new ExecutionException((Throwable)new EJBException((Exception)e)) : new ExecutionException((Throwable)new EJBException(new Exception(e)));
        }

        @Override
        public boolean isCancelled() {
            return this.canceled;
        }

        @Override
        public boolean isDone() {
            if (this.canceled) {
                return false;
            }
            return this.target.isDone();
        }
    }

    private class AsynchronousCall
    implements Callable<Object> {
        private Class<?> interfce;
        private Method method;
        private Object[] args;
        private AtomicBoolean asynchronousCancelled;

        public AsynchronousCall(Class<?> interfce, Method method, Object[] args, AtomicBoolean asynchronousCancelled) {
            this.interfce = interfce;
            this.method = method;
            this.args = args;
            this.asynchronousCancelled = asynchronousCancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() throws Exception {
            try {
                ThreadContext.initAsynchronousCancelled(this.asynchronousCancelled);
                Object retValue = EjbObjectProxyHandler.this.container.invoke(EjbObjectProxyHandler.this.deploymentID, EjbObjectProxyHandler.this.interfaceType, this.interfce, this.method, this.args, EjbObjectProxyHandler.this.primaryKey);
                if (retValue == null) {
                    Object var2_2 = null;
                    return var2_2;
                }
                if (retValue instanceof Future) {
                    Future asyncResult = (Future)retValue;
                    Object v = asyncResult.get();
                    return v;
                }
                Object var2_4 = null;
                return var2_4;
            }
            finally {
                ThreadContext.removeAsynchronousCancelled();
            }
        }
    }
}

