/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateful;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.ivm.EjbObjectInputStream;
import org.apache.openejb.core.stateful.PassivationStrategy;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class SimplePassivater
implements PassivationStrategy {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private File sessionDirectory;

    public SimplePassivater() throws SystemException {
        this.init(null);
    }

    @Override
    public void init(Properties props) throws SystemException {
        if (props == null) {
            props = new Properties();
        }
        String dir = props.getProperty("org/openejb/core/InstanceManager/PASSIVATOR_PATH_PREFIX");
        try {
            this.sessionDirectory = dir != null ? SystemInstance.get().getBase().getDirectory(dir) : new File(System.getProperty("java.io.tmpdir", File.separator + "tmp"));
            logger.info("Using directory " + this.sessionDirectory + " for stateful session passivation");
        }
        catch (IOException e) {
            throw new SystemException(this.getClass().getName() + ".init(): can't use directory prefix " + dir + ":" + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivate(Object primaryKey, Object state) throws SystemException {
        try {
            String filename = primaryKey.toString().replace(':', '=');
            File sessionFile = new File(this.sessionDirectory, filename);
            logger.info("Passivating to file " + sessionFile);
            ObjectOutputStream oos = new ObjectOutputStream(IO.write((File)sessionFile));
            try {
                oos.writeObject(state);
            }
            finally {
                sessionFile.deleteOnExit();
                IO.close((Closeable)oos);
            }
        }
        catch (NotSerializableException nse) {
            logger.error("Passivation failed ", nse);
            throw (SystemException)new SystemException("The type " + nse.getMessage() + " is not serializable as mandated by the EJB specification.").initCause(nse);
        }
        catch (Exception t) {
            logger.error("Passivation failed ", t);
            throw new SystemException(t);
        }
    }

    @Override
    public void passivate(Map hash) throws SystemException {
        for (Object id : hash.keySet()) {
            this.passivate(id, hash.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object activate(Object primaryKey) throws SystemException {
        try {
            String filename = primaryKey.toString().replace(':', '=');
            File sessionFile = new File(this.sessionDirectory, filename);
            if (!sessionFile.exists()) {
                logger.info("Activation failed: file not found " + sessionFile);
                return null;
            }
            logger.info("Activating from file " + sessionFile);
            EjbObjectInputStream ois = new EjbObjectInputStream(IO.read((File)sessionFile));
            try {
                Object object = ois.readObject();
                return object;
            }
            finally {
                IO.close((Closeable)ois);
                sessionFile.delete();
            }
        }
        catch (Exception t) {
            logger.info("Activation failed ", t);
            throw new SystemException(t);
        }
    }
}

