/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.quartz.SchedulerConfigException;
import org.quartz.spi.ThreadPool;

public class DefaultTimerThreadPoolAdapter
implements ThreadPool {
    private static final Logger logger = Logger.getInstance(LogCategory.TIMER, "org.apache.openejb.util.resources");
    private Executor executor;
    private String instanceId;
    private String instanceName;
    private final Object threadAvailableLock = new Object();
    private final boolean threadPoolExecutorUsed;

    public DefaultTimerThreadPoolAdapter() {
        this.executor = (Executor)SystemInstance.get().getComponent(Executor.class);
        if (this.executor == null) {
            int size = Integer.parseInt(SystemInstance.get().getProperty("openejb.timer.pool.size", "2"));
            if (size < 2) {
                size = 2;
            }
            this.executor = new ThreadPoolExecutor(2, size, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(size), new DaemonThreadFactory(DefaultTimerThreadPoolAdapter.class), new RejectedExecutionHandler(){

                @Override
                public void rejectedExecution(Runnable r, ThreadPoolExecutor tpe) {
                    if (null == r || null == tpe || tpe.isShutdown() || tpe.isTerminated() || tpe.isTerminating()) {
                        return;
                    }
                    try {
                        if (!tpe.getQueue().offer(r, 30L, TimeUnit.SECONDS)) {
                            throw new RejectedExecutionException("Timeout waiting for executor slot");
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RejectedExecutionException("Interrupted waiting for executor slot");
                    }
                }
            });
            ((ThreadPoolExecutor)this.executor).allowCoreThreadTimeOut(true);
            SystemInstance.get().setComponent(Executor.class, (Object)this.executor);
        }
        this.threadPoolExecutorUsed = this.executor instanceof ThreadPoolExecutor;
        if (!this.threadPoolExecutorUsed) {
            logger.warning("Unrecognized ThreadPool implementation [" + this.executor.getClass().getName() + "] is used, EJB Timer service may not work correctly");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int blockForAvailableThreads() {
        if (this.threadPoolExecutorUsed) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.executor;
            Object object = this.threadAvailableLock;
            synchronized (object) {
                while (threadPoolExecutor.getMaximumPoolSize() - threadPoolExecutor.getActiveCount() < 1 && !threadPoolExecutor.isShutdown()) {
                    try {
                        this.threadAvailableLock.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return threadPoolExecutor.getMaximumPoolSize() - threadPoolExecutor.getActiveCount();
            }
        }
        return 1;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public int getPoolSize() {
        if (this.threadPoolExecutorUsed) {
            return ((ThreadPoolExecutor)this.executor).getPoolSize();
        }
        return 1;
    }

    public void initialize() throws SchedulerConfigException {
    }

    public boolean runInThread(Runnable runnable) {
        try {
            this.executor.execute(runnable);
            return true;
        }
        catch (RejectedExecutionException e) {
            logger.error("Failed to execute timer task", e);
            return false;
        }
    }

    public void shutdown(boolean arg0) {
    }
}

