/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.timer;

import java.lang.reflect.Method;
import java.util.Date;
import javax.ejb.EJBException;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.timer.TimerImpl;
import org.apache.openejb.core.timer.TimerType;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.triggers.AbstractTrigger;

public abstract class TimerData {
    public static final String OPEN_EJB_TIMEOUT_TRIGGER_NAME_PREFIX = "OPEN_EJB_TIMEOUT_TRIGGER_";
    public static final String OPEN_EJB_TIMEOUT_TRIGGER_GROUP_NAME = "OPEN_EJB_TIMEOUT_TRIGGER_GROUP";
    private static final Logger log = Logger.getInstance(LogCategory.TIMER, "org.apache.openejb.util.resources");
    private final long id;
    final EjbTimerServiceImpl timerService;
    private final String deploymentId;
    private final Object primaryKey;
    private final Method timeoutMethod;
    private final Object info;
    private boolean persistent;
    protected AbstractTrigger<?> trigger;
    protected Scheduler scheduler;
    private final Timer timer;
    private boolean newTimer = false;
    private boolean cancelled = false;
    private boolean synchronizationRegistered = false;
    private boolean expired;

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public TimerData(long id, EjbTimerServiceImpl timerService, String deploymentId, Object primaryKey, Method timeoutMethod, TimerConfig timerConfig) {
        this.id = id;
        this.timerService = timerService;
        this.deploymentId = deploymentId;
        this.primaryKey = primaryKey;
        this.info = timerConfig == null ? null : timerConfig.getInfo();
        this.persistent = timerConfig == null ? true : timerConfig.isPersistent();
        this.timer = new TimerImpl(this);
        this.timeoutMethod = timeoutMethod;
    }

    public void stop() {
        if (this.trigger != null) {
            try {
                Scheduler s = this.timerService.getScheduler();
                if (!s.isShutdown()) {
                    s.unscheduleJob(this.trigger.getKey());
                }
            }
            catch (SchedulerException e) {
                throw new EJBException("fail to cancel the timer", (Exception)((Object)e));
            }
        }
        this.cancelled = true;
    }

    public long getId() {
        return this.id;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public Object getPrimaryKey() {
        return this.primaryKey;
    }

    public Object getInfo() {
        return this.info;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public boolean isNewTimer() {
        return this.newTimer;
    }

    public void newTimer() {
        this.trigger = this.initializeTrigger();
        this.trigger.computeFirstFireTime(null);
        this.trigger.setGroup(OPEN_EJB_TIMEOUT_TRIGGER_GROUP_NAME);
        this.trigger.setName(OPEN_EJB_TIMEOUT_TRIGGER_NAME_PREFIX + this.deploymentId + "_" + this.id);
        this.newTimer = true;
        this.registerTimerDataSynchronization();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.timerService.cancelled(this);
        if (this.trigger != null) {
            try {
                Scheduler s = this.timerService.getScheduler();
                if (!s.isShutdown()) {
                    s.unscheduleJob(this.trigger.getKey());
                }
            }
            catch (SchedulerException e) {
                throw new EJBException("fail to cancel the timer", (Exception)((Object)e));
            }
        }
        this.cancelled = true;
        this.registerTimerDataSynchronization();
    }

    public Method getTimeoutMethod() {
        return this.timeoutMethod;
    }

    private void transactionComplete(boolean committed) {
        if (this.newTimer) {
            this.newTimer = false;
            if (!this.isCancelled() && committed) {
                this.timerService.schedule(this);
            }
        } else if (!committed) {
            this.cancelled = false;
            this.timerService.addTimerData(this);
            this.timerService.schedule(this);
        }
    }

    private void registerTimerDataSynchronization() {
        if (this.synchronizationRegistered) {
            return;
        }
        try {
            int status;
            Transaction transaction = this.timerService.getTransactionManager().getTransaction();
            int n = status = transaction == null ? 6 : transaction.getStatus();
            if (transaction != null && status == 0 || status == 1) {
                transaction.registerSynchronization((Synchronization)new TimerDataSynchronization());
                this.synchronizationRegistered = true;
                return;
            }
        }
        catch (Exception e) {
            log.warning("Unable to register timer data transaction synchronization", e);
        }
        this.transactionComplete(true);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public Trigger getTrigger() {
        if (this.scheduler != null) {
            try {
                TriggerKey key = new TriggerKey(this.trigger.getName(), this.trigger.getGroup());
                if (this.scheduler.checkExists(key)) {
                    return this.scheduler.getTrigger(key);
                }
            }
            catch (SchedulerException e) {
                return null;
            }
        }
        return this.trigger;
    }

    public Date getNextTimeout() {
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            log.warning("Interrupted exception when waiting 1ms for the trigger to init", e);
        }
        Date nextTimeout = null;
        if (this.getTrigger() != null) {
            nextTimeout = this.getTrigger().getNextFireTime();
        }
        return nextTimeout;
    }

    public long getTimeRemaining() {
        Date nextTimeout = this.getNextTimeout();
        return nextTimeout.getTime() - System.currentTimeMillis();
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public abstract TimerType getType();

    protected abstract AbstractTrigger<?> initializeTrigger();

    private class TimerDataSynchronization
    implements Synchronization {
        private TimerDataSynchronization() {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            TimerData.this.synchronizationRegistered = false;
            TimerData.this.transactionComplete(status == 3);
        }
    }
}

