/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc;

import java.io.File;
import java.io.IOException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.DataSourcePlugin;
import org.apache.xbean.finder.ResourceFinder;

public class InstantdbDataSourcePlugin
implements DataSourcePlugin {
    @Override
    public void configure(BasicDataSource dataSource) {
        String prefix;
        String jdbcUrl = dataSource.getUrl();
        int index = jdbcUrl.indexOf(prefix = "jdbc:idb:");
        if (index == -1) {
            return;
        }
        String confFile = jdbcUrl.substring(index + prefix.length());
        File base = SystemInstance.get().getBase().getDirectory();
        File file = new File(base, confFile);
        if (file.exists()) {
            return;
        }
        if (!file.getParentFile().exists()) {
            return;
        }
        try {
            ResourceFinder finder = new ResourceFinder("");
            String defaultProperties = finder.findString("default.instantdb.properties");
            IO.copy((byte[])defaultProperties.getBytes(), (File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean enableUserDirHack() {
        return true;
    }
}

