/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import org.apache.xbean.asm.AnnotationVisitor;
import org.apache.xbean.asm.Attribute;
import org.apache.xbean.asm.ClassReader;
import org.apache.xbean.asm.ClassVisitor;
import org.apache.xbean.asm.FieldVisitor;
import org.apache.xbean.asm.MethodVisitor;
import org.apache.xbean.finder.UrlSet;

public class AnnotationFinder {
    private final ClassLoader classLoader;
    private final List<String> classesNotLoaded = new ArrayList<String>();
    private final int ASM_FLAGS = 7;
    private final Collection<URL> urls;
    private List<String> classNames;
    public static int classes;

    public AnnotationFinder(ClassLoader classLoader) throws Exception {
        this(classLoader, true);
    }

    public AnnotationFinder(ClassLoader classLoader, boolean excludeParent) throws Exception {
        this(classLoader, AnnotationFinder.getUrls(classLoader, excludeParent));
    }

    public AnnotationFinder(ClassLoader classLoader, ClassLoader exclude) throws Exception {
        this(classLoader, AnnotationFinder.getUrls(classLoader, exclude));
    }

    public AnnotationFinder(ClassLoader classLoader, URL url) {
        this(classLoader, Arrays.asList(url));
    }

    public AnnotationFinder(ClassLoader classLoader, Collection<URL> urls) {
        this.classLoader = classLoader;
        this.urls = urls;
        this.classNames = new ArrayList<String>();
        for (URL location : urls) {
            if (location == null) continue;
            try {
                if (location.getProtocol().equals("jar")) {
                    this.classNames.addAll(this.jar(location));
                    continue;
                }
                if (!location.getProtocol().equals("file")) continue;
                try {
                    URL jarUrl = new URL("jar", "", location.toExternalForm() + "!/");
                    JarURLConnection juc = (JarURLConnection)jarUrl.openConnection();
                    juc.getJarFile();
                    this.classNames.addAll(this.jar(jarUrl));
                }
                catch (IOException e) {
                    this.classNames.addAll(this.file(location));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getClassesNotLoaded() {
        return Collections.unmodifiableList(this.classesNotLoaded);
    }

    public boolean find(Filter filter) {
        Visitor annotationVisitor = new Visitor(filter);
        for (String className : this.classNames) {
            try {
                this.readClassDef(className, annotationVisitor);
            }
            catch (NotFoundException e) {
            }
            catch (FoundException e) {
                return true;
            }
        }
        return false;
    }

    private static Collection<URL> getUrls(ClassLoader classLoader, boolean excludeParent) throws IOException {
        return AnnotationFinder.getUrls(classLoader, excludeParent ? classLoader.getParent() : null);
    }

    private static Collection<URL> getUrls(ClassLoader classLoader, ClassLoader excludeParent) throws IOException {
        UrlSet urlSet = new UrlSet(classLoader);
        if (excludeParent != null) {
            urlSet = urlSet.exclude(excludeParent);
        }
        return urlSet.getUrls();
    }

    private List<String> file(URL location) {
        ArrayList<String> classNames = new ArrayList<String>();
        File dir = new File(URLDecoder.decode(location.getPath()));
        if (dir.getName().equals("META-INF")) {
            dir = dir.getParentFile();
        }
        if (dir.isDirectory()) {
            this.scanDir(dir, classNames, "");
        }
        return classNames;
    }

    private void scanDir(File dir, List<String> classNames, String packageName) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.scanDir(file, classNames, packageName + file.getName() + ".");
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String name = file.getName();
            if ((name = name.replaceFirst(".class$", "")).contains(".")) continue;
            classNames.add(packageName + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> jar(URL location) throws IOException {
        URL url;
        String jarPath = location.getFile();
        if (jarPath.indexOf("!") > -1) {
            jarPath = jarPath.substring(0, jarPath.indexOf("!"));
        }
        if ("file".equals((url = new URL(jarPath)).getProtocol())) {
            JarFile jarFile = new JarFile(url.getFile().replace("%20", " "));
            return this.jar(jarFile);
        }
        InputStream in = url.openStream();
        in = new BufferedInputStream(in);
        try {
            JarInputStream jarStream = new JarInputStream(in);
            List<String> list = this.jar(jarStream);
            return list;
        }
        finally {
            in.close();
        }
    }

    private List<String> jar(JarFile jarFile) {
        ArrayList<String> classNames = new ArrayList<String>();
        Enumeration<JarEntry> jarEntries = jarFile.entries();
        while (jarEntries.hasMoreElements()) {
            JarEntry entry = jarEntries.nextElement();
            this.addClassName(classNames, entry);
        }
        return classNames;
    }

    private List<String> jar(JarInputStream jarStream) throws IOException {
        JarEntry entry;
        ArrayList<String> classNames = new ArrayList<String>();
        while ((entry = jarStream.getNextJarEntry()) != null) {
            this.addClassName(classNames, entry);
        }
        return classNames;
    }

    private void addClassName(List<String> classNames, JarEntry entry) {
        if (entry.isDirectory() || !entry.getName().endsWith(".class")) {
            return;
        }
        String className = entry.getName();
        if ((className = className.replaceFirst(".class$", "")).contains(".")) {
            return;
        }
        className = className.replace(File.separatorChar, '.');
        classNames.add(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readClassDef(String className, ClassVisitor visitor) {
        block7: {
            ++classes;
            if (!className.endsWith(".class")) {
                className = className.replace('.', '/') + ".class";
            }
            try {
                URL resource = this.classLoader.getResource(className);
                if (resource != null) {
                    InputStream in = resource.openStream();
                    in = new BufferedInputStream(in);
                    try {
                        ClassReader classReader = new ClassReader(in);
                        classReader.accept(visitor, 7);
                        break block7;
                    }
                    finally {
                        in.close();
                    }
                }
                new Exception("Could not load " + className).printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class Visitor
    implements ClassVisitor {
        private NotFoundException notFoundException;
        private FoundException foundException;
        private final Filter filter;

        public Visitor(Filter filter) {
            this.filter = filter;
            try {
                throw new NotFoundException();
            }
            catch (NotFoundException e) {
                this.notFoundException = e;
                try {
                    throw new FoundException();
                }
                catch (FoundException e2) {
                    this.foundException = e2;
                    return;
                }
            }
        }

        public AnnotationVisitor visitAnnotation(String name, boolean visible) {
            StringBuilder sb = new StringBuilder(name);
            sb.deleteCharAt(0);
            sb.deleteCharAt(sb.length() - 1);
            for (int i = 0; i < sb.length(); ++i) {
                if (sb.charAt(i) != '/') continue;
                sb.setCharAt(i, '.');
            }
            name = sb.toString();
            if (this.filter.accept(name)) {
                throw this.foundException;
            }
            return null;
        }

        public void visit(int i, int i1, String string, String string1, String string2, String[] strings) {
        }

        public void visitSource(String string, String string1) {
        }

        public void visitOuterClass(String string, String string1, String string2) {
        }

        public void visitAttribute(Attribute attribute) {
            throw this.notFoundException;
        }

        public void visitInnerClass(String string, String string1, String string2, int i) {
            throw this.notFoundException;
        }

        public FieldVisitor visitField(int i, String string, String string1, String string2, Object object) {
            throw this.notFoundException;
        }

        public MethodVisitor visitMethod(int i, String string, String string1, String string2, String[] strings) {
            throw this.notFoundException;
        }

        public void visitEnd() {
            throw this.notFoundException;
        }
    }

    public static class FoundException
    extends RuntimeException {
    }

    public static class NotFoundException
    extends RuntimeException {
    }

    public static interface Filter {
        public boolean accept(String var1);
    }
}

