/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.logging.ConsoleHandler;
import java.util.logging.LogManager;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.JuliLogStream;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.LogStream;
import org.apache.openejb.util.LogStreamFactory;
import org.apache.openejb.util.SingleLineFormatter;

public class JuliLogStreamFactory
implements LogStreamFactory {
    @Override
    public LogStream createLogStream(LogCategory logCategory) {
        return new JuliLogStream(logCategory);
    }

    private static boolean is(String classname) {
        try {
            JuliLogStreamFactory.class.getClassLoader().loadClass(classname);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        boolean tomee = JuliLogStreamFactory.is("org.apache.tomee.catalina.TomcatLoader");
        boolean embedded = JuliLogStreamFactory.is("org.apache.tomee.embedded.Container");
        if ((!tomee || embedded) && System.getProperty("java.util.logging.manager") == null) {
            System.setProperty("java.util.logging.manager", OpenEJBLogManager.class.getName());
        }
        try {
            if (SystemInstance.get().getOptions().get("openjpa.Log", (String)null) == null) {
                JuliLogStreamFactory.class.getClassLoader().loadClass("org.apache.openjpa.lib.log.LogFactoryAdapter");
                System.setProperty("openjpa.Log", "org.apache.openejb.openjpa.JULOpenJPALogFactory");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class OpenEJBSimpleLayoutHandler
    extends ConsoleHandler {
        public OpenEJBSimpleLayoutHandler() {
            this.setFormatter(new SingleLineFormatter());
        }
    }

    public static class OpenEJBLogManager
    extends LogManager {
        @Override
        public String getProperty(String name) {
            String parentValue = super.getProperty(name);
            if (SystemInstance.get().getProperties().containsKey(name)) {
                return SystemInstance.get().getProperty(name);
            }
            String propertyKeyValue = "logging" + OpenEJBLogManager.reverseProperty(name);
            if (SystemInstance.get().getProperties().containsKey(propertyKeyValue)) {
                return SystemInstance.get().getProperty(propertyKeyValue);
            }
            if (OpenEJBLogManager.class.getName().equals(System.getProperty("java.util.logging.manager")) && OpenEJBLogManager.isOverridableLogger(name) && parentValue == null) {
                if (name.endsWith(".handlers")) {
                    return OpenEJBSimpleLayoutHandler.class.getName();
                }
                if (name.endsWith(".useParentHandlers")) {
                    return "false";
                }
            }
            return parentValue;
        }

        private static String reverseProperty(String name) {
            if (name.contains(".") && !name.endsWith(".")) {
                int idx = name.lastIndexOf(46);
                return name.substring(idx) + "." + name.substring(0, idx);
            }
            return name;
        }

        private static boolean isOverridableLogger(String name) {
            return name.toLowerCase().contains("openejb") || name.toLowerCase().contains("transaction") || name.toLowerCase().contains("cxf") || name.toLowerCase().contains("timer") || name.startsWith("org.apache.") || name.startsWith("net.sf.ehcache.") || name.startsWith("org.quartz.") || name.startsWith("org.hibernate.");
        }
    }
}

