/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.net.URI;
import java.net.URL;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.OpenEjbVersion;

public class UpdateChecker
implements Runnable {
    private static final String SKIP_CHECK = "openejb.version.check";
    private static final String REPO_URL = SystemInstance.get().getOptions().get("openejb.version.check.repo.url", "http://repo1.maven.org/maven2/org/apache/openejb/");
    private static final String URL = SystemInstance.get().getOptions().get("openejb.version.check.url", REPO_URL + "openejb/maven-metadata.xml");
    private static final String TAG = "latest";
    private static final String UNDEFINED = "undefined";
    private static String LATEST = "undefined";

    @Override
    public void run() {
        if (UpdateChecker.isSkipped()) {
            return;
        }
        try {
            URL url = new URL(URL);
            String metaData = IO.readFileAsString((URI)url.toURI());
            LATEST = UpdateChecker.extractLatest(metaData);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String extractLatest(String metaData) {
        if (metaData != null) {
            boolean found = false;
            for (String s : metaData.replace(">", ">\n").split("\n")) {
                if (found) {
                    return UpdateChecker.trim(s).replace("</latest>", "");
                }
                if (s.isEmpty() || !UpdateChecker.trim(s).endsWith("<latest>")) continue;
                found = true;
            }
        }
        return UNDEFINED;
    }

    private static String trim(String s) {
        return s.replace("\t", "").replace(" ", "");
    }

    public static boolean usesLatest() {
        return OpenEjbVersion.get().getVersion().equals(LATEST);
    }

    public static String message() {
        if (UpdateChecker.isSkipped()) {
            return "version checking is skipped";
        }
        if (UNDEFINED.equals(LATEST)) {
            return "can't determine the latest version";
        }
        String version = OpenEjbVersion.get().getVersion();
        if (version.equals(LATEST)) {
            return "running on the latest version";
        }
        return "you are using the version " + version + ", our latest stable version " + LATEST + " is available on " + REPO_URL;
    }

    public static boolean isSkipped() {
        return System.getProperty(SKIP_CHECK) == null;
    }

    public static void main(String[] args) {
        UpdateChecker checker = new UpdateChecker();
        checker.run();
        System.out.println(UpdateChecker.message());
    }
}

