/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.Injection;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.util.proxy.InvocationHandler;
import org.apache.openejb.util.proxy.ProxyManager;
import org.apache.openejb.util.proxy.QueryProxy;
import org.apache.xbean.finder.MetaAnnotatedClass;

public class DynamicProxyImplFactory {
    public static boolean isKnownDynamicallyImplemented(Class<?> clazz) {
        MetaAnnotatedClass metaClass = new MetaAnnotatedClass(clazz);
        return clazz.isInterface() && (metaClass.getAnnotation(PersistenceContext.class) != null || metaClass.getAnnotation(org.apache.openejb.api.Proxy.class) != null);
    }

    public static Object newProxy(BeanContext context, java.lang.reflect.InvocationHandler invocationHandler) {
        if (invocationHandler instanceof QueryProxy) {
            EntityManager em = null;
            for (Injection injection : context.getInjections()) {
                if (!QueryProxy.class.equals((Object)injection.getTarget())) continue;
                try {
                    em = (EntityManager)context.getJndiEnc().lookup(injection.getJndiName());
                }
                catch (NamingException e) {
                    throw new OpenEJBRuntimeException("a dynamic bean should reference at least one correct PersistenceContext", e);
                }
            }
            if (em == null) {
                throw new OpenEJBRuntimeException("can't find the entity manager to use for the dynamic bean " + context.getEjbName());
            }
            ((QueryProxy)invocationHandler).setEntityManager(em);
        }
        try {
            return ProxyManager.newProxyInstance(context.getBeanClass(), (InvocationHandler)new Handler(invocationHandler));
        }
        catch (IllegalAccessException e) {
            throw new OpenEJBRuntimeException("illegal access", e);
        }
    }

    public static Object realHandler(Object proxy) {
        java.lang.reflect.InvocationHandler handler;
        if (proxy != null && Proxy.isProxyClass(proxy.getClass()) && (handler = Proxy.getInvocationHandler(proxy)) instanceof Handler) {
            return ((Handler)handler).realHandler();
        }
        return null;
    }

    private static class Handler
    implements InvocationHandler {
        private java.lang.reflect.InvocationHandler handler;

        private Handler(java.lang.reflect.InvocationHandler handler) {
            this.handler = handler;
        }

        @Override
        public InvocationHandler getInvocationHandler() {
            return this;
        }

        public java.lang.reflect.InvocationHandler realHandler() {
            return this.handler;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return this.handler.invoke(proxy, method, args);
        }
    }
}

