/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.enterprise.inject.Alternative;
import javax.validation.ValidationException;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.AdditionalDeployments;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

@Stateless(name="openejb/Deployer")
@Remote(value={Deployer.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
@Alternative
public class DeployerEjb
implements Deployer {
    public static final String OPENEJB_DEPLOYER_FORCED_APP_ID_PROP = "openejb.deployer.forced.appId";
    public static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, DeployerEjb.class);
    private static final File uniqueFile;
    private final DeploymentLoader deploymentLoader = new DeploymentLoader();
    private final ConfigurationFactory configurationFactory = new ConfigurationFactory();
    private final Assembler assembler = (Assembler)SystemInstance.get().getComponent(org.apache.openejb.spi.Assembler.class);

    @Override
    public String getUniqueFile() {
        return uniqueFile.getAbsolutePath();
    }

    @Override
    public Collection<AppInfo> getDeployedApps() {
        return this.assembler.getDeployedApplications();
    }

    @Override
    public AppInfo deploy(String location) throws OpenEJBException {
        return this.deploy(location, null);
    }

    @Override
    public AppInfo deploy(Properties properties) throws OpenEJBException {
        return this.deploy(null, properties);
    }

    @Override
    public AppInfo deploy(String inLocation, Properties properties) throws OpenEJBException {
        String rawLocation = inLocation;
        if (rawLocation == null && properties == null) {
            throw new NullPointerException("location and properties are null");
        }
        if (rawLocation == null) {
            rawLocation = properties.getProperty("filename");
        }
        if (properties == null) {
            properties = new Properties();
        }
        AppModule appModule = null;
        File file = new File(ProvisioningUtil.realLocation((String)rawLocation));
        try {
            appModule = this.deploymentLoader.load(file);
            TreeMap<String, Module> modules = new TreeMap<String, Module>();
            for (EjbModule ejbModule : appModule.getEjbModules()) {
                modules.put(ejbModule.getModuleId(), ejbModule);
            }
            for (ClientModule clientModule : appModule.getClientModules()) {
                modules.put(clientModule.getModuleId(), clientModule);
            }
            for (WebModule webModule : appModule.getWebModules()) {
                String contextRoot = properties.getProperty("webapp." + webModule.getJarLocation() + ".context-root");
                if (contextRoot != null) {
                    webModule.setContextRoot(contextRoot);
                }
                modules.put(webModule.getModuleId(), webModule);
            }
            for (ConnectorModule connectorModule : appModule.getConnectorModules()) {
                modules.put(connectorModule.getModuleId(), connectorModule);
            }
            for (Map.Entry entry : properties.entrySet()) {
                DeploymentModule module;
                String name = (String)entry.getKey();
                if (!name.startsWith("altDD/")) continue;
                int slash = (name = name.substring("altDD".length() + 1)).indexOf(47);
                if (slash > 0) {
                    String moduleId = name.substring(0, slash);
                    name = name.substring(slash + 1);
                    module = (DeploymentModule)modules.get(moduleId);
                } else {
                    module = appModule;
                }
                if (module == null) continue;
                String value = (String)entry.getValue();
                File dd = new File(value);
                if (dd.canRead()) {
                    module.getAltDDs().put(name, dd.toURI().toURL());
                    continue;
                }
                module.getAltDDs().put(name, value);
            }
            AppInfo appInfo = this.configurationFactory.configureApplication(appModule);
            appInfo.autoDeploy = Boolean.parseBoolean(properties.getProperty("openejb.app.autodeploy", "false"));
            if (properties != null && properties.containsKey(OPENEJB_DEPLOYER_FORCED_APP_ID_PROP)) {
                appInfo.appId = properties.getProperty(OPENEJB_DEPLOYER_FORCED_APP_ID_PROP);
            }
            this.assembler.createApplication(appInfo);
            this.saveDeployment(file, true);
            return appInfo;
        }
        catch (Throwable e) {
            if (appModule != null) {
                ClassLoaderUtil.destroyClassLoader(appModule.getJarLocation());
            }
            e.printStackTrace();
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            if (e instanceof OpenEJBException) {
                if (e.getCause() instanceof ValidationException) {
                    throw (ValidationException)e.getCause();
                }
                throw (OpenEJBException)e;
            }
            throw new OpenEJBException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveDeployment(File file, boolean add) {
        File config;
        Deployments deps = new Deployments();
        if (file.isDirectory()) {
            deps.setDir(file.getAbsolutePath());
        } else {
            deps.setJar(file.getAbsolutePath());
        }
        try {
            config = SystemInstance.get().getBase().getFile("conf/deployments.xml", false);
        }
        catch (IOException e) {
            config = null;
        }
        if (config == null || !config.getParentFile().exists()) {
            LOGGER.info("can't save the added app because the conf folder doesn't exist, it will not be present next time you'll start");
            return;
        }
        OutputStream os = null;
        try {
            AdditionalDeployments additionalDeployments;
            block20: {
                block19: {
                    if (config.exists() && config.length() > 0L) {
                        InputStream fis = IO.read((File)config);
                        try {
                            additionalDeployments = JaxbOpenejb.unmarshal(AdditionalDeployments.class, fis);
                        }
                        finally {
                            IO.close((Closeable)fis);
                        }
                    } else {
                        additionalDeployments = new AdditionalDeployments();
                    }
                    if (!add) break block19;
                    if (additionalDeployments.getDeployments().contains(deps)) break block20;
                    additionalDeployments.getDeployments().add(deps);
                    break block20;
                }
                Iterator<Deployments> it = additionalDeployments.getDeployments().iterator();
                while (it.hasNext()) {
                    Deployments current = it.next();
                    if (deps.getDir() != null && deps.getDir().equals(current.getDir())) {
                        it.remove();
                        break;
                    }
                    if (deps.getJar() != null && deps.getJar().equals(current.getJar())) {
                        it.remove();
                        break;
                    }
                    String jar = deps.getJar();
                    if (jar == null || jar.length() <= 3 || !jar.substring(0, jar.length() - 4).equals(deps.getDir())) continue;
                    it.remove();
                    break;
                }
            }
            os = IO.write((File)config);
            JaxbOpenejb.marshal(AdditionalDeployments.class, additionalDeployments, os);
            IO.close((Closeable)os);
        }
        catch (Exception e) {
            LOGGER.error("can't save the added app, will not be present next time you'll start", e);
        }
        finally {
            IO.close(os);
        }
    }

    @Override
    public void undeploy(String moduleId) throws UndeployException, NoSuchApplicationException {
        try {
            this.assembler.destroyApplication(moduleId);
        }
        catch (NoSuchApplicationException nsae) {
            try {
                this.assembler.destroyApplication(ProvisioningUtil.realLocation((String)moduleId));
            }
            catch (Exception e) {
                try {
                    this.assembler.destroyApplication(new File(moduleId).getAbsolutePath());
                }
                catch (Exception e2) {
                    try {
                        this.assembler.destroyApplication(new File(ProvisioningUtil.realLocation((String)moduleId)).getAbsolutePath());
                    }
                    catch (Exception e3) {
                        throw nsae;
                    }
                }
            }
        }
        this.saveDeployment(new File(moduleId), false);
    }

    static {
        String uniqueName = "OpenEJB-" + new BigInteger(128, new SecureRandom()).toString(36);
        String tempDir = System.getProperty("java.io.tmpdir");
        File unique = null;
        try {
            unique = new File(tempDir, uniqueName).getCanonicalFile();
            unique.createNewFile();
        }
        catch (IOException e) {
            unique = new File(SystemInstance.get().getHome().getDirectory(), "work");
            if (unique.exists()) {
                try {
                    unique = new File(unique, uniqueName).getCanonicalFile();
                    unique.createNewFile();
                }
                catch (IOException e1) {
                    throw new OpenEJBRuntimeException(e);
                }
            }
            throw new OpenEJBRuntimeException("can't create unique file, please set java.io.tmpdir to a writable folder or create work folder", e);
        }
        uniqueFile = unique;
        uniqueFile.deleteOnExit();
    }
}

