/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.interceptor.Interceptor;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.BeansInfo;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.cdi.StartupObject;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.classloader.ClassLoaderComparator;
import org.apache.openejb.util.classloader.DefaultClassLoaderComparator;
import org.apache.webbeans.annotation.AnnotationManager;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.AnnotationUtil;

public class CdiScanner
implements ScannerService {
    public static final String OPENEJB_CDI_FILTER_CLASSLOADER = "openejb.cdi.filter.classloader";
    private final Set<Class<?>> classes = new HashSet();

    public Set<String> getAllAnnotations(String className) {
        return Collections.emptySet();
    }

    public void init(Object object) {
        if (!(object instanceof StartupObject)) {
            return;
        }
        StartupObject startupObject = (StartupObject)object;
        AppInfo appInfo = startupObject.getAppInfo();
        ClassLoader classLoader = startupObject.getClassLoader();
        ClassLoaderComparator comparator = classLoader instanceof ClassLoaderComparator ? (ClassLoaderComparator)((Object)classLoader) : new DefaultClassLoaderComparator(classLoader);
        WebBeansContext webBeansContext = startupObject.getAppContext().getWebBeansContext();
        AlternativesManager alternativesManager = webBeansContext.getAlternativesManager();
        DecoratorsManager decoratorsManager = webBeansContext.getDecoratorsManager();
        InterceptorsManager interceptorsManager = webBeansContext.getInterceptorsManager();
        HashSet<String> ejbClasses = new HashSet<String>();
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                ejbClasses.add(bean.ejbClass);
            }
        }
        AnnotationManager annotationManager = webBeansContext.getAnnotationManager();
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            Class clazz;
            BeansInfo beans = ejbJar.beans;
            if (beans == null) continue;
            StringBuilder errors = new StringBuilder("You can't define multiple times the same class in beans.xml: ");
            if (this.addErrors(errors, "alternative classes", beans.duplicatedAlternativeClasses) || this.addErrors(errors, "alternative stereotypes", beans.duplicatedAlternativeStereotypes) || this.addErrors(errors, "decorators", beans.duplicatedDecorators) || this.addErrors(errors, "interceptors", beans.duplicatedInterceptors)) {
                throw new WebBeansConfigurationException(errors.toString());
            }
            beans.duplicatedAlternativeStereotypes.clear();
            beans.duplicatedAlternativeClasses.clear();
            beans.duplicatedDecorators.clear();
            beans.duplicatedInterceptors.clear();
            for (String className : beans.interceptors) {
                clazz = this.load(className, classLoader);
                if (clazz != null) {
                    if (AnnotationUtil.hasAnnotation((Annotation[])clazz.getDeclaredAnnotations(), Interceptor.class) && !annotationManager.hasInterceptorBindingMetaAnnotation(clazz.getDeclaredAnnotations())) {
                        throw new WebBeansConfigurationException("Interceptor class : " + clazz.getName() + " must have at least one @InterceptorBindingType");
                    }
                    if (interceptorsManager.isInterceptorEnabled(clazz)) continue;
                    interceptorsManager.addNewInterceptor(clazz);
                    this.classes.add(clazz);
                    continue;
                }
                throw new WebBeansConfigurationException("Could not load interceptor class: " + className);
            }
            for (String className : beans.decorators) {
                clazz = this.load(className, classLoader);
                if (clazz != null) {
                    if (decoratorsManager.isDecoratorEnabled(clazz)) continue;
                    decoratorsManager.addNewDecorator(clazz);
                    this.classes.add(clazz);
                    continue;
                }
                throw new WebBeansConfigurationException("Could not load decorator class: " + className);
            }
            for (String className : beans.alternativeStereotypes) {
                clazz = this.load(className, classLoader);
                if (clazz != null) {
                    alternativesManager.addStereoTypeAlternative(clazz, null, null);
                    this.classes.add(clazz);
                    continue;
                }
                throw new WebBeansConfigurationException("Could not load alternativeStereotype class: " + className);
            }
            for (String className : beans.alternativeClasses) {
                clazz = this.load(className, classLoader);
                if (clazz != null) {
                    alternativesManager.addClazzAlternative(clazz, null, null);
                    this.classes.add(clazz);
                    continue;
                }
                throw new WebBeansConfigurationException("Could not load alternative class: " + className);
            }
            ClassLoader scl = ClassLoader.getSystemClassLoader();
            boolean filterByClassLoader = "true".equals(SystemInstance.get().getProperty(OPENEJB_CDI_FILTER_CLASSLOADER, "true"));
            for (String className : beans.managedClasses) {
                Class clazz2;
                if (ejbClasses.contains(className) || (clazz2 = this.load(className, classLoader)) == null) continue;
                ClassLoader cl = clazz2.getClassLoader();
                if (filterByClassLoader && !comparator.isSame(cl) && (!cl.equals(scl) || startupObject.getWebContext() != null)) continue;
                this.classes.add(clazz2);
            }
        }
    }

    private boolean addErrors(StringBuilder errors, String msg, List<String> list) {
        if (!list.isEmpty()) {
            errors.append("[ ").append(msg).append(" --> ");
            for (String s : list) {
                errors.append(s).append(" ");
            }
            errors.append("]");
            return true;
        }
        return false;
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return false;
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return null;
    }

    private Class load(String className, ClassLoader classLoader) {
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoClassDefFoundError e) {
            return null;
        }
    }

    public void scan() {
    }

    public Set<URL> getBeanXmls() {
        return Collections.emptySet();
    }

    public Set<Class<?>> getBeanClasses() {
        return this.classes;
    }

    public void release() {
        this.classes.clear();
    }
}

