/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.el.ELResolver;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.cdi.BeansDeployer;
import org.apache.openejb.cdi.CdiEjbBean;
import org.apache.openejb.cdi.CdiInterceptor;
import org.apache.openejb.cdi.CdiPlugin;
import org.apache.openejb.cdi.CdiResourceInjectionService;
import org.apache.openejb.cdi.CdiScanner;
import org.apache.openejb.cdi.CurrentCreationalContext;
import org.apache.openejb.cdi.NewCdiEjbBean;
import org.apache.openejb.cdi.StartupObject;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.component.InjectionPointBean;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.ejb.common.component.EjbBeanCreatorImpl;
import org.apache.webbeans.ejb.common.util.EjbUtility;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.portable.events.ExtensionLoader;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.portable.events.generics.GProcessAnnotatedType;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public class OpenEJBLifecycle
implements ContainerLifecycle {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_CDI, OpenEJBLifecycle.class);
    public static final String OPENEJB_CDI_SKIP_CLASS_NOT_FOUND = "openejb.cdi.skip-class-not-found";
    protected ScannerService scannerService;
    protected final ContextsService contextsService;
    private final boolean skipClassNotFoundError;
    private final BeansDeployer deployer;
    private final WebBeansXMLConfigurator xmlDeployer;
    private final JNDIService jndiService;
    private final BeanManagerImpl beanManager;
    private final WebBeansContext webBeansContext;
    private ScheduledExecutorService service = null;

    public OpenEJBLifecycle() {
        this(WebBeansContext.currentInstance());
    }

    public OpenEJBLifecycle(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.beforeInitApplication(null);
        this.beanManager = webBeansContext.getBeanManagerImpl();
        this.xmlDeployer = new WebBeansXMLConfigurator();
        this.deployer = new BeansDeployer(this.xmlDeployer, webBeansContext);
        this.jndiService = (JNDIService)webBeansContext.getService(JNDIService.class);
        this.beanManager.setXMLConfigurator(this.xmlDeployer);
        this.scannerService = webBeansContext.getScannerService();
        this.contextsService = webBeansContext.getContextsService();
        this.skipClassNotFoundError = SystemInstance.get().getOptions().get(OPENEJB_CDI_SKIP_CLASS_NOT_FOUND, false);
        this.initApplication(null);
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startApplication(Object startupObject) {
        if (startupObject instanceof ServletContextEvent) {
            this.startServletContext((ServletContext)this.getServletContext(startupObject));
            return;
        }
        if (!(startupObject instanceof StartupObject)) {
            logger.debug("startupObject is not of StartupObject type; ignored");
            return;
        }
        StartupObject stuff = (StartupObject)startupObject;
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        logger.info("OpenWebBeans Container is starting...");
        long begin = System.currentTimeMillis();
        try {
            Thread.currentThread().setContextClassLoader(stuff.getClassLoader());
            this.beforeStartApplication(startupObject);
            this.webBeansContext.getPluginLoader().startUp();
            CdiPlugin cdiPlugin = (CdiPlugin)this.webBeansContext.getPluginLoader().getEjbPlugin();
            AppContext appContext = stuff.getAppContext();
            if (stuff.getWebContext() == null) {
                appContext.setWebBeansContext(this.webBeansContext);
            }
            cdiPlugin.setClassLoader(stuff.getClassLoader());
            cdiPlugin.setWebBeansContext(this.webBeansContext);
            cdiPlugin.startup();
            cdiPlugin.configureDeployments(stuff.getBeanContexts());
            CdiResourceInjectionService injectionService = (CdiResourceInjectionService)this.webBeansContext.getService(ResourceInjectionService.class);
            injectionService.setAppContext(stuff.getAppContext());
            try {
                CdiEjbBean bean;
                boolean deployEjb;
                this.loadExtensions(appContext);
                this.contextsService.init(startupObject);
                this.deployer.configureDefaultBeans();
                this.deployer.fireBeforeBeanDiscoveryEvent();
                logger.debug("Scanning classpaths for beans artifacts.");
                if (this.scannerService instanceof CdiScanner) {
                    CdiScanner service = (CdiScanner)this.scannerService;
                    service.init(startupObject);
                } else {
                    new CdiScanner().init(startupObject);
                }
                this.scannerService.scan();
                this.deployer.deployFromXML(this.scannerService);
                this.deployer.checkStereoTypes(this.scannerService);
                this.deployManagedBeans(this.scannerService.getBeanClasses(), stuff.getBeanContexts());
                boolean bl = deployEjb = stuff.getWebContext() == null;
                if (deployEjb) {
                    for (BeanContext beanContext : stuff.getBeanContexts()) {
                        if (!beanContext.getComponentType().isCdiCompatible()) continue;
                        Class<Object> implClass = beanContext.getManagedClass();
                        AnnotatedType annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(implClass);
                        GProcessAnnotatedType processAnnotatedEvent = this.webBeansContext.getWebBeansUtil().fireProcessAnnotatedTypeEvent(annotatedType);
                        if (processAnnotatedEvent.isVeto()) continue;
                        CdiEjbBean<Object> bean2 = new CdiEjbBean<Object>(beanContext, this.webBeansContext);
                        beanContext.set(CdiEjbBean.class, bean2);
                        beanContext.set(CurrentCreationalContext.class, new CurrentCreationalContext());
                        beanContext.addSystemInterceptor(new CdiInterceptor(bean2, this.beanManager, cdiPlugin.getContexsServices()));
                        EjbUtility.fireEvents(implClass, bean2, (ProcessAnnotatedType)processAnnotatedEvent);
                        this.webBeansContext.getWebBeansUtil().setInjectionTargetBeanEnableFlag(bean2);
                        Class clazz = beanContext.getBeanClass();
                        while (clazz.isAnnotationPresent(Specializes.class) && (clazz = clazz.getSuperclass()) != null && !Object.class.equals(clazz)) {
                            CdiEjbBean superBean = new CdiEjbBean(beanContext, this.webBeansContext, clazz);
                            EjbBeanCreatorImpl ejbBeanCreator = new EjbBeanCreatorImpl(superBean);
                            ejbBeanCreator.defineSerializable();
                            ejbBeanCreator.defineStereoTypes();
                            ejbBeanCreator.defineScopeType("Session Bean implementation class : " + clazz.getName() + " stereotypes must declare same @ScopeType annotations", false);
                            ejbBeanCreator.defineQualifier();
                            ejbBeanCreator.defineName(WebBeansUtil.getManagedBeanDefaultName((String)clazz.getSimpleName()));
                            bean2.specialize(superBean);
                            EjbUtility.defineSpecializedData(clazz, bean2);
                        }
                    }
                }
                this.deployer.checkSpecializations(this.scannerService);
                this.deployer.fireAfterBeanDiscoveryEvent();
                this.deployer.validateInjectionPoints();
                if (deployEjb) {
                    for (BeanContext beanContext : stuff.getBeanContexts()) {
                        if (!beanContext.getComponentType().isSession() || beanContext.isDynamicallyImplemented()) continue;
                        bean = beanContext.get(CdiEjbBean.class);
                        List datas = bean.getInterceptorStack();
                        ArrayList<org.apache.openejb.core.interceptor.InterceptorData> converted = new ArrayList<org.apache.openejb.core.interceptor.InterceptorData>();
                        for (InterceptorData data : datas) {
                            org.apache.openejb.core.interceptor.InterceptorData openejbData = org.apache.openejb.core.interceptor.InterceptorData.scan(data.getInterceptorClass());
                            if (data.isDefinedInMethod()) {
                                Method method = data.getInterceptorBindingMethod();
                                beanContext.addCdiMethodInterceptor(method, openejbData);
                                continue;
                            }
                            converted.add(openejbData);
                        }
                        beanContext.setCdiInterceptors(converted);
                    }
                }
                this.deployer.fireAfterDeploymentValidationEvent();
                if (deployEjb) {
                    for (BeanContext beanContext : stuff.getBeanContexts()) {
                        bean = beanContext.get(CdiEjbBean.class);
                        if (bean == null) continue;
                        BeanManagerImpl manager = this.webBeansContext.getBeanManagerImpl();
                        manager.addBean(new NewCdiEjbBean(bean));
                    }
                }
            }
            catch (Exception e1) {
                Assembler.logger.error("CDI Beans module deployment failed", e1);
                throw new OpenEJBRuntimeException(e1);
            }
            this.afterStartApplication(startupObject);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
        logger.info("OpenWebBeans Container has started, it took {0} ms.", Long.toString(System.currentTimeMillis() - begin));
    }

    private void loadExtensions(AppContext appContext) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        ExtensionLoader extensionLoader = this.webBeansContext.getExtensionLoader();
        extensionLoader.loadExtensionServices(appContext.getClassLoader());
    }

    private void deployManagedBeans(Set<Class<?>> beanClasses, List<BeanContext> ejbs) {
        HashSet managedBeans = new HashSet(beanClasses);
        for (BeanContext beanContext : ejbs) {
            if (!beanContext.getComponentType().isSession()) continue;
            managedBeans.remove(beanContext.getBeanClass());
        }
        LinkedHashMap<Class, AnnotatedType> annotatedTypes = new LinkedHashMap<Class, AnnotatedType>();
        for (Class clazz : managedBeans) {
            AnnotatedType at = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(clazz);
            if (at != null) {
                annotatedTypes.put(clazz, at);
                continue;
            }
            logger.warning("an error occured create AnnotatedType for class " + clazz.getName() + ". Skipping.");
        }
        for (Map.Entry entry : annotatedTypes.entrySet()) {
            GProcessAnnotatedType processAnnotatedEvent;
            try {
                processAnnotatedEvent = this.webBeansContext.getWebBeansUtil().fireProcessAnnotatedTypeEvent((AnnotatedType)entry.getValue());
            }
            catch (RuntimeException cnfe) {
                if (this.skipClassNotFoundError && OpenEJBLifecycle.rootCauseIsClassNotFound(cnfe)) {
                    logger.error("an error occured firing ProcessAnnotatedEvent for class " + ((AnnotatedType)entry.getValue()).getJavaClass().getName() + ". Skipping the bean.");
                    logger.debug("Skipping bean cause", cnfe);
                    continue;
                }
                throw cnfe;
            }
            if (processAnnotatedEvent.isVeto()) continue;
            this.deployer.defineManagedBean((Class)entry.getKey(), processAnnotatedEvent);
        }
        annotatedTypes.clear();
    }

    private static boolean rootCauseIsClassNotFound(RuntimeException re) {
        Throwable e;
        e.getStackTrace();
        for (e = re; e != null; e = e.getCause()) {
            if (!(e instanceof ClassNotFoundException)) continue;
            return true;
        }
        return false;
    }

    public void stopApplication(Object endObject) {
        logger.debug("OpenWebBeans Container is stopping.");
        try {
            this.beforeStopApplication(null);
            this.beanManager.fireEvent((Object)new BeforeShutdownImpl(), BeansDeployer.EMPTY_ANNOTATION_ARRAY);
            this.contextsService.destroy(null);
            if (this.jndiService != null) {
                this.jndiService.unbind("java:comp/BeanManager");
            }
            this.webBeansContext.getPluginLoader().shutDown();
            this.webBeansContext.getExtensionLoader().clear();
            this.beanManager.getInjectionResolver().clearCaches();
            this.webBeansContext.getProxyFactory().clear();
            this.webBeansContext.getAnnotatedElementFactory().clear();
            this.afterStopApplication(null);
            this.beanManager.clear();
            WebBeansFinder.clearInstances((Object)WebBeansUtil.getCurrentClassLoader());
        }
        catch (Exception e) {
            logger.error("An error occured while stopping the container.", e);
        }
    }

    protected ScannerService getScannerService() {
        return this.scannerService;
    }

    public ContextsService getContextService() {
        return this.contextsService;
    }

    protected BeansDeployer getDeployer() {
        return this.deployer;
    }

    protected WebBeansXMLConfigurator getXmlDeployer() {
        return this.xmlDeployer;
    }

    protected JNDIService getJndiService() {
        return this.jndiService;
    }

    public void initApplication(Properties properties) {
        this.afterInitApplication(properties);
    }

    protected void beforeInitApplication(Properties properties) {
    }

    protected void afterInitApplication(Properties properties) {
    }

    protected void afterStartApplication(Object startupObject) {
    }

    public void startServletContext(ServletContext servletContext) {
        this.service = OpenEJBLifecycle.initializeServletContext(servletContext, this.webBeansContext);
    }

    public static ScheduledExecutorService initializeServletContext(final ServletContext servletContext, WebBeansContext context) {
        String strDelay = context.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.conversation.Conversation.periodicDelay", "150000");
        long delay = Long.parseLong(strDelay);
        ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runable) {
                Thread t = new Thread(runable, "OwbConversationCleaner-" + servletContext.getContextPath());
                t.setDaemon(true);
                return t;
            }
        });
        executorService.scheduleWithFixedDelay(new ConversationCleaner(context), delay, delay, TimeUnit.MILLISECONDS);
        ELAdaptor elAdaptor = (ELAdaptor)context.getService(ELAdaptor.class);
        ELResolver resolver = elAdaptor.getOwbELResolver();
        if (context.getOpenWebBeansConfiguration().isJspApplication()) {
            logger.debug("Application is configured as JSP. Adding EL Resolver.");
            JspFactory factory = JspFactory.getDefaultFactory();
            if (factory != null) {
                JspApplicationContext applicationCtx = factory.getJspApplicationContext(servletContext);
                applicationCtx.addELResolver(resolver);
            } else {
                logger.debug("Default JspFactory instance was not found");
            }
        }
        servletContext.setAttribute(BeanManager.class.getName(), (Object)context.getBeanManagerImpl());
        return executorService;
    }

    protected void afterStopApplication(Object stopObject) throws Exception {
        ResourceInjectionService injectionServices = (ResourceInjectionService)this.webBeansContext.getService(ResourceInjectionService.class);
        if (injectionServices != null) {
            injectionServices.clear();
        }
        this.cleanupShutdownThreadLocals();
        WebBeansFinder.clearInstances((Object)WebBeansUtil.getCurrentClassLoader());
    }

    private void cleanupShutdownThreadLocals() {
        InjectionPointBean.removeThreadLocal();
    }

    private Object getServletContext(Object object) {
        if (object instanceof ServletContextEvent) {
            object = ((ServletContextEvent)object).getServletContext();
            return object;
        }
        return object;
    }

    protected void beforeStartApplication(Object startupObject) {
    }

    protected void beforeStopApplication(Object stopObject) throws Exception {
        if (this.service != null) {
            this.service.shutdownNow();
        }
    }

    private static class ConversationCleaner
    implements Runnable {
        private final WebBeansContext webBeansContext;

        private ConversationCleaner(WebBeansContext webBeansContext) {
            this.webBeansContext = webBeansContext;
        }

        @Override
        public void run() {
            this.webBeansContext.getConversationManager().destroyWithRespectToTimout();
        }
    }

    public static class NewEjbBean<T>
    extends CdiEjbBean<T>
    implements NewBean<T> {
        public NewEjbBean(BeanContext beanContext, WebBeansContext webBeansContext) {
            super(beanContext, webBeansContext);
        }
    }
}

