/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.jee.NamedModule;
import org.apache.openejb.loader.SystemInstance;

public interface DeploymentModule {
    public static final String OPENEJB_MODULENAME_USE_HASH = "openejb.modulename.useHash";

    public String getModuleId();

    public URI getModuleUri();

    public ClassLoader getClassLoader();

    public String getJarLocation();

    public File getFile();

    public Map<String, Object> getAltDDs();

    public ValidationContext getValidation();

    public Set<String> getWatchedResources();

    public boolean isStandaloneModule();

    public void setStandaloneModule(boolean var1);

    public Properties getProperties();

    public static class ID {
        private final String name;
        private final File location;
        private final URI uri;
        private boolean overriden = false;

        public ID(NamedModule vendorDd, NamedModule specDd, String name, File location, URI uri, DeploymentModule module) {
            this.name = this.name(vendorDd, specDd, uri, location, name, module);
            this.location = this.location(location, uri);
            this.uri = this.uri(uri, location, this.name);
        }

        private URI uri(URI uri, File location, String name) {
            if (uri != null) {
                return uri;
            }
            if (location != null) {
                return location.toURI();
            }
            return URI.create(name);
        }

        private File location(File location, URI uri) {
            if (location != null) {
                return location;
            }
            if (uri != null && uri.isAbsolute()) {
                return new File(uri);
            }
            return null;
        }

        private String name(NamedModule vendor, NamedModule spec, URI uri, File location, String name, DeploymentModule module) {
            String systPropName;
            if (location != null && (systPropName = SystemInstance.get().getOptions().get(location.getName() + ".moduleId", (String)null)) != null) {
                this.overriden = true;
                return systPropName;
            }
            if (spec != null && spec.getModuleName() != null) {
                return spec.getModuleName().trim();
            }
            if (name != null && !name.startsWith("@")) {
                return name;
            }
            if (vendor != null && vendor.getModuleName() != null) {
                return vendor.getModuleName().trim();
            }
            if (vendor != null && vendor.getId() != null) {
                return vendor.getId().trim();
            }
            if (spec != null && spec.getId() != null) {
                return spec.getId().trim();
            }
            if (uri != null) {
                return this.stripExtension(uri.getPath());
            }
            if (location != null && SystemInstance.get().getOptions().get(DeploymentModule.OPENEJB_MODULENAME_USE_HASH, false)) {
                return this.moduleName(location) + module.hashCode();
            }
            if (location != null) {
                return this.moduleName(location);
            }
            if (name != null) {
                return name;
            }
            return "@" + module.getClass().getSimpleName() + module.hashCode();
        }

        public boolean isOverriden() {
            return this.overriden;
        }

        private String moduleName(File location) {
            ArrayList<String> invalid = new ArrayList<String>();
            invalid.add("classes");
            invalid.add("test-classes");
            invalid.add("target");
            invalid.add("build");
            invalid.add("dist");
            invalid.add("bin");
            while (invalid.contains(location.getName())) {
                location = location.getParentFile();
            }
            return this.stripExtension(location.getName());
        }

        private String stripExtension(String name) {
            String[] exts;
            for (String ext : exts = new String[]{".jar", ".zip", ".ear", ".war", ".rar", ".unpacked"}) {
                if (!name.endsWith(ext)) continue;
                return name.substring(0, name.length() - ext.length());
            }
            return name;
        }

        public String getName() {
            if (this.name.startsWith("@")) {
                return this.name.substring(1);
            }
            return this.name;
        }

        public File getLocation() {
            return this.location;
        }

        public URI getUri() {
            return this.uri;
        }
    }
}

