/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.sys;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.apache.openejb.config.sys.AbstractService;
import org.apache.openejb.config.sys.ConnectionManager;
import org.apache.openejb.config.sys.Connector;
import org.apache.openejb.config.sys.Container;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.config.sys.JndiProvider;
import org.apache.openejb.config.sys.Openejb;
import org.apache.openejb.config.sys.ProxyFactory;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.config.sys.SecurityService;
import org.apache.openejb.config.sys.StackHandler;
import org.apache.openejb.config.sys.TransactionManager;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Saxs;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class SaxOpenejb
extends StackHandler {
    public static final String HOME_VAR = "$home";
    private final Openejb openejb = new Openejb();

    SaxOpenejb() {
    }

    public static Openejb parse(InputSource source) throws SAXException, ParserConfigurationException, IOException {
        SAXParser parser = Saxs.factory().newSAXParser();
        SaxOpenejb sax = new SaxOpenejb();
        parser.parse(source, (DefaultHandler)sax);
        return sax.openejb;
    }

    @Override
    public void startDocument() throws SAXException {
        this.push(new Document());
    }

    private class ImportElement
    extends DefaultHandler {
        private String path = null;

        private ImportElement() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.path = attributes.getValue("path");
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.path != null) {
                InputStream is;
                this.updatePath();
                try {
                    URL url = new URL(this.path);
                    is = url.openStream();
                }
                catch (MalformedURLException e) {
                    File file = new File(this.path);
                    try {
                        is = new FileInputStream(file);
                    }
                    catch (FileNotFoundException e1) {
                        throw new SAXException("specified path '" + this.path + "' is neither an url nor a file path", e);
                    }
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
                try {
                    Openejb importedOpenEJB = SaxOpenejb.parse(new InputSource(is));
                    this.merge(SaxOpenejb.this.openejb, importedOpenEJB);
                }
                catch (ParserConfigurationException e) {
                    throw new SAXException(e);
                }
                catch (IOException e) {
                    throw new SAXException(e);
                }
            }
        }

        private void updatePath() {
            if (this.path != null && this.path.startsWith(SaxOpenejb.HOME_VAR)) {
                this.path = SystemInstance.get().getHome().getDirectory().getAbsolutePath() + this.path.substring(SaxOpenejb.HOME_VAR.length());
            }
        }

        private void merge(Openejb openejb, Openejb importedOpenEJB) {
            if (importedOpenEJB.container != null) {
                for (Container container : importedOpenEJB.container) {
                    openejb.add(container);
                }
            }
            if (importedOpenEJB.jndiProvider != null) {
                for (JndiProvider jndiProvider : importedOpenEJB.jndiProvider) {
                    openejb.add(jndiProvider);
                }
            }
            if (importedOpenEJB.securityService != null || importedOpenEJB.transactionManager != null || importedOpenEJB.connectionManager != null || importedOpenEJB.proxyFactory != null) {
                // empty if block
            }
            if (importedOpenEJB.connector != null) {
                for (Connector connector : importedOpenEJB.connector) {
                    openejb.add(connector);
                }
            }
            if (importedOpenEJB.resource != null) {
                for (Resource resource : importedOpenEJB.resource) {
                    openejb.add(resource);
                }
            }
            if (importedOpenEJB.deployments != null) {
                for (Deployments deployment : importedOpenEJB.deployments) {
                    openejb.add(deployment);
                }
            }
        }
    }

    public class JndiProviderElement
    extends StackHandler.ServiceElement<JndiProvider> {
        public JndiProviderElement() {
            super((StackHandler)SaxOpenejb.this, (AbstractService)new JndiProvider());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.getJndiProvider().add((JndiProvider)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    public class TransactionManagerElement
    extends StackHandler.ServiceElement<TransactionManager> {
        public TransactionManagerElement() {
            super((StackHandler)SaxOpenejb.this, (AbstractService)new TransactionManager());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.setTransactionManager((TransactionManager)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    public class ProxyFactoryElement
    extends StackHandler.ServiceElement<ProxyFactory> {
        public ProxyFactoryElement() {
            super((StackHandler)SaxOpenejb.this, (AbstractService)new ProxyFactory());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.setProxyFactory((ProxyFactory)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    public class ConnectionManagerElement
    extends StackHandler.ServiceElement<ConnectionManager> {
        public ConnectionManagerElement() {
            super((StackHandler)SaxOpenejb.this, (AbstractService)new ConnectionManager());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.setConnectionManager((ConnectionManager)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    public class SecurityServiceElement
    extends StackHandler.ServiceElement<SecurityService> {
        public SecurityServiceElement() {
            super((StackHandler)SaxOpenejb.this, (AbstractService)new SecurityService());
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.setSecurityService((SecurityService)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    public class ContainerElement
    extends StackHandler.ServiceElement<Container> {
        public ContainerElement() {
            super((StackHandler)SaxOpenejb.this, (AbstractService)new Container());
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            super.startElement(uri, localName, qName, attributes);
            String ctype = attributes.getValue("ctype");
            if (ctype != null) {
                ((Container)this.service).setType(ctype);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            SaxOpenejb.this.openejb.getContainer().add((Container)this.service);
            super.endElement(uri, localName, qName);
        }
    }

    private class DeploymentsElement
    extends DefaultHandler {
        private final Deployments deployments = new Deployments();

        private DeploymentsElement() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.deployments.setDir(attributes.getValue("dir"));
            this.deployments.setJar(attributes.getValue("jar"));
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            SaxOpenejb.this.openejb.getDeployments().add(this.deployments);
        }
    }

    private class Document
    extends DefaultHandler {
        private Document() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("openejb")) {
                SaxOpenejb.this.push(new Root());
            } else if (localName.equals("tomee")) {
                SaxOpenejb.this.push(new Root());
            } else {
                throw new IllegalStateException("Unsupported Element: " + localName);
            }
        }
    }

    private class Root
    extends DefaultHandler {
        private Root() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (localName.equals("Container")) {
                SaxOpenejb.this.push(new ContainerElement());
            } else if (localName.equals("JndiProvider")) {
                SaxOpenejb.this.push(new JndiProviderElement());
            } else if (localName.equals("SecurityService")) {
                SaxOpenejb.this.push(new SecurityServiceElement());
            } else if (localName.equals("TransactionManager")) {
                SaxOpenejb.this.push(new TransactionManagerElement());
            } else if (localName.equals("ConnectionManager")) {
                SaxOpenejb.this.push(new ConnectionManagerElement());
            } else if (localName.equals("ProxyFactory")) {
                SaxOpenejb.this.push(new ProxyFactoryElement());
            } else if (localName.equals("Resource")) {
                SaxOpenejb.this.push(new StackHandler.ResourceElement(SaxOpenejb.this.openejb.getResource()));
            } else if (localName.equals("Connector")) {
                SaxOpenejb.this.push(new StackHandler.ResourceElement(SaxOpenejb.this.openejb.getResource()));
            } else if (localName.equals("Deployments")) {
                SaxOpenejb.this.push(new DeploymentsElement());
            } else if (localName.equals("Import")) {
                SaxOpenejb.this.push(new ImportElement());
            } else if (localName.equals("Service")) {
                SaxOpenejb.this.push(new StackHandler.DeclaredServiceElement(SaxOpenejb.this.openejb.getServices()));
            } else {
                throw new IllegalStateException("Unsupported Element: " + localName);
            }
            SaxOpenejb.this.get().startElement(uri, localName, qName, attributes);
        }
    }
}

