/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.AccessLocalException;
import javax.ejb.EJBAccessException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.Handle;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.InvalidateReferenceException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.core.entity.EntityEjbHomeHandler;
import org.apache.openejb.core.ivm.BaseEjbProxyHandler;
import org.apache.openejb.core.ivm.EjbObjectProxyHandler;
import org.apache.openejb.core.ivm.IntraVmArtifact;
import org.apache.openejb.core.ivm.IntraVmCopyMonitor;
import org.apache.openejb.core.ivm.IntraVmHandle;
import org.apache.openejb.core.ivm.IntraVmMetaData;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.core.managed.ManagedHomeHandler;
import org.apache.openejb.core.singleton.SingletonEjbHomeHandler;
import org.apache.openejb.core.stateful.StatefulEjbHomeHandler;
import org.apache.openejb.core.stateless.StatelessEjbHomeHandler;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.proxy.LocalBeanProxyFactory;
import org.apache.openejb.util.proxy.ProxyManager;

public abstract class EjbHomeProxyHandler
extends BaseEjbProxyHandler {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private final Map<String, MethodType> dispatchTable = new HashMap<String, MethodType>();

    public EjbHomeProxyHandler(BeanContext beanContext, InterfaceType interfaceType, List<Class> interfaces, Class mainInterface) {
        super(beanContext, null, interfaceType, interfaces, mainInterface);
        this.dispatchTable.put("create", MethodType.CREATE);
        this.dispatchTable.put("getEJBMetaData", MethodType.META_DATA);
        this.dispatchTable.put("getHomeHandle", MethodType.HOME_HANDLE);
        this.dispatchTable.put("remove", MethodType.REMOVE);
        if (interfaceType.isHome()) {
            Method[] methods;
            Class homeInterface = beanContext.getInterface(interfaceType);
            for (Method method : methods = homeInterface.getMethods()) {
                if (method.getName().startsWith("create")) {
                    this.dispatchTable.put(method.getName(), MethodType.CREATE);
                    continue;
                }
                if (!method.getName().startsWith("find")) continue;
                this.dispatchTable.put(method.getName(), MethodType.FIND);
            }
        }
    }

    @Override
    public void invalidateReference() {
        throw new IllegalStateException("A home reference must never be invalidated!");
    }

    protected static EjbHomeProxyHandler createHomeHandler(BeanContext beanContext, InterfaceType interfaceType, List<Class> interfaces, Class mainInterface) {
        switch (beanContext.getComponentType()) {
            case STATEFUL: {
                return new StatefulEjbHomeHandler(beanContext, interfaceType, interfaces, mainInterface);
            }
            case STATELESS: {
                return new StatelessEjbHomeHandler(beanContext, interfaceType, interfaces, mainInterface);
            }
            case SINGLETON: {
                return new SingletonEjbHomeHandler(beanContext, interfaceType, interfaces, mainInterface);
            }
            case MANAGED: {
                return new ManagedHomeHandler(beanContext, interfaceType, interfaces, mainInterface);
            }
            case CMP_ENTITY: 
            case BMP_ENTITY: {
                return new EntityEjbHomeHandler(beanContext, interfaceType, interfaces, mainInterface);
            }
        }
        throw new IllegalStateException("Component type does not support rpc interfaces: " + (Object)((Object)beanContext.getComponentType()));
    }

    public static Object createHomeProxy(BeanContext beanContext, InterfaceType interfaceType) {
        return EjbHomeProxyHandler.createHomeProxy(beanContext, interfaceType, null, interfaceType.isRemote() ? beanContext.getRemoteInterface() : beanContext.getLocalInterface());
    }

    public static Object createHomeProxy(BeanContext beanContext, InterfaceType interfaceType, List<Class> objectInterfaces, Class mainInterface) {
        if (!interfaceType.isHome()) {
            throw new IllegalArgumentException("InterfaceType is not a Home type: " + (Object)((Object)interfaceType));
        }
        try {
            EjbHomeProxyHandler handler = EjbHomeProxyHandler.createHomeHandler(beanContext, interfaceType, objectInterfaces, mainInterface);
            ArrayList<Class<IntraVmProxy>> proxyInterfaces = new ArrayList<Class<IntraVmProxy>>(2);
            Class homeInterface = beanContext.getInterface(interfaceType);
            proxyInterfaces.add(homeInterface);
            proxyInterfaces.add(IntraVmProxy.class);
            return ProxyManager.newProxyInstance(proxyInterfaces.toArray(new Class[0]), (InvocationHandler)handler);
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException("Can't create EJBHome stub" + e.getMessage(), e);
        }
    }

    public Object createProxy(Object primaryKey, Class mainInterface) {
        try {
            InterfaceType objectInterfaceType = this.interfaceType.getCounterpart();
            BeanType type = this.getBeanContext().getComponentType();
            EjbObjectProxyHandler handler = this.newEjbObjectHandler(this.getBeanContext(), primaryKey, objectInterfaceType, this.getInterfaces(), mainInterface);
            if ((InterfaceType.LOCALBEAN.equals((Object)objectInterfaceType) || this.getBeanContext().getComponentType().equals((Object)BeanType.MANAGED)) && !this.getBeanContext().isDynamicallyImplemented()) {
                return LocalBeanProxyFactory.newProxyInstance(handler.getBeanContext().getClassLoader(), handler, handler.getBeanContext().getBeanClass(), IntraVmProxy.class, Serializable.class);
            }
            ArrayList<Class> proxyInterfaces = new ArrayList<Class>(handler.getInterfaces().size() + 1);
            proxyInterfaces.addAll(handler.getInterfaces());
            proxyInterfaces.add(IntraVmProxy.class);
            if (BeanType.STATEFUL.equals((Object)type) || BeanType.MANAGED.equals((Object)type)) {
                proxyInterfaces.add(BeanContext.Removable.class);
            }
            return ProxyManager.newProxyInstance(proxyInterfaces.toArray(new Class[0]), (InvocationHandler)handler);
        }
        catch (IllegalAccessException iae) {
            throw new OpenEJBRuntimeException("Could not create IVM proxy for " + this.getInterfaces().get(0), iae);
        }
    }

    protected abstract EjbObjectProxyHandler newEjbObjectHandler(BeanContext var1, Object var2, InterfaceType var3, List<Class> var4, Class var5);

    @Override
    protected Object _invoke(Object proxy, Class interfce, Method method, Object[] args) throws Throwable {
        if (logger.isDebugEnabled()) {
            logger.debug("invoking method " + method.getName() + " on " + this.deploymentID);
        }
        String methodName = method.getName();
        try {
            Object retValue;
            MethodType operation = this.dispatchTable.get(methodName);
            if (operation == null) {
                retValue = this.homeMethod(interfce, method, args, proxy);
            } else {
                switch (operation) {
                    case CREATE: {
                        retValue = this.create(interfce, method, args, proxy);
                        break;
                    }
                    case FIND: {
                        retValue = this.findX(interfce, method, args, proxy);
                        break;
                    }
                    case META_DATA: {
                        retValue = this.getEJBMetaData(method, args, proxy);
                        break;
                    }
                    case HOME_HANDLE: {
                        retValue = this.getHomeHandle(method, args, proxy);
                        break;
                    }
                    case REMOVE: {
                        Class<?> type = method.getParameterTypes()[0];
                        if (Handle.class.isAssignableFrom(type)) {
                            retValue = this.removeWithHandle(interfce, method, args, proxy);
                            break;
                        }
                        retValue = this.removeByPrimaryKey(interfce, method, args, proxy);
                        break;
                    }
                    default: {
                        throw new OpenEJBRuntimeException("Inconsistent internal state: value " + (Object)((Object)operation) + " for operation " + methodName);
                    }
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("finished invoking method " + method.getName() + ". Return value:" + retValue);
            }
            return retValue;
        }
        catch (RemoteException re) {
            if (this.interfaceType.isLocal()) {
                throw new EJBException(re.getMessage()).initCause(re.detail);
            }
            throw re;
        }
        catch (InvalidateReferenceException ire) {
            Throwable cause = ire.getRootCause();
            if (cause instanceof RemoteException && this.interfaceType.isLocal()) {
                RemoteException re = (RemoteException)cause;
                Throwable detail = re.detail != null ? re.detail : re;
                cause = new EJBException(re.getMessage()).initCause(detail);
            }
            throw cause;
        }
        catch (ApplicationException ae) {
            Throwable exc;
            Throwable throwable = exc = ae.getRootCause() != null ? ae.getRootCause() : ae;
            if (exc instanceof EJBAccessException) {
                if (this.interfaceType.isBusiness()) {
                    throw exc;
                }
                if (this.interfaceType.isLocal()) {
                    throw (AccessLocalException)new AccessLocalException(exc.getMessage()).initCause(exc);
                }
                try {
                    throw new AccessException(exc.getMessage()).initCause(exc);
                }
                catch (IllegalStateException vmbug) {
                    throw new AccessException(exc.getMessage(), (Exception)exc);
                }
            }
            throw exc;
        }
        catch (SystemException se) {
            if (this.interfaceType.isLocal()) {
                throw new EJBException("Container has suffered a SystemException").initCause(se.getRootCause());
            }
            throw new RemoteException("Container has suffered a SystemException", se.getRootCause());
        }
        catch (OpenEJBException oe) {
            if (this.interfaceType.isLocal()) {
                throw new EJBException("Unknown Container Exception").initCause(oe.getRootCause());
            }
            throw new RemoteException("Unknown Container Exception", oe.getRootCause());
        }
        catch (Throwable t) {
            logger.debug("finished invoking method " + method.getName() + " with exception:" + t, t);
            throw t;
        }
    }

    protected Object homeMethod(Class interfce, Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        return this.container.invoke(this.deploymentID, this.interfaceType, interfce, method, args, null);
    }

    protected Object create(Class interfce, Method method, Object[] args, Object proxy) throws Throwable {
        ProxyInfo proxyInfo = (ProxyInfo)this.container.invoke(this.deploymentID, this.interfaceType, interfce, method, args, null);
        assert (proxyInfo != null) : "Container returned a null ProxyInfo: ContainerID=" + this.container.getContainerID();
        return this.createProxy(proxyInfo.getPrimaryKey(), this.getMainInterface());
    }

    protected abstract Object findX(Class var1, Method var2, Object[] var3, Object var4) throws Throwable;

    protected Object getEJBMetaData(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        IntraVmMetaData metaData = new IntraVmMetaData(this.getBeanContext().getHomeInterface(), this.getBeanContext().getRemoteInterface(), this.getBeanContext().getPrimaryKeyClass(), this.getBeanContext().getComponentType());
        metaData.setEJBHome((EJBHome)proxy);
        return metaData;
    }

    protected Object getHomeHandle(Method method, Object[] args, Object proxy) throws Throwable {
        this.checkAuthorization(method);
        return new IntraVmHandle(proxy);
    }

    @Override
    public ProxyInfo getProxyInfo() {
        if (this.getMainInterface() == null) {
            throw new IllegalStateException("no main interface");
        }
        return new ProxyInfo(this.getBeanContext(), null, this.getBeanContext().getInterfaces(this.interfaceType), this.interfaceType, this.getMainInterface());
    }

    @Override
    protected Object _writeReplace(Object proxy) throws ObjectStreamException {
        if (IntraVmCopyMonitor.isIntraVmCopyOperation()) {
            return new IntraVmArtifact(proxy);
        }
        if (IntraVmCopyMonitor.isStatefulPassivationOperation()) {
            return proxy;
        }
        if (IntraVmCopyMonitor.isCrossClassLoaderOperation()) {
            return proxy;
        }
        ApplicationServer applicationServer = ServerFederation.getApplicationServer();
        return applicationServer.getEJBHome(this.getProxyInfo());
    }

    protected Object removeWithHandle(Class interfce, Method method, Object[] args, Object proxy) throws Throwable {
        EjbObjectProxyHandler stub;
        IntraVmHandle handle = (IntraVmHandle)args[0];
        Object primKey = handle.getPrimaryKey();
        try {
            stub = (EjbObjectProxyHandler)ProxyManager.getInvocationHandler(handle.getEJBObject());
        }
        catch (IllegalArgumentException e) {
            stub = null;
        }
        this.container.invoke(this.deploymentID, this.interfaceType, interfce, method, args, primKey);
        if (stub != null) {
            this.invalidateAllHandlers(stub.getRegistryId());
        }
        return null;
    }

    protected abstract Object removeByPrimaryKey(Class var1, Method var2, Object[] var3, Object var4) throws Throwable;

    private static enum MethodType {
        CREATE,
        FIND,
        HOME_HANDLE,
        META_DATA,
        REMOVE;

    }
}

