/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security.jaas;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.security.Principal;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.openejb.core.security.jaas.GroupPrincipal;
import org.apache.openejb.core.security.jaas.UserPrincipal;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class ScriptLoginModule
implements LoginModule {
    private static Logger log = Logger.getInstance(LogCategory.OPENEJB_SECURITY, "org.apache.openejb.util.resources");
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map<String, ?> options;
    public Set<Principal> principals = new LinkedHashSet<Principal>();
    private UserData userData;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.options = options;
        this.subject = subject;
        this.callbackHandler = callbackHandler;
    }

    private UserData getUserData() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false)};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.getMessage());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException(uce.getMessage() + " not available to obtain information from user");
        }
        String user = ((NameCallback)callbacks[0]).getName();
        char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        String password = new String(tmpPassword);
        return new UserData(user, password);
    }

    @Override
    public boolean login() throws LoginException {
        List myGroups;
        String scriptText;
        String scriptURI = (String)this.options.get("scriptURI");
        if ((scriptURI == null || "".equals(scriptURI.trim())) && ((scriptURI = System.getProperty("openejb.ScriptLoginModule.scriptURI")) == null || "".equals(scriptURI.trim()))) {
            throw new LoginException("No login script defined");
        }
        URI uri = URI.create(scriptURI);
        try {
            scriptText = new Scanner(new File(uri)).useDelimiter("\\Z").next();
        }
        catch (FileNotFoundException e) {
            throw new LoginException("Invalid login script URI. Value: " + scriptURI);
        }
        this.userData = this.getUserData();
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName((String)this.options.get("engineName"));
        SimpleScriptContext newContext = new SimpleScriptContext();
        Bindings bindings = newContext.getBindings(100);
        bindings.put("user", (Object)this.userData.user);
        bindings.put("password", (Object)this.userData.pass);
        try {
            myGroups = (List)engine.eval(scriptText, (ScriptContext)newContext);
        }
        catch (ScriptException e) {
            throw new LoginException("Cannot execute login script. Msg: " + e.getMessage());
        }
        this.userData.groups.addAll(myGroups);
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.principals.add(new UserPrincipal(this.userData.user));
        for (String myGroup : this.userData.groups) {
            this.principals.add(new GroupPrincipal(myGroup));
        }
        this.subject.getPrincipals().addAll(this.principals);
        this.clear();
        log.debug("commit");
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        this.clear();
        log.debug("abort");
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().removeAll(this.principals);
        this.principals.clear();
        log.debug("logout");
        return true;
    }

    private void clear() {
        this.userData = null;
    }

    private class UserData {
        public final String user;
        public final String pass;
        public final Set<String> groups = new HashSet<String>();

        private UserData(String user, String pass) {
            this.user = user;
            this.pass = pass;
        }
    }
}

