/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateful;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.core.stateful.Cache;
import org.apache.openejb.core.stateful.PassivationStrategy;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class SimpleCache<K, V>
implements Cache<K, V> {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private final ConcurrentHashMap<K, Entry> cache = new ConcurrentHashMap();
    private final Queue<Entry> lru = new LinkedBlockingQueue<Entry>();
    private Cache.CacheListener<V> listener;
    private PassivationStrategy passivator;
    private int capacity;
    private int bulkPassivate;
    private long timeOut = -1L;
    private ScheduledExecutorService executor;
    private long frequency = 60000L;
    private ScheduledFuture future;

    public SimpleCache() {
    }

    public SimpleCache(Cache.CacheListener<V> listener, PassivationStrategy passivator, int capacity, int bulkPassivate, Duration timeOut) {
        this.listener = listener;
        this.passivator = passivator;
        this.capacity = capacity;
        this.bulkPassivate = bulkPassivate;
        this.timeOut = timeOut.getTime(TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void init() {
        if (this.frequency > 0L && this.future == null) {
            this.initScheduledExecutorService();
            this.future = this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    SimpleCache.this.processLRU();
                }
            }, this.frequency, this.frequency, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public synchronized void destroy() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    private synchronized void initScheduledExecutorService() {
        if (this.executor == null) {
            this.executor = Executors.newScheduledThreadPool(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runable) {
                    Thread t = new Thread(runable, "Stateful cache");
                    t.setDaemon(true);
                    return t;
                }
            });
        }
    }

    @Override
    public synchronized Cache.CacheListener<V> getListener() {
        return this.listener;
    }

    @Override
    public synchronized void setListener(Cache.CacheListener<V> listener) {
        this.listener = listener;
    }

    public synchronized PassivationStrategy getPassivator() {
        return this.passivator;
    }

    public synchronized void setPassivator(PassivationStrategy passivator) {
        this.passivator = passivator;
    }

    public synchronized void setPassivator(Class<? extends PassivationStrategy> passivatorClass) throws Exception {
        this.passivator = passivatorClass.newInstance();
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    public synchronized void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public synchronized void setPoolSize(int capacity) {
        this.capacity = capacity;
    }

    public synchronized int getBulkPassivate() {
        return this.bulkPassivate;
    }

    public synchronized void setBulkPassivate(int bulkPassivate) {
        this.bulkPassivate = bulkPassivate;
    }

    public synchronized long getTimeOut() {
        return this.timeOut;
    }

    private static long ms(String durationValue, TimeUnit defaultTU) {
        Duration duration = new Duration(durationValue.trim());
        if (duration.getUnit() == null) {
            duration.setUnit(defaultTU);
        }
        return duration.getUnit().toMillis(duration.getTime());
    }

    public synchronized void setTimeOut(String timeOut) {
        this.timeOut = SimpleCache.ms(timeOut, TimeUnit.MINUTES);
    }

    public void setScheduledExecutorService(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.executor;
    }

    public void setFrequency(String frequency) {
        this.frequency = SimpleCache.ms(frequency, TimeUnit.SECONDS);
    }

    public long getFrequency() {
        return this.frequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(K key, V value) {
        Entry entry = this.cache.get(key);
        if (entry != null) {
            entry.lock.lock();
            try {
                if (entry.getState() != EntryState.REMOVED) {
                    throw new IllegalStateException("An entry for the key " + key + " already exists");
                }
                this.cache.remove(key);
                this.lru.remove(entry);
            }
            finally {
                entry.lock.unlock();
            }
        }
        entry = new Entry(key, value, EntryState.CHECKED_OUT);
        this.cache.put(key, entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public V checkOut(K key) throws Exception {
        int i = 0;
        while (true) {
            block14: {
                if (i >= 10) {
                    Entry entry = this.cache.remove(key);
                    if (entry == null) throw new OpenEJBRuntimeException("Cache is corrupted: the entry " + key + " in the Map 'cache' is in state PASSIVATED");
                    this.lru.remove(entry);
                    throw new OpenEJBRuntimeException("Cache is corrupted: the entry " + key + " in the Map 'cache' is in state PASSIVATED");
                }
                Entry entry = this.cache.get(key);
                if (entry == null && (entry = this.loadEntry(key)) == null) {
                    return null;
                }
                entry.lock.lock();
                try {
                    switch (entry.getState()) {
                        case AVAILABLE: {
                            break;
                        }
                        case CHECKED_OUT: {
                            throw new IllegalStateException("The entry " + key + " is already checked-out");
                        }
                        case PASSIVATED: {
                            this.cache.remove(key, entry);
                            break block14;
                        }
                        case REMOVED: {
                            V v = null;
                            return v;
                        }
                    }
                    entry.setState(EntryState.CHECKED_OUT);
                    this.lru.remove(entry);
                    Object object = entry.getValue();
                    return (V)object;
                }
                finally {
                    entry.lock.unlock();
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkIn(K key) {
        Entry entry = this.cache.get(key);
        if (entry == null) {
            return;
        }
        entry.lock.lock();
        try {
            switch (entry.getState()) {
                case AVAILABLE: {
                    if (this.lru.contains(entry)) {
                        entry.resetTimeOut();
                        return;
                    }
                    throw new IllegalStateException("The entry " + key + " is not checked-out");
                }
                case PASSIVATED: {
                    throw new IllegalStateException("The entry " + key + " is not checked-out");
                }
                case REMOVED: {
                    return;
                }
            }
            entry.setState(EntryState.AVAILABLE);
            this.lru.add(entry);
            entry.resetTimeOut();
        }
        finally {
            entry.lock.unlock();
        }
        if (this.frequency == 0L) {
            this.processLRU();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        Entry entry = this.cache.get(key);
        if (entry == null) {
            return null;
        }
        entry.lock.lock();
        try {
            this.cache.remove(key);
            this.lru.remove(entry);
            entry.setState(EntryState.REMOVED);
            Object object = entry.getValue();
            return (V)object;
        }
        finally {
            entry.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Cache.CacheFilter<V> filter) {
        Iterator<Entry> iterator = this.cache.values().iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            entry.lock.lock();
            try {
                if (!filter.matches(entry.getValue())) continue;
                iterator.remove();
                this.lru.remove(entry);
                entry.setState(EntryState.REMOVED);
            }
            finally {
                entry.lock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processLRU() {
        Entry entry;
        Cache.CacheListener<Object> listener = this.getListener();
        Iterator iterator = this.lru.iterator();
        block31: while (iterator.hasNext()) {
            Entry entry2 = (Entry)iterator.next();
            entry2.lock.lock();
            try {
                switch (entry2.getState()) {
                    case AVAILABLE: {
                        break;
                    }
                    case CHECKED_OUT: {
                        continue block31;
                    }
                    case PASSIVATED: {
                        iterator.remove();
                        continue block31;
                    }
                    case REMOVED: {
                        iterator.remove();
                        continue block31;
                    }
                }
                if (!entry2.isTimedOut()) continue;
                iterator.remove();
                this.cache.remove(entry2.getKey());
                entry2.setState(EntryState.REMOVED);
                if (listener == null) continue;
                try {
                    listener.timedOut(entry2.getValue());
                }
                catch (Exception e) {
                    logger.error("An unexpected exception occured from timedOut callback", e);
                }
            }
            finally {
                entry2.lock.unlock();
            }
        }
        if (this.lru.size() < this.getCapacity()) return;
        LinkedHashMap<Object, Object> valuesToStore = new LinkedHashMap<Object, Object>();
        ArrayList<Entry> entries = new ArrayList<Entry>();
        int bulkPassivate = this.getBulkPassivate();
        if (bulkPassivate < 1) {
            bulkPassivate = 1;
        }
        block32: for (int i = 0; i < bulkPassivate && (entry = this.lru.poll()) != null; ++i) {
            if (!entry.lock.tryLock()) continue;
            try {
                switch (entry.getState()) {
                    case AVAILABLE: {
                        break;
                    }
                    case CHECKED_OUT: {
                        continue block32;
                    }
                    case PASSIVATED: {
                        this.lru.remove(entry);
                        continue block32;
                    }
                    case REMOVED: {
                        this.lru.remove(entry);
                        continue block32;
                    }
                }
                this.cache.remove(entry.getKey());
                this.lru.remove(entry);
                if (entry.isTimedOut()) {
                    entry.setState(EntryState.REMOVED);
                    if (listener == null) continue;
                    try {
                        listener.timedOut(entry.getValue());
                    }
                    catch (Exception e) {
                        logger.error("An unexpected exception occured from timedOut callback", e);
                    }
                    continue;
                }
                entry.lock.lock();
                entries.add(entry);
                entry.setState(EntryState.PASSIVATED);
                valuesToStore.put(entry.getKey(), entry.getValue());
                continue;
            }
            finally {
                entry.lock.unlock();
            }
        }
        if (valuesToStore.isEmpty()) return;
        try {
            this.storeEntries(valuesToStore);
            return;
        }
        finally {
            Iterator i$ = entries.iterator();
            while (true) {
                if (!i$.hasNext()) {
                }
                entry = (Entry)i$.next();
                entry.lock.unlock();
            }
        }
    }

    private Entry loadEntry(K key) throws Exception {
        PassivationStrategy passivator = this.getPassivator();
        if (passivator == null) {
            return null;
        }
        Object value = null;
        try {
            value = passivator.activate(key);
        }
        catch (Exception e) {
            logger.error("An unexpected exception occured while reading entries from disk", e);
        }
        if (value == null) {
            return null;
        }
        Cache.CacheListener<Object> listener = this.getListener();
        if (listener != null) {
            listener.afterLoad(value);
        }
        Entry entry = new Entry(key, value, EntryState.AVAILABLE);
        this.cache.put(key, entry);
        return entry;
    }

    private void storeEntries(Map<K, V> entriesToStore) {
        Cache.CacheListener<V> listener = this.getListener();
        Iterator<Map.Entry<K, V>> iterator = entriesToStore.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            if (listener == null) continue;
            try {
                listener.beforeStore(entry.getValue());
            }
            catch (Exception e) {
                iterator.remove();
                logger.error("An unexpected exception occured from beforeStore callback", e);
            }
        }
        PassivationStrategy passivator = this.getPassivator();
        if (passivator == null) {
            return;
        }
        try {
            passivator.passivate(entriesToStore);
        }
        catch (Exception e) {
            logger.error("An unexpected exception occured while writting the entries to disk", e);
        }
    }

    private class Entry {
        private final K key;
        private final V value;
        private final ReentrantLock lock = new ReentrantLock();
        private EntryState state;
        private long lastAccess;
        private long timeOut;

        private Entry(K key, V value, EntryState state) {
            Duration duration;
            this.key = key;
            this.value = value;
            this.state = state;
            this.timeOut = value instanceof Cache.TimeOut ? ((duration = ((Cache.TimeOut)value).getTimeOut()) != null ? duration.getTime(TimeUnit.MILLISECONDS) : SimpleCache.this.getTimeOut()) : SimpleCache.this.getTimeOut();
            this.lastAccess = System.currentTimeMillis();
        }

        private K getKey() {
            this.assertLockHeld();
            return this.key;
        }

        private V getValue() {
            this.assertLockHeld();
            return this.value;
        }

        private EntryState getState() {
            this.assertLockHeld();
            return this.state;
        }

        private void setState(EntryState state) {
            this.assertLockHeld();
            this.state = state;
        }

        private boolean isTimedOut() {
            this.assertLockHeld();
            if (this.timeOut < 0L) {
                return false;
            }
            if (this.timeOut == 0L) {
                return true;
            }
            long now = System.currentTimeMillis();
            return now - this.lastAccess > this.timeOut;
        }

        private void resetTimeOut() {
            this.assertLockHeld();
            if (this.timeOut > 0L) {
                this.lastAccess = System.currentTimeMillis();
            }
        }

        private void assertLockHeld() {
            if (!this.lock.isHeldByCurrentThread()) {
                throw new IllegalStateException("Entry must be locked");
            }
        }
    }

    private static enum EntryState {
        AVAILABLE,
        CHECKED_OUT,
        PASSIVATED,
        REMOVED;

    }
}

