/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.naming.InitContextFactory;
import org.apache.openejb.injection.FallbackPropertyInjector;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.NamedModule;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.junit.AppResource;
import org.apache.openejb.junit.Configuration;
import org.apache.openejb.junit.MockInjector;
import org.apache.openejb.junit.Module;
import org.apache.openejb.junit.TestInstance;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.ServiceManagerProxy;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.junit.rules.MethodRule;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class ApplicationComposer
extends BlockJUnit4ClassRunner {
    public static final String OPENEJB_APPLICATION_COMPOSER_CONTEXT = "openejb.application.composer.context";
    private static final Class[] MODULE_TYPES = new Class[]{IAnnotationFinder.class, ClassesArchive.class, AppModule.class, WebModule.class, EjbModule.class, Application.class, EjbJar.class, EnterpriseBean.class, Persistence.class, PersistenceUnit.class, Connector.class, Beans.class, Class[].class};
    private final TestClass testClass;
    private ServiceManagerProxy serviceManager = null;

    public ApplicationComposer(Class<?> klass) throws InitializationError {
        super(klass);
        this.testClass = new TestClass(klass);
        this.validate();
    }

    private void validate() throws InitializationError {
        String gripe;
        List mockInjector;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        List configs = this.testClass.getAnnotatedMethods(Configuration.class);
        if (configs.size() > 1) {
            String gripe2 = "Test class should have no more than one @Configuration method";
            errors.add(new Exception("Test class should have no more than one @Configuration method"));
        }
        if ((mockInjector = this.testClass.getAnnotatedMethods(MockInjector.class)).size() > 1) {
            errors.add(new Exception("Test class should have no more than one @MockInjector method"));
        }
        for (FrameworkMethod method : configs) {
            Class<?> type = method.getMethod().getReturnType();
            if (Properties.class.isAssignableFrom(type)) continue;
            String gripe3 = "@Configuration method must return " + Properties.class.getName();
            errors.add(new Exception(gripe3));
        }
        int appModules = 0;
        int modules = 0;
        for (FrameworkMethod method : this.testClass.getAnnotatedMethods(Module.class)) {
            ++modules;
            Class<?> type = method.getMethod().getReturnType();
            if (Application.class.isAssignableFrom(type)) {
                ++appModules;
                continue;
            }
            if (this.isValidModuleType(type, MODULE_TYPES)) continue;
            String gripe4 = "@Module method must return " + Join.join(" or ", MODULE_TYPES).replaceAll("(class|interface) ", "");
            errors.add(new Exception(gripe4));
        }
        if (appModules > 1) {
            gripe = "Test class should have no more than one @Module method that returns " + Application.class.getName();
            errors.add(new Exception(gripe));
        }
        if (modules < 1) {
            gripe = "Test class should have at least one @Module method";
            errors.add(new Exception("Test class should have at least one @Module method"));
        }
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
    }

    private boolean isValidModuleType(Class<?> type, Class[] moduleTypes) {
        for (Class moduleType : moduleTypes) {
            if (!moduleType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    protected List<MethodRule> rules(Object test) {
        List rules = super.rules(test);
        rules.add(new MethodRule(){

            public Statement apply(Statement base, FrameworkMethod method, Object target) {
                return new DeployApplication(target, base);
            }
        });
        return rules;
    }

    public class DeployApplication
    extends Statement {
        private final Object testInstance;
        private final Statement next;

        public DeployApplication(Object testInstance, Statement next) {
            this.testInstance = testInstance;
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            FrameworkMethod method;
            Object o;
            Class javaClass = ApplicationComposer.this.testClass.getJavaClass();
            ClassLoader loader = javaClass.getClassLoader();
            AppModule appModule = new AppModule(loader, javaClass.getSimpleName());
            EjbJar ejbJar = new EjbJar();
            OpenejbJar openejbJar = new OpenejbJar();
            ManagedBean bean = (ManagedBean)ejbJar.addEnterpriseBean((EnterpriseBean)new ManagedBean(javaClass.getSimpleName(), javaClass.getName(), true));
            bean.setTransactionType(TransactionType.BEAN);
            EjbDeployment ejbDeployment = openejbJar.addEjbDeployment((EnterpriseBean)bean);
            ejbDeployment.setDeploymentId(javaClass.getName());
            appModule.getEjbModules().add(new EjbModule(ejbJar, openejbJar));
            Properties configuration = new Properties();
            configuration.put("openejb.deployments.classpath", "false");
            List methods = ApplicationComposer.this.testClass.getAnnotatedMethods(Configuration.class);
            Iterator i$ = methods.iterator();
            if (i$.hasNext() && (o = (method = (FrameworkMethod)i$.next()).invokeExplosively(this.testInstance, new Object[0])) instanceof Properties) {
                Properties properties = (Properties)o;
                configuration.putAll((Map<?, ?>)properties);
            }
            if (SystemInstance.isInitialized()) {
                SystemInstance.reset();
            }
            SystemInstance.init((Properties)configuration);
            SystemInstance.get().setComponent(TestInstance.class, (Object)new TestInstance(ApplicationComposer.this.testClass.getJavaClass(), this.testInstance));
            List mockInjectors = ApplicationComposer.this.testClass.getAnnotatedMethods(MockInjector.class);
            for (FrameworkMethod method2 : mockInjectors) {
                Object o2 = method2.invokeExplosively(this.testInstance, new Object[0]);
                if (o2 instanceof Class) {
                    o2 = ((Class)o2).newInstance();
                }
                if (!(o2 instanceof FallbackPropertyInjector)) continue;
                SystemInstance.get().setComponent(FallbackPropertyInjector.class, (Object)((FallbackPropertyInjector)o2));
            }
            Application application = null;
            for (FrameworkMethod method3 : ApplicationComposer.this.testClass.getAnnotatedMethods(Module.class)) {
                EjbModule ejbModule;
                Class[] beans;
                Object bean2;
                EjbModule ejbModule2;
                Object obj = method3.invokeExplosively(this.testInstance, new Object[0]);
                if (obj instanceof WebModule) {
                    appModule.getWebModules().add((WebModule)obj);
                    continue;
                }
                if (obj instanceof EjbModule) {
                    ejbModule2 = (EjbModule)obj;
                    ejbModule2.initAppModule(appModule);
                    appModule.getEjbModules().add(ejbModule2);
                    continue;
                }
                if (obj instanceof EjbJar) {
                    EjbJar ejbJar2 = (EjbJar)obj;
                    this.setId(ejbJar2, method3);
                    appModule.getEjbModules().add(new EjbModule(ejbJar2));
                    continue;
                }
                if (obj instanceof EnterpriseBean) {
                    bean2 = (EnterpriseBean)obj;
                    EjbJar ejbJar3 = new EjbJar(method3.getName());
                    ejbJar3.addEnterpriseBean(bean2);
                    EjbModule ejbModule3 = new EjbModule(ejbJar3);
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(bean2.getEjbClass());
                    ejbModule3.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(new Class[]{clazz})).link());
                    appModule.getEjbModules().add(ejbModule3);
                    continue;
                }
                if (obj instanceof Application) {
                    application = (Application)obj;
                    this.setId(application, method3);
                    continue;
                }
                if (obj instanceof Connector) {
                    Connector connector = (Connector)obj;
                    this.setId(connector, method3);
                    appModule.getConnectorModules().add(new ConnectorModule(connector));
                    continue;
                }
                if (obj instanceof Persistence) {
                    Persistence persistence = (Persistence)obj;
                    appModule.addPersistenceModule(new PersistenceModule("", persistence));
                    continue;
                }
                if (obj instanceof PersistenceUnit) {
                    PersistenceUnit unit = (PersistenceUnit)obj;
                    appModule.addPersistenceModule(new PersistenceModule("", new Persistence(new PersistenceUnit[]{unit})));
                    continue;
                }
                if (obj instanceof Beans) {
                    beans = (Class[])obj;
                    ejbModule = new EjbModule(new EjbJar(method3.getName()));
                    ejbModule.setBeans((Beans)beans);
                    appModule.getEjbModules().add(ejbModule);
                    continue;
                }
                if (obj instanceof Class[]) {
                    beans = (Class[])obj;
                    ejbModule = new EjbModule(new EjbJar(method3.getName()));
                    ejbModule.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(beans)).link());
                    ejbModule.setBeans(new Beans());
                    appModule.getEjbModules().add(ejbModule);
                    continue;
                }
                if (obj instanceof Class) {
                    bean2 = (Class)obj;
                    ejbModule = new EjbModule(new EjbJar(method3.getName()));
                    ejbModule.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(new Class[]{bean2})).link());
                    ejbModule.setBeans(new Beans());
                    appModule.getEjbModules().add(ejbModule);
                    continue;
                }
                if (obj instanceof IAnnotationFinder) {
                    ejbModule2 = new EjbModule(new EjbJar(method3.getName()));
                    ejbModule2.setFinder((IAnnotationFinder)obj);
                    ejbModule2.setBeans(new Beans());
                    appModule.getEjbModules().add(ejbModule2);
                    continue;
                }
                if (obj instanceof ClassesArchive) {
                    ejbModule2 = new EjbModule(new EjbJar(method3.getName()));
                    ejbModule2.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)obj).link());
                    ejbModule2.setBeans(new Beans());
                    appModule.getEjbModules().add(ejbModule2);
                    continue;
                }
                if (!(obj instanceof AppModule)) continue;
                AppModule module = (AppModule)obj;
                appModule.getEjbModules().addAll(module.getEjbModules());
                appModule.getPersistenceModules().addAll(module.getPersistenceModules());
                appModule.getAdditionalLibMbeans().addAll(module.getAdditionalLibMbeans());
                appModule.getWebModules().addAll(module.getWebModules());
                appModule.getConnectorModules().addAll(module.getConnectorModules());
                appModule.getResources().addAll(module.getResources());
                appModule.getServices().addAll(module.getServices());
                appModule.getPojoConfigurations().putAll(module.getPojoConfigurations());
                appModule.getAdditionalLibraries().addAll(module.getAdditionalLibraries());
                appModule.getAltDDs().putAll(module.getAltDDs());
                appModule.getProperties().putAll((Map<?, ?>)module.getProperties());
            }
            if (application != null) {
                AppModule newModule = new AppModule(appModule.getClassLoader(), appModule.getModuleId(), application, false);
                newModule.getClientModules().addAll(appModule.getClientModules());
                newModule.addPersistenceModules(appModule.getPersistenceModules());
                newModule.getEjbModules().addAll(appModule.getEjbModules());
                newModule.getConnectorModules().addAll(appModule.getConnectorModules());
                appModule = newModule;
            }
            try {
                ConfigurationFactory config = new ConfigurationFactory();
                config.init(SystemInstance.get().getProperties());
                Assembler assembler = new Assembler();
                SystemInstance.get().setComponent(Assembler.class, (Object)assembler);
                assembler.buildContainerSystem(config.getOpenEjbConfiguration());
                if ("true".equals(configuration.getProperty("openejb.embedded.remotable", "false"))) {
                    try {
                        ApplicationComposer.this.serviceManager = new ServiceManagerProxy();
                        ApplicationComposer.this.serviceManager.start();
                    }
                    catch (ServiceManagerProxy.AlreadyStartedException e) {
                        throw new OpenEJBRuntimeException(e);
                    }
                }
                AppInfo appInfo = config.configureApplication(appModule);
                AppContext appContext = assembler.createApplication(appInfo);
                try {
                    ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
                    BeanContext context = containerSystem.getBeanContext(javaClass.getName());
                    ThreadContext callContext = new ThreadContext(context, null, Operation.INJECTION);
                    ThreadContext oldContext = ThreadContext.enter(callContext);
                    try {
                        InjectionProcessor<Object> processor = new InjectionProcessor<Object>(this.testInstance, context.getInjections(), context.getJndiContext());
                        processor.createInstance();
                        try {
                            OWBInjector.inject((BeanManager)appContext.getBeanManager(), (Object)this.testInstance, null);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    finally {
                        ThreadContext.exit(oldContext);
                    }
                    System.setProperty("java.naming.factory.initial", InitContextFactory.class.getName());
                    System.getProperties().put(ApplicationComposer.OPENEJB_APPLICATION_COMPOSER_CONTEXT, appContext.getGlobalJndiContext());
                    List fields = ApplicationComposer.this.testClass.getAnnotatedFields(AppResource.class);
                    for (FrameworkField field : fields) {
                        Field jField;
                        Class type = field.getType();
                        if (AppModule.class.isAssignableFrom(type)) {
                            jField = field.getField();
                            jField.setAccessible(true);
                            jField.set(this.testInstance, appModule);
                            continue;
                        }
                        if (Context.class.isAssignableFrom(type)) {
                            jField = field.getField();
                            jField.setAccessible(true);
                            jField.set(this.testInstance, appContext.getGlobalJndiContext());
                            continue;
                        }
                        throw new IllegalArgumentException("can't find value for type " + type.getName());
                    }
                    ThreadContext previous = ThreadContext.enter(new ThreadContext(context, null, Operation.BUSINESS));
                    try {
                        this.next.evaluate();
                    }
                    finally {
                        ThreadContext.exit(previous);
                    }
                }
                finally {
                    assembler.destroyApplication(appInfo.path);
                }
            }
            finally {
                if (ApplicationComposer.this.serviceManager != null) {
                    try {
                        ApplicationComposer.this.serviceManager.stop();
                    }
                    catch (RuntimeException ignored) {}
                }
                OpenEJB.destroy();
                SystemInstance.reset();
            }
        }

        private void load(String className) {
            try {
                ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
            }
            catch (Throwable t1) {
                try {
                    ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private <Module extends NamedModule> Module setId(Module module, FrameworkMethod method) {
            return this.setId(module, method.getName());
        }

        private <Module extends NamedModule> Module setId(Module module, String name) {
            if (module.getModuleName() != null) {
                return module;
            }
            if (module.getId() != null) {
                return module;
            }
            module.setId(name);
            return module;
        }
    }
}

