/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource;

import java.util.concurrent.TimeUnit;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.geronimo.connector.outbound.GenericConnectionManager;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.LocalTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.NoTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PartitionedPool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.SinglePool;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.resource.AutoConnectionTracker;
import org.apache.openejb.util.Duration;

public class GeronimoConnectionManagerFactory {
    private String name;
    private ClassLoader classLoader;
    private TransactionManager transactionManager;
    private String transactionSupport;
    private boolean pooling = true;
    private String partitionStrategy;
    private int poolMaxSize = 10;
    private int poolMinSize = 0;
    private boolean allConnectionsEqual = true;
    private int connectionMaxWaitMilliseconds = 5000;
    private int connectionMaxIdleMinutes = 15;
    private ManagedConnectionFactory mcf;

    public ManagedConnectionFactory getMcf() {
        return this.mcf;
    }

    public void setMcf(ManagedConnectionFactory mcf) {
        this.mcf = mcf;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getTransactionSupport() {
        return this.transactionSupport;
    }

    public void setTransactionSupport(String transactionSupport) {
        this.transactionSupport = transactionSupport;
    }

    public boolean isPooling() {
        return this.pooling;
    }

    public void setPooling(boolean pooling) {
        this.pooling = pooling;
    }

    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public void setPartitionStrategy(String partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    public int getPoolMaxSize() {
        return this.poolMaxSize;
    }

    public void setPoolMaxSize(int poolMaxSize) {
        this.poolMaxSize = poolMaxSize;
    }

    public int getPoolMinSize() {
        return this.poolMinSize;
    }

    public void setPoolMinSize(int poolMinSize) {
        this.poolMinSize = poolMinSize;
    }

    public boolean isAllConnectionsEqual() {
        return this.allConnectionsEqual;
    }

    public void setAllConnectionsEqual(boolean allConnectionsEqual) {
        this.allConnectionsEqual = allConnectionsEqual;
    }

    public int getConnectionMaxWaitMilliseconds() {
        return this.connectionMaxWaitMilliseconds;
    }

    public void setConnectionMaxWaitMilliseconds(int connectionMaxWaitMilliseconds) {
        this.connectionMaxWaitMilliseconds = connectionMaxWaitMilliseconds;
    }

    public void setConnectionMaxWaitTime(Duration connectionMaxWait) {
        if (connectionMaxWait.getUnit() == null) {
            connectionMaxWait.setUnit(TimeUnit.MILLISECONDS);
        }
        long milleseconds = TimeUnit.MILLISECONDS.convert(connectionMaxWait.getTime(), connectionMaxWait.getUnit());
        this.setConnectionMaxWaitMilliseconds((int)milleseconds);
    }

    public int getConnectionMaxIdleMinutes() {
        return this.connectionMaxIdleMinutes;
    }

    public void setConnectionMaxIdleMinutes(int connectionMaxIdleMinutes) {
        this.connectionMaxIdleMinutes = connectionMaxIdleMinutes;
    }

    public void setConnectionMaxIdleTime(Duration connectionMaxIdle) {
        if (connectionMaxIdle.getUnit() == null) {
            connectionMaxIdle.setUnit(TimeUnit.MINUTES);
        }
        long minutes = TimeUnit.MINUTES.convert(connectionMaxIdle.getTime(), connectionMaxIdle.getUnit());
        this.setConnectionMaxIdleMinutes((int)minutes);
    }

    public GenericConnectionManager create() {
        RecoverableTransactionManager tm;
        PoolingSupport poolingSupport = this.createPoolingSupport();
        ClassLoader classLoader = this.classLoader;
        if (classLoader == null) {
            Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        TransactionSupport txSupport = this.createTransactionSupport();
        if (this.transactionManager instanceof RecoverableTransactionManager) {
            tm = (RecoverableTransactionManager)this.transactionManager;
        } else {
            if (txSupport.isRecoverable()) {
                throw new OpenEJBRuntimeException("currently recoverable tx support (xa) needs a geronimo tx manager");
            }
            tm = new SimpleRecoverableTransactionManager(this.transactionManager);
        }
        return new GenericConnectionManager(txSupport, poolingSupport, null, (ConnectionTracker)new AutoConnectionTracker(), tm, this.mcf, this.name, classLoader);
    }

    private TransactionSupport createTransactionSupport() {
        if (this.transactionSupport == null || "local".equalsIgnoreCase(this.transactionSupport)) {
            return LocalTransactions.INSTANCE;
        }
        if ("none".equalsIgnoreCase(this.transactionSupport)) {
            return NoTransactions.INSTANCE;
        }
        if ("xa".equalsIgnoreCase(this.transactionSupport)) {
            return new XATransactions(true, false);
        }
        throw new IllegalArgumentException("Unknown transaction type " + this.transactionSupport);
    }

    private PoolingSupport createPoolingSupport() {
        if (!this.pooling) {
            return new NoPool();
        }
        if (this.partitionStrategy == null || "none".equalsIgnoreCase(this.partitionStrategy)) {
            return new SinglePool(this.poolMaxSize, this.poolMinSize, this.connectionMaxWaitMilliseconds, this.connectionMaxIdleMinutes, this.allConnectionsEqual, !this.allConnectionsEqual, false);
        }
        if ("by-connector-properties".equalsIgnoreCase(this.partitionStrategy)) {
            return new PartitionedPool(this.poolMaxSize, this.poolMinSize, this.connectionMaxWaitMilliseconds, this.connectionMaxIdleMinutes, this.allConnectionsEqual, !this.allConnectionsEqual, false, true, false);
        }
        if ("by-subject".equalsIgnoreCase(this.partitionStrategy)) {
            return new PartitionedPool(this.poolMaxSize, this.poolMinSize, this.connectionMaxWaitMilliseconds, this.connectionMaxIdleMinutes, this.allConnectionsEqual, !this.allConnectionsEqual, false, false, true);
        }
        throw new IllegalArgumentException("Unknown partition strategy " + this.partitionStrategy);
    }

    private class SimpleRecoverableTransactionManager
    implements RecoverableTransactionManager {
        private final TransactionManager delegate;

        public SimpleRecoverableTransactionManager(TransactionManager transactionManager) {
            this.delegate = transactionManager;
        }

        public void recoveryError(Exception e) {
            throw new UnsupportedOperationException();
        }

        public void registerNamedXAResourceFactory(NamedXAResourceFactory namedXAResourceFactory) {
            throw new UnsupportedOperationException();
        }

        public void unregisterNamedXAResourceFactory(String namedXAResourceFactoryName) {
            throw new UnsupportedOperationException();
        }

        public void begin() throws NotSupportedException, SystemException {
            this.delegate.begin();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            this.delegate.commit();
        }

        public int getStatus() throws SystemException {
            return this.delegate.getStatus();
        }

        public Transaction getTransaction() throws SystemException {
            return this.delegate.getTransaction();
        }

        public void resume(Transaction transaction) throws IllegalStateException, InvalidTransactionException, SystemException {
            this.delegate.resume(transaction);
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.delegate.rollback();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.delegate.setRollbackOnly();
        }

        public void setTransactionTimeout(int i) throws SystemException {
            this.delegate.setTransactionTimeout(i);
        }

        public Transaction suspend() throws SystemException {
            return this.delegate.suspend();
        }
    }
}

