/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.dbcp;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.management.Description;
import javax.management.ManagedAttribute;
import javax.management.ManagedOperation;
import javax.management.ObjectName;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.openejb.monitoring.DynamicMBeanWrapper;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ObjectNameBuilder;

@Description(value="describe a datasource pool")
public class JMXBasicDataSource {
    private final transient BasicDataSource ds;
    private transient ObjectName objectName;

    public JMXBasicDataSource(String name, BasicDataSource ds) {
        this.ds = ds;
        this.objectName = ObjectNameBuilder.uniqueName("datasources", name, ds);
        try {
            LocalMBeanServer.get().registerMBean(new DynamicMBeanWrapper(this), this.objectName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregister() {
        try {
            LocalMBeanServer.get().unregisterMBean(this.objectName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ManagedAttribute
    @Description(value="The class driver name.")
    public String getDriverClassName() {
        return this.ds.getDriverClassName();
    }

    @ManagedAttribute
    @Description(value="The connection URL to be passed to our JDBC driver to establish a connection.")
    public String getUrl() {
        return this.ds.getUrl();
    }

    @ManagedAttribute
    @Description(value="The SQL query that will be used to validate connections from this pool before returning them to the caller.")
    public String getValidationQuery() {
        return this.ds.getValidationQuery();
    }

    @ManagedAttribute
    @Description(value="The connection username to be passed to our JDBC driver to establish a connection.")
    public String getUsername() {
        return this.ds.getUsername();
    }

    @ManagedAttribute
    @Description(value="Timeout in seconds before connection validation queries fail.")
    public int getValidationQueryTimeout() {
        return this.ds.getValidationQueryTimeout();
    }

    @ManagedAttribute
    @Description(value="The initial number of connections that are created when the pool is started.")
    public int getInitialSize() {
        return this.ds.getInitialSize();
    }

    @ManagedAttribute
    @Description(value="The maximum number of active connections that can be allocated from this pool at the same time, or negative for no limit.")
    public int getMaxActive() {
        return this.ds.getMaxActive();
    }

    @ManagedAttribute
    @Description(value="The maximum number of connections that can remain idle in the pool, without extra ones beingdestroyed, or negative for no limit.")
    public int getMaxIdle() {
        return this.ds.getMaxIdle();
    }

    @ManagedAttribute
    @Description(value="The minimum number of active connections that can remain idle in the pool, without extra ones being created when the evictor runs, or 0 to create none.")
    public int getMinIdle() {
        return this.ds.getMinIdle();
    }

    @ManagedAttribute
    @Description(value="The minimum number of active connections that can remain idle in the pool, without extra ones being created when the evictor runs, or 0 to create none.")
    public int getNumTestsPerEvictionRun() {
        return this.ds.getNumTestsPerEvictionRun();
    }

    @ManagedAttribute
    @Description(value="The minimum amount of time an object may sit idle in the pool before it is eligible for eviction by the idle object evictor (if any).")
    public long getMinEvictableIdleTimeMillis() {
        return this.ds.getMinEvictableIdleTimeMillis();
    }

    @ManagedAttribute
    @Description(value="The number of milliseconds to sleep between runs of the idle object evictor thread.")
    public long getTimeBetweenEvictionRunsMillis() {
        return this.ds.getTimeBetweenEvictionRunsMillis();
    }

    @ManagedAttribute
    @Description(value="The maximum number of open statements that can be allocated from the statement pool at the same time, or non-positive for no limit.")
    public int getMaxOpenPreparedStatements() {
        return this.ds.getMaxOpenPreparedStatements();
    }

    @ManagedAttribute
    @Description(value="The maximum number of milliseconds that the pool will wait (when there are no available connections) for a connection to be returned before throwing an exception, or <= 0 to wait indefinitely.")
    public long getMaxWait() {
        return this.ds.getMaxWait();
    }

    @ManagedAttribute
    @Description(value="The default auto-commit state of connections created by this pool.")
    public boolean getDefaultAutoCommit() {
        return this.ds.getDefaultAutoCommit();
    }

    @ManagedAttribute
    @Description(value="Prepared statement pooling for this pool.")
    public boolean getPoolPreparedStatements() {
        return this.ds.isPoolPreparedStatements();
    }

    @ManagedAttribute
    @Description(value="The indication of whether objects will be validated before being borrowed from the pool.")
    public boolean getTestOnBorrow() {
        return this.ds.getTestOnBorrow();
    }

    @ManagedAttribute
    @Description(value="The indication of whether objects will be validated before being returned to the pool.")
    public boolean getTestOnReturn() {
        return this.ds.getTestOnReturn();
    }

    @ManagedAttribute
    @Description(value="The indication of whether objects will be validated by the idle object evictor (if any).")
    public boolean getTestWhileIdle() {
        return this.ds.getTestWhileIdle();
    }

    @ManagedAttribute
    @Description(value="The default \"catalog\" of connections created by this pool.")
    public String getDefaultCatalog() {
        return this.ds.getDefaultCatalog();
    }

    @ManagedAttribute
    @Description(value="The default read-only state of connections created by this pool.")
    public boolean getDefaultReadOnly() {
        return this.ds.getDefaultReadOnly();
    }

    @ManagedAttribute
    @Description(value="The default TransactionIsolation state of connections created by this pool.")
    public int getDefaultTransactionIsolation() {
        return this.ds.getDefaultTransactionIsolation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedOperation
    @Description(value="Execute the validation query.")
    public String executeValidationQuery() {
        Connection conn;
        String query = this.ds.getValidationQuery();
        if (query == null || query.trim().isEmpty()) {
            return "no validation query defined";
        }
        try {
            conn = this.ds.getConnection();
        }
        catch (SQLException e) {
            return e.getMessage();
        }
        Statement statement = null;
        try {
            statement = conn.createStatement();
            if (statement.execute(query)) {
                String string = "OK";
                return string;
            }
            String string = "KO";
            return string;
        }
        catch (SQLException e) {
            String string = e.getMessage();
            return string;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @ManagedAttribute
    @Description(value="Set the class driver.")
    public void setDriverClassName(String name) {
        this.ds.setDriverClassName(name);
    }

    @ManagedAttribute
    @Description(value="Set the connection URL.")
    public void setUrl(String url) {
        this.ds.setUrl(url);
    }

    @ManagedAttribute
    @Description(value="Set the SQL validation query.")
    public void setValidationQuery(String query) {
        this.ds.setValidationQuery(query);
    }

    @ManagedAttribute
    @Description(value="Set the connection username to be passed to our JDBC driver to establish a connection.")
    public void setUsername(String user) {
        this.ds.setUsername(user);
    }

    @ManagedAttribute
    @Description(value="Set the timeout in seconds before connection validation queries fail.")
    public void setValidationQueryTimeout(int timeout) {
        this.ds.setValidationQueryTimeout(timeout);
    }

    @ManagedAttribute
    @Description(value="Set the initial number of connections that are created when the pool is started.")
    public void setInitialSize(int size) {
        this.ds.setInitialSize(size);
    }

    @ManagedAttribute
    @Description(value="Set the maximum number of active connections that can be allocated from this pool at the same time, or negative for no limit.")
    public void setMaxActive(int max) {
        this.ds.setMaxActive(max);
    }

    @ManagedAttribute
    @Description(value="Set the maximum number of connections that can remain idle in the pool, without extra ones beingdestroyed, or negative for no limit.")
    public void setMaxIdle(int max) {
        this.ds.setMaxIdle(max);
    }

    @ManagedAttribute
    @Description(value="Set the minimum number of active connections that can remain idle in the pool, without extra ones being created when the evictor runs, or 0 to create none.")
    public void setMinIdle(int min) {
        this.ds.setMinIdle(min);
    }

    @ManagedAttribute
    @Description(value="Set the minimum number of active connections that can remain idle in the pool, without extra ones being created when the evictor runs, or 0 to create none.")
    public void setNumTestsPerEvictionRun(int num) {
        this.ds.setNumTestsPerEvictionRun(num);
    }

    @ManagedAttribute
    @Description(value="Set the minimum amount of time an object may sit idle in the pool before it is eligible for eviction by the idle object evictor (if any).")
    public void setMinEvictableIdleTimeMillis(long time) {
        this.ds.setMinEvictableIdleTimeMillis(time);
    }

    @ManagedAttribute
    @Description(value="Set the number of milliseconds to sleep between runs of the idle object evictor thread.")
    public void setTimeBetweenEvictionRunsMillis(long time) {
        this.ds.setTimeBetweenEvictionRunsMillis(time);
    }

    @ManagedAttribute
    @Description(value="Set the maximum number of open statements that can be allocated from the statement pool at the same time, or non-positive for no limit.")
    public void setMaxOpenPreparedStatements(int max) {
        this.ds.setMaxOpenPreparedStatements(max);
    }

    @ManagedAttribute
    @Description(value="Set the maximum number of milliseconds that the pool will wait (when there are no available connections) for a connection to be returned before throwing an exception, or <= 0 to wait indefinitely.")
    public void setMaxWait(long max) {
        this.ds.setMaxWait(max);
    }

    @ManagedAttribute
    @Description(value="Set the default auto-commit state of connections created by this pool.")
    public void setDefaultAutoCommit(boolean auto) {
        this.ds.setDefaultAutoCommit(auto);
    }

    @ManagedAttribute
    @Description(value="Set the prepared statement pooling for this pool.")
    public void setPoolPreparedStatements(boolean pool) {
        this.ds.setPoolPreparedStatements(pool);
    }

    @ManagedAttribute
    @Description(value="Set the indication of whether objects will be validated before being borrowed from the pool.")
    public void setTestOnBorrow(boolean test) {
        this.ds.setTestOnBorrow(test);
    }

    @ManagedAttribute
    @Description(value="Set the indication of whether objects will be validated before being returned to the pool.")
    public void setTestOnReturn(boolean test) {
        this.ds.setTestOnReturn(test);
    }

    @ManagedAttribute
    @Description(value="Set the indication of whether objects will be validated by the idle object evictor (if any).")
    public void setTestWhileIdle(boolean test) {
        this.ds.setTestWhileIdle(test);
    }

    @ManagedAttribute
    @Description(value="The default \"catalog\" of connections created by this pool.")
    public void setDefaultCatalog(String catalog) {
        this.ds.setDefaultCatalog(catalog);
    }

    @ManagedAttribute
    @Description(value="Set the default read-only state of connections created by this pool.")
    public void setDefaultReadOnly(boolean ro) {
        this.ds.setDefaultReadOnly(ro);
    }

    @ManagedAttribute
    @Description(value="Set the default TransactionIsolation state of connections created by this pool ([NONE: 0, READ_COMMITTED: 2, READ_UNCOMMITTED: 4, SERIALIZABLE: 8]).")
    public void setDefaultTransactionIsolation(int level) {
        this.ds.setDefaultTransactionIsolation(level);
    }
}

