/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.managed.xa;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.openejb.resource.jdbc.managed.local.ManagedDataSource;
import org.apache.openejb.resource.jdbc.managed.xa.ManagedXAConnection;

public class ManagedXADataSource
extends ManagedDataSource {
    private static final Class<?>[] CONNECTION_CLASS = new Class[]{XAConnection.class};
    private final XADataSource xaDataSource;

    public ManagedXADataSource(DataSource ds, TransactionManager txMgr) {
        super(ds, txMgr);
        this.xaDataSource = (XADataSource)((Object)ds);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.managedXA(this.xaDataSource.getXAConnection().getConnection());
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.managedXA(this.xaDataSource.getXAConnection(username, password).getConnection());
    }

    private Connection managedXA(Connection connection) throws SQLException {
        return (Connection)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), CONNECTION_CLASS, (InvocationHandler)new ManagedXAConnection(connection, this.transactionManager));
    }
}

