/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.loader.Options;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.executor.OfferRejectedExecutionHandler;

public class ExecutorBuilder {
    private int size = 10;
    private String prefix = "Pool";
    private ThreadFactory threadFactory;
    private RejectedExecutionHandler rejectedExecutionHandler;

    public ExecutorBuilder size(int size) {
        this.size = size;
        return this;
    }

    public ExecutorBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ExecutorBuilder threadFactory(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
        return this;
    }

    public ExecutorBuilder rejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this.rejectedExecutionHandler = rejectedExecutionHandler;
        return this;
    }

    public ThreadPoolExecutor build(Options options) {
        RejectedExecutionHandler handler;
        int corePoolSize = options.get(this.prefix + ".CorePoolSize", this.size);
        int maximumPoolSize = Math.max(options.get(this.prefix + ".MaximumPoolSize", corePoolSize), corePoolSize);
        int size = options.get(this.prefix + ".QueueSize", maximumPoolSize);
        Duration keepAliveTime = (Duration)options.get(this.prefix + ".KeepAliveTime", (Object)new Duration(60L, TimeUnit.SECONDS));
        boolean allowCoreThreadTimeout = options.get(this.prefix + ".AllowCoreThreadTimeOut", true);
        QueueType defaultQueueType = size == 0 ? QueueType.SYNCHRONOUS : QueueType.LINKED;
        BlockingQueue queue = ((QueueType)options.get(this.prefix + ".QueueType", (Enum)defaultQueueType)).create(options, this.prefix, size);
        ThreadFactory factory = this.threadFactory;
        if (factory == null) {
            factory = new DaemonThreadFactory(this.prefix);
        }
        if ((handler = this.rejectedExecutionHandler) == null) {
            Duration duration = (Duration)options.get(this.prefix + ".OfferTimeout", (Object)new Duration(30L, TimeUnit.SECONDS));
            handler = new OfferRejectedExecutionHandler(duration);
        }
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime.getTime(), keepAliveTime.getUnit() != null ? keepAliveTime.getUnit() : TimeUnit.SECONDS, queue, factory, handler);
        threadPoolExecutor.allowCoreThreadTimeOut(allowCoreThreadTimeout);
        return threadPoolExecutor;
    }

    public static enum QueueType {
        ARRAY,
        LINKED,
        PRIORITY,
        SYNCHRONOUS;


        public BlockingQueue create(Options options, String prefix, int queueSize) {
            switch (this) {
                case ARRAY: {
                    return new ArrayBlockingQueue(queueSize);
                }
                case LINKED: {
                    return new LinkedBlockingQueue(queueSize);
                }
                case PRIORITY: {
                    return new PriorityBlockingQueue();
                }
                case SYNCHRONOUS: {
                    return new SynchronousQueue(options.get(prefix + ".QueueFair", false));
                }
            }
            throw new IllegalArgumentException("Unknown QueueType type: " + (Object)((Object)this));
        }
    }
}

