/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.util.logging.ConsoleHandler;
import java.util.logging.LogManager;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.log.ConsoleColorHandler;
import org.apache.openejb.log.SingleLineFormatter;
import org.apache.openejb.util.JuliLogStream;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.LogStream;
import org.apache.openejb.util.LogStreamFactory;

public class JuliLogStreamFactory
implements LogStreamFactory {
    public static final String OPENEJB_LOG_COLOR_PROP = "openejb.log.color";
    private static String consoleHandlerClazz;

    @Override
    public LogStream createLogStream(LogCategory logCategory) {
        return new JuliLogStream(logCategory);
    }

    public static boolean isNotIDE() {
        return !System.getProperty("java.class.path").contains("idea_rt");
    }

    private static boolean is(String classname) {
        try {
            JuliLogStreamFactory.class.getClassLoader().loadClass(classname);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        boolean tomee = JuliLogStreamFactory.is("org.apache.tomee.catalina.TomcatLoader");
        boolean embedded = JuliLogStreamFactory.is("org.apache.tomee.embedded.Container");
        if ((!tomee || embedded) && System.getProperty("java.util.logging.manager") == null) {
            System.setProperty("java.util.logging.manager", OpenEJBLogManager.class.getName());
            consoleHandlerClazz = SystemInstance.get().getOptions().get(OPENEJB_LOG_COLOR_PROP, false) && JuliLogStreamFactory.isNotIDE() ? ConsoleColorHandler.class.getName() : OpenEJBSimpleLayoutHandler.class.getName();
        }
        try {
            if (SystemInstance.get().getOptions().get("openjpa.Log", (String)null) == null) {
                JuliLogStreamFactory.class.getClassLoader().loadClass("org.apache.openjpa.lib.log.LogFactoryAdapter");
                System.setProperty("openjpa.Log", "org.apache.openejb.openjpa.JULOpenJPALogFactory");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperty("openwebbeans.logging.factory", "org.apache.webbeans.logger.JULLoggerFactory");
    }

    public static class OpenEJBSimpleLayoutHandler
    extends ConsoleHandler {
        public OpenEJBSimpleLayoutHandler() {
            this.setFormatter(new SingleLineFormatter());
            this.setOutputStream(System.out);
        }
    }

    public static class OpenEJBLogManager
    extends LogManager {
        public void forceReset() {
            super.reset();
        }

        @Override
        public void reset() throws SecurityException {
        }

        @Override
        public String getProperty(String name) {
            String parentValue = super.getProperty(name);
            if (SystemInstance.get().getProperties().containsKey(name)) {
                return SystemInstance.get().getProperty(name);
            }
            String propertyKeyValue = "logging" + OpenEJBLogManager.reverseProperty(name);
            if (SystemInstance.get().getProperties().containsKey(propertyKeyValue)) {
                return SystemInstance.get().getProperty(propertyKeyValue);
            }
            if (OpenEJBLogManager.class.getName().equals(System.getProperty("java.util.logging.manager")) && OpenEJBLogManager.isOverridableLogger(name) && parentValue == null) {
                if (name.endsWith(".handlers")) {
                    return consoleHandlerClazz;
                }
                if (name.endsWith(".useParentHandlers")) {
                    return "false";
                }
            }
            return parentValue;
        }

        private static String reverseProperty(String name) {
            if (name.contains(".") && !name.endsWith(".")) {
                int idx = name.lastIndexOf(46);
                return name.substring(idx) + "." + name.substring(0, idx);
            }
            return name;
        }

        private static boolean isOverridableLogger(String name) {
            return name.toLowerCase().contains("openejb") || name.toLowerCase().contains("transaction") || name.toLowerCase().contains("cxf") || name.toLowerCase().contains("timer") || name.startsWith("org.apache.") || name.startsWith("openjpa.") || name.startsWith("net.sf.ehcache.") || name.startsWith("org.quartz.") || name.startsWith("org.hibernate.");
        }

        static {
            final LogManager mgr = LogManager.getLogManager();
            if (mgr instanceof OpenEJBLogManager) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        ((OpenEJBLogManager)mgr).forceReset();
                    }
                });
            }
        }
    }
}

