/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.xbean.finder.UrlSet;

public class URLs {
    public static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, URLs.class.getPackage().getName());

    public static File toFile(URL url) {
        if ("jar".equals(url.getProtocol())) {
            try {
                String spec = url.getFile();
                int separator = spec.indexOf(33);
                if (separator == -1) {
                    throw new MalformedURLException("no ! found in jar url spec:" + spec);
                }
                return URLs.toFile(new URL(spec.substring(0, separator++)));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        if ("file".equals(url.getProtocol())) {
            return new File(JarLocation.decode((String)url.getFile()));
        }
        throw new IllegalArgumentException("Unsupported URL scheme: " + url.toExternalForm());
    }

    public static String toFilePath(URL url) {
        return URLs.toFile(url).getAbsolutePath();
    }

    public static UrlSet cullSystemAndOpenEJBJars(UrlSet original) throws IOException {
        return URLs.cullSystemJars(URLs.cullOpenEJBJars(original));
    }

    public static UrlSet cullSystemJars(UrlSet original) throws IOException {
        UrlSet urls = new UrlSet((Collection)original.getUrls());
        urls = urls.exclude(ClassLoader.getSystemClassLoader().getParent());
        urls = urls.excludeJavaExtDirs();
        urls = urls.excludeJavaEndorsedDirs();
        urls = urls.excludeJavaHome();
        urls = urls.excludePaths(System.getProperty("sun.boot.class.path", ""));
        urls = urls.exclude(".*/JavaVM.framework/.*");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Culled {0} system urls from set", original.size() - urls.size());
        }
        return urls;
    }

    public static UrlSet cullOpenEJBJars(UrlSet original) throws IOException {
        UrlSet urls = new UrlSet((Collection)original.getUrls());
        urls = urls.exclude(".*openejb.*");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Culled {0} OpenEJB urls from set", original.size() - urls.size());
        }
        return urls;
    }

    private URLs() {
    }
}

