/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.openejb.BeanContext;
import org.apache.openejb.RpcContainer;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.util.proxy.LocalBeanProxyFactory;

public class ProxyEJB {
    private ProxyEJB() {
    }

    public static Object proxy(BeanContext beanContext) {
        if (beanContext.getBusinessLocalInterface() != null) {
            return ProxyEJB.proxy(beanContext, new Class[]{beanContext.getBusinessLocalInterface()});
        }
        if (beanContext.isLocalbean()) {
            return ProxyEJB.proxy(beanContext, new Class[]{beanContext.getBusinessLocalBeanInterface()});
        }
        if (beanContext.getBusinessRemoteInterface() != null) {
            return ProxyEJB.proxy(beanContext, new Class[]{beanContext.getBusinessRemoteInterface()});
        }
        throw new IllegalArgumentException("can't proxy " + beanContext.getEjbName());
    }

    public static Object proxy(BeanContext beanContext, Class<?>[] itfs) {
        if (beanContext.isLocalbean()) {
            return LocalBeanProxyFactory.newProxyInstance(itfs[0].getClassLoader(), new Handler(beanContext), itfs[0], IntraVmProxy.class, Serializable.class);
        }
        return Proxy.newProxyInstance(itfs[0].getClassLoader(), itfs, (InvocationHandler)new Handler(beanContext));
    }

    private static class Handler
    implements InvocationHandler {
        private BeanContext beanContext;

        public Handler(BeanContext bc) {
            this.beanContext = bc;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            RpcContainer container = (RpcContainer)RpcContainer.class.cast(this.beanContext.getContainer());
            return container.invoke(this.beanContext.getDeploymentID(), this.beanContext.getInterfaceType(method.getDeclaringClass()), method.getDeclaringClass(), method, args, null);
        }
    }
}

