/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.openejb.util;

import org.apache.openejb.loader.SystemInstance;
import org.apache.xbean.finder.ResourceFinder;

import java.io.IOException;
import java.util.List;

public final class EventHelper {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, EventHelper.class);

    private EventHelper() {
        // no-op
    }

    public static void installExtensions(final ResourceFinder finder) {
        try {
            final List<Class<?>> classes = finder.findAvailableClasses("org.apache.openejb.extension");
            for (Class<?> clazz : classes) {
                try {
                    final Object object = clazz.newInstance();
                    SystemInstance.get().addObserver(object);
                } catch (Throwable t) {
                    LOGGER.error("Extension construction failed" + clazz.getName(), t);
                }
            }
        } catch (IOException e) {
            LOGGER.error("Extension scanning of 'META-INF/org.apache.openejb.extension' files failed", e);
        }
    }
}
