/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.ValidationContext;
import org.apache.openejb.config.ValidationRule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.SessionBean;

public class CheckRestMethodArePublic
implements ValidationRule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(AppModule appModule) {
        ArrayList<String> standAloneClasses = new ArrayList<String>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            for (EjbModule ejb : appModule.getEjbModules()) {
                Thread.currentThread().setContextClassLoader(ejb.getClassLoader());
                for (EnterpriseBean bean : ejb.getEjbJar().getEnterpriseBeans()) {
                    if (!(bean instanceof SessionBean) || !((SessionBean)bean).isRestService()) continue;
                    standAloneClasses.add(bean.getEjbClass());
                    this.valid(ejb.getValidation(), ejb.getClassLoader(), bean.getEjbClass());
                }
            }
            for (WebModule web : appModule.getWebModules()) {
                Thread.currentThread().setContextClassLoader(web.getClassLoader());
                ArrayList<String> classes = new ArrayList<String>();
                classes.addAll(web.getRestClasses());
                classes.addAll(web.getEjbRestServices());
                for (String app : web.getRestApplications()) {
                    Application appInstance;
                    Class<?> clazz;
                    try {
                        clazz = web.getClassLoader().loadClass(app);
                    }
                    catch (ClassNotFoundException e) {
                        continue;
                    }
                    try {
                        appInstance = (Application)clazz.newInstance();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    for (Class rsClass : appInstance.getClasses()) {
                        classes.add(rsClass.getName());
                    }
                    for (Object rsSingleton : appInstance.getSingletons()) {
                        classes.add(rsSingleton.getClass().getName());
                    }
                }
                Iterator it = classes.iterator();
                while (it.hasNext()) {
                    String current = (String)it.next();
                    if (!standAloneClasses.contains(current)) continue;
                    it.remove();
                }
                for (String classname : classes) {
                    this.valid(web.getValidation(), web.getClassLoader(), classname);
                }
                classes.clear();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
        standAloneClasses.clear();
    }

    private void valid(ValidationContext validation, ClassLoader classLoader, String classname) {
        try {
        }
        catch (ClassNotFoundException e) {
            return;
        }
        int publicMethodNumber = 0;
        int nonPublicMethods = 0;
        for (Class<?> clazz = classLoader.loadClass(classname); !Object.class.equals(clazz) && clazz != null; clazz = clazz.getSuperclass()) {
            for (Method mtd : clazz.getDeclaredMethods()) {
                boolean isPublic = Modifier.isPublic(mtd.getModifiers());
                if (mtd.getAnnotation(Path.class) != null && !isPublic) {
                    String name = mtd.toGenericString();
                    validation.warn(name, "rest.method.visibility", name);
                }
                if (isPublic) {
                    ++publicMethodNumber;
                    continue;
                }
                ++nonPublicMethods;
            }
        }
        if (publicMethodNumber == 0 && nonPublicMethods > 0) {
            validation.warn(classname, "no.method.in.rest.class", classname);
        } else if (publicMethodNumber == 0 && nonPublicMethods == 0) {
            validation.warn(classname, "no.rest.resource.method", classname);
        }
    }
}

