/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import java.io.Serializable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class CoreUserTransaction
implements UserTransaction,
Serializable {
    private static final long serialVersionUID = 9203248912222645965L;
    private static final Logger transactionLogger = Logger.getInstance(LogCategory.TRANSACTION, "org.apache.openejb.util.resources");
    private transient TransactionManager transactionManager;

    public CoreUserTransaction(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    private TransactionManager transactionManager() {
        if (this.transactionManager == null) {
            this.transactionManager = OpenEJB.getTransactionManager();
        }
        return this.transactionManager;
    }

    public void begin() throws NotSupportedException, SystemException {
        this.transactionManager().begin();
        if (transactionLogger.isInfoEnabled()) {
            transactionLogger.info("Started user transaction " + this.transactionManager().getTransaction());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (transactionLogger.isInfoEnabled()) {
            transactionLogger.info("Committing user transaction " + this.transactionManager().getTransaction());
        }
        this.transactionManager().commit();
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        if (transactionLogger.isInfoEnabled()) {
            transactionLogger.info("Rolling back user transaction " + this.transactionManager().getTransaction());
        }
        this.transactionManager().rollback();
    }

    public int getStatus() throws SystemException {
        int status = this.transactionManager().getStatus();
        if (transactionLogger.isInfoEnabled()) {
            transactionLogger.info("User transaction " + this.transactionManager().getTransaction() + " has status " + CoreUserTransaction.getStatus(status));
        }
        return status;
    }

    public void setRollbackOnly() throws SystemException {
        if (transactionLogger.isInfoEnabled()) {
            transactionLogger.info("Marking user transaction for rollback: " + this.transactionManager().getTransaction());
        }
        this.transactionManager().setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.transactionManager().setTransactionTimeout(seconds);
    }

    private static String getStatus(int status) {
        StringBuilder buffer = new StringBuilder(100);
        switch (status) {
            case 0: {
                buffer.append("STATUS_ACTIVE: ");
                buffer.append("A transaction is associated with the target object and it is in the active state.");
                break;
            }
            case 3: {
                buffer.append("STATUS_COMMITTED: ");
                buffer.append("A transaction is associated with the target object and it has been committed.");
                break;
            }
            case 8: {
                buffer.append("STATUS_COMMITTING: ");
                buffer.append("A transaction is associated with the target object and it is in the process of committing.");
                break;
            }
            case 1: {
                buffer.append("STATUS_MARKED_ROLLBACK: ");
                buffer.append("A transaction is associated with the target object and it has been marked for rollback, perhaps as a result of a setRollbackOnly operation.");
                break;
            }
            case 6: {
                buffer.append("STATUS_NO_TRANSACTION: ");
                buffer.append("No transaction is currently associated with the target object.");
                break;
            }
            case 2: {
                buffer.append("STATUS_PREPARED: ");
                buffer.append("A transaction is associated with the target object and it has been prepared, i.e.");
                break;
            }
            case 7: {
                buffer.append("STATUS_PREPARING: ");
                buffer.append("A transaction is associated with the target object and it is in the process of preparing.");
                break;
            }
            case 4: {
                buffer.append("STATUS_ROLLEDBACK: ");
                buffer.append("A transaction is associated with the target object and the outcome has been determined as rollback.");
                break;
            }
            case 9: {
                buffer.append("STATUS_ROLLING_BACK: ");
                buffer.append("A transaction is associated with the target object and it is in the process of rolling back.");
                break;
            }
            default: {
                buffer.append("Unknown status ").append(status);
            }
        }
        return buffer.toString();
    }
}

