/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.junit;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.enterprise.inject.spi.BeanManager;
import javax.naming.Context;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InjectionProcessor;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.cdi.ScopeHelper;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.core.Operation;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.naming.InitContextFactory;
import org.apache.openejb.injection.FallbackPropertyInjector;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.ManagedBean;
import org.apache.openejb.jee.NamedModule;
import org.apache.openejb.jee.TransactionType;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.jee.oejb3.EjbDeployment;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.junit.AppResource;
import org.apache.openejb.junit.Classes;
import org.apache.openejb.junit.Component;
import org.apache.openejb.junit.Configuration;
import org.apache.openejb.junit.Descriptor;
import org.apache.openejb.junit.Descriptors;
import org.apache.openejb.junit.EnableServices;
import org.apache.openejb.junit.MockInjector;
import org.apache.openejb.junit.Module;
import org.apache.openejb.junit.TestInstance;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.ServiceManagerProxy;
import org.apache.openejb.util.URLs;
import org.apache.openejb.web.LightweightWebAppBuilder;
import org.apache.webbeans.inject.AbstractInjectable;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.web.lifecycle.test.MockHttpSession;
import org.apache.webbeans.web.lifecycle.test.MockServletContext;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.junit.rules.MethodRule;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class ApplicationComposer
extends BlockJUnit4ClassRunner {
    public static final String OPENEJB_APPLICATION_COMPOSER_CONTEXT = "openejb.application.composer.context";
    private static final Class[] MODULE_TYPES = new Class[]{IAnnotationFinder.class, ClassesArchive.class, AppModule.class, WebModule.class, EjbModule.class, Application.class, WebApp.class, EjbJar.class, EnterpriseBean.class, Persistence.class, PersistenceUnit.class, Connector.class, Beans.class, Class[].class};
    private final TestClass testClass;
    private ServiceManagerProxy serviceManager = null;

    public ApplicationComposer(Class<?> klass) throws InitializationError {
        super(klass);
        this.testClass = new TestClass(klass);
        this.validate();
        this.linkageErrorProtection();
    }

    private void linkageErrorProtection() {
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        try {
            Class.forName("sun.security.pkcs11.SunPKCS11", true, loader);
            Class.forName("sun.security.pkcs11.SunPKCS11$Descriptor", true, loader);
            Class.forName("sun.security.pkcs11.wrapper.PKCS11Exception", true, loader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void validate() throws InitializationError {
        String gripe;
        Class<?> returnType;
        List mockInjector;
        ArrayList<Exception> errors = new ArrayList<Exception>();
        List configs = this.testClass.getAnnotatedMethods(Configuration.class);
        if (configs.size() > 1) {
            String gripe2 = "Test class should have no more than one @Configuration method";
            errors.add(new Exception("Test class should have no more than one @Configuration method"));
        }
        if ((mockInjector = this.testClass.getAnnotatedMethods(MockInjector.class)).size() > 1) {
            errors.add(new Exception("Test class should have no more than one @MockInjector method"));
        }
        for (FrameworkMethod method : configs) {
            Class<?> type = method.getMethod().getReturnType();
            if (Properties.class.isAssignableFrom(type)) continue;
            String gripe3 = "@Configuration method must return " + Properties.class.getName();
            errors.add(new Exception(gripe3));
        }
        for (FrameworkMethod method : this.testClass.getAnnotatedMethods(Component.class)) {
            if (method.getMethod().getParameterTypes().length <= 0) continue;
            errors.add(new Exception("@Component methods shouldn't take any parameters"));
        }
        for (FrameworkMethod method : this.testClass.getAnnotatedMethods(Descriptors.class)) {
            returnType = method.getMethod().getReturnType();
            if (returnType.equals(WebModule.class) || returnType.equals(EjbModule.class) || returnType.equals(WebApp.class) || returnType.equals(EjbJar.class) || returnType.equals(AppModule.class)) continue;
            errors.add(new Exception("@Descriptors can't be used on " + returnType.getName()));
        }
        for (FrameworkMethod method : this.testClass.getAnnotatedMethods(Classes.class)) {
            returnType = method.getMethod().getReturnType();
            if (returnType.equals(WebModule.class) || returnType.equals(EjbModule.class) || returnType.equals(WebApp.class) || returnType.equals(EjbJar.class)) continue;
            errors.add(new Exception("@Classes can't be used on a method returning " + returnType));
        }
        int appModules = 0;
        int modules = 0;
        for (FrameworkMethod method : this.testClass.getAnnotatedMethods(Module.class)) {
            ++modules;
            Class<?> type = method.getMethod().getReturnType();
            if (Application.class.isAssignableFrom(type)) {
                ++appModules;
                continue;
            }
            if (this.isValidModuleType(type, MODULE_TYPES)) continue;
            String gripe4 = "@Module method must return " + Join.join(" or ", MODULE_TYPES).replaceAll("(class|interface) ", "");
            errors.add(new Exception(gripe4));
        }
        if (appModules > 1) {
            gripe = "Test class should have no more than one @Module method that returns " + Application.class.getName();
            errors.add(new Exception(gripe));
        }
        if (modules < 1) {
            gripe = "Test class should have at least one @Module method";
            errors.add(new Exception("Test class should have at least one @Module method"));
        }
        if (!errors.isEmpty()) {
            throw new InitializationError(errors);
        }
    }

    private boolean isValidModuleType(Class<?> type, Class[] moduleTypes) {
        for (Class moduleType : moduleTypes) {
            if (!moduleType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    protected List<MethodRule> rules(Object test) {
        List rules = super.rules(test);
        rules.add(new MethodRule(){

            public Statement apply(Statement base, FrameworkMethod method, Object target) {
                return new DeployApplication(target, base);
            }
        });
        return rules;
    }

    private static String implicitRootUrl() {
        ResourceFinder finder = new ResourceFinder("", Thread.currentThread().getContextClassLoader());
        try {
            URL url = DeploymentLoader.altDDSources(DeploymentLoader.mapDescriptors(finder), false).get("persistence.xml");
            if (url == null) {
                return "";
            }
            File file = URLs.toFile(url);
            if (file.getName().endsWith("persistence.xml")) {
                String parent = file.getParentFile().getName();
                if (parent.equalsIgnoreCase("META-INF")) {
                    return file.getParentFile().getParentFile().getAbsolutePath();
                }
                return file.getParentFile().getAbsolutePath();
            }
            return url.toExternalForm();
        }
        catch (IOException e) {
            return "";
        }
    }

    private static Map<String, URL> descriptorsToMap(Descriptors descriptors) {
        if (descriptors != null) {
            HashMap<String, URL> dds = new HashMap<String, URL>();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            for (Descriptor descriptor : descriptors.value()) {
                dds.put(descriptor.name(), loader.getResource(descriptor.path()));
            }
            return dds;
        }
        return Collections.emptyMap();
    }

    private static IAnnotationFinder finderFromClasses(Class<?>[] value) {
        return new AnnotationFinder((Archive)new ClassesArchive((Class[])value)).link();
    }

    private void initFilteredServiceManager(EnableServices services) {
        Class<?> serviceManagerClass;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            serviceManagerClass = classLoader.loadClass("org.apache.openejb.server.FilteredServiceManager");
        }
        catch (ClassNotFoundException e) {
            String msg = "Services filtering requires class 'org.apache.openejb.server.FilteredServiceManager' to be available.  Make sure you have the openejb-server-*.jar in your classpath.";
            throw new IllegalStateException(msg, e);
        }
        Method initServiceManager = null;
        try {
            initServiceManager = serviceManagerClass.getMethod("initServiceManager", String[].class);
            initServiceManager.invoke(null, new Object[]{services.value()});
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed initializing FilteredServiceManager with services " + services.value(), e);
        }
    }

    public class DeployApplication
    extends Statement {
        private final Object testInstance;
        private final Statement next;

        public DeployApplication(Object testInstance, Statement next) {
            this.testInstance = testInstance;
            this.next = next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            FrameworkMethod method;
            Object o;
            List methods;
            Iterator i$;
            Class javaClass = ApplicationComposer.this.testClass.getJavaClass();
            ClassLoader loader = javaClass.getClassLoader();
            AppModule appModule = new AppModule(loader, javaClass.getSimpleName());
            EjbJar ejbJar = new EjbJar();
            OpenejbJar openejbJar = new OpenejbJar();
            ManagedBean bean = (ManagedBean)ejbJar.addEnterpriseBean((EnterpriseBean)new ManagedBean(javaClass.getSimpleName(), javaClass.getName(), true));
            bean.setTransactionType(TransactionType.BEAN);
            EjbDeployment ejbDeployment = openejbJar.addEjbDeployment((EnterpriseBean)bean);
            ejbDeployment.setDeploymentId(javaClass.getName());
            appModule.getEjbModules().add(new EjbModule(ejbJar, openejbJar));
            Properties configuration = new Properties();
            configuration.put("openejb.deployments.classpath", "false");
            EnableServices annotation = ApplicationComposer.this.testClass.getJavaClass().getAnnotation(EnableServices.class);
            if (annotation != null && annotation.httpDebug()) {
                configuration.setProperty("httpejbd.print", "true");
                configuration.setProperty("httpejbd.indent.xml", "true");
                configuration.setProperty("logging.level.OpenEJB.server.http", "FINE");
            }
            if ((i$ = (methods = ApplicationComposer.this.testClass.getAnnotatedMethods(Configuration.class)).iterator()).hasNext() && (o = (method = (FrameworkMethod)i$.next()).invokeExplosively(this.testInstance, new Object[0])) instanceof Properties) {
                Properties properties = (Properties)o;
                configuration.putAll((Map<?, ?>)properties);
            }
            if (SystemInstance.isInitialized()) {
                SystemInstance.reset();
            }
            SystemInstance.init((Properties)configuration);
            SystemInstance.get().setComponent(TestInstance.class, (Object)new TestInstance(ApplicationComposer.this.testClass.getJavaClass(), this.testInstance));
            List mockInjectors = ApplicationComposer.this.testClass.getAnnotatedMethods(MockInjector.class);
            for (FrameworkMethod method2 : mockInjectors) {
                Object o2 = method2.invokeExplosively(this.testInstance, new Object[0]);
                if (o2 instanceof Class) {
                    o2 = ((Class)o2).newInstance();
                }
                if (!(o2 instanceof FallbackPropertyInjector)) continue;
                SystemInstance.get().setComponent(FallbackPropertyInjector.class, (Object)((FallbackPropertyInjector)o2));
            }
            for (FrameworkMethod method2 : ApplicationComposer.this.testClass.getAnnotatedMethods(Component.class)) {
                Class<?> key;
                Object value = method2.invokeExplosively(this.testInstance, new Object[0]);
                if (value instanceof Class) {
                    value = ((Class)value).newInstance();
                }
                if (!(key = method2.getMethod().getReturnType()).isInstance(value)) {
                    throw new OpenEJBRuntimeException(value + " is not an instance of " + key.getName());
                }
                SystemInstance.get().setComponent(key, value);
            }
            Map additionalDescriptors = ApplicationComposer.descriptorsToMap(ApplicationComposer.this.testClass.getJavaClass().getAnnotation(Descriptors.class));
            Application application = null;
            int webModulesNb = 0;
            for (FrameworkMethod method3 : ApplicationComposer.this.testClass.getAnnotatedMethods(Module.class)) {
                Class[] beans;
                Object bean2;
                EjbModule ejbModule;
                EjbModule ejbModule2;
                Object obj = method3.invokeExplosively(this.testInstance, new Object[0]);
                Classes classesAnnotation = (Classes)method3.getAnnotation(Classes.class);
                if (obj instanceof WebApp) {
                    ++webModulesNb;
                    WebApp webapp = (WebApp)obj;
                    String root = webapp.getContextRoot();
                    if (root == null) {
                        root = "/openejb";
                    }
                    WebModule webModule = new WebModule(webapp, root, Thread.currentThread().getContextClassLoader(), "", root);
                    webModule.getAltDDs().putAll(additionalDescriptors);
                    webModule.getAltDDs().putAll(ApplicationComposer.descriptorsToMap((Descriptors)method3.getAnnotation(Descriptors.class)));
                    if (classesAnnotation != null) {
                        webModule.setFinder(ApplicationComposer.finderFromClasses(classesAnnotation.value()));
                    }
                    DeploymentLoader.addWebModule(webModule, appModule);
                    continue;
                }
                if (obj instanceof WebModule) {
                    ++webModulesNb;
                    WebModule webModule = (WebModule)obj;
                    webModule.getAltDDs().putAll(additionalDescriptors);
                    webModule.getAltDDs().putAll(ApplicationComposer.descriptorsToMap((Descriptors)method3.getAnnotation(Descriptors.class)));
                    if (classesAnnotation != null) {
                        webModule.setFinder(ApplicationComposer.finderFromClasses(classesAnnotation.value()));
                    }
                    DeploymentLoader.addWebModule(webModule, appModule);
                    continue;
                }
                if (obj instanceof EjbModule) {
                    ejbModule2 = (EjbModule)obj;
                    ejbModule2.getAltDDs().putAll(additionalDescriptors);
                    ejbModule2.getAltDDs().putAll(ApplicationComposer.descriptorsToMap((Descriptors)method3.getAnnotation(Descriptors.class)));
                    if (classesAnnotation != null) {
                        ejbModule2.setFinder(ApplicationComposer.finderFromClasses(classesAnnotation.value()));
                    }
                    ejbModule2.initAppModule(appModule);
                    appModule.getEjbModules().add(ejbModule2);
                    continue;
                }
                if (obj instanceof EjbJar) {
                    EjbJar ejbJar2 = (EjbJar)obj;
                    this.setId(ejbJar2, method3);
                    ejbModule = new EjbModule(ejbJar2);
                    ejbModule.getAltDDs().putAll(additionalDescriptors);
                    ejbModule.getAltDDs().putAll(ApplicationComposer.descriptorsToMap((Descriptors)method3.getAnnotation(Descriptors.class)));
                    appModule.getEjbModules().add(ejbModule);
                    if (classesAnnotation == null) continue;
                    ejbModule.setFinder(ApplicationComposer.finderFromClasses(classesAnnotation.value()));
                    continue;
                }
                if (obj instanceof EnterpriseBean) {
                    bean2 = (EnterpriseBean)obj;
                    EjbJar ejbJar3 = new EjbJar(method3.getName());
                    ejbJar3.addEnterpriseBean(bean2);
                    EjbModule ejbModule3 = new EjbModule(ejbJar3);
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(bean2.getEjbClass());
                    ejbModule3.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(new Class[]{clazz})).link());
                    appModule.getEjbModules().add(ejbModule3);
                    continue;
                }
                if (obj instanceof Application) {
                    application = (Application)obj;
                    this.setId(application, method3);
                    continue;
                }
                if (obj instanceof Connector) {
                    Connector connector = (Connector)obj;
                    this.setId(connector, method3);
                    appModule.getConnectorModules().add(new ConnectorModule(connector));
                    continue;
                }
                if (obj instanceof Persistence) {
                    Persistence persistence = (Persistence)obj;
                    appModule.addPersistenceModule(new PersistenceModule(ApplicationComposer.implicitRootUrl(), persistence));
                    continue;
                }
                if (obj instanceof PersistenceUnit) {
                    PersistenceUnit unit = (PersistenceUnit)obj;
                    appModule.addPersistenceModule(new PersistenceModule(ApplicationComposer.implicitRootUrl(), new Persistence(new PersistenceUnit[]{unit})));
                    continue;
                }
                if (obj instanceof Beans) {
                    beans = (Class[])obj;
                    ejbModule = new EjbModule(new EjbJar(method3.getName()));
                    ejbModule.setBeans((Beans)beans);
                    if (classesAnnotation != null) {
                        ejbModule.setFinder(ApplicationComposer.finderFromClasses(classesAnnotation.value()));
                    }
                    appModule.getEjbModules().add(ejbModule);
                    continue;
                }
                if (obj instanceof Class[]) {
                    beans = (Class[])obj;
                    ejbModule = new EjbModule(new EjbJar(method3.getName()));
                    ejbModule.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(beans)).link());
                    ejbModule.setBeans(new Beans());
                    appModule.getEjbModules().add(ejbModule);
                    continue;
                }
                if (obj instanceof Class) {
                    bean2 = (Class)obj;
                    ejbModule = new EjbModule(new EjbJar(method3.getName()));
                    ejbModule.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)new ClassesArchive(new Class[]{bean2})).link());
                    ejbModule.setBeans(new Beans());
                    appModule.getEjbModules().add(ejbModule);
                    continue;
                }
                if (obj instanceof IAnnotationFinder) {
                    ejbModule2 = new EjbModule(new EjbJar(method3.getName()));
                    ejbModule2.setFinder((IAnnotationFinder)obj);
                    ejbModule2.setBeans(new Beans());
                    appModule.getEjbModules().add(ejbModule2);
                    continue;
                }
                if (obj instanceof ClassesArchive) {
                    ejbModule2 = new EjbModule(new EjbJar(method3.getName()));
                    ejbModule2.setFinder((IAnnotationFinder)new AnnotationFinder((Archive)obj).link());
                    ejbModule2.setBeans(new Beans());
                    appModule.getEjbModules().add(ejbModule2);
                    continue;
                }
                if (!(obj instanceof AppModule)) continue;
                AppModule module = (AppModule)obj;
                module.getAltDDs().putAll(additionalDescriptors);
                module.getAltDDs().putAll(ApplicationComposer.descriptorsToMap((Descriptors)method3.getAnnotation(Descriptors.class)));
                if (module.getWebModules().size() > 0) {
                    ++webModulesNb;
                }
                appModule.getEjbModules().addAll(module.getEjbModules());
                appModule.getPersistenceModules().addAll(module.getPersistenceModules());
                appModule.getAdditionalLibMbeans().addAll(module.getAdditionalLibMbeans());
                appModule.getWebModules().addAll(module.getWebModules());
                appModule.getConnectorModules().addAll(module.getConnectorModules());
                appModule.getResources().addAll(module.getResources());
                appModule.getServices().addAll(module.getServices());
                appModule.getPojoConfigurations().putAll(module.getPojoConfigurations());
                appModule.getAdditionalLibraries().addAll(module.getAdditionalLibraries());
                appModule.getAltDDs().putAll(module.getAltDDs());
                appModule.getProperties().putAll((Map<?, ?>)module.getProperties());
            }
            if (application != null) {
                AppModule newModule = new AppModule(appModule.getClassLoader(), appModule.getModuleId(), application, false);
                newModule.getClientModules().addAll(appModule.getClientModules());
                newModule.addPersistenceModules(appModule.getPersistenceModules());
                newModule.getEjbModules().addAll(appModule.getEjbModules());
                newModule.getConnectorModules().addAll(appModule.getConnectorModules());
                appModule = newModule;
            }
            if (webModulesNb > 0 && SystemInstance.get().getComponent(WebAppBuilder.class) == null) {
                SystemInstance.get().setComponent(WebAppBuilder.class, (Object)new LightweightWebAppBuilder());
            }
            try {
                ConfigurationFactory config = new ConfigurationFactory();
                config.init(SystemInstance.get().getProperties());
                Assembler assembler = new Assembler();
                SystemInstance.get().setComponent(Assembler.class, (Object)assembler);
                assembler.buildContainerSystem(config.getOpenEjbConfiguration());
                if ("true".equals(configuration.getProperty("openejb.embedded.remotable", "false")) || annotation != null) {
                    try {
                        if (annotation != null) {
                            ApplicationComposer.this.initFilteredServiceManager(annotation);
                        }
                        ApplicationComposer.this.serviceManager = new ServiceManagerProxy(false);
                        ApplicationComposer.this.serviceManager.start();
                    }
                    catch (ServiceManagerProxy.AlreadyStartedException e) {
                        throw new OpenEJBRuntimeException(e);
                    }
                }
                MockServletContext servletContext = new MockServletContext();
                MockHttpSession session = new MockHttpSession();
                AppInfo appInfo = config.configureApplication(appModule);
                AppContext appContext = assembler.createApplication(appInfo);
                ScopeHelper.startContexts(appContext.getWebBeansContext().getContextsService(), (ServletContext)servletContext, (HttpSession)session);
                try {
                    ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
                    BeanContext context = containerSystem.getBeanContext(javaClass.getName());
                    ThreadContext callContext = new ThreadContext(context, null, Operation.INJECTION);
                    ThreadContext oldContext = ThreadContext.enter(callContext);
                    try {
                        InjectionProcessor<Object> processor = new InjectionProcessor<Object>(this.testInstance, context.getInjections(), context.getJndiContext());
                        processor.createInstance();
                        AbstractInjectable.instanceUnderInjection.set(this.testInstance);
                        try {
                            OWBInjector.inject((BeanManager)appContext.getBeanManager(), (Object)this.testInstance, null);
                            AbstractInjectable.instanceUnderInjection.remove();
                        }
                        catch (Throwable t) {
                            try {
                                t.printStackTrace();
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                AbstractInjectable.instanceUnderInjection.remove();
                            }
                        }
                    }
                    finally {
                        ThreadContext.exit(oldContext);
                    }
                    System.setProperty("java.naming.factory.initial", InitContextFactory.class.getName());
                    System.getProperties().put(ApplicationComposer.OPENEJB_APPLICATION_COMPOSER_CONTEXT, appContext.getGlobalJndiContext());
                    List fields = ApplicationComposer.this.testClass.getAnnotatedFields(AppResource.class);
                    for (FrameworkField field : fields) {
                        Field jField;
                        Class type = field.getType();
                        if (AppModule.class.isAssignableFrom(type)) {
                            jField = field.getField();
                            jField.setAccessible(true);
                            jField.set(this.testInstance, appModule);
                            continue;
                        }
                        if (Context.class.isAssignableFrom(type)) {
                            jField = field.getField();
                            jField.setAccessible(true);
                            jField.set(this.testInstance, appContext.getGlobalJndiContext());
                            continue;
                        }
                        throw new IllegalArgumentException("can't find value for type " + type.getName());
                    }
                    ThreadContext previous = ThreadContext.enter(new ThreadContext(context, null, Operation.BUSINESS));
                    try {
                        this.next.evaluate();
                    }
                    finally {
                        ThreadContext.exit(previous);
                    }
                }
                finally {
                    ScopeHelper.stopContexts(appContext.getWebBeansContext().getContextsService(), (ServletContext)servletContext, (HttpSession)session);
                    assembler.destroyApplication(appInfo.path);
                }
            }
            finally {
                if (ApplicationComposer.this.serviceManager != null) {
                    try {
                        ApplicationComposer.this.serviceManager.stop();
                    }
                    catch (RuntimeException ignored) {}
                }
                OpenEJB.destroy();
                SystemInstance.reset();
            }
        }

        private void load(String className) {
            try {
                ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
            }
            catch (Throwable t1) {
                try {
                    ((Object)((Object)this)).getClass().getClassLoader().loadClass(className);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private <Module extends NamedModule> Module setId(Module module, FrameworkMethod method) {
            return this.setId(module, method.getName());
        }

        private <Module extends NamedModule> Module setId(Module module, String name) {
            if (module.getModuleName() != null) {
                return module;
            }
            if (module.getId() != null) {
                return module;
            }
            module.setId(name);
            return module;
        }
    }
}

