/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.xml.bind.JAXBException;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.api.LocalClient;
import org.apache.openejb.api.RemoteClient;
import org.apache.openejb.classloader.WebAppEnricher;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ClientModule;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.DeploymentFilterable;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.FinderFactory;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.config.ReadDescriptors;
import org.apache.openejb.config.RequireDescriptors;
import org.apache.openejb.config.ResourcesModule;
import org.apache.openejb.config.TldScanner;
import org.apache.openejb.config.UnknownModuleTypeException;
import org.apache.openejb.config.UnsupportedModuleTypeException;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.WebappAggregatedArchive;
import org.apache.openejb.config.WsModule;
import org.apache.openejb.config.event.BeforeDeploymentEvent;
import org.apache.openejb.core.EmptyResourcesClassLoader;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.ApplicationClient;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.FacesConfig;
import org.apache.openejb.jee.JavaWsdlMapping;
import org.apache.openejb.jee.JaxbJavaee;
import org.apache.openejb.jee.JspConfig;
import org.apache.openejb.jee.Module;
import org.apache.openejb.jee.Taglib;
import org.apache.openejb.jee.TldTaglib;
import org.apache.openejb.jee.WebApp;
import org.apache.openejb.jee.WebserviceDescription;
import org.apache.openejb.jee.Webservices;
import org.apache.openejb.jee.oejb3.OpenejbJar;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.AnnotationFinder;
import org.apache.openejb.util.JarExtractor;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.URLs;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.IAnnotationFinder;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.filter.Filter;
import org.apache.xbean.finder.filter.Filters;
import org.xml.sax.SAXException;

public class DeploymentLoader
implements DeploymentFilterable {
    public static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP_CONFIG, "org.apache.openejb.util.resources");
    public static final String OPENEJB_ALTDD_PREFIX = "openejb.altdd.prefix";
    private static final String ddDir = "META-INF/";
    public static final String EAR_WEBAPP_PERSISTENCE_XML_JARS = "ear-webapp-persistence-xml-jars";
    public static final String RAR_URLS_KEY = "rar-urls";
    public static final String URLS_KEY = "urls";
    private boolean scanManagedBeans = true;
    private static final Collection<String> KNOWN_DESCRIPTORS = Arrays.asList("app-ctx.xml", "module.properties", "application.properties", "web.xml", "ejb-jar.xml", "openejb-jar.xml", "env-entries.properties", "beans.xml", "ra.xml", "application.xml", "application-client.xml", "persistence-fragment.xml", "persistence.xml", "validation.xml", "exclusions.list");
    private static String ALTDD = SystemInstance.get().getOptions().get("openejb.altdd.prefix", (String)null);

    public AppModule load(File jarFile) throws OpenEJBException {
        Class<? extends DeploymentModule> moduleClass;
        block30: {
            AppModule appModule;
            block31: {
                URLClassLoader doNotUseClassLoader;
                URL baseUrl;
                String jarPath;
                block28: {
                    AppModule appModule2;
                    block29: {
                        block26: {
                            AppModule appModule322;
                            block27: {
                                block24: {
                                    AppModule appModule322;
                                    block25: {
                                        block22: {
                                            AppModule appModule4;
                                            block23: {
                                                block20: {
                                                    AppModule appModule52;
                                                    block21: {
                                                        block18: {
                                                            AppModule appModule6;
                                                            block19: {
                                                                try {
                                                                    jarPath = jarFile.getCanonicalPath();
                                                                }
                                                                catch (IOException e) {
                                                                    throw new OpenEJBException("Invalid application file path " + jarFile, e);
                                                                }
                                                                baseUrl = DeploymentLoader.getFileUrl(jarFile);
                                                                doNotUseClassLoader = null;
                                                                try {
                                                                    try {
                                                                        doNotUseClassLoader = ClassLoaderUtil.createClassLoader(jarPath, new URL[]{baseUrl}, this.getOpenEJBClassLoader());
                                                                        moduleClass = this.discoverModuleType(baseUrl, (ClassLoader)ClassLoaderUtil.createTempClassLoader(doNotUseClassLoader), true);
                                                                    }
                                                                    catch (Exception e) {
                                                                        throw new UnknownModuleTypeException("Unable to determine module type for jar: " + baseUrl.toExternalForm(), e);
                                                                    }
                                                                    if (!ResourcesModule.class.equals(moduleClass)) break block18;
                                                                    AppModule appModule52 = new AppModule(null, jarPath);
                                                                    ResourcesModule module = new ResourcesModule();
                                                                    module.getAltDDs().put("resources.xml", baseUrl);
                                                                    ReadDescriptors.readResourcesXml(module);
                                                                    module.initAppModule(appModule52);
                                                                    appModule6 = appModule52;
                                                                    if (null == doNotUseClassLoader) break block19;
                                                                }
                                                                catch (Throwable throwable) {
                                                                    if (null != doNotUseClassLoader) {
                                                                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                                                    }
                                                                    throw throwable;
                                                                }
                                                                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                                            }
                                                            return appModule6;
                                                        }
                                                        if (!AppModule.class.equals(moduleClass)) break block20;
                                                        appModule52 = this.createAppModule(jarFile, jarPath);
                                                        if (null == doNotUseClassLoader) break block21;
                                                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                                    }
                                                    return appModule52;
                                                }
                                                if (!EjbModule.class.equals(moduleClass)) break block22;
                                                URL[] urls = new URL[]{baseUrl};
                                                SystemInstance.get().fireEvent((Object)new BeforeDeploymentEvent(urls));
                                                URLClassLoader classLoader = ClassLoaderUtil.createTempClassLoader(jarPath, urls, this.getOpenEJBClassLoader());
                                                EjbModule ejbModule = this.createEjbModule(baseUrl, jarPath, classLoader);
                                                AppModule appModule322 = new AppModule(ejbModule);
                                                DeploymentLoader.addPersistenceUnits(appModule322, baseUrl);
                                                appModule4 = appModule322;
                                                if (null == doNotUseClassLoader) break block23;
                                                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                            }
                                            return appModule4;
                                        }
                                        if (!ClientModule.class.equals(moduleClass)) break block24;
                                        String jarLocation = URLs.toFilePath(baseUrl);
                                        ClientModule clientModule = this.createClientModule(baseUrl, jarLocation, this.getOpenEJBClassLoader(), null);
                                        appModule322 = new AppModule(clientModule);
                                        if (null == doNotUseClassLoader) break block25;
                                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                                    }
                                    return appModule322;
                                }
                                if (!ConnectorModule.class.equals(moduleClass)) break block26;
                                String jarLocation = URLs.toFilePath(baseUrl);
                                ConnectorModule connectorModule = DeploymentLoader.createConnectorModule(jarLocation, jarLocation, this.getOpenEJBClassLoader(), null);
                                appModule322 = new AppModule(connectorModule);
                                if (null == doNotUseClassLoader) break block27;
                                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                            }
                            return appModule322;
                        }
                        if (!WebModule.class.equals(moduleClass)) break block28;
                        File file = URLs.toFile(baseUrl);
                        WebModule webModule = this.createWebModule(file.getAbsolutePath(), baseUrl, this.getOpenEJBClassLoader(), this.getContextRoot(), this.getModuleName());
                        AppModule appModule7 = new AppModule(webModule.getClassLoader(), file.getAbsolutePath(), new Application(), true);
                        DeploymentLoader.addWebModule(webModule, appModule7);
                        HashMap<String, Object> otherDD = new HashMap<String, Object>();
                        List<URL> urls = webModule.getScannableUrls();
                        ResourceFinder finder = new ResourceFinder("", urls.toArray(new URL[urls.size()]));
                        otherDD.putAll(DeploymentLoader.getDescriptors(finder, false));
                        try {
                            List persistenceXmls = finder.findAll("META-INF/persistence.xml");
                            if (persistenceXmls.size() >= 1) {
                                URL old = (URL)otherDD.get("persistence.xml");
                                if (old != null && !persistenceXmls.contains(old)) {
                                    persistenceXmls.add(old);
                                }
                                otherDD.put("persistence.xml", persistenceXmls);
                            }
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        this.addConnectorModules(appModule7, webModule);
                        this.addWebPersistenceDD("persistence.xml", otherDD, appModule7);
                        this.addWebPersistenceDD("persistence-fragment.xml", otherDD, appModule7);
                        DeploymentLoader.addPersistenceUnits(appModule7, baseUrl);
                        appModule7.setStandloneWebModule();
                        appModule7.setDelegateFirst(false);
                        appModule2 = appModule7;
                        if (null == doNotUseClassLoader) break block29;
                        ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
                    }
                    return appModule2;
                }
                if (!PersistenceModule.class.equals(moduleClass)) break block30;
                String jarLocation = URLs.toFilePath(baseUrl);
                URLClassLoader classLoader = ClassLoaderUtil.createTempClassLoader(jarPath, new URL[]{baseUrl}, this.getOpenEJBClassLoader());
                AppModule appModule8 = new AppModule(classLoader, jarLocation);
                DeploymentLoader.addPersistenceUnits(appModule8, baseUrl);
                appModule = appModule8;
                if (null == doNotUseClassLoader) break block31;
                ClassLoaderUtil.destroyClassLoader(doNotUseClassLoader);
            }
            return appModule;
        }
        throw new UnsupportedModuleTypeException("Unsupported module type: " + moduleClass.getSimpleName());
    }

    private void addConnectorModules(AppModule appModule, WebModule webModule) throws OpenEJBException {
        File file;
        if (webModule.getAltDDs().containsKey("ra.xml")) {
            String jarLocation = new File(webModule.getJarLocation(), "/WEB-INF/classes").getAbsolutePath();
            ConnectorModule connectorModule = DeploymentLoader.createConnectorModule(jarLocation, jarLocation, webModule.getClassLoader(), webModule.getModuleId() + "RA", (URL)webModule.getAltDDs().get("ra.xml"));
            appModule.getConnectorModules().add(connectorModule);
        }
        for (URL url : webModule.getRarUrls()) {
            try {
                file = URLs.toFile(url);
                if (!file.getName().endsWith(".rar")) continue;
                String jarLocation = file.getAbsolutePath();
                ConnectorModule connectorModule = DeploymentLoader.createConnectorModule(jarLocation, jarLocation, webModule.getClassLoader(), null);
                appModule.getConnectorModules().add(connectorModule);
            }
            catch (Exception e) {
                logger.error("error processing url " + url.toExternalForm(), e);
            }
        }
        for (URL url : webModule.getScannableUrls()) {
            try {
                file = URLs.toFile(url);
                if (!file.getName().endsWith(".jar")) continue;
                JarFile jarFile = new JarFile(file);
                String name = (ALTDD != null ? ALTDD + "." : "") + "ra.xml";
                JarEntry entry = jarFile.getJarEntry(name);
                if (entry == null) {
                    name = ddDir + name;
                    entry = jarFile.getJarEntry(name);
                }
                if (entry == null) continue;
                String jarLocation = file.getAbsolutePath();
                ConnectorModule connectorModule = DeploymentLoader.createConnectorModule(jarLocation, jarLocation, webModule.getClassLoader(), null);
                appModule.getConnectorModules().add(connectorModule);
            }
            catch (Exception e) {
                logger.error("error processing url " + url.toExternalForm(), e);
            }
        }
    }

    protected ClassLoader getOpenEJBClassLoader() {
        return ParentClassLoaderFinder.Helper.get();
    }

    private void addWebPersistenceDD(String name, Map<String, Object> otherDD, AppModule appModule) {
        if (otherDD.containsKey(name)) {
            ArrayList<URL> persistenceUrls = (ArrayList<URL>)appModule.getAltDDs().get(name);
            if (persistenceUrls == null) {
                persistenceUrls = new ArrayList<URL>();
                appModule.getAltDDs().put(name, persistenceUrls);
            }
            if (otherDD.containsKey(name)) {
                Object otherUrl = otherDD.get(name);
                if (otherUrl instanceof URL && !persistenceUrls.contains(otherUrl)) {
                    persistenceUrls.add((URL)otherUrl);
                } else if (otherUrl instanceof List) {
                    List otherList = (List)otherDD.get(name);
                    for (URL url : otherList) {
                        if (persistenceUrls.contains(url)) continue;
                        persistenceUrls.add(url);
                    }
                }
            }
        }
    }

    protected AppModule createAppModule(File jarFile, String jarPath) throws OpenEJBException {
        File appDir = DeploymentLoader.unpack(jarFile);
        try {
            appDir = appDir.getCanonicalFile();
        }
        catch (IOException e) {
            throw new OpenEJBException("Invalid application directory " + appDir.getAbsolutePath());
        }
        URL appUrl = DeploymentLoader.getFileUrl(appDir);
        String appId = appDir.getAbsolutePath();
        URLClassLoader tmpClassLoader = ClassLoaderUtil.createTempClassLoader(appId, new URL[]{appUrl}, this.getOpenEJBClassLoader());
        ResourceFinder finder = new ResourceFinder("", (ClassLoader)tmpClassLoader, new URL[]{appUrl});
        Map<String, URL> appDescriptors = DeploymentLoader.getDescriptors(finder);
        try {
            String absolutePath;
            Map libs;
            Application application;
            HashMap<String, URL> ejbModules = new HashMap<String, URL>();
            HashMap<String, URL> clientModules = new HashMap<String, URL>();
            HashMap<String, URL> resouceModules = new HashMap<String, URL>();
            HashMap<String, URL> webModules = new HashMap<String, URL>();
            HashMap<String, String> webContextRoots = new HashMap<String, String>();
            URL applicationXmlUrl = appDescriptors.get("application.xml");
            ArrayList<URL> extraLibs = new ArrayList<URL>();
            if (applicationXmlUrl != null) {
                application = DeploymentLoader.unmarshal(Application.class, "application.xml", applicationXmlUrl);
                for (Module module : application.getModule()) {
                    try {
                        if (module.getEjb() != null) {
                            URL uRL = finder.find(module.getEjb().trim());
                            ejbModules.put(module.getEjb(), uRL);
                            continue;
                        }
                        if (module.getJava() != null) {
                            URL uRL = finder.find(module.getJava().trim());
                            clientModules.put(module.getJava(), uRL);
                            extraLibs.add(uRL);
                            continue;
                        }
                        if (module.getConnector() != null) {
                            URL uRL = finder.find(module.getConnector().trim());
                            resouceModules.put(module.getConnector(), uRL);
                            continue;
                        }
                        if (module.getWeb() == null) continue;
                        URL uRL = finder.find(module.getWeb().getWebUri().trim());
                        webModules.put(module.getWeb().getWebUri(), uRL);
                        webContextRoots.put(module.getWeb().getWebUri(), module.getWeb().getContextRoot());
                    }
                    catch (IOException iOException) {
                        throw new OpenEJBException("Invalid path to module " + iOException.getMessage(), iOException);
                    }
                }
            } else {
                application = new Application();
                HashMap<String, URL> files = new HashMap<String, URL>();
                DeploymentLoader.scanDir(appDir, files, "", false);
                files.remove("META-INF/MANIFEST.MF");
                for (Map.Entry<String, URL> entry : files.entrySet()) {
                    if (!entry.getKey().matches(".*\\.(jar|war|rar|ear)")) continue;
                    try {
                        URLClassLoader moduleClassLoader = ClassLoaderUtil.createTempClassLoader(appId, new URL[]{entry.getValue()}, tmpClassLoader);
                        Class<? extends DeploymentModule> moduleType = this.discoverModuleType(entry.getValue(), (ClassLoader)moduleClassLoader, true);
                        if (EjbModule.class.equals(moduleType)) {
                            ejbModules.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        if (ClientModule.class.equals(moduleType)) {
                            clientModules.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        if (ConnectorModule.class.equals(moduleType)) {
                            resouceModules.put(entry.getKey(), entry.getValue());
                            continue;
                        }
                        if (!WebModule.class.equals(moduleType)) continue;
                        webModules.put(entry.getKey(), entry.getValue());
                    }
                    catch (UnsupportedOperationException e) {
                        logger.info("Ignoring unknown module type: " + entry.getKey());
                    }
                    catch (UnknownModuleTypeException e) {
                        logger.info("Ignoring unknown module type: " + entry.getKey());
                    }
                    catch (Exception e) {
                        throw new OpenEJBException("Unable to determine the module type of " + entry.getKey() + ": Exception: " + e.getMessage(), e);
                    }
                }
            }
            if (application.getLibraryDirectory() == null) {
                application.setLibraryDirectory("lib/");
            } else {
                String dir = application.getLibraryDirectory();
                if (!dir.endsWith("/")) {
                    application.setLibraryDirectory(dir + "/");
                }
            }
            try {
                libs = finder.getResourcesMap(application.getLibraryDirectory());
                extraLibs.addAll(libs.values());
            }
            catch (IOException e) {
                logger.warning("Cannot load libs from '" + application.getLibraryDirectory() + "' : " + e.getMessage(), e);
            }
            try {
                libs = finder.getResourcesMap("APP-INF/lib/");
                extraLibs.addAll(libs.values());
            }
            catch (IOException e) {
                logger.warning("Cannot load libs from 'APP-INF/lib/' : " + e.getMessage(), e);
            }
            try {
                libs = finder.getResourcesMap("META-INF/lib/");
                extraLibs.addAll(libs.values());
            }
            catch (IOException e) {
                logger.warning("Cannot load libs from 'META-INF/lib/' : " + e.getMessage(), e);
            }
            HashMap<String, URL> rarLibs = new HashMap<String, URL>();
            for (Map.Entry<String, URL> entry : resouceModules.entrySet()) {
                try {
                    File rarFile = URLs.toFile(entry.getValue());
                    rarFile = DeploymentLoader.unpack(rarFile);
                    entry.setValue(rarFile.toURI().toURL());
                    DeploymentLoader.scanDir(appDir, rarLibs, "");
                }
                catch (MalformedURLException e) {
                    throw new OpenEJBException("Malformed URL to app. " + e.getMessage(), e);
                }
            }
            Iterator iterator = rarLibs.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!((String)entry.getKey()).endsWith(".jar")) continue;
                iterator.remove();
            }
            ArrayList<Object> classPath = new ArrayList<Object>();
            classPath.addAll(ejbModules.values());
            classPath.addAll(clientModules.values());
            classPath.addAll(rarLibs.values());
            classPath.addAll(extraLibs);
            URL[] uRLArray = classPath.toArray(new URL[classPath.size()]);
            SystemInstance.get().fireEvent((Object)new BeforeDeploymentEvent(uRLArray));
            URLClassLoader appClassLoader = ClassLoaderUtil.createTempClassLoader(appId, uRLArray, this.getOpenEJBClassLoader());
            AppModule appModule = new AppModule(appClassLoader, appId, application, false);
            appModule.getAdditionalLibraries().addAll(extraLibs);
            appModule.getAltDDs().putAll(appDescriptors);
            appModule.getWatchedResources().add(appId);
            if (applicationXmlUrl != null) {
                appModule.getWatchedResources().add(URLs.toFilePath(applicationXmlUrl));
            }
            for (String moduleName : ejbModules.keySet()) {
                try {
                    URL ejbUrl = (URL)ejbModules.get(moduleName);
                    if (ClassLoaderUtil.isUrlCached(appModule.getJarLocation(), ejbUrl)) {
                        try {
                            ejbUrl = ClassLoaderUtil.getUrlCachedName(appModule.getJarLocation(), ejbUrl).toURI().toURL();
                        }
                        catch (MalformedURLException ignore) {
                            // empty catch block
                        }
                    }
                    File ejbFile = URLs.toFile(ejbUrl);
                    absolutePath = ejbFile.getAbsolutePath();
                    EjbModule ejbModule = this.createEjbModule(ejbUrl, absolutePath, appClassLoader);
                    appModule.getEjbModules().add(ejbModule);
                }
                catch (OpenEJBException e) {
                    logger.error("Unable to load EJBs from EAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            for (String moduleName : clientModules.keySet()) {
                try {
                    URL clientUrl = (URL)clientModules.get(moduleName);
                    if (ClassLoaderUtil.isUrlCached(appModule.getJarLocation(), clientUrl)) {
                        try {
                            clientUrl = ClassLoaderUtil.getUrlCachedName(appModule.getJarLocation(), clientUrl).toURI().toURL();
                        }
                        catch (MalformedURLException ignore) {
                            // empty catch block
                        }
                    }
                    File clientFile = URLs.toFile(clientUrl);
                    absolutePath = clientFile.getAbsolutePath();
                    ClientModule clientModule = this.createClientModule(clientUrl, absolutePath, appClassLoader, null);
                    appModule.getClientModules().add(clientModule);
                }
                catch (Exception e) {
                    logger.error("Unable to load App Client from EAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            for (String moduleName : resouceModules.keySet()) {
                try {
                    URL rarUrl = (URL)resouceModules.get(moduleName);
                    if (ClassLoaderUtil.isUrlCached(appModule.getJarLocation(), rarUrl)) {
                        try {
                            rarUrl = ClassLoaderUtil.getUrlCachedName(appModule.getJarLocation(), rarUrl).toURI().toURL();
                        }
                        catch (MalformedURLException ignore) {
                            // empty catch block
                        }
                    }
                    ConnectorModule connectorModule = DeploymentLoader.createConnectorModule(appId, URLs.toFilePath(rarUrl), appClassLoader, moduleName);
                    appModule.getConnectorModules().add(connectorModule);
                }
                catch (OpenEJBException e) {
                    logger.error("Unable to load RAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            for (String moduleName : webModules.keySet()) {
                try {
                    URL warUrl = (URL)webModules.get(moduleName);
                    this.addWebModule(appModule, warUrl, appClassLoader, (String)webContextRoots.get(moduleName), null);
                }
                catch (OpenEJBException e) {
                    logger.error("Unable to load WAR: " + appId + ", module: " + moduleName + ". Exception: " + e.getMessage(), e);
                }
            }
            this.addBeansXmls(appModule);
            Properties p = new Properties();
            p.put(appModule.getModuleId(), appModule.getJarLocation());
            FileUtils base = new FileUtils(appModule.getModuleId(), appModule.getModuleId(), (Hashtable)p);
            ArrayList<URL> filteredUrls = new ArrayList<URL>();
            DeploymentsResolver.loadFromClasspath(base, filteredUrls, appModule.getClassLoader());
            DeploymentLoader.addPersistenceUnits(appModule, filteredUrls.toArray(new URL[filteredUrls.size()]));
            for (WebModule webModule : appModule.getWebModules()) {
                List<URL> scannableUrls = webModule.getScannableUrls();
                ArrayList<URL> foundRootUrls = new ArrayList<URL>();
                for (URL url : scannableUrls) {
                    if (DeploymentLoader.addPersistenceUnits(appModule, url).isEmpty()) continue;
                    foundRootUrls.add(url);
                }
                webModule.getAltDDs().put(EAR_WEBAPP_PERSISTENCE_XML_JARS, foundRootUrls);
            }
            for (DeploymentModule module : appModule.getDeploymentModule()) {
                module.setStandaloneModule(false);
            }
            return appModule;
        }
        catch (OpenEJBException e) {
            logger.error("Unable to load EAR: " + jarPath, e);
            throw e;
        }
    }

    protected ClientModule createClientModule(URL clientUrl, String absolutePath, ClassLoader appClassLoader, String moduleName) throws OpenEJBException {
        return this.createClientModule(clientUrl, absolutePath, appClassLoader, moduleName, true);
    }

    protected ClientModule createClientModule(URL clientUrl, String absolutePath, ClassLoader appClassLoader, String moduleName, boolean log) throws OpenEJBException {
        ResourceFinder clientFinder = new ResourceFinder(new URL[]{clientUrl});
        URL manifestUrl = null;
        try {
            manifestUrl = clientFinder.find("META-INF/MANIFEST.MF");
        }
        catch (IOException e) {
            // empty catch block
        }
        String mainClass = null;
        if (manifestUrl != null) {
            try {
                InputStream is = IO.read((URL)manifestUrl);
                Manifest manifest = new Manifest(is);
                mainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
            }
            catch (IOException e) {
                throw new OpenEJBException("Unable to determine Main-Class defined in META-INF/MANIFEST.MF file", e);
            }
        }
        Map<String, URL> descriptors = DeploymentLoader.getDescriptors(clientFinder, log);
        ApplicationClient applicationClient = null;
        URL clientXmlUrl = descriptors.get("application-client.xml");
        if (clientXmlUrl != null) {
            applicationClient = ReadDescriptors.readApplicationClient(clientXmlUrl);
        }
        ClientModule clientModule = new ClientModule(applicationClient, appClassLoader, absolutePath, mainClass, moduleName);
        clientModule.getAltDDs().putAll(descriptors);
        if (absolutePath != null) {
            clientModule.getWatchedResources().add(absolutePath);
        }
        if (clientXmlUrl != null && "file".equals(clientXmlUrl.getProtocol())) {
            clientModule.getWatchedResources().add(URLs.toFilePath(clientXmlUrl));
        }
        return clientModule;
    }

    protected EjbModule createEjbModule(URL baseUrl, String jarPath, ClassLoader classLoader) throws OpenEJBException {
        Map<String, URL> descriptors;
        if (baseUrl != null) {
            descriptors = DeploymentLoader.getDescriptors(baseUrl);
        } else {
            try {
                descriptors = this.getDescriptors(classLoader, null);
            }
            catch (IOException e) {
                descriptors = new HashMap<String, URL>();
            }
        }
        EjbJar ejbJar = null;
        URL ejbJarXmlUrl = descriptors.get("ejb-jar.xml");
        if (ejbJarXmlUrl != null) {
            try {
                ejbJar = ReadDescriptors.readEjbJar(ejbJarXmlUrl.openStream());
            }
            catch (IOException e) {
                throw new OpenEJBException(e);
            }
        }
        EjbModule ejbModule = new EjbModule(classLoader, null, jarPath, ejbJar, null);
        ejbModule.getAltDDs().putAll(descriptors);
        if (jarPath != null) {
            ejbModule.getWatchedResources().add(jarPath);
        }
        if (ejbJarXmlUrl != null && "file".equals(ejbJarXmlUrl.getProtocol())) {
            ejbModule.getWatchedResources().add(URLs.toFilePath(ejbJarXmlUrl));
        }
        ejbModule.setClientModule(this.createClientModule(baseUrl, jarPath, classLoader, null, false));
        DeploymentLoader.addWebservices(ejbModule);
        return ejbModule;
    }

    private WebModule createWebModule(String jar, URL warUrl, ClassLoader parentClassLoader, String contextRoot, String moduleName) throws OpenEJBException {
        return this.createWebModule(jar, URLs.toFilePath(warUrl), parentClassLoader, contextRoot, moduleName);
    }

    public void addWebModule(AppModule appModule, URL warUrl, ClassLoader parentClassLoader, String contextRoot, String moduleName) throws OpenEJBException {
        WebModule webModule = this.createWebModule(appModule.getJarLocation(), URLs.toFilePath(warUrl), parentClassLoader, contextRoot, moduleName);
        List<URL> parentUrls = DeploymentLoader.filterWebappUrls(appModule.getAdditionalLibraries().toArray(new URL[appModule.getAdditionalLibraries().size()]), (URL)webModule.getAltDDs().get("exclusions.list"));
        webModule.getScannableUrls().addAll(parentUrls);
        DeploymentLoader.addWebModule(webModule, appModule);
    }

    public static EjbModule addWebModule(WebModule webModule, AppModule appModule) throws OpenEJBException {
        Object o;
        ArrayList<URL> persistenceXmls;
        appModule.getWebModules().add(webModule);
        if (appModule.isStandaloneModule()) {
            appModule.getAdditionalLibraries().addAll(webModule.getUrls());
        }
        if ((persistenceXmls = (ArrayList<URL>)appModule.getAltDDs().get("persistence.xml")) == null) {
            persistenceXmls = new ArrayList<URL>();
            appModule.getAltDDs().put("persistence.xml", persistenceXmls);
        }
        if ((o = webModule.getAltDDs().get("persistence.xml")) instanceof URL) {
            URL url = (URL)o;
            persistenceXmls.add(url);
        }
        if (o instanceof List) {
            List urls = (List)o;
            persistenceXmls.addAll(urls);
        }
        EjbModule webEjbModule = new EjbModule(webModule.getClassLoader(), webModule.getModuleId(), webModule.getJarLocation(), null, null);
        webEjbModule.setWebapp(true);
        webEjbModule.getAltDDs().putAll(webModule.getAltDDs());
        appModule.getEjbModules().add(webEjbModule);
        try {
            DeploymentLoader.fillEjbJar(webModule, webEjbModule);
            if (webModule.getFinder() == null) {
                IAnnotationFinder finder;
                if (DeploymentLoader.isMetadataComplete(webModule, webEjbModule)) {
                    finder = new AnnotationFinder((Archive)new ClassesArchive(new Class[0]));
                    webModule.setFinder(finder);
                    webEjbModule.setFinder(finder);
                } else {
                    finder = FinderFactory.createFinder(webModule);
                    webModule.setFinder(finder);
                    webEjbModule.setFinder(finder);
                }
            } else if (webEjbModule.getFinder() == null) {
                webEjbModule.setFinder(webModule.getFinder());
            }
        }
        catch (Exception e) {
            throw new OpenEJBException("Unable to create annotation scanner for web module " + webModule.getModuleId(), e);
        }
        DeploymentLoader.addWebservices(webEjbModule);
        return webEjbModule;
    }

    private static void fillEjbJar(WebModule webModule, EjbModule ejbModule) {
        Object o = webModule.getAltDDs().get("ejb-jar.xml");
        if (o != null) {
            return;
        }
        if (ejbModule.getEjbJar() != null) {
            return;
        }
        EjbJar ejbJar = new EjbJar();
        WebApp webApp = webModule.getWebApp();
        ejbJar.setMetadataComplete(webApp.isMetadataComplete());
        ejbModule.setEjbJar(ejbJar);
    }

    private static boolean isMetadataComplete(WebModule webModule, EjbModule ejbModule) {
        if (webModule.getWebApp() == null) {
            return false;
        }
        if (!webModule.getWebApp().isMetadataComplete().booleanValue()) {
            return false;
        }
        if (webModule.getAltDDs().get("beans.xml") == null) {
            return true;
        }
        if (ejbModule.getEjbJar() == null) {
            return true;
        }
        return ejbModule.getEjbJar().isMetadataComplete();
    }

    public WebModule createWebModule(String appId, String warPath, ClassLoader parentClassLoader, String contextRoot, String moduleName) throws OpenEJBException {
        Map<String, URL> descriptors;
        File warFile = new File(warPath);
        if (!warFile.isDirectory()) {
            warFile = DeploymentLoader.unpack(warFile);
        }
        try {
            descriptors = this.getWebDescriptors(warFile);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to collect descriptors in web module: " + contextRoot, e);
        }
        URL webXmlUrl = descriptors.get("web.xml");
        WebApp webApp = webXmlUrl != null ? ReadDescriptors.readWebApp(webXmlUrl) : new WebApp();
        Map<String, URL[]> urls = DeploymentLoader.getWebappUrlsAndRars(warFile);
        ArrayList<URL> webUrls = new ArrayList<URL>();
        webUrls.addAll(Arrays.asList((Object[])urls.get(URLS_KEY)));
        ArrayList<URL> addedUrls = new ArrayList<URL>();
        for (URL url : urls.get(RAR_URLS_KEY)) {
            File[] files = DeploymentLoader.unpack(URLs.toFile(url)).listFiles();
            if (files == null) continue;
            for (File f : files) {
                if (!f.getName().endsWith(".jar")) continue;
                try {
                    addedUrls.add(f.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.warning("War path bad: " + f.getAbsolutePath(), e);
                }
            }
        }
        webUrls.addAll(addedUrls);
        URL[] webUrlsArray = webUrls.toArray(new URL[webUrls.size()]);
        SystemInstance.get().fireEvent((Object)new BeforeDeploymentEvent(webUrlsArray, parentClassLoader));
        URLClassLoader warClassLoader = ClassLoaderUtil.createTempClassLoader(appId, webUrlsArray, parentClassLoader);
        WebModule webModule = new WebModule(webApp, contextRoot, warClassLoader, warFile.getAbsolutePath(), moduleName);
        webModule.setUrls(webUrls);
        webModule.setAddedUrls(addedUrls);
        webModule.setRarUrls(Arrays.asList((Object[])urls.get(RAR_URLS_KEY)));
        webModule.setScannableUrls(DeploymentLoader.filterWebappUrls(webUrlsArray, descriptors.get("exclusions.list")));
        webModule.getAltDDs().putAll(descriptors);
        webModule.getWatchedResources().add(warPath);
        webModule.getWatchedResources().add(warFile.getAbsolutePath());
        if (webXmlUrl != null && "file".equals(webXmlUrl.getProtocol())) {
            webModule.getWatchedResources().add(URLs.toFilePath(webXmlUrl));
        }
        this.addTagLibraries(webModule);
        DeploymentLoader.addWebservices(webModule);
        this.addFacesConfigs(webModule);
        this.addBeansXmls(webModule);
        return webModule;
    }

    public static List<URL> filterWebappUrls(URL[] webUrls, URL exclusions) {
        Filter excludeFilter = null;
        if (exclusions != null) {
            try {
                String[] prefixes = NewLoaderLogic.readInputStreamList(exclusions.openStream());
                excludeFilter = Filters.prefixes((String[])prefixes);
            }
            catch (IOException e) {
                logger.warning("can't read " + exclusions.toExternalForm());
            }
        }
        UrlSet urls = new UrlSet(webUrls);
        try {
            urls = NewLoaderLogic.applyBuiltinExcludes(urls, null, excludeFilter);
        }
        catch (MalformedURLException e) {
            return Arrays.asList(webUrls);
        }
        return urls.getUrls();
    }

    private void addBeansXmls(WebModule webModule) {
        ArrayList<URL> xmls;
        List<URL> urls = webModule.getScannableUrls();
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), (ClassLoader)new EmptyResourcesClassLoader());
        try {
            xmls = Collections.list(loader.getResources("META-INF/beans.xml"));
            xmls.add((URL)webModule.getAltDDs().get("beans.xml"));
        }
        catch (IOException e) {
            return;
        }
        Beans complete = null;
        for (URL url : xmls) {
            if (url == null) continue;
            complete = this.mergeBeansXml(complete, url);
        }
        webModule.getAltDDs().put("beans.xml", complete);
    }

    private Beans mergeBeansXml(Beans current, URL url) {
        Beans returnValue = current;
        try {
            Beans beans;
            try {
                beans = ReadDescriptors.readBeans(url.openStream());
            }
            catch (IOException e) {
                return returnValue;
            }
            if (current == null) {
                returnValue = beans;
            } else {
                current.getAlternativeClasses().addAll(beans.getAlternativeClasses());
                current.getAlternativeStereotypes().addAll(beans.getAlternativeStereotypes());
                current.getDecorators().addAll(beans.getDecorators());
                current.getInterceptors().addAll(beans.getInterceptors());
            }
            ReadDescriptors.checkDuplicatedByBeansXml(beans, returnValue);
        }
        catch (OpenEJBException e) {
            logger.error("Unable to read beans.xml from :" + url.toExternalForm());
        }
        return returnValue;
    }

    private void addBeansXmls(AppModule appModule) {
        ArrayList<URL> xmls;
        List<URL> urls = appModule.getAdditionalLibraries();
        URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]));
        try {
            xmls = Collections.list(loader.getResources("META-INF/beans.xml"));
        }
        catch (IOException e) {
            return;
        }
        Beans complete = null;
        for (URL url : xmls) {
            if (url == null) continue;
            complete = this.mergeBeansXml(complete, url);
        }
        if (complete == null) {
            return;
        }
        EjbModule ejbModule = new EjbModule(appModule.getClassLoader(), "ear-scoped-cdi-beans_" + appModule.getModuleId(), new EjbJar(), new OpenejbJar());
        ejbModule.setBeans(complete);
        ejbModule.setFinder(new FinderFactory.ModuleLimitedFinder((IAnnotationFinder)new AnnotationFinder((Archive)new WebappAggregatedArchive(appModule.getClassLoader(), appModule.getAltDDs(), xmls))));
        appModule.getEjbModules().add(ejbModule);
    }

    protected String getContextRoot() {
        return null;
    }

    protected String getModuleName() {
        return null;
    }

    public static Map<String, URL[]> getWebappUrlsAndRars(File warFile) {
        WebAppEnricher enricher;
        File[] list;
        HashSet<URL> webClassPath = new HashSet<URL>();
        HashSet<URL> webRars = new HashSet<URL>();
        File webInfDir = new File(warFile, "WEB-INF");
        try {
            webClassPath.add(new File(webInfDir, "classes").toURI().toURL());
        }
        catch (MalformedURLException e) {
            logger.warning("War path bad: " + new File(webInfDir, "classes"), e);
        }
        File libDir = new File(webInfDir, "lib");
        if (libDir.exists() && (list = libDir.listFiles()) != null) {
            for (File file : list) {
                String name = file.getName();
                if (name.endsWith(".jar") || name.endsWith(".zip")) {
                    try {
                        webClassPath.add(file.toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        logger.warning("War path bad: " + file, e);
                    }
                    continue;
                }
                if (!name.endsWith(".rar")) continue;
                try {
                    webRars.add(file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.warning("War path bad: " + file, e);
                }
            }
        }
        if ((enricher = (WebAppEnricher)SystemInstance.get().getComponent(WebAppEnricher.class)) != null) {
            webClassPath.addAll(Arrays.asList(enricher.enrichment(null)));
        }
        HashMap<String, URL[]> urls = new HashMap<String, URL[]>();
        urls.put(URLS_KEY, webClassPath.toArray(new URL[webClassPath.size()]));
        urls.put(RAR_URLS_KEY, webRars.toArray(new URL[webRars.size()]));
        return urls;
    }

    public static URL[] getWebappUrls(File warFile) {
        return DeploymentLoader.getWebappUrlsAndRars(warFile).get(URLS_KEY);
    }

    private static void addWebservices(WsModule wsModule) throws OpenEJBException {
        URL moduleUrl;
        boolean webservicesEnabled = SystemInstance.get().getOptions().get("openejb.webservices.enabled", true);
        if (!webservicesEnabled) {
            wsModule.getAltDDs().remove("webservices.xml");
            wsModule.setWebservices(null);
            return;
        }
        Object webservicesObject = wsModule.getAltDDs().get("webservices.xml");
        if (webservicesObject == null || !(webservicesObject instanceof URL)) {
            return;
        }
        URL webservicesUrl = (URL)webservicesObject;
        try {
            File jarFile = new File(wsModule.getJarLocation());
            moduleUrl = jarFile.toURI().toURL();
            if (jarFile.isFile()) {
                moduleUrl = new URL("jar", "", -1, moduleUrl + "!/");
            }
        }
        catch (MalformedURLException e) {
            logger.warning("Invalid module location " + wsModule.getJarLocation());
            return;
        }
        HashMap<URL, JavaWsdlMapping> jaxrpcMappingCache = new HashMap<URL, JavaWsdlMapping>();
        Webservices webservices = ReadDescriptors.readWebservices(webservicesUrl);
        wsModule.setWebservices(webservices);
        if ("file".equals(webservicesUrl.getProtocol())) {
            wsModule.getWatchedResources().add(URLs.toFilePath(webservicesUrl));
        }
        for (WebserviceDescription webserviceDescription : webservices.getWebserviceDescription()) {
            String jaxrpcMappingFile = webserviceDescription.getJaxrpcMappingFile();
            if (jaxrpcMappingFile == null) continue;
            try {
                URL jaxrpcMappingUrl = new URL(moduleUrl, jaxrpcMappingFile);
                JavaWsdlMapping jaxrpcMapping = (JavaWsdlMapping)jaxrpcMappingCache.get(jaxrpcMappingUrl);
                if (jaxrpcMapping == null) {
                    jaxrpcMapping = ReadDescriptors.readJaxrpcMapping(jaxrpcMappingUrl);
                    jaxrpcMappingCache.put(jaxrpcMappingUrl, jaxrpcMapping);
                }
                webserviceDescription.setJaxrpcMapping(jaxrpcMapping);
                if (!"file".equals(jaxrpcMappingUrl.getProtocol())) continue;
                wsModule.getWatchedResources().add(URLs.toFilePath(jaxrpcMappingUrl));
            }
            catch (MalformedURLException e) {
                logger.warning("Invalid jaxrpc-mapping-file location " + jaxrpcMappingFile);
            }
        }
    }

    private void addTagLibraries(WebModule webModule) throws OpenEJBException {
        HashSet<URL> tldLocations = new HashSet<URL>();
        File warFile = new File(webModule.getJarLocation());
        WebApp webApp = webModule.getWebApp();
        if (webApp != null) {
            for (JspConfig jspConfig : webApp.getJspConfig()) {
                for (Taglib taglib : jspConfig.getTaglib()) {
                    String location = taglib.getTaglibLocation();
                    if (!location.startsWith("/")) {
                        location = "/WEB-INF/" + location;
                    }
                    try {
                        File file = new File(warFile, location).getCanonicalFile().getAbsoluteFile();
                        tldLocations.addAll(TldScanner.scanForTagLibs(file));
                    }
                    catch (IOException e) {
                        logger.warning("JSP tag library location bad: " + location, e);
                    }
                }
            }
        }
        Set<URL> urls = TldScanner.scanWarForTagLibs(warFile);
        tldLocations.addAll(urls);
        ClassLoader parentClassLoader = webModule.getClassLoader().getParent();
        urls = TldScanner.scan(parentClassLoader);
        tldLocations.addAll(urls);
        for (URL location : tldLocations) {
            TldTaglib taglib = ReadDescriptors.readTldTaglib(location);
            webModule.getTaglibs().add(taglib);
            if (!"file".equals(location.getProtocol())) continue;
            webModule.getWatchedResources().add(URLs.toFilePath(location));
        }
    }

    private void addFacesConfigs(WebModule webModule) throws OpenEJBException {
        File facesConfigFile;
        File webInf;
        HashSet<URL> facesConfigLocations = new HashSet<URL>();
        File warFile = new File(webModule.getJarLocation());
        WebApp webApp = webModule.getWebApp();
        if (webApp != null) {
            String foundContextParam = (String)webApp.contextParamsAsMap().get("javax.faces.CONFIG_FILES");
            if (foundContextParam != null) {
                String commaDelimitedListOfFiles = foundContextParam.trim();
                String[] configFiles = commaDelimitedListOfFiles.split(",");
                String[] trimmedConfigFiles = new String[configFiles.length];
                for (int i = 0; i < configFiles.length; ++i) {
                    trimmedConfigFiles[i] = configFiles[i].trim();
                }
                for (String location : trimmedConfigFiles) {
                    if (!location.startsWith("/")) {
                        logger.error("A faces configuration file should be context relative when specified in web.xml. Please fix the value of context parameter javax.faces.CONFIG_FILES for the file " + location);
                    }
                    try {
                        File file = new File(warFile, location).getCanonicalFile().getAbsoluteFile();
                        URL url = file.toURI().toURL();
                        facesConfigLocations.add(url);
                    }
                    catch (IOException e) {
                        logger.error("Faces configuration file location bad: " + location, e);
                    }
                }
            } else {
                logger.debug("faces config file is null");
            }
        }
        if ((webInf = new File(warFile, "WEB-INF")).isDirectory() && (facesConfigFile = new File(webInf, "faces-config.xml")).exists()) {
            try {
                facesConfigFile = facesConfigFile.getCanonicalFile().getAbsoluteFile();
                URL url = facesConfigFile.toURI().toURL();
                facesConfigLocations.add(url);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (URL location : facesConfigLocations) {
            FacesConfig facesConfig = ReadDescriptors.readFacesConfig(location);
            webModule.getFacesConfigs().add(facesConfig);
            if (!"file".equals(location.getProtocol())) continue;
            webModule.getWatchedResources().add(URLs.toFilePath(location));
        }
    }

    protected static ConnectorModule createConnectorModule(String appId, String rarPath, ClassLoader parentClassLoader, String moduleId) throws OpenEJBException {
        return DeploymentLoader.createConnectorModule(appId, rarPath, parentClassLoader, moduleId, null);
    }

    protected static ConnectorModule createConnectorModule(String appId, String rarPath, ClassLoader parentClassLoader, String moduleId, URL raXmlUrl) throws OpenEJBException {
        File rarFile = new File(rarPath);
        rarFile = DeploymentLoader.unpack(rarFile);
        URL baseUrl = DeploymentLoader.getFileUrl(rarFile);
        Map<String, URL> descriptors = DeploymentLoader.getDescriptors(baseUrl);
        Connector connector = null;
        URL rarXmlUrl = descriptors.get("ra.xml");
        if (rarXmlUrl == null && raXmlUrl != null) {
            descriptors.put("ra.xml", raXmlUrl);
            rarXmlUrl = raXmlUrl;
        }
        if (rarXmlUrl != null) {
            connector = ReadDescriptors.readConnector(rarXmlUrl);
        }
        HashMap<String, URL> rarLibs = new HashMap<String, URL>();
        DeploymentLoader.scanDir(rarFile, rarLibs, "");
        Iterator<Map.Entry<String, URL>> iterator = rarLibs.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, URL> fileEntry = iterator.next();
            if (fileEntry.getKey().endsWith(".jar")) continue;
            iterator.remove();
        }
        ArrayList<URL> classPath = new ArrayList<URL>();
        classPath.addAll(rarLibs.values());
        URL[] urls = classPath.toArray(new URL[classPath.size()]);
        URLClassLoader appClassLoader = ClassLoaderUtil.createTempClassLoader(appId, urls, parentClassLoader);
        ConnectorModule connectorModule = new ConnectorModule(connector, appClassLoader, rarPath, moduleId);
        connectorModule.getAltDDs().putAll(descriptors);
        connectorModule.getLibraries().addAll(classPath);
        connectorModule.getWatchedResources().add(rarPath);
        connectorModule.getWatchedResources().add(rarFile.getAbsolutePath());
        if (rarXmlUrl != null && "file".equals(rarXmlUrl.getProtocol())) {
            connectorModule.getWatchedResources().add(URLs.toFilePath(rarXmlUrl));
        }
        return connectorModule;
    }

    protected static Collection<URL> addPersistenceUnits(AppModule appModule, URL ... urls) throws OpenEJBException {
        String urlString;
        URL descriptor;
        Map<String, URL> descriptors;
        ResourceFinder finder;
        ArrayList<URL> persistenceFragmentsUrls;
        ArrayList<Object> persistenceUrls;
        ArrayList<URL> added = new ArrayList<URL>();
        try {
            persistenceUrls = (ArrayList<Object>)appModule.getAltDDs().get("persistence.xml");
        }
        catch (ClassCastException e) {
            Object value = appModule.getAltDDs().get("persistence.xml");
            persistenceUrls = new ArrayList<Object>();
            persistenceUrls.add(URL.class.cast(value));
            added.add((URL)persistenceUrls.iterator().next());
            appModule.getAltDDs().put("persistence.xml", persistenceUrls);
        }
        if (persistenceUrls == null) {
            persistenceUrls = new ArrayList();
            appModule.getAltDDs().put("persistence.xml", persistenceUrls);
        }
        if ((persistenceFragmentsUrls = (ArrayList<URL>)appModule.getAltDDs().get("persistence-fragment.xml")) == null) {
            persistenceFragmentsUrls = new ArrayList<URL>();
            appModule.getAltDDs().put("persistence-fragment.xml", persistenceFragmentsUrls);
        }
        for (URL url : urls) {
            finder = new ResourceFinder("", appModule.getClassLoader(), new URL[]{url});
            descriptors = DeploymentLoader.getDescriptors(finder, false);
            if (!descriptors.containsKey("persistence.xml") || persistenceUrls.contains(descriptor = descriptors.get("persistence.xml"))) continue;
            urlString = descriptor.toExternalForm();
            if (!urlString.contains("META-INF/persistence.xml")) {
                logger.info("AltDD persistence.xml -> " + urlString);
            }
            persistenceUrls.add(descriptor);
            added.add(descriptor);
        }
        for (URL url : urls) {
            finder = new ResourceFinder("", appModule.getClassLoader(), new URL[]{url});
            descriptors = DeploymentLoader.getDescriptors(finder, false);
            if (!descriptors.containsKey("persistence-fragment.xml") || persistenceFragmentsUrls.contains(descriptor = descriptors.get("persistence-fragment.xml"))) continue;
            urlString = descriptor.toExternalForm();
            if (!urlString.contains("META-INF/persistence-fragment.xml")) {
                logger.info("AltDD persistence-fragment.xml -> " + urlString);
            }
            persistenceFragmentsUrls.add(descriptor);
            added.add(descriptor);
        }
        return added;
    }

    public static Map<String, URL> getDescriptors(URL moduleUrl) throws OpenEJBException {
        ResourceFinder finder = new ResourceFinder(new URL[]{moduleUrl});
        return DeploymentLoader.getDescriptors(finder);
    }

    private static Map<String, URL> getDescriptors(ResourceFinder finder) throws OpenEJBException {
        return DeploymentLoader.getDescriptors(finder, true);
    }

    private static Map<String, URL> getDescriptors(ResourceFinder finder, boolean log) throws OpenEJBException {
        try {
            return DeploymentLoader.altDDSources(DeploymentLoader.mapDescriptors(finder), log);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to determine descriptors in jar.", e);
        }
    }

    public static Map<String, URL> mapDescriptors(ResourceFinder finder) throws IOException {
        Map map = finder.getResourcesMap(ddDir);
        if (map.size() == 0) {
            for (String descriptor : KNOWN_DESCRIPTORS) {
                URL url = finder.getResource(ddDir + descriptor);
                if (url == null) continue;
                map.put(descriptor, url);
            }
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<String, URL> altDDSources(Map<String, URL> map, boolean log) {
        if (ALTDD == null || ALTDD.length() <= 0) {
            return map;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(ALTDD.split(",")));
        Collections.reverse(list);
        HashMap<String, URL> alts = new HashMap<String, URL>();
        for (String string : list) {
            String string2 = string.trim();
            if (!string2.matches(".*[.-]$")) {
                String string3 = string2 + ".";
            }
            for (Map.Entry<String, URL> entry : new HashMap<String, URL>(map).entrySet()) {
                void var5_5;
                String key = entry.getKey();
                URL value = entry.getValue();
                if (!key.startsWith((String)var5_5)) continue;
                key = key.substring(var5_5.length());
                alts.put(key, value);
            }
        }
        for (Map.Entry entry : alts.entrySet()) {
            String key = (String)entry.getKey();
            URL value = (URL)entry.getValue();
            if (value.equals(map.get(key))) continue;
            if (log) {
                logger.info("AltDD " + key + " -> " + value.toExternalForm());
            }
            map.put(key, value);
        }
        return map;
    }

    protected Map<String, URL> getWebDescriptors(File warFile) throws IOException {
        File[] files;
        File webInfDir;
        TreeMap<String, URL> descriptors = new TreeMap<String, URL>();
        if (warFile.isFile()) {
            URL jarURL = new URL("jar", "", -1, warFile.toURI().toURL() + "!/");
            try {
                JarFile jarFile = new JarFile(warFile);
                for (JarEntry entry : Collections.list(jarFile.entries())) {
                    String entryName = entry.getName();
                    if (entry.isDirectory() || !entryName.startsWith("WEB-INF/") || !KNOWN_DESCRIPTORS.contains(entryName.substring("WEB-INF/".length())) && !entryName.endsWith(".xml")) continue;
                    descriptors.put(entryName, new URL(jarURL, entry.getName()));
                }
            }
            catch (IOException e) {}
        } else if (warFile.isDirectory() && (webInfDir = new File(warFile, "WEB-INF")).isDirectory() && (files = webInfDir.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) continue;
                descriptors.put(file.getName(), file.toURI().toURL());
            }
        }
        return descriptors;
    }

    protected File getFile(URL warUrl) {
        if ("jar".equals(warUrl.getProtocol())) {
            String pathname = warUrl.getPath();
            if (!pathname.startsWith("file:")) {
                return null;
            }
            pathname = pathname.substring("file:".length());
            pathname = pathname.substring(0, pathname.lastIndexOf(33));
            try {
                pathname = URLDecoder.decode(pathname, "UTF-8");
            }
            catch (Exception e) {
                pathname = URLDecoder.decode(pathname);
            }
            return new File(pathname);
        }
        if ("file".equals(warUrl.getProtocol())) {
            String pathname = warUrl.getPath();
            try {
                return new File(URLDecoder.decode(pathname, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                return new File(URLDecoder.decode(pathname));
            }
        }
        return null;
    }

    public static <T> T unmarshal(Class<T> type, String descriptor, URL url) throws OpenEJBException {
        try {
            return (T)JaxbJavaee.unmarshalJavaee(type, (InputStream)new BufferedInputStream(url.openStream()));
        }
        catch (SAXException e) {
            throw new OpenEJBException("Cannot parse the " + descriptor + " file: " + url.toExternalForm(), e);
        }
        catch (JAXBException e) {
            throw new OpenEJBException("Cannot unmarshall the " + descriptor + " file: " + url.toExternalForm(), e);
        }
        catch (IOException e) {
            throw new OpenEJBException("Cannot read the " + descriptor + " file: " + url.toExternalForm(), e);
        }
        catch (Exception e) {
            throw new OpenEJBException("Encountered unknown error parsing the " + descriptor + " file: " + url.toExternalForm(), e);
        }
    }

    public static void scanDir(File dir, Map<String, URL> files, String path) {
        DeploymentLoader.scanDir(dir, files, path, true);
    }

    public static void scanDir(File dir, Map<String, URL> files, String path, boolean recursive) {
        File[] dirFiles = dir.listFiles();
        if (dirFiles != null) {
            for (File file : dirFiles) {
                if (file.isDirectory()) {
                    if (!recursive) continue;
                    DeploymentLoader.scanDir(file, files, path + file.getName() + "/");
                    continue;
                }
                String name = file.getName();
                try {
                    files.put(path + name, file.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    logger.warning("EAR path bad: " + path + name, e);
                }
            }
        }
    }

    public Class<? extends DeploymentModule> discoverModuleType(URL baseUrl, ClassLoader classLoader, boolean searchForDescriptorlessApplications) throws IOException, UnknownModuleTypeException {
        HashSet<RequireDescriptors> search = new HashSet<RequireDescriptors>();
        if (!searchForDescriptorlessApplications) {
            search.addAll(Arrays.asList(RequireDescriptors.values()));
        }
        return this.discoverModuleType(baseUrl, classLoader, search);
    }

    public Class<? extends DeploymentModule> discoverModuleType(URL baseUrl, ClassLoader classLoader, Set<RequireDescriptors> requireDescriptor) throws IOException, UnknownModuleTypeException {
        Class defaultType;
        BufferedInputStream is;
        Manifest manifest;
        String mainClass;
        Map<String, URL> webDescriptors;
        boolean scanPotentialEjbModules = !requireDescriptor.contains((Object)RequireDescriptors.EJB);
        boolean scanPotentialClientModules = !requireDescriptor.contains((Object)RequireDescriptors.CLIENT);
        URL pathToScanDescriptors = baseUrl;
        if (baseUrl != null) {
            String baseURLString = baseUrl.toString();
            if (baseUrl.getProtocol().equals("file") && baseURLString.endsWith("WEB-INF/classes/")) {
                pathToScanDescriptors = new URL(baseURLString.substring(0, baseURLString.lastIndexOf("WEB-INF/classes/")));
            }
        }
        Map<String, URL> descriptors = this.getDescriptors(classLoader, pathToScanDescriptors);
        String path = baseUrl != null ? baseUrl.getPath() : "";
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.endsWith(".xml")) {
            return ResourcesModule.class;
        }
        if (descriptors.containsKey("application.xml") || path.endsWith(".ear")) {
            return AppModule.class;
        }
        if (descriptors.containsKey("ra.xml") || path.endsWith(".rar")) {
            return ConnectorModule.class;
        }
        if (baseUrl != null && ((webDescriptors = this.getWebDescriptors(this.getFile(baseUrl))).containsKey("web.xml") || webDescriptors.containsKey("web-fragment.xml") || path.endsWith(".war") || new File(path, "WEB-INF").exists())) {
            return WebModule.class;
        }
        if (descriptors.containsKey("ejb-jar.xml") || descriptors.containsKey("beans.xml")) {
            return EjbModule.class;
        }
        if (descriptors.containsKey("application-client.xml")) {
            return ClientModule.class;
        }
        URL manifestUrl = descriptors.get("MANIFEST.MF");
        if (scanPotentialClientModules && manifestUrl != null && (mainClass = (manifest = new Manifest(is = new BufferedInputStream(manifestUrl.openStream()))).getMainAttributes().getValue(Attributes.Name.MAIN_CLASS)) != null) {
            return ClientModule.class;
        }
        Class<? extends DeploymentModule> cls = this.checkAnnotations(baseUrl, classLoader, scanPotentialEjbModules, scanPotentialClientModules);
        if (cls != null) {
            return cls;
        }
        if (descriptors.containsKey("persistence.xml") || descriptors.containsKey("persistence-fragment.xml")) {
            return PersistenceModule.class;
        }
        File file = URLs.toFile(baseUrl);
        if (DeploymentsResolver.isValidDirectory(file)) {
            File[] files = file.listFiles();
            if (DeploymentLoader.containsEarAssets(files)) {
                return AppModule.class;
            }
            if (DeploymentLoader.containsWebAssets(files)) {
                return WebModule.class;
            }
        }
        if ((defaultType = SystemInstance.get().getOptions().get("openejb.default.deployment-module", (Class)null)) != null) {
            if (WebModule.class.equals((Object)defaultType) && (path.endsWith(".jar!") || path.endsWith(".jar"))) {
                throw new UnknownModuleTypeException("Unknown module type: url=" + path + " which can't be a war.");
            }
            logger.info("type for '" + path + "' was not found, defaulting to " + defaultType.getSimpleName());
            return defaultType;
        }
        throw new UnknownModuleTypeException("Unknown module type: url=" + path);
    }

    private static boolean containsWebAssets(File[] files) {
        if (files != null) {
            for (File file : files) {
                String fn = file.getName().toLowerCase();
                if (fn.endsWith(".jsp")) {
                    return true;
                }
                if (!fn.endsWith(".html")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean containsEarAssets(File[] files) {
        if (files != null) {
            for (File file : files) {
                String fn = file.getName().toLowerCase();
                if (fn.endsWith(".jar")) {
                    return true;
                }
                if (fn.endsWith(".war")) {
                    return true;
                }
                if (!fn.endsWith(".rar")) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, URL> getDescriptors(ClassLoader classLoader, URL pathToScanDescriptors) throws IOException {
        ResourceFinder finder = new ResourceFinder("", classLoader, new URL[]{pathToScanDescriptors});
        return DeploymentLoader.altDDSources(DeploymentLoader.mapDescriptors(finder), false);
    }

    private Class<? extends DeploymentModule> checkAnnotations(URL urls, ClassLoader classLoader, final boolean scanPotentialEjbModules, final boolean scanPotentialClientModules) {
        Class cls = null;
        if (scanPotentialEjbModules || scanPotentialClientModules) {
            org.apache.openejb.util.AnnotationFinder classFinder = new org.apache.openejb.util.AnnotationFinder(classLoader, urls);
            final LinkedHashSet otherTypes = new LinkedHashSet();
            AnnotationFinder.Filter filter = new AnnotationFinder.Filter(){
                final String packageName = LocalClient.class.getName().replace("LocalClient", "");

                @Override
                public boolean accept(String annotationName) {
                    if (scanPotentialClientModules && annotationName.startsWith(this.packageName)) {
                        if (LocalClient.class.getName().equals(annotationName)) {
                            otherTypes.add(ClientModule.class);
                        }
                        if (RemoteClient.class.getName().equals(annotationName)) {
                            otherTypes.add(ClientModule.class);
                        }
                    } else if (scanPotentialEjbModules) {
                        if (annotationName.startsWith("javax.ejb.")) {
                            if ("javax.ejb.Stateful".equals(annotationName)) {
                                return true;
                            }
                            if ("javax.ejb.Stateless".equals(annotationName)) {
                                return true;
                            }
                            if ("javax.ejb.Singleton".equals(annotationName)) {
                                return true;
                            }
                            if ("javax.ejb.MessageDriven".equals(annotationName)) {
                                return true;
                            }
                        } else if (DeploymentLoader.this.scanManagedBeans && "javax.annotation.ManagedBean".equals(annotationName)) {
                            return true;
                        }
                    }
                    return false;
                }
            };
            if (classFinder.find(filter)) {
                cls = EjbModule.class;
                try {
                    JarFile war;
                    ZipEntry entry;
                    File ar = URLs.toFile(urls);
                    if (!ar.isDirectory() && !ar.getName().endsWith("ar") && (entry = (war = new JarFile(ar)).getEntry("WEB-INF/")) != null) {
                        logger.warning("you deployed " + urls.toExternalForm() + ", it seems it is a war with no extension, please rename it");
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (otherTypes.size() > 0) {
                cls = (Class)otherTypes.iterator().next();
            }
        }
        return cls;
    }

    public static File unpack(File jarFile) throws OpenEJBException {
        if (jarFile.isDirectory() || jarFile.getName().endsWith(".jar")) {
            return jarFile;
        }
        String name = jarFile.getName();
        name = name.endsWith(".ear") || name.endsWith(".zip") || name.endsWith(".war") || name.endsWith(".rar") ? name.replaceFirst("....$", "") : name + ".unpacked";
        try {
            return JarExtractor.extract(jarFile, name);
        }
        catch (IOException e) {
            throw new OpenEJBException("Unable to extract jar. " + e.getMessage(), e);
        }
    }

    protected static URL getFileUrl(File jarFile) throws OpenEJBException {
        URL baseUrl;
        try {
            baseUrl = jarFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new OpenEJBException("Malformed URL to app. " + e.getMessage(), e);
        }
        return baseUrl;
    }

    public static void reloadAltDD() {
        ALTDD = SystemInstance.get().getOptions().get(OPENEJB_ALTDD_PREFIX, (String)null);
    }
}

