/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.openejb.core;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;

public class EmptyResourcesClassLoader extends ClassLoader {
    public EmptyResourcesClassLoader() {
        super(null);
    }

    @Override
    protected URL findResource(final String name) {
        return null;
    }

    @Override
    public Enumeration<URL> getResources(final String name) throws IOException {
        return new Enumeration<URL>() {
            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                throw new UnsupportedOperationException("this enumeration has no elements");
            }
        };
    }
}
