/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.openejb.core.mdb;

import javax.enterprise.context.spi.CreationalContext;
import java.util.Map;

/**
 * @version $Rev: 1178455 $ $Date: 2011-10-03 16:58:53 +0000 (Mon, 03 Oct 2011) $
 */
public class Instance {
    public final Object bean;
    public final Map<String,Object> interceptors;
    public final CreationalContext creationalContext;

    public Instance(Object bean, Map<String, Object> interceptors, CreationalContext creationalContext) {
        this.bean = bean;
        this.interceptors = interceptors;
        this.creationalContext = creationalContext;
    }
}
