/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.openejb.core.timer.quartz;

import org.quartz.impl.jdbcjobstore.NoSuchDelegateException;
import org.quartz.impl.jdbcjobstore.StdJDBCDelegate;
import org.quartz.spi.ClassLoadHelper;
import org.slf4j.Logger;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PatchedStdJDBCDelegate extends StdJDBCDelegate {

    public PatchedStdJDBCDelegate(final Logger logger,
                                  final String tablePrefix,
                                  final String schedName,
                                  final String instanceId,
                                  final ClassLoadHelper classLoadHelper) throws NoSuchDelegateException {
        initialize(logger, tablePrefix, schedName, instanceId, classLoadHelper, false, null);
    }

    public PatchedStdJDBCDelegate(final Logger logger,
                                  final String tablePrefix,
                                  final String schedName,
                                  final String instanceId,
                                  final ClassLoadHelper classLoadHelper,
                                  final Boolean useProperties) throws NoSuchDelegateException {
        initialize(logger, tablePrefix, schedName, instanceId, classLoadHelper, useProperties, null);
    }

    public PatchedStdJDBCDelegate(final Logger logger,
                                  final String tablePrefix,
                                  final String schedName,
                                  final String instanceId,
                                  final ClassLoadHelper classLoadHelper,
                                  final Boolean useProperties,
                                  final String initString) throws NoSuchDelegateException {
        initialize(logger, tablePrefix, schedName, instanceId, classLoadHelper, useProperties, initString);
    }

    @Override
    protected Object getObjectFromBlob(final ResultSet rs, final String colName)
        throws ClassNotFoundException, IOException, SQLException {
        Object obj = null;

        final Blob blobLocator = rs.getBlob(colName);
        if (blobLocator != null && blobLocator.length() != 0) {
            final InputStream binaryInput = blobLocator.getBinaryStream();

            if (null != binaryInput) {
                if (!(binaryInput instanceof ByteArrayInputStream) || ((ByteArrayInputStream) binaryInput).available() != 0) {
                    final ObjectInputStream in = new QuartzObjectInputStream(binaryInput, classLoadHelper);
                    try {
                        obj = in.readObject();
                    } finally {
                        in.close();
                    }
                }
            }

        }
        return obj;
    }
}

